package com.ejianc.business.zdsmaterial.plan.purchase.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.*;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialSourceVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Service("purchasePlan") 
public class PurchasePlanBpmServiceImpl implements ICommonBusinessService {

    @Autowired
	private IPurchasePlanService service;
    @Autowired
	private IPurchasePlanDetailService purchasePlanDetailService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
	private IEmployeeApi employeeApi;

	@Autowired
	private IMaterialCategoryService categoryService;

	@Autowired
	private IMaterialService materialService;

	@Value("${common.env.base-host}")
	private String baseHost;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		PurchasePlanEntity entity = service.selectById(billId);
		if (CollectionUtils.isEmpty(entity.getDetailList())){
			return CommonResponse.error("明细为空，当前单据不能提交！");
		}

//		List<PurchasePlanDetailEntity> emptyPropertyValueList = entity.getDetailList().stream()
//				.filter(detail -> StringUtils.isBlank(detail.getPropertyValue())).collect(Collectors.toList());
//		if(CollectionUtils.isNotEmpty(emptyPropertyValueList)) {
//			StringBuffer sp = new StringBuffer("编码为【");
//			sp.append(emptyPropertyValueList.stream().map(PurchasePlanDetailEntity::getMaterialCode).collect(Collectors.joining(",")));
//			sp.append("】的物料档案规格型号为空，请填写！");
//			return CommonResponse.error(sp.toString());
//		}

		//检查是否存在属性关系为空的明细项
//		List<PurchasePlanDetailEntity> emptyPropertyList = entity.getDetailList().stream()
//				.filter(detail -> StringUtils.isBlank(detail.getProperty())).collect(Collectors.toList());
//		if(CollectionUtils.isNotEmpty(emptyPropertyList)) {
//			//若存在，则先判断在档案库中是否有匹配的物料档案
//			List<MaterialVO> checkList = new ArrayList<>();
//			emptyPropertyList.forEach(data-> {
//				MaterialVO vo = new MaterialVO();
//				vo.setId(data.getMaterialId());
//				vo.setCode(data.getMaterialCode());
//				vo.setName(data.getMaterialName());
//				vo.setCategoryId(data.getMaterialTypeId());
//				vo.setCategoryName(data.getMaterialTypeName());
//				vo.setUnitId(data.getUnitId());
//				vo.setUnitName(data.getUnitName());
//				vo.setProductCode(data.getProductCode());
//				vo.setEnabled(ZDSMaterialCommonEnums.停启用_启用.getCode());
//				vo.setBlockedFlag(ZDSMaterialCommonEnums.封存_正常.getCode());
//				vo.setPropertyShowName(data.getPropertyValue());
//
//				vo.setHasNewPropertyValStr(data.getDetailIndex().toString()); //暂存 用于信息提示
//				checkList.add(vo);
//			});
//
//			//查询档案库是否存在匹配的物料项
//			List<MaterialVO> exsistList = materialService.checkUnitAndProperty(checkList, false);
//			Map<String, MaterialVO> exsitMap = exsistList.stream().collect(Collectors.toMap(item -> item.getName() + item.getUnitId().toString() + item.getPropertyShowName(),
//					item -> item));
//			MaterialVO tmp = null;
//			for(Iterator<MaterialVO> it = checkList.iterator(); it.hasNext();) {
//				tmp = it.next();
//				if(exsitMap.containsKey(tmp.getName() + tmp.getUnitId().toString() + tmp.getPropertyShowName())) {
//					//在物料档案库中存在相同的档案，排除掉
//					it.remove();
//				}
//			}
//			if(CollectionUtils.isNotEmpty(checkList)) {
//				//存在物料明细 在档案库中无匹配项 且 属性关系为空，存在无法设置属性关系的项 则提示重新编辑在提交
//				return CommonResponse.error("序号为：" +
//						checkList.stream().map(item -> item.getHasNewPropertyValStr()).collect(Collectors.joining("、"))
//						+ "物料明细项的规格型号与物料分类下属性不一致，请重新设置明细的规格型号后再启动流程！");
//			}
//		}

		List<PurchasePlanDetailEntity> detailList = entity.getDetailList();
		List<PurchasePlanDetailEntity> collect = detailList.stream().filter(e -> 1 == e.getWorkPlanFlag()).collect(Collectors.toList());
		if (CollectionUtils.isNotEmpty(collect)){
			List<Long> collect1 = collect.stream().map(e -> e.getMaterialId()).collect(Collectors.toList());
			service.checkMaterialSumPlan(collect1,entity.getProjectId());
		}

		service.validatePlanNum(entity);

		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		PurchasePlanEntity purchasePlanEntity = service.selectById(billId);
		purchasePlanEntity.setCommitDate(new Date());
		CommonResponse<EmployeeVO> employeeVOCommonResponse = employeeApi.queryEmployeByUserId(sessionManager.getUserContext().getUserId());
		purchasePlanEntity.setCommitUserId(sessionManager.getUserContext().getUserId());
		purchasePlanEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
		purchasePlanEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
		service.saveOrUpdate(purchasePlanEntity);
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
//	@Override
//	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
//
//		return bpmBackCheck(billId, state, billTypeCode);
//	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PurchasePlanEntity purchasePlanEntity = service.selectById(billId);

		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
			service.validatePlanNum(purchasePlanEntity);

			if (CollectionUtils.isEmpty(purchasePlanEntity.getDetailList())){
				return CommonResponse.error("明细为空，当前单据不能提交！");
			}

			List<PurchasePlanDetailEntity> emptyPropertyValueList = purchasePlanEntity.getDetailList().stream()
					.filter(detail -> StringUtils.isBlank(detail.getPropertyValue())).collect(Collectors.toList());
			if(CollectionUtils.isNotEmpty(emptyPropertyValueList)) {
				StringBuffer sp = new StringBuffer("编码为【");
				sp.append(emptyPropertyValueList.stream().map(PurchasePlanDetailEntity::getMaterialCode).collect(Collectors.joining(",")));
				sp.append("】的物料档案规格型号为空，请填写！");
				return CommonResponse.error(sp.toString());
			}
		}

		service.planToSum(purchasePlanEntity,true);
		List<PurchasePlanDetailEntity> detailList = purchasePlanEntity.getDetailList();
		List<PurchasePlanDetailEntity> collect = detailList.stream().filter(e -> 1 == e.getWorkPlanFlag()).collect(Collectors.toList());
		if (CollectionUtils.isNotEmpty(collect)){
			List<Long> collect1 = collect.stream().map(e -> e.getMaterialId()).collect(Collectors.toList());
			service.checkMaterialSumPlan(collect1,purchasePlanEntity.getProjectId());
		}
		purchasePlanEntity.setEffectDate(new Date());
		purchasePlanEntity.setApproveUserId(sessionManager.getUserContext().getUserId());
		purchasePlanEntity.setApproveUserName(sessionManager.getUserContext().getUserName());
		purchasePlanEntity.setApproveUserCode(sessionManager.getUserContext().getUserCode());
		service.setSid(purchasePlanEntity);
		service.saveOrUpdate(purchasePlanEntity,false);
		pushToMaterial(purchasePlanEntity);
		return CommonResponse.success("终审审核成功");
	}

	/**
	 * 推送物料库
	 * @param entity
	 */
	private void pushToMaterial(PurchasePlanEntity entity) {
		List<PurchasePlanDetailEntity> detailList = entity.getDetailList();
		detailList = detailList.stream().filter(x->PlanConstant.SOURCE_TYPE_NEW.equals(x.getSourceType())).collect(Collectors.toList());
		if(CollectionUtils.isEmpty(detailList)){
			return;
		}
		List<Long> typeIds = detailList.stream().map(PurchasePlanDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
		QueryParam param = new QueryParam();
		param.getParams().put("id", new Parameter(QueryParam.IN, typeIds));
		List<MaterialCategoryEntity> typeList = categoryService.queryList(param);
		Map<Long, MaterialCategoryEntity> typeMap = typeList.stream().collect(Collectors.toMap(x->x.getId(), x->x));

		List<MaterialVO> saveList = new ArrayList<>();
		detailList.forEach(data->{
			MaterialVO vo = new MaterialVO();
			vo.setId(data.getMaterialId());
			vo.setCode(data.getMaterialCode());
			vo.setName(data.getMaterialName());
			vo.setCategoryId(data.getMaterialTypeId());
			vo.setCategoryCode(typeMap.get(data.getMaterialTypeId()).getCode());
			vo.setCategoryName(data.getMaterialTypeName());
			vo.setUnitId(data.getUnitId());
			vo.setUnitName(data.getUnitName());
			vo.setProductCode(data.getProductCode());
			vo.setEnabled(ZDSMaterialCommonEnums.停启用_启用.getCode());
			vo.setBlockedFlag(ZDSMaterialCommonEnums.封存_正常.getCode());
			vo.setSystemId("sys");
			vo.setSourceId(String.valueOf(data.getId()));
			vo.setPropertyShowName(data.getPropertyValue());
			vo.setRelationList(JSONArray.parseArray(data.getProperty(), MaterialPropertyRelationVO.class));
			List<MaterialSourceVO> sourceList = new ArrayList<>();
			MaterialSourceVO materialSourceVO = new MaterialSourceVO();
			materialSourceVO.setMaterialId(data.getMaterialId());
			materialSourceVO.setBillType("EJCBT202311000006");
			materialSourceVO.setBillTypeName("物资采购计划");
			materialSourceVO.setSourceBillCode(entity.getBillCode());
			materialSourceVO.setSourcePid(entity.getId());
			materialSourceVO.setSourceDetailId(data.getId());
			materialSourceVO.setSourceBillPcUrl(baseHost + "ejc-zdsmaterial-frontend/#/purchasePlan/card");
			materialSourceVO.setSourceCreateUserCode(entity.getCreateUserCode());
			materialSourceVO.setSourceCreateUserName(entity.getCreateUserName());
			materialSourceVO.setSourceCreateTime(entity.getCreateTime());
			materialSourceVO.setSourceCreateTime(entity.getCreateTime());
			materialSourceVO.setSourceOrgName(entity.getOrgName());
			sourceList.add(materialSourceVO);
			vo.setSourceList(sourceList);

			saveList.add(vo);
		});
		List<MaterialVO> materialVOS = materialService.addNewMaterialsFromBill(saveList);
		Map<String, List<MaterialVO>> map = materialVOS.stream().collect(
				Collectors.groupingBy(
						s->s.getName()+'-'+(StringUtils.isNotBlank(s.getPropertyShowName()) ? s.getPropertyShowName():"")+'-'+s.getUnitId()
				));
		for (PurchasePlanDetailEntity controlPlanDetailEntity : detailList){
			String key = controlPlanDetailEntity.getMaterialName() + "-" + (StringUtils.isNotBlank(controlPlanDetailEntity.getPropertyValue()) ? controlPlanDetailEntity.getPropertyValue() : "") + "-" + controlPlanDetailEntity.getUnitId();
			if (map.containsKey(key)) {
				MaterialVO materialVOS1 = map.get(key).get(0);
				controlPlanDetailEntity.setMaterialId(materialVOS1.getId());
				controlPlanDetailEntity.setMaterialCode(materialVOS1.getCode());
			}
		}
		purchasePlanDetailService.saveOrUpdateBatch(detailList);
	}



	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PurchasePlanEntity entity = service.selectById(billId);
		// 删除物料库
		List<PurchasePlanDetailEntity> detailList = entity.getDetailList();
		List<Long> sourceIds = detailList.stream().filter(x->PlanConstant.SOURCE_TYPE_NEW.equals(x.getSourceType())).
				map(PurchasePlanDetailEntity::getId).collect(Collectors.toList());
		if(CollectionUtils.isNotEmpty(sourceIds)) {
			materialService.deleteMaterialsFromBill(sourceIds);
		}
		return CommonResponse.success();
	}


	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

		PurchasePlanEntity purchasePlanEntity = service.selectById(billId);
		service.planToSum(purchasePlanEntity,false);
		return CommonResponse.success("弃审/撤回前校验回调成功！");

	}
}
