package com.ejianc.business.zdsmaterial.plan.control.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.*;
import com.ejianc.business.zdsmaterial.material.service.*;
import com.ejianc.business.zdsmaterial.material.vo.*;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanSumDetailVO;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanSumVO;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdsmaterial.plan.control.mapper.ControlPlanSumMapper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物资总控计划汇总
 *
 * @author generator
 *
 */
@Service("controlPlanSumService")
public class ControlPlanSumServiceImpl extends BaseServiceImpl<ControlPlanSumMapper, ControlPlanSumEntity> implements IControlPlanSumService {

    private static final String BILL_CODE = "ZDS_MATERIAL_CONTROL_PLAN_SUM";//此处需要根据实际修改

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IPurchasePlanService purchasePlanService;
    @Autowired
    private IControlPlanSumDetailService controlPlanSumDetailService;
    @Autowired
    private IPurchasePlanDetailService purchasePlanDetailService;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public ControlPlanSumVO saveOrUpdate(ControlPlanSumVO saveOrUpdateVO) {
        if (null == saveOrUpdateVO.getExeOrgId()) {
            CommonResponse<OrgVO> commonResponse = orgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (commonResponse.isSuccess() && null != commonResponse.getData()) {
                String[] split = commonResponse.getData().getInnerCode().split("\\|");
                Long exeOrgId = split.length > 1 ? Long.valueOf(split[1]) : null;
                if (null != exeOrgId) {
                    OrgVO orgVO = orgApi.getOneById(exeOrgId).getData();
                    saveOrUpdateVO.setExeOrgId(exeOrgId);
                    saveOrUpdateVO.setExeOrgCode(orgVO.getCode());
                    saveOrUpdateVO.setExeOrgName(orgVO.getName());
                }
            }
        }
        ControlPlanSumEntity entity = BeanMapper.map(saveOrUpdateVO, ControlPlanSumEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setCreateUserName(sessionManager.getUserContext().getUserName());
        }
        List<ControlPlanSumDetailVO> detailList = saveOrUpdateVO.getDetailList();
        // 汇总材料分类
        String materialTypeNames = detailList.stream().filter(x->!"del".equals(x.getRowState()) &&
                StringUtils.isNotEmpty(x.getMaterialTypeName())).map(x->x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        if(entity.getCreateUserId() == null){
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }

        super.saveOrUpdate(entity, false);

        //推送物料库
        pushToMaterial(entity);
        //更新引用状态
        updateQuoteType(entity);

        //更新关联状态

        ControlPlanSumVO vo = BeanMapper.map(entity, ControlPlanSumVO.class);
        return vo;
    }
    /**
     * 推送物料库
     * @param entity
     */
    private void pushToMaterial(ControlPlanSumEntity entity) {
        List<ControlPlanSumDetailEntity> detailList = entity.getDetailList();

        //过滤掉已存在的物料档案
        detailList = detailList.stream().filter(x->PlanConstant.SOURCE_TYPE_NEW.equals(x.getSourceType())
                && !PlanConstant.ROW_TYPE_CHANGE.equals(x.getRowType())
        && !PlanConstant.ROW_TYPE_UNCHANGE.equals(x.getRowType())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(detailList)){
            return;
        }
        List<Long> typeIds = detailList.stream().map(ControlPlanSumDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, typeIds));
        List<MaterialCategoryEntity> typeList = categoryService.queryList(param);
        Map<Long, MaterialCategoryEntity> typeMap = typeList.stream().collect(Collectors.toMap(x->x.getId(), x->x));

        List<MaterialVO> saveList = new ArrayList<>();
        detailList.forEach(data->{
            MaterialVO vo = new MaterialVO();
            vo.setId(data.getMaterialId());
            vo.setCode(data.getMaterialCode());
            vo.setName(data.getMaterialName());
            vo.setCategoryId(data.getMaterialTypeId());
            vo.setCategoryCode(typeMap.get(data.getMaterialTypeId()).getCode());
            vo.setCategoryName(data.getMaterialTypeName());
            vo.setUnitId(data.getUnitId());
            vo.setUnitName(data.getUnitName());
            vo.setEnabled(ZDSMaterialCommonEnums.停启用_启用.getCode());
            vo.setBlockedFlag(ZDSMaterialCommonEnums.封存_正常.getCode());
            vo.setSystemId("sys");
            vo.setProductCode(data.getProductCode());
            vo.setSourceId(String.valueOf(data.getSourceId()));
            vo.setPropertyShowName(data.getPropertyValue());
            vo.setRelationList(JSONArray.parseArray(data.getProperty(), MaterialPropertyRelationVO.class));
            List<MaterialSourceVO> sourceList = new ArrayList<>();
            MaterialSourceVO materialSourceVO = new MaterialSourceVO();
            materialSourceVO.setMaterialId(data.getMaterialId());
            materialSourceVO.setBillType("EJCBT202311000011");
            materialSourceVO.setBillTypeName("物资总控计划汇总");
            materialSourceVO.setSourceBillCode(entity.getBillCode());
            materialSourceVO.setSourcePid(entity.getId());
            materialSourceVO.setSourceDetailId(data.getId());
            materialSourceVO.setSourceBillPcUrl(baseHost + "ejc-zdsmaterial-frontend/#/controlPlanSum/card");
            materialSourceVO.setSourceCreateUserCode(entity.getCreateUserCode());
            materialSourceVO.setSourceCreateUserName(entity.getCreateUserName());
            materialSourceVO.setSourceOrgName(entity.getOrgName());
            sourceList.add(materialSourceVO);
            vo.setSourceList(sourceList);
            saveList.add(vo);
        });
        List<MaterialVO> materialVOS = materialService.addNewMaterialsFromBill(saveList);
        Map<String, List<MaterialVO>> map = materialVOS.stream().collect(
				Collectors.groupingBy(
						s->s.getName()+'-'+(StringUtils.isNotBlank(s.getPropertyShowName()) ? s.getPropertyShowName() : "")+'-'+s.getUnitId()
				));
        for (ControlPlanSumDetailEntity controlPlanSumDetailEntity : detailList){
            String key = controlPlanSumDetailEntity.getMaterialName() + "-" +
                    (StringUtils.isNotBlank(controlPlanSumDetailEntity.getPropertyValue()) ? controlPlanSumDetailEntity.getPropertyValue() : "") + "-" + controlPlanSumDetailEntity.getUnitId();
            if (map.containsKey(key)) {
                MaterialVO materialVOS1 = map.get(key).get(0);
                controlPlanSumDetailEntity.setMaterialId(materialVOS1.getId());
                controlPlanSumDetailEntity.setMaterialCode(materialVOS1.getCode());
            }
        }
        controlPlanSumDetailService.saveOrUpdateBatch(detailList);

    }
    /**
     * 更新引用状态
     * @param entity
     */
    private void updateQuoteType(ControlPlanSumEntity entity) {
        LambdaQueryWrapper<PurchasePlanEntity> lambdaPurchase = Wrappers.<PurchasePlanEntity>lambdaQuery();
        lambdaPurchase.eq(PurchasePlanEntity::getProjectId, entity.getProjectId());
        lambdaPurchase.in(PurchasePlanEntity::getBillState, 1, 3);
        List<PurchasePlanEntity> purchasePlanEntities = purchasePlanService.list(lambdaPurchase);
        Map<Long, BigDecimal> numMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(purchasePlanEntities)){
            List<Long> purchaseId = new ArrayList<>();
            purchaseId = purchasePlanEntities.stream().map(PurchasePlanEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<PurchasePlanDetailEntity> lambdaPurchaseDetail = Wrappers.<PurchasePlanDetailEntity>lambdaQuery();
            lambdaPurchaseDetail.in(PurchasePlanDetailEntity::getPlanId, purchaseId);
            List<PurchasePlanDetailEntity> purchasePlanDetailEntities = purchasePlanDetailService.list(lambdaPurchaseDetail);
            numMap = purchasePlanDetailEntities.stream().collect(Collectors.groupingBy(PurchasePlanDetailEntity::getMaterialId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getRequirementNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        List<ControlPlanSumDetailEntity> detailList = entity.getDetailList();
        for (ControlPlanSumDetailEntity controlPlanSumDetailEntity : detailList){
            if (numMap.containsKey(controlPlanSumDetailEntity.getMaterialId())){
                BigDecimal bigDecimal = numMap.get(controlPlanSumDetailEntity.getMaterialId());
                controlPlanSumDetailEntity.setPlanNum(bigDecimal);
                controlPlanSumDetailEntity.setQuoteType(2);
            }else {
                controlPlanSumDetailEntity.setPlanNum(null);
                controlPlanSumDetailEntity.setQuoteType(1);
            }
        }
        controlPlanSumDetailService.updateBatchById(detailList);

    }

    @Override
    public ControlPlanSumEntity saveOrUpdateEntity(ControlPlanSumEntity entity) {
        ControlPlanSumVO saveOrUpdateVO = BeanMapper.map(entity, ControlPlanSumVO.class);
        ControlPlanSumVO result = this.saveOrUpdate(saveOrUpdateVO);
        return BeanMapper.map(result, ControlPlanSumEntity.class);
    }
}
