package com.ejianc.business.zdsmaterial.erp.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/8/26 14:52
 */
@RestController
@RequestMapping(value = "/api/zdsBrandRelation")
public class BrandRelationApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBrandRelationService service;

    @PostMapping(value = "/saveOrUpdateRelations")
    CommonResponse<String> saveOrUpdateRelations(@RequestBody List<BrandRelationVO> relations) {
        logger.info("接收到待保存/更新的品牌关系:{}", JSONObject.toJSONString(relations));

        String msg = service.saveOrUpdateRelations(relations);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("操作成功！");
    }

}
