package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.asynchandler.bean.MaPushErpRecordsEntity;
import com.ejianc.business.zdsmaterial.asynchandler.consumer.PushErpRecordListener;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationFlowEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.BrandRelationMapper;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationFlowService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationVO;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierMaterialInfoApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierMaterialInfoVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.base.Stopwatch;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 品牌关系
 * 
 * @author generator
 * 
 */
@Service("brandRelationService")
public class BrandRelationServiceImpl extends BaseServiceImpl<BrandRelationMapper, BrandRelationEntity> implements IBrandRelationService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private BrandRelationMapper mapper;

    @Value("${erp.reqHost}")
    private String reqHost;

    @Autowired
    private QueueUtils queueUtils;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private EnvironmentTools environmentTools;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Lazy
    @Autowired
    private IBrandService brandService;

    @Autowired
    private IBrandRelationFlowService relationFlowService;

    @Autowired
    private IMatSupplierApi supplierApi;

    @Autowired
    private IMatSupplierMaterialInfoApi matSupplierMaterialInfoApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Value("${spring.cloud.config.profile}")
    private String profile;

    private final String CHECK_ERP_RELATION_URL = "/cefoc/yql/getBrandLibraryRelationList";

    @Override
    public List<BrandRelationEntity> checkRelation(List<BrandRelationEntity> saveRelations) {
        QueryWrapper<BrandRelationEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        query.and(q -> {
            saveRelations.stream().forEach(r -> {
                q.or(iq ->iq.eq("material_type_id", r.getMaterialTypeId()).eq("brand_id", r.getBrandId()));
            });
            return q;
        });


        return super.list(query);
    }

    @Override
    public List<BrandRelationEntity> getAllByCategoryId(Long categoryId) {
        QueryWrapper<BrandRelationEntity> query = new QueryWrapper<>();
        query.eq("material_type_id", categoryId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }

    @Override
    public List<BrandRelationEntity> getByBrandId(Long brandId) {
        QueryWrapper<BrandRelationEntity> query = new QueryWrapper<>();
        query.eq("brand_id", brandId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }

    @Override
    public List<BrandRelationEntity> getAllByIds(List<Long> ids) {
        QueryWrapper<BrandRelationEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }

    @Override
    @Async(value = "maContextCommonTask")
    public void syncRelationToErp(DataPushErpParam pushParam) {
        logger.info("品牌关系信息推送ERP-------------开始----------------");
        logger.info("本次推送ERP品牌信息：{}, 推送类型: {}", JSONObject.toJSONString(pushParam.getPushData()), pushParam.getBillType());


        //查询操作人信息
        CommonResponse<UserVO> userResp = userApi.findUserByUserId(pushParam.getOperatorId());
        if(!userResp.isSuccess() || null == userResp.getData()) {
            logger.error("查询人员id-{}信息失败，{}", pushParam.getOperatorId(), JSONObject.toJSONString(userResp));
            throw new BusinessException("查询操作人员信息失败！");
        }
        UserVO operator = userResp.getData();

        //查询所有品牌信息
        List<Long> brandIds = pushParam.getPushData().stream().map(BrandRelationVO::getBrandId).collect(Collectors.toList());
        List<BrandVO> brandList = brandService.getAllByIds(brandIds);
        Map<Long, BrandVO> brandMap = new HashMap<>();
        for(BrandVO brand : brandList) {
            brandMap.put(brand.getId(), brand);
        }

        //查询对应的供应商供货内容
        List<Long> sourceDetailList = pushParam.getPushData().stream().filter(item -> null != item.getSourceDetailId())
                .map(item -> item.getSourceDetailId()).collect(Collectors.toList());
        Map<Long, MatSupplierMaterialInfoVO> infoIdMap = new HashMap<>();
        Map<String, MatSupplierMaterialInfoVO> infoMaterialBrandMap = new HashMap<>();
        Map<Long, ProjectPoolSetVO> projectMap = new HashMap<>();

        List<Long> supplierIds = pushParam.getPushData().stream().map(BrandRelationVO::getSupplierId).collect(Collectors.toList());


        //查询供应商信息
        CommonResponse<List<MatSupplierVO>> supplierInfos = supplierApi.getAllByIds(supplierIds);
        Map<Long, MatSupplierVO> supplierMap = new HashMap<>();
        if(supplierInfos.isSuccess()) {
            List<MatSupplierVO> supplierList = supplierInfos.getData();
            supplierMap.putAll(supplierList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        } else {
            logger.error("******* 根据供应商id-{}查询供应商信息失败，{}", JSONObject.toJSONString(supplierIds), JSONObject.toJSONString(supplierInfos));
        }

        if(CollectionUtils.isNotEmpty(sourceDetailList)) {
            CommonResponse<List<MatSupplierMaterialInfoVO>> matInfoResp = matSupplierMaterialInfoApi.getAllBySupplierIds(supplierIds);
            if(!matInfoResp.isSuccess()) {
                logger.error("查询对应供应商供货内容列表，供应商ids-{}失败：{}", JSONObject.toJSONString(sourceDetailList), JSONObject.toJSONString(matInfoResp));
            } else if(CollectionUtils.isNotEmpty(matInfoResp.getData())) {
                Set<Long> projectIds = new HashSet<>();
                for(MatSupplierMaterialInfoVO info : matInfoResp.getData()) {
                    infoIdMap.put(info.getId(), info);

                    if(null != info.getMaterialId() && StringUtils.isNotBlank(info.getBrandId())) {
                        if(infoMaterialBrandMap.containsKey(info.getMaterialId().toString() + info.getBrandId()) && DateUtil.compareDate(info.getTerminalTime(),
                                infoMaterialBrandMap.get(info.getMaterialId().toString() + info.getBrandId()).getTerminalTime()) > 1) {
                            infoMaterialBrandMap.put(info.getMaterialId().toString() + info.getBrandId(), info);
                        } else {
                            infoMaterialBrandMap.put(info.getMaterialId().toString() + info.getBrandId(), info);
                        }
                    }

                    if(null != info.getAffiliatedProjectId()) {
                        projectIds.add(info.getAffiliatedProjectId());
                    }
                }
                if(CollectionUtils.isNotEmpty(projectIds)) {
                    CommonResponse<List<ProjectPoolSetVO>> projectResp = projectPoolApi.queryProjectsByIds(new ArrayList<>(projectIds));
                    if(!projectResp.isSuccess()) {
                        logger.error("查询对应供应商供货内容关联项目列表ids-{}失败：{}", JSONObject.toJSONString(projectIds), JSONObject.toJSONString(projectResp));
                    } else if(CollectionUtils.isNotEmpty(projectResp.getData())) {
                        for(ProjectPoolSetVO project : projectResp.getData()) {
                            projectMap.put(project.getId(), project);
                        }
                    }
                }
            }
        }

        //检查是否存在需要查询SID的供应商存在
        String pushResult = null;
        //推送地址
        String reqUrl = reqHost + (PlanConstant.品牌关系新增.equals(pushParam.getPushType()) ? PlanConstant.品牌关系新增推送ERP地址 : PlanConstant.品牌关系更新推送ERP地址);

        //推送参数记录
        MaPushErpRecordsEntity record = new MaPushErpRecordsEntity();
        record.setData(JSONObject.toJSONString(pushParam.getPushData()));
        record.setOperatorId(pushParam.getOperatorId());
        record.setOperatorName(operator.getUserName());
        record.setBillType(pushParam.getBillType());
        record.setPushDate(new Date());
        record.setUrl(reqUrl);

        //组装推送参数
        List<JSONObject> pushParams = new ArrayList<>();
        JSONObject syncItem = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        MatSupplierMaterialInfoVO material = null;
        for(BrandRelationVO relation : pushParam.getPushData()) {
            if(!PlanConstant.INTEGER_YES.equals(relation.getDbSupplierFlag())) {
                //供应商不在库 补推送ERPR
                logger.info("供应商-{}不在库，品牌关系id-{}跳过推送！", relation.getSupplierName(), relation.getId());
                continue;
            }
            syncItem = new JSONObject();
            syncItem.put("C_PS_BrandLibraryRelationOID", relation.getSourceId()); //品牌关系ERP sid
            syncItem.put("SYS_Deleted", StringUtils.isNotBlank(relation.getDelFlag()) ?
                    PlanConstant.STRING_YES.equals(relation.getDelFlag()) ? true : false :
                    null != relation.getRelationEnabled() ? relation.getRelationEnabled() == 1 ? false : true : null); //供应商与关系停气用
            syncItem.put("SYS_Created", sdf.format(relation.getCreateTime())); //创建时间
            syncItem.put("SYS_LAST_UPD", null != relation.getUpdateTime() ? sdf.format(relation.getUpdateTime()) : null); //最后修改时间
            syncItem.put("Enabled", null != relation.getBrandEnabled() ? 1 == relation.getBrandEnabled() :
                    brandMap.containsKey(relation.getBrandId()) ? 1 == brandMap.get(relation.getBrandId()).getRelationEnabled() : null); //品牌与供应商关系是否启用 1启用0未启用
            syncItem.put("BrandSid", relation.getBrandSid()); //品牌SID
            syncItem.put("Memo", relation.getMemo()); //备注
            syncItem.put("CategorySid", relation.getMaterialTypeSid());//物资未级分类SID
            syncItem.put("CategoryName", relation.getMaterialTypeName());//物资未级分类名称
            syncItem.put("CategoryTwoSid", relation.getMaterialTypePsid());//物资二级分类SID
            syncItem.put("CategoryTwoName", relation.getMaterialTypePname()); //物资二级分类名称
            if(StringUtils.isNotBlank(relation.getSupplierSid()) || supplierMap.containsKey(relation.getSupplierId()) && StringUtils.isNotBlank(supplierMap.get(relation.getSupplierId()).getThirdSourceId())) {
                syncItem.put("SupplierSid", StringUtils.isNotBlank(relation.getSupplierSid()) ? relation.getSupplierSid()
                        : supplierMap.get(relation.getSupplierId()).getThirdSourceId()); //供应商SID
            } else {
                logger.error("供应商SID为空，品牌关系-{}推送跳过", relation.getId());
                record.setBeforePushSupInfo("供应商SID为空，品牌关系-"+relation.getId().toString()+"推送跳过");
                continue;
            }
            syncItem.put("SupplierCharacter", relation.getSupplierCharacter()); //公司性质0-生产商，1-供应商
            syncItem.put("ApprHuman_sid", operator.getSourceId()); //最后操作人SID
            syncItem.put("ApprHuman", operator.getUserName()); //最后操作人名称


            if(infoIdMap.containsKey(relation.getSourceDetailId())) {
                material = infoIdMap.get(relation.getSourceDetailId());
            }

            if(null == material && supplierMap.size() == 1) { //仅只推单个个供应商下品牌关系时这样获取
                material = infoMaterialBrandMap.get(relation.getMaterialTypeId().toString() + relation.getBrandId());
            }
            if(null != material) {
                logger.info("materialInfo:{}", JSONObject.toJSONString(material));
                syncItem.put("PropertyCode", StringUtils.isNotBlank(material.getPropertyValue()) ?
                        com.ejianc.business.zdssupplier.cons.PlanConstant.EL_TO_ERP_MAT_MATERIAL_PROPERTY.containsKey(material.getPropertyValue()) ?
                                com.ejianc.business.zdssupplier.cons.PlanConstant.EL_TO_ERP_MAT_MATERIAL_PROPERTY.get(material.getPropertyValue()) : material.getPropertyValue() : null); //属性
                if(null != material.getAffiliatedProjectId()) {
                    syncItem.put("AffiliatedProject", material.getAffiliatedProjectName());
                    if(projectMap.containsKey(material.getAffiliatedProjectId())) {
                        syncItem.put("AccountingProjectSet_FK", projectMap.get(material.getAffiliatedProjectId()).getSourceId());
                    }
                }
            } else if(PlanConstant.STRING_NO.equals(relation.getSupplierCharacter())) {
                syncItem.put("PropertyCode", PlanConstant.STRING_NO);
            }

            pushParams.add(syncItem);
        }

        if(CollectionUtils.isEmpty(pushParams)) {
            logger.error("可推送品牌关系为空，推送任务结束！");
            record.setPushResult("可推送品牌关系为空，推送任务结束！");
            record.setSucFlag(PlanConstant.STRING_NO);
            //更新品牌推送ERP结果
            this.updateRelationPushFlag(pushParam.getPushData().stream().map(BrandRelationVO::getId).collect(Collectors.toList()), pushResult);
            //推送记录放入待处理队列中
            queueUtils.sendMq(PushErpRecordListener.PUSH_ERP_RECORD_QUEUE+"_"+profile, JSONObject.toJSONString(record));
            return;
        }

        Map<String, String> headers = null;
        try {
            Stopwatch start = Stopwatch.createStarted();
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(pushParams),
                    headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);

            logger.info("品牌关系信息推送ERP：url-{}, 参数：{}，结果：{}", reqUrl,
                    JSONObject.toJSONString(pushParams, SerializerFeature.PrettyFormat), reqResp);
            Stopwatch stop = start.stop();

            record.setErpResult(reqResp);
            record.setErpHandleSeconds(stop.elapsed(TimeUnit.SECONDS));
            logger.info("品牌关系信息推送ERP耗时：{}秒", record.getErpHandleSeconds());

            JSONObject reqJson = JSONObject.parseObject(reqResp);
            if("ok".equals(reqJson.getString("status"))) {
                pushResult = PlanConstant.STRING_YES;
            } else {
                pushResult = PlanConstant.STRING_NO;
                record.setFailType("ERP数据处理失败！");

                //如果是更新，则判断品牌关系在ERP是否存在若不存在，则进行新增操作
                if(!PlanConstant.品牌关系新增.equals(pushParam.getPushType())) {
                    this.checkAndRePush(pushParams);
                }
            }
            record.setSucFlag(pushResult);

        } catch (Exception e) {
            logger.error("品牌关系信息同步ERP异常，", e);
            record.setSucFlag(PlanConstant.STRING_NO);
            pushResult = PlanConstant.STRING_NO;
            record.setFailType("品牌关系信息同步ERP，请求异常！");
        }

        //更新品牌推送ERP结果
        this.updateRelationPushFlag(pushParam.getPushData().stream().map(BrandRelationVO::getId).collect(Collectors.toList()), pushResult);

        //推送记录放入待处理队列中
        queueUtils.sendMq(PushErpRecordListener.PUSH_ERP_RECORD_QUEUE+"_"+profile, JSONObject.toJSONString(record));
        logger.info("品牌关系信息推送ERP-------------结束----------------");
    }

    private void checkAndRePush(List<JSONObject> pushParams) {
        logger.info("品牌关系信息  检测 并 推送ERP-------------开始----------------");
        logger.info("本次检测并重推ERP品牌信息：{}, 推送类型: {}", JSONObject.toJSONString(pushParams));


        MaPushErpRecordsEntity record = new MaPushErpRecordsEntity();
        record.setData(JSONObject.toJSONString(pushParams));
        record.setPushDate(new Date());
        record.setBeforePushSupInfo("品牌关系检查重新推送。。。。");
        record.setUrl(reqHost+PlanConstant.品牌关系更新推送ERP地址);
        String reqParams = pushParams.stream().map(item -> item.getString("C_PS_BrandLibraryRelationOID")).collect(Collectors.joining(","));
        Map<String, String> headers = null;
        JSONObject reqJson = null;
        String pushResult = null;
        try {
            //1、检查更新失败的品牌关系 是否都已在ERP中存在
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String queryUrl = reqHost+CHECK_ERP_RELATION_URL +"?inputStr=" + reqParams;
            String reqResp = HttpTookit.postByJson(queryUrl, JSONObject.toJSONString(new JSONObject()),
                    headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);

            logger.info("品牌关系信息ERP查询：url-{}, 参数：{}，结果：{}", queryUrl,
                    reqParams, reqResp);

            reqJson = JSONObject.parseObject(reqResp);
            if("ok".equals(reqJson.getString("status"))) {
                //获取在ERP已存在的品牌关系SID列表
                JSONArray relationArr = reqJson.getJSONArray("data");
                List<String> relationSids = relationArr.stream().map(item -> ((JSONObject) item).getString("C_PS_BrandLibraryRelationOID"))
                        .collect(Collectors.toList());

                List<JSONObject> addList = new ArrayList<>();
                List<JSONObject> updateList = new ArrayList<>();

                for(JSONObject relationJson : pushParams) {
                    if(relationSids.contains(relationJson.getString("C_PS_BrandLibraryRelationOID"))) {
                        updateList.add(relationJson);
                    } else {
                        addList.add(relationJson);
                    }
                }

                //2、在ERP中已存在的品牌关系走新增逻辑
                logger.info("本次检测后，新增品牌关系{}条", addList.size());
                if(CollectionUtils.isNotEmpty(addList)) {
                    MaPushErpRecordsEntity newRecord = BeanMapper.map(record, MaPushErpRecordsEntity.class);
                    headers = ZDSInterfaceCommonUtil.getErpHeaders();
                    Stopwatch start = Stopwatch.createStarted();
                    reqResp = HttpTookit.postByJson(reqHost+PlanConstant.品牌关系新增推送ERP地址, JSONObject.toJSONString(addList),
                            headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
                    logger.info("品牌关系新增推送ERP：url-{}, 参数：{}，结果：{}", reqHost+PlanConstant.品牌关系新增推送ERP地址,
                            JSONObject.toJSONString(addList, SerializerFeature.PrettyFormat), reqResp);
                    Stopwatch stop = start.stop();

                    newRecord.setErpResult(reqResp);
                    newRecord.setErpHandleSeconds(stop.elapsed(TimeUnit.SECONDS));
                    logger.info("品牌关系新增推送ERP耗时：{}秒", record.getErpHandleSeconds());

                    reqJson = JSONObject.parseObject(reqResp);
                    if("ok".equals(reqJson.getString("status"))) {
                        pushResult = PlanConstant.STRING_YES;
                    } else {
                        pushResult = PlanConstant.STRING_NO;
                        newRecord.setFailType("ERP数据处理失败！");
                    }
                    newRecord.setSucFlag(pushResult);
                    //推送记录放入待处理队列中
                    queueUtils.sendMq(PushErpRecordListener.PUSH_ERP_RECORD_QUEUE+"_"+profile, JSONObject.toJSONString(newRecord));
                }

                //3、在ERP中不存在的品牌关系走更新逻辑
                logger.info("本次检测后，更新品牌关系{}条", updateList.size());
                if(CollectionUtils.isNotEmpty(updateList)) {
                    MaPushErpRecordsEntity updateRecord = BeanMapper.map(record, MaPushErpRecordsEntity.class);
                    headers = ZDSInterfaceCommonUtil.getErpHeaders();
                    Stopwatch start = Stopwatch.createStarted();
                    reqResp = HttpTookit.postByJson(reqHost+PlanConstant.品牌关系更新推送ERP地址, JSONObject.toJSONString(updateList),
                            headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
                    logger.info("品牌关系更新推送ERP：url-{}, 参数：{}，结果：{}", reqHost+PlanConstant.品牌关系更新推送ERP地址,
                            JSONObject.toJSONString(updateList, SerializerFeature.PrettyFormat), reqResp);
                    Stopwatch stop = start.stop();

                    updateRecord.setErpResult(reqResp);
                    updateRecord.setErpHandleSeconds(stop.elapsed(TimeUnit.SECONDS));
                    logger.info("品牌关系更新推送ERP耗时：{}秒", record.getErpHandleSeconds());

                    reqJson = JSONObject.parseObject(reqResp);
                    if("ok".equals(reqJson.getString("status"))) {
                        pushResult = PlanConstant.STRING_YES;
                    } else {
                        pushResult = PlanConstant.STRING_NO;
                        updateRecord.setFailType("ERP数据处理失败！");
                    }
                    updateRecord.setSucFlag(pushResult);
                    //推送记录放入待处理队列中
                    queueUtils.sendMq(PushErpRecordListener.PUSH_ERP_RECORD_QUEUE+"_"+profile, JSONObject.toJSONString(record));
                }
            } else {
                logger.error("品牌关系信息同步ERP失败，{}", reqResp);
                record.setSucFlag(PlanConstant.STRING_NO);
                record.setFailType("品牌关系信息ERP查询，请求失败");
                //推送记录放入待处理队列中
                queueUtils.sendMq(PushErpRecordListener.PUSH_ERP_RECORD_QUEUE+"_"+profile, JSONObject.toJSONString(record));
            }
        } catch (Exception e) {
            logger.error("品牌关系信息同步ERP异常，", e);
            record.setSucFlag(PlanConstant.STRING_NO);
            record.setFailType("品牌关系信息同步ERP，请求异常！");
            //推送记录放入待处理队列中
            queueUtils.sendMq(PushErpRecordListener.PUSH_ERP_RECORD_QUEUE+"_"+profile, JSONObject.toJSONString(record));
        }

        logger.info("品牌关系信息  检测 并 推送ERP-------------结束----------------");
    }

    @Override
    public List<BrandRelationEntity> getAllByCategoryIds(List<Long> categoryIds, String brandName, String supplierName) {
        QueryWrapper<BrandRelationEntity> query = new QueryWrapper<>();
        query.in("material_type_id", categoryIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        if(StringUtils.isNotBlank(brandName)) {
            query.like("brand_name", brandName);
        }
        if(StringUtils.isNotBlank(supplierName)) {
            query.like("supplier_name", supplierName);
        }
        query.orderByAsc("material_type_code", "brand_name", "supplier_name");

        return super.list(query);
    }

    @Override
    public String saveOrUpdateRelations(List<BrandRelationVO> relations) {
        //查询供应商下所有品牌关系
        List<BrandRelationEntity> supplierRelations = this.getAllBySupplierId(relations.get(0).getSupplierId());
        //获取品牌关系对应的物料末级分类
        List<Long> categoryIds = new ArrayList<>(relations.stream().map(BrandRelationVO::getMaterialTypeId).collect(Collectors.toSet()));

        //是否生成流水
        boolean generateFlow = relations.get(0).isGenerateFlowFlag();
        //当前操作人
        Long operator = relations.get(0).getOperatorId();
        //操作类型
        String operateType = relations.get(0).getOperateType();
        //设置物料分类信息
        List<MaterialCategoryVO> categorys = categoryService.getAllByIds(categoryIds);
        //获取物料二级分类信息
        List<Long> categoryPids = new ArrayList<>(categorys.stream().map(MaterialCategoryVO::getParentId).collect(Collectors.toSet()));

        List<MaterialCategoryVO> categtoryParents = categoryService.getAllByIds(categoryPids);
        Map<Long, MaterialCategoryVO> categtoryParentsMap = categtoryParents.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<Long, MaterialCategoryVO> categtoryMap = categorys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));

        Map<Long, BrandRelationVO> relationMap = relations.stream().collect(Collectors.toMap(item -> item.getSourceDetailId(), item -> item));
        Map<String, List<BrandRelationVO>> relationKeyMap = null;

        //查询相关品牌信息
        List<Long> brandIds = new ArrayList<>(relations.stream().map(BrandRelationVO::getBrandId).collect(Collectors.toSet()));
        List<BrandVO> brandList = brandService.getAllByIds(brandIds);
        Map<Long, BrandVO> brandMap = brandList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));

        List<BrandRelationEntity> saveList = new ArrayList<>();
        List<BrandRelationEntity> updateList = new ArrayList<>();
        List<BrandRelationEntity> delList = new ArrayList<>();

        BrandRelationVO tmp = null;
        MaterialCategoryVO category = null;
        MaterialCategoryVO categoryP = null;
        BrandVO brand = null;
        BrandRelationEntity relation = null;
        List<BrandRelationFlowEntity> flowList = new ArrayList<>();

        //查询人员信息
        Long operatorId = relations.get(0).getOperatorId();
        UserVO user = null;
        if(null != operatorId) {
            CommonResponse<UserVO> userResp = userApi.findUserByUserId(operatorId);
            if(!userResp.isSuccess() || null == userResp.getData()) {
                logger.error("查询人员id-{}信息失败", operatorId);
            } else {
                user = userResp.getData();
            }
        }

        Map<Long, MatSupplierMaterialInfoVO> supplierMaterialMap = new HashMap<>();
        Map<String, List<MatSupplierMaterialInfoVO>> supplierMaterialBrandMap = new HashMap<>();
        if(StringUtils.isNotBlank(relations.get(0).getSupplierSid()) && null != relations.get(0).getSupplierId()) {
            //若供应商SID为空，则查询供应商SID信息
            CommonResponse<MatSupplierVO> supplierResp = supplierApi.getOneById(relations.get(0).getSupplierId());
            if(!supplierResp.isSuccess() || null == supplierResp.getData()) {
                logger.error("查询供应商id-{}信息失败，{}", JSONObject.toJSONString(supplierResp));
            } else {
                MatSupplierVO supplierVO = supplierResp.getData();
                relations.forEach(r -> r.setSupplierSid(supplierVO.getThirdSourceId()));
                supplierMaterialMap.putAll(supplierVO.getMaterialInfoList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }
        }

        BrandRelationEntity upDbRelation = null;
        if(CollectionUtils.isNotEmpty(supplierRelations)) {
            //品牌关系来源id对应供应商供货内容主键
            for(Iterator<BrandRelationEntity> it = supplierRelations.iterator(); it.hasNext(); ) {
                relation = null;
                tmp =null;
                upDbRelation = it.next();

                if(null != upDbRelation.getSourceDetailId() && relationMap.containsKey(upDbRelation.getSourceDetailId())) {
                    relation = upDbRelation;
                    tmp = relationMap.get(upDbRelation.getSourceDetailId());
                    supplierMaterialMap.remove(upDbRelation.getSourceDetailId());

                    //品牌或物料分类发生变化
                    upDbRelation.setPushErpFlag(PlanConstant.INTEGER_NO);
                    upDbRelation.setMaterialTypeId(tmp.getMaterialTypeId());
                    category = categtoryMap.get(upDbRelation.getMaterialTypeId());
                    upDbRelation.setMaterialTypeCode(category.getCode());
                    upDbRelation.setMaterialTypeName(category.getName());
                    upDbRelation.setMaterialTypeSid(category.getSourceId());

                    categoryP = categtoryParentsMap.get(category.getParentId());
                    upDbRelation.setMaterialTypePid(categoryP.getId());
                    upDbRelation.setMaterialTypePname(categoryP.getName());
                    upDbRelation.setMaterialTypePsid(categoryP.getSourceId());

                    brand = brandMap.get(tmp.getBrandId());
                    upDbRelation.setBrandId(brand.getId());
                    upDbRelation.setBrandName(brand.getBrandName());
                    upDbRelation.setBrandSid(brand.getSourceId());

                    upDbRelation.setSupplierName(tmp.getSupplierName());
                    upDbRelation.setSupplierCode(tmp.getSupplierCode());
                    upDbRelation.setSupplierSid(tmp.getSupplierSid());
                    upDbRelation.setSupplierCharacter(tmp.getSupplierCharacter());

                    //清空标签信息
                    upDbRelation.setBrandLabel(null);
                    upDbRelation.setDbSupplierFlag(PlanConstant.INTEGER_YES);

                    updateList.add(upDbRelation);
                    relationMap.remove(upDbRelation.getSourceDetailId());
                    it.remove();
                }
            }

            supplierMaterialBrandMap.putAll(supplierMaterialMap.values().stream().collect(Collectors.groupingBy(item -> item.getMaterialId().toString() + item.getBrandId())));
            MatSupplierMaterialInfoVO tmpInfo = null;
            relationKeyMap = relations.stream().collect(Collectors.groupingBy(item -> item.getMaterialTypeId().toString()+item.getBrandId().toString()));
            List<BrandRelationVO> tmpRelationList = null;
            //来源主键与供应商供货内容主键不一致
            for(BrandRelationEntity dbRelation : supplierRelations) {
                relation = null;
                tmp =null;

                if(null == relation && relationKeyMap.containsKey(dbRelation.getMaterialTypeId().toString()+dbRelation.getBrandId().toString())) {
                    relation = dbRelation;
                    tmpRelationList = relationKeyMap.get(dbRelation.getMaterialTypeId().toString()+dbRelation.getBrandId().toString());
                    if(CollectionUtils.isNotEmpty(tmpRelationList)) {
                        tmp = tmpRelationList.get(0);
                        tmpRelationList.remove(tmp);
                        if(tmpRelationList.isEmpty()) {
                            relationKeyMap.remove(dbRelation.getMaterialTypeId().toString()+dbRelation.getBrandId().toString());
                        }
                    }
                }
                if(supplierMaterialBrandMap.containsKey(dbRelation.getMaterialTypeId().toString()+dbRelation.getBrandId().toString()) && CollectionUtils.isNotEmpty(supplierMaterialBrandMap.get(dbRelation.getMaterialTypeId().toString()+dbRelation.getBrandId().toString()))) {
                    tmpInfo = supplierMaterialBrandMap.get(dbRelation.getMaterialTypeId().toString()+dbRelation.getBrandId().toString()).get(0);
                    supplierMaterialBrandMap.get(dbRelation.getMaterialTypeId().toString()+dbRelation.getBrandId().toString()).remove(tmpInfo);
                }

                if(null == tmp) {
                    //关系删除项
                    dbRelation.setDelFlag(PlanConstant.STRING_YES);
                    delList.add(dbRelation);
                } else {
                    if(PlanConstant.STRING_YES.equals(tmp.getDelFlag())) {
                        //关系删除项
                        dbRelation.setDelFlag(PlanConstant.STRING_YES);
                        delList.add(dbRelation);
                    } else {


                        //品牌或物料分类发生变化
                        dbRelation.setPushErpFlag(PlanConstant.INTEGER_NO);
                        dbRelation.setMaterialTypeId(tmp.getMaterialTypeId());
                        category = categtoryMap.get(dbRelation.getMaterialTypeId());
                        dbRelation.setMaterialTypeCode(category.getCode());
                        dbRelation.setMaterialTypeName(category.getName());
                        dbRelation.setMaterialTypeSid(category.getSourceId());

                        categoryP = categtoryParentsMap.get(category.getParentId());
                        dbRelation.setMaterialTypePid(categoryP.getId());
                        dbRelation.setMaterialTypePname(categoryP.getName());
                        dbRelation.setMaterialTypePsid(categoryP.getSourceId());

                        brand = brandMap.get(tmp.getBrandId());
                        dbRelation.setBrandId(brand.getId());
                        dbRelation.setBrandName(brand.getBrandName());
                        dbRelation.setBrandSid(brand.getSourceId());

                        dbRelation.setSupplierName(tmp.getSupplierName());
                        dbRelation.setSupplierCode(tmp.getSupplierCode());
                        dbRelation.setSupplierSid(tmp.getSupplierSid());
                        dbRelation.setSupplierCharacter(tmp.getSupplierCharacter());

                        //清空标签信息
                        dbRelation.setBrandLabel(null);
                        dbRelation.setDbSupplierFlag(PlanConstant.INTEGER_YES);
                        if(null != tmpInfo) {
                            dbRelation.setSourceDetailId(tmpInfo.getId());
                        }


                        updateList.add(dbRelation);
                    }

                    if(null != tmp) {
                        if(CollectionUtils.isNotEmpty(tmp.getDetailList())) {
                            flowList.addAll(BeanMapper.mapList(tmp.getDetailList(), BrandRelationFlowEntity.class));
                        } else if(generateFlow) {
                            //生成流水
                            BrandRelationFlowEntity flow = new BrandRelationFlowEntity();
                            flow.setSourceBillId(tmp.getSourceMainId());
                            flow.setSourceBillDetailId(tmp.getSourceDetailId());
                            flow.setRelationId(relation.getId());
                            flow.setOperateTime(new Date());
                            flow.setOperateUserId(operator);
                            flow.setOperateType(operateType + "-更新品牌关系");
                            flow.setBillPcUrl(tmp.getPcUrl());
                            if(null != user) {
                                flow.setOperateUserCode(user.getUserCode());
                                flow.setOperateUserName(user.getUserName());
                            }
                            flowList.add(flow);
                        }
                    } else if(null != relation && generateFlow) {
                        //生成流水
                        BrandRelationFlowEntity flow = new BrandRelationFlowEntity();
                        flow.setSourceBillId(relation.getSourceMainId());
                        flow.setSourceBillDetailId(relation.getSourceDetailId());
                        flow.setRelationId(relation.getId());
                        flow.setOperateTime(new Date());
                        flow.setOperateUserId(operator);
                        flow.setOperateType(operateType + "-删除品牌关系");
                        if(null != user) {
                            flow.setOperateUserCode(user.getUserCode());
                            flow.setOperateUserName(user.getUserName());
                        }
                        flowList.add(flow);
                    }

                    relationMap.remove(tmp.getSourceDetailId());
                }
            }
        }

        if(MapUtils.isNotEmpty(relationMap)) {
            for(BrandRelationVO newRelation : relationMap.values()) {
                relation = new BrandRelationEntity();
                relation.setPushErpFlag(PlanConstant.INTEGER_NO);
                relation.setMaterialTypeId(newRelation.getMaterialTypeId());
                category = categtoryMap.get(relation.getMaterialTypeId());
                relation.setMaterialTypeCode(category.getCode());
                relation.setMaterialTypeName(category.getName());
                relation.setMaterialTypeSid(category.getSourceId());

                categoryP = categtoryParentsMap.get(category.getParentId());
                relation.setMaterialTypePid(categoryP.getId());
                relation.setMaterialTypePname(categoryP.getName());
                relation.setMaterialTypePsid(categoryP.getSourceId());

                brand = brandMap.get(newRelation.getBrandId());
                if(null == brand) {
                    logger.info("供应商id-{}对应品牌【id-{},brandName-{}】信息无匹配信息或已被删除", newRelation.getSupplierId(),
                            newRelation.getBrandId(), newRelation.getBrandName());
                    continue;
                }
                relation.setBrandId(brand.getId());
                relation.setBrandName(brand.getBrandName());
                relation.setBrandSid(brand.getSourceId());

                relation.setBrandLabel(null);
                relation.setDbSupplierFlag(PlanConstant.INTEGER_YES);
                relation.setRelationEnabled(PlanConstant.INTEGER_YES); //默认启用
                relation.setSupplierId(newRelation.getSupplierId());
                relation.setSupplierSid(newRelation.getSupplierSid());
                relation.setSupplierCode(newRelation.getSupplierCode());
                relation.setSupplierName(newRelation.getSupplierName());
                relation.setSourceMainId(newRelation.getSourceMainId());
                relation.setSourceDetailId(newRelation.getSourceDetailId());
                relation.setId(IdWorker.getId());
                relation.setSourceId(ZDSInterfaceCommonUtil.changeLongToGUID(relation.getId()));
                relation.setSupplierCharacter(newRelation.getSupplierCharacter());

                if(CollectionUtils.isNotEmpty(newRelation.getDetailList())) {
                    flowList.addAll(BeanMapper.mapList(newRelation.getDetailList(), BrandRelationFlowEntity.class));
                } else if(generateFlow) {
                    //生成流水
                    BrandRelationFlowEntity flow = new BrandRelationFlowEntity();
                    flow.setSourceBillId(newRelation.getSourceMainId());
                    flow.setSourceBillDetailId(newRelation.getSourceDetailId());
                    flow.setRelationId(relation.getId());
                    flow.setOperateTime(new Date());
                    flow.setOperateUserId(newRelation.getOperatorId());
                    flow.setOperateType(newRelation.getOperateType() + "-新增品牌关系");
                    flow.setBillPcUrl(newRelation.getPcUrl());
                    if(null != user) {
                        flow.setOperateUserCode(user.getUserCode());
                        flow.setOperateUserName(user.getUserName());
                    }
                    flowList.add(flow);
                }

                saveList.add(relation);
            }
        }

        String billType = relations.get(0).getBillType();
        logger.info("本次新增供应商品牌关系：{}条", saveList.size());
        if(CollectionUtils.isNotEmpty(saveList)) {
            super.saveOrUpdateBatch(saveList, saveList.size(), false);
            List<BrandRelationEntity> syncList = saveList.stream().collect(Collectors.toList());
            //推送ERP
            if(CollectionUtils.isNotEmpty(syncList)) {
                queueUtils.sendMq(DataPushErpParam.DATA_PUSH_ERP_QUEUE+"_"+profile,
                        JSONObject.toJSONString(new DataPushErpParam(BeanMapper.mapList(syncList, BrandRelationVO.class),
                                operatorId, PlanConstant.品牌关系新增, billType)));
            }
        }
        logger.info("本次更新供应商品牌关系：{}条", updateList.size());
        if(CollectionUtils.isNotEmpty(updateList)) {
            super.saveOrUpdateBatch(updateList, updateList.size(), false);
            //推送ERP
            queueUtils.sendMq(DataPushErpParam.DATA_PUSH_ERP_QUEUE+"_"+profile,
                    JSONObject.toJSONString(new DataPushErpParam(BeanMapper.mapList(updateList, BrandRelationVO.class),
                            operatorId, PlanConstant.品牌关系更新, billType)));
        }
        logger.info("本次删除供应商品牌关系：{}条", delList.size());
        if(CollectionUtils.isNotEmpty(delList)) {
            super.removeByIds(delList.stream().map(BrandRelationEntity::getId).collect(Collectors.toList()));
            //推送ERP
            queueUtils.sendMq(DataPushErpParam.DATA_PUSH_ERP_QUEUE+"_"+profile,
                    JSONObject.toJSONString(new DataPushErpParam(BeanMapper.mapList(delList, BrandRelationVO.class),
                            operatorId, PlanConstant.品牌关系更新, billType)));
        }

        logger.info("本次保存流水：{}条", flowList.size());
        if(CollectionUtils.isNotEmpty(flowList)) {
            relationFlowService.saveOrUpdateBatch(flowList, flowList.size(), false);
        }

        return null;
    }

    @Override
    public List<BrandRelationEntity> getAllBySupplierId(Long supplierId) {
        QueryWrapper<BrandRelationEntity> query = new QueryWrapper<>();
        query.eq("supplier_id", supplierId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        return super.list(query);
    }

    @Override
    public List<BrandRelationEntity> getTerminatedRelations() {
        return mapper.getTerminatedRelations();
    }

    private void updateRelationPushFlag(List<Long> ids, String pushResult) {
        UpdateWrapper<BrandRelationEntity> update = new UpdateWrapper<>();
        update.in("id", ids);
        update.set("push_erp_flag", pushResult);

        super.update(update);
    }

    private void initContext(Long userId) {
        String initContextUrl = environmentTools.getBaseHost() + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        initContextUrl = initContextUrl + "&userId="+userId.toString();
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);

        CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
        try {
            if(userContextResponse.isSuccess()) {
                JSONObject userContext =userContextResponse.getData().getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if(null != userContext) {
                    authtoken.append("userType=").append(userContext.get("userType"))
                            .append(";userCode=").append(userContext.get("userCode"))
                            .append(";orgId=").append(userContext.get("orgId"))
                            .append(";tenantid=").append(userContext.get("tenantid"))
                            .append(";token=").append(userContext.get("token"))
                            .append(";u_logints=").append(userContext.get("u_logints"))
                            .append(";u_usercode=").append(userContext.get("u_usercode"))
                            .append(";userId=").append(userContext.get("userId"));
                }
                if(authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());
                    InvocationInfoProxy.setParameter(ReferConstant.HEAD_authority, authtoken.toString());
                }
                if(null != userContext) {
                    InvocationInfoProxy.setTenantid(userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid(userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode(userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId(userContext.getLong("orgId"));
                }
            }
        } catch (Exception e) {
            logger.error("初始化异步任务上下文异常：",e);
        }

    }
}
