/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.cloudstore.apply.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cloudstore.apply.bean.AllotApplyDetailEntity;
import com.ejianc.business.zdsmaterial.cloudstore.apply.bean.AllotApplyEntity;
import com.ejianc.business.zdsmaterial.cloudstore.apply.service.IAllotApplyService;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyDetailVO;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyVO;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"allotApply"})
public class AllotApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ALLOT_ACCEPT";
    @Autowired
    private IAllotApplyService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IGoodsService goodsService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AllotApplyVO> saveOrUpdate(@RequestBody AllotApplyVO saveOrUpdateVO) {
        List<AllotApplyDetailEntity> detailList;
        AllotApplyEntity entity = (AllotApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AllotApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(detailList = entity.getDetailList())) {
            List<Long> collect = detailList.stream().map(e -> e.getSourceId()).collect(Collectors.toList());
            Map<Long, BigDecimal> allotableNum = this.goodsService.getAllotableNum(collect);
            for (AllotApplyDetailEntity detail : detailList) {
                if (!allotableNum.containsKey(detail.getSourceId())) continue;
                BigDecimal decimal = allotableNum.get(detail.getSourceId());
                if (!ComputeUtil.isGreaterThan((BigDecimal)detail.getAllotNum(), (BigDecimal)decimal)) continue;
                return CommonResponse.error((String)("\u7269\u8d44\uff1a" + detail.getMaterialName() + "\u8c03\u62e8\u91cf\u5927\u4e8e\u4e0a\u67b6\u6570\u91cf!"));
            }
        }
        BigDecimal decimal = saveOrUpdateVO.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).collect(Collectors.reducing(BigDecimal.ZERO, AllotApplyDetailVO::getAllotTaxMny, BigDecimal::add));
        entity.setTaxMny(decimal);
        String materialTypeNames = saveOrUpdateVO.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(AllotApplyDetailVO::getMaterialTypeName).collect(Collectors.toSet()).stream().distinct().collect(Collectors.joining(","));
        entity.setMaterialNames(materialTypeNames);
        this.service.saveOrUpdate((Object)entity, false);
        AllotApplyVO vo = (AllotApplyVO)BeanMapper.map((Object)((Object)entity), AllotApplyVO.class);
        return this.queryDetail(entity.getId());
    }

    @RequestMapping(value={"/addAllotApplyByGoods"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AllotApplyVO> addAllotApplyByGoods(@RequestBody GoodsVO goodsVO) {
        AllotApplyVO allotApplyVO = this.service.addAllotApplyByGoods(goodsVO);
        return CommonResponse.success((Object)allotApplyVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AllotApplyVO> queryDetail(Long id) {
        return this.service.queryDetail(id);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AllotApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AllotApplyVO allotApplyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AllotApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("purUserName");
        fuzzyFields.add("inProjectCode");
        fuzzyFields.add("purUserPhone");
        fuzzyFields.add("materialNames");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("inParentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("inOrgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AllotApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List records = new ArrayList();
        CommonResponse<IPage<AllotApplyVO>> iPageCommonResponse = this.queryList(param);
        if (iPageCommonResponse.isSuccess()) {
            records = ((IPage)iPageCommonResponse.getData()).getRecords();
        }
        records.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        HashMap beans = new HashMap();
        beans.put("records", records);
        ExcelExport.getInstance().export("AllotApply-export.xlsx", beans, response);
    }
}

