package com.ejianc.business.zdsmaterial.asynchandler.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.asynchandler.bean.MaPushErpRecordsEntity;
import com.ejianc.business.zdsmaterial.asynchandler.service.IMaPushErpRecordsService;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 接受并保存推送ERP数据记录
 *
 * @author CJ
 * @Description:
 * @date 2024/4/24 11:31
 */
@Component
public class PushErpRecordListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String PUSH_ERP_RECORD_QUEUE = "ma_push_erp_record";

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private IMaPushErpRecordsService service;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        logger.info("接收到待保存推送ERP数据记录：{}", mqMessage.getBody());
        try {
            MaPushErpRecordsEntity record = JSONObject.parseObject(mqMessage.getBody().toString(), MaPushErpRecordsEntity.class);
            service.saveOrUpdate(record, false);
        } catch (Exception e) {
            logger.error("保存数据同步ERP记录异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{PUSH_ERP_RECORD_QUEUE+"_1"+profile};
    }
}
