package com.ejianc.business.zdsmaterial.erp.service;

import com.ejianc.business.zdsmaterial.erp.bean.ExpenseAccountDetailEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2024/10/22 16:56
 */
public interface IExpenseAccountDetailService extends IBaseService<ExpenseAccountDetailEntity> {
    List<ExpenseAccountDetailEntity> getAllBySourceDetailIds(List<String> sourceDetailIds);

    /**
     * 占用或释放报销单明细入库量
     *
     * @param expenseAccountId 主表Id
     * @param nums
     * @param addFlag true-占用，false-释放
     */
    String handleAcceptNum(Long expenseAccountId, Map<Long, BigDecimal> nums, boolean addFlag);

    /**
     * 可验收量验证
     *
     * @param nums
     * @return
     */
    String validateAcceptNum(Map<Long, BigDecimal> nums);
}
