package com.ejianc.business.zdsmaterial.out.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.BillPushStatusEnum;
import com.ejianc.business.zdsmaterial.cons.enums.ClaimTypeEnum;
import com.ejianc.business.zdsmaterial.out.bean.OutStoreEntity;
import com.ejianc.business.zdsmaterial.out.service.IOutStoreService;
import com.ejianc.business.zdsmaterial.out.service.impl.OutStoreBpmServiceImpl;
import com.ejianc.business.zdsmaterial.out.vo.ExportOutStoreVO;
import com.ejianc.business.zdsmaterial.out.vo.OutStoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 领料出库
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outStore")
@Api(value = "领料出库", tags = {"领料出库"})
public class OutStoreController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOutStoreService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @Autowired
    private IProSupplierApi proSupplierApi;
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-zdssupbusiness-mobile/#/proMaterial/outStore/card";

    private final String billTypeCode = PlanConstant.OUT_STORE_BILL_TYPE;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutStoreVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OutStoreVO saveOrUpdateVO) {
    	return service.saveOrUpdate(saveOrUpdateVO);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutStoreVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        OutStoreEntity entity = service.selectById(id);
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSubSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSubSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("单据获取供方信息失败，生成分享连接失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法协同分享。");
        }
        if(BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(entity);
                logger.info("获取推送供方结果--"+pushResult);
                if(!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSubSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }
        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSubSupplierId().toString(), mobileBillShareFrontUrl,null);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutStoreVO> vos) {
        return service.del(vos);
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryList(@RequestBody QueryParam param) {
        this.getQueryParam(param);
        param.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_EL));// 自制

        IPage<OutStoreEntity> page = service.queryPage(param,false);
        IPage<OutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutStoreVO> records = BeanMapper.mapList(page.getRecords(), OutStoreVO.class);
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @ApiOperation("查询供方发起列表")
    @RequestMapping(value = "/queryListBySupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryListBySupplier(@RequestBody QueryParam param) {
        this.getQueryParam(param);
        param.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_SUPPLIER));// 供方发起

        IPage<OutStoreEntity> page = service.queryPage(param,false);
        IPage<OutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutStoreVO> records = BeanMapper.mapList(page.getRecords(), OutStoreVO.class);

        // 赋值是否确认人
        List<Long> projectIds = records.stream().map(OutStoreVO::getProjectId).collect(Collectors.toList());
        List<Long> contractIds = records.stream().filter(x->x.getSubContractId() != null).map(OutStoreVO::getSubContractId).collect(Collectors.toList());
        Map<Long, Boolean> confirmMap = service.queryConfirmEnable(projectIds, contractIds);
        for(OutStoreVO vo : records){
            if(confirmMap.containsKey(vo.getSubContractId())){
                vo.setConfirmEnable(confirmMap.get(vo.getSubContractId()));
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private void getQueryParam(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("subSupplierName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subEmployeeName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("useFor");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        this.getQueryParam(param);
        param.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_EL));// 自制
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<OutStoreEntity> list = service.queryList(param);
        List<ExportOutStoreVO> listVO = new ArrayList<>();
        //todo:字段翻译等等
       if(CollectionUtils.isNotEmpty(list)){
           for (OutStoreEntity entity : list) {
               ExportOutStoreVO storeVO = BeanMapper.map(entity, ExportOutStoreVO.class);
               storeVO.setBillState(BillStateEnum.getEnumByStateCode(entity.getBillState()).getDescription());
               storeVO.setSignStatus(PlanConstant.SIGN_STATUS.get(entity.getSignStatus()));
               storeVO.setSourceType(PlanConstant.OUT_SOURCE_TYPE.get(entity.getSourceType()));
               storeVO.setConfirmState(PlanConstant.CONFIRM_STATE.get(entity.getConfirmState()));
               storeVO.setClaimType(ClaimTypeEnum.getEnumByStateCode(entity.getClaimType()).getDescription());
               if(entity.getOutDate()!=null){
                   storeVO.setOutDate(DateFormatUtil.formatDate("yyyy-MM-dd", entity.getOutDate()));
               }
               listVO.add(storeVO);
           }
       }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listVO);
        ExcelExport.getInstance().export("OutStore-export.xlsx", beans, response);
    }

    @ApiOperation("供方发起导出")
    @RequestMapping(value = "/excelExportBySupplier", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportBySupplier(@RequestBody QueryParam param, HttpServletResponse response) {
        this.getQueryParam(param);
        param.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_SUPPLIER));// 供方发起
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<OutStoreEntity> list = service.queryList(param);
        List<ExportOutStoreVO> listVO = new ArrayList<>();
        //todo:字段翻译等等
        if(CollectionUtils.isNotEmpty(list)){
            for (OutStoreEntity entity : list) {
                ExportOutStoreVO storeVO = BeanMapper.map(entity, ExportOutStoreVO.class);
                storeVO.setBillState(BillStateEnum.getEnumByStateCode(entity.getBillState()).getDescription());
                storeVO.setSignStatus(PlanConstant.SIGN_STATUS.get(entity.getSignStatus()));
                storeVO.setSourceType(PlanConstant.OUT_SOURCE_TYPE.get(entity.getSourceType()));
                storeVO.setConfirmState(PlanConstant.CONFIRM_STATE.get(entity.getConfirmState()));
                storeVO.setClaimType(ClaimTypeEnum.getEnumByStateCode(entity.getClaimType()).getDescription());
                if(entity.getOutDate()!=null){
                    storeVO.setOutDate(DateFormatUtil.formatDate("yyyy-MM-dd", entity.getOutDate()));
                }
                listVO.add(storeVO);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listVO);
        ExcelExport.getInstance().export("OutStoreBySupplier-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOutStoreData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> refOutStoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutStoreEntity> page = service.queryPage(param,false);
        IPage<OutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutStoreVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 单据确认并回写协同业务系统
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "/billConfirm")
    @ResponseBody
    public CommonResponse<String> billConfirm(@RequestBody OutStoreVO vo) {
        String msg = service.updateBillConfirmState(vo);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("操作成功！");
    }

    @ApiOperation("查询已签字列表")
    @RequestMapping(value = "/queryFinishList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryFinishList(@RequestBody QueryParam param) {
        param.getParams().put("signStatus", new Parameter(QueryParam.EQ, PlanConstant.SIGN_STATUS_YES));
        IPage<OutStoreVO> pageData = service.queryOutStoreList(param);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("查询未签字列表")
    @RequestMapping(value = "/queryWaitList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryWaitList(@RequestBody QueryParam param) {
        param.getParams().put("signStatus", new Parameter(QueryParam.EQ, PlanConstant.SIGN_STATUS_NO));
        IPage<OutStoreVO> pageData = service.queryOutStoreList(param);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("接收领料出库")
    @RequestMapping(value = "/saveOutStore", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> saveOutStore(HttpServletRequest request) {
        return CommonResponse.success("接收成功！", service.saveOutStore(request));
    }

    @ApiOperation("领料出库撤回")
    @RequestMapping(value = "/deleteOutStore", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> deleteOutStore(@RequestBody OutStoreVO vo) {
        return CommonResponse.success("撤回成功！", service.delOutStore(vo));
    }

//    @ApiOperation("签字")
//    @RequestMapping(value = "/saveSignStatus", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<OutStoreVO> saveSignStatus(@RequestBody OutStoreVO vo) {
//        return CommonResponse.success("签字成功！", service.saveSignStatus(vo));
//    }

    @Autowired
    private OutStoreBpmServiceImpl bpmService;

    /**
     * 审批后事件
     * @param id
     * @return
     */
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String > test(@RequestParam Long id) {
        CommonResponse<String> response = bpmService.afterApprovalProcessor(id, null, null);
        OutStoreEntity entity = service.selectById(id);
        entity.setBillState(1);
        service.updateById(entity);
        return response;
    }

    /**
     * 弃审后事件
     * @param id
     * @return
     */
    @RequestMapping(value = "/test2", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String > test2(@RequestParam Long id) {
        CommonResponse<String> response = bpmService.afterAbstainingProcessor(id, null, null);
        OutStoreEntity entity = service.selectById(id);
        entity.setBillState(0);
        service.updateById(entity);
        return response;
    }
}
