/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.asynchandler.bean.BillStatusUpdateVO;
import com.ejianc.business.zdsmaterial.cloudstore.constants.CommonConstants;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractManagerService;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.erp.service.IMessageInfoService;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceFileEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceOcrEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MatInvoiceMapper;
import com.ejianc.business.zdsmaterial.material.service.IMatCheckerSettingService;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceDetailService;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceService;
import com.ejianc.business.zdsmaterial.material.vo.MatInvoiceVO;
import com.ejianc.business.zdsmaterial.util.BillLockUtil;
import com.ejianc.business.zdsmaterial.util.CommonUtils;
import com.ejianc.business.zdsmaterial.util.PushFileUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="matInvoiceService")
public class MatInvoiceServiceImpl
extends BaseServiceImpl<MatInvoiceMapper, MatInvoiceEntity>
implements IMatInvoiceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "EJCBT202404000001";
    private static final String BILL_NAME = "\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matInvoice/supSignSync";
    private static final String BILL_CODE = "MAT_INVOICE";
    private static final String INVOICE_CHECK_LIST_CODE = "constituent-company-list";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IMatSupplierApi matSupplierApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IErpInvoiceService erpInvoiceService;
    @Autowired
    private PushFileUtil pushFileUtil;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IErpInvoiceDetailService invoiceDetailService;
    @Autowired
    private IMatCheckerSettingService matCheckerSettingService;
    @Autowired
    private IMessageInfoService messageInfoService;
    @Autowired
    private IErpInvoiceDetailService erpInvoiceDetailService;
    private final String COMPANY_SOCIAL_CODE = "company_social_code";
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IContractManagerService contractManagerService;
    @Autowired
    private IMatInvoiceDetailService detailService;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    @Autowired
    private QueueUtils queueUtils;

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveSyncBill(HttpServletRequest request) {
        this.logger.info("\u8fdb\u5165\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String fileStrList = request.getParameter("fileList");
        List fileList = JSONArray.parseArray((String)fileStrList, AttachmentVO.class);
        this.logger.info("\u63a5\u6536\u5230\u6570\u636etransData\uff1a{}\uff0cfileList\uff1a{},", (Object)transData, (Object)fileStrList);
        MatInvoiceVO vo = (MatInvoiceVO)JSONObject.parseObject((String)transData, MatInvoiceVO.class);
        if (vo == null || vo.getId() == null) {
            throw new BusinessException("\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        MatInvoiceEntity saveEntity = (MatInvoiceEntity)((Object)BeanMapper.map((Object)vo, MatInvoiceEntity.class));
        try {
            CommonResponse ejcCloudSystemCode;
            BillCodeParam billCodeParam;
            CommonResponse billCode;
            Long checkerId;
            ContractEntity contract;
            boolean lock = BillLockUtil.getLock(BILL_TYPE, vo.getId(), 600);
            if (!lock) {
                throw new BusinessException("\u5355\u636e\u4fe1\u606f\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            saveEntity.setPrintFlag(PlanConstant.INTEGER_NO);
            EmployeeVO craetor = null;
            if ("1".equals(saveEntity.getOpenOcrState())) {
                Set inValidNumbers = saveEntity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && !"1".equals(x.getOcrState())).map(x -> x.getInvoiceNumber()).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(inValidNumbers)) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25, \u53f7\u7801\u4e3a\u3010" + inValidNumbers.stream().collect(Collectors.joining("\u3001")) + "\u3011\u7684\u53d1\u7968\u672a\u4e0a\u4f20\u53d1\u7968\u9644\u4ef6\uff01");
                }
                inValidNumbers = saveEntity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && !"\u67e5\u9a8c\u901a\u8fc7".equals(x.getOcrCheckMsg())).map(x -> x.getInvoiceNumber()).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(inValidNumbers)) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25, \u53d1\u7968\u3010" + inValidNumbers.stream().collect(Collectors.joining("\u3001")) + "\u3011\u4e0b\u5b58\u5728\u67e5\u9a8c\u672a\u901a\u8fc7\u7684\u6e05\u5355\uff01");
                }
            } else if (CollectionUtils.isEmpty(saveEntity.getFileList())) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25, \u672a\u4e0a\u4f20\u53d1\u7968\u9644\u4ef6!");
            }
            if (null == (contract = (ContractEntity)((Object)this.contractService.selectById(saveEntity.getContractId())))) {
                this.logger.error("\u6839\u636e\u91c7\u8d2d\u5408\u540cid-{}\uff0c\u67e5\u8be2\u5bf9\u5e94\u91c7\u8d2d\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)saveEntity.getContractId());
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25, \u67e5\u8be2\u53d1\u7968\u5bf9\u5e94\u5408\u540c\u4fe1\u606f\u5931\u8d25!");
            }
            if (CollectionUtils.isEmpty(saveEntity.getDetailList())) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53d1\u7968\u6e05\u5355\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)contract.getContractPartyA())) {
                String partA = contract.getContractPartyA();
                Set invoiceNumers = saveEntity.getDetailList().stream().filter(item -> !partA.replaceAll("\uff08", "(").replaceAll("\uff09", ")").equals(item.getInvoiceHeader().replaceAll("\uff08", "(").replaceAll("\uff09", ")"))).map(item -> item.getInvoiceNumber()).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(invoiceNumers)) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53d1\u7968\u3010" + invoiceNumers.stream().collect(Collectors.joining("\u3001")) + "\u3011\u62ac\u5934\u4e0e\u5408\u540c\u7532\u65b9\u4fe1\u606f\u4e0d\u4e00\u81f4\uff01");
                }
                if ("1".equals(saveEntity.getOpenOcrState()) && CollectionUtils.isNotEmpty(saveEntity.getOcrList())) {
                    List companySocialVos;
                    String socialCode = null;
                    CommonResponse defDetails = this.defdocApi.detailListByDetailNamesAndDocCode(new String[]{partA}, "company_social_code");
                    if (!defDetails.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)defDetails.getData()))) {
                        this.logger.info("*******\u83b7\u53d6\u7532\u65b9\uff1a{}\u5bf9\u5e94\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u5931\u8d25\u6216\u4e3a\u7a7a*********\uff01");
                    }
                    if (CollectionUtils.isNotEmpty(companySocialVos = ((List)defDetails.getData()).stream().filter(item -> item.getName().equals(partA)).collect(Collectors.toList()))) {
                        socialCode = ((DefdocDetailVO)companySocialVos.get(0)).getCode();
                    }
                    JSONObject identifyResult = null;
                    for (MatInvoiceOcrEntity item2 : saveEntity.getOcrList()) {
                        identifyResult = JSONObject.parseObject((String)item2.getIdentifyResult());
                        if (StringUtils.isNotBlank((CharSequence)partA) && !partA.replaceAll("\uff08", "(").replaceAll("\uff09", ")").equals(identifyResult.getString("purchaserName").replaceAll("\uff08", "(").replaceAll("\uff09", ")"))) {
                            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff1a\u8d2d\u4e70\u65b9\u4e0e\u5408\u540c\u7532\u65b9\u4fe1\u606f\u4e0d\u4e00\u81f4");
                        }
                        if (!StringUtils.isNotBlank((CharSequence)socialCode) || socialCode.equalsIgnoreCase(identifyResult.getString("purchaserTaxNumber"))) continue;
                        throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff1a\u8d2d\u4e70\u65b9\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u9519\u8bef");
                    }
                }
            }
            if (null == (checkerId = this.contractManagerService.getContractOperator(saveEntity.getContractId(), "1"))) {
                checkerId = this.matCheckerSettingService.getByContractId(saveEntity.getContractId());
            }
            if (null == checkerId && StringUtils.isNotBlank((CharSequence)saveEntity.getAdminId())) {
                checkerId = Long.valueOf(saveEntity.getAdminId());
            }
            if (null == checkerId) {
                this.logger.error("\u6839\u636e\u91c7\u8d2d\u5408\u540cid-{}\uff0c\u67e5\u8be2\u5bf9\u5e94\u91c7\u8d2d\u53d1\u7968\u4eba\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)saveEntity.getContractId());
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u53d1\u7968\u672a\u8bbe\u7f6e\u5bf9\u5e94\u5ba1\u6838\u4eba!");
            }
            CommonResponse creatorResp = this.employeeApi.getById(checkerId);
            if (!creatorResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u5931\u8d25,{}", (Object)checkerId, (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
            }
            if (null == creatorResp.getData()) {
                this.logger.error("\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u4e3a\u7a7a,{}", (Object)checkerId, (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
            }
            craetor = (EmployeeVO)creatorResp.getData();
            if (!checkerId.equals(saveEntity.getAdminId())) {
                saveEntity.setAdminId(craetor.getId().toString());
                saveEntity.setAdminCode(craetor.getCode());
                saveEntity.setAdminName(craetor.getName());
            }
            if ((billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo))).isSuccess()) {
                saveEntity.setBillCode((String)billCode.getData());
            }
            saveEntity.setSourceId(saveEntity.getId());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setSignState(Integer.valueOf("0"));
            CommonUtils.clearInvalidData(saveEntity);
            saveEntity.setRejectReason(null);
            saveEntity.setCreateUserName(craetor.getUserName());
            saveEntity.setCreateUserId(craetor.getUserId());
            saveEntity.setCreateUserCode(craetor.getCode());
            saveEntity.setPushErpFlag("0");
            ArrayList<Long> invoiceIds = new ArrayList<Long>();
            ArrayList<String> invoiceNums = new ArrayList();
            for (MatInvoiceDetailEntity detail : saveEntity.getDetailList()) {
                detail.setSourceId(detail.getId());
                detail.setSourceMainId(detail.getMainId());
                CommonUtils.clearInvalidData(detail);
                detail.setCreateUserCode(craetor.getUserCode());
                invoiceIds.add(detail.getInvoiceId());
            }
            if (CollectionUtils.isNotEmpty(invoiceIds)) {
                List<String> list;
                List<ErpInvoiceEntity> invoiceList = this.erpInvoiceService.getAllByIds(invoiceIds);
                invoiceNums = invoiceList.stream().map(ErpInvoiceEntity::getNumber).collect(Collectors.toList());
                List<ErpInvoiceEntity> list2 = this.erpInvoiceService.getAllByInvoiceNums(invoiceNums);
                this.logger.info("\u91c7\u8d2d: \u6839\u636e\u53d1\u7968\u53f7\uff1a{}, EL\u67e5\u8be2\u5230\u53d1\u7968\u6570\uff1a{}", (Object)JSONObject.toJSONString(invoiceNums), (Object)list2.size());
                HashSet quoteNumList = new HashSet();
                for (ErpInvoiceEntity e : list2) {
                    this.logger.info("\u91c7\u8d2d\u53d1\u7968id-{},number-{}, ERP\u5f15\u7528\u6807\u8bc6\uff1a{}", new Object[]{e.getId(), e.getNumber(), e.getErpQuoteFlag()});
                    if (!"1".equals(e.getQuoteFlag()) && !"1".equals(e.getErpQuoteFlag())) continue;
                    quoteNumList.add(e.getNumber());
                }
                if (CollectionUtils.isNotEmpty((Collection)quoteNumList)) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + quoteNumList.stream().collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
                }
                if (CollectionUtils.isNotEmpty(saveEntity.getDetailList()) && CollectionUtils.isNotEmpty(list = this.erpInvoiceService.checkQuote(new ArrayList<String>(saveEntity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet())), "mat"))) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + list.stream().collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
                }
                List<String> list3 = this.getQuoteInfoByInvoiceNums(invoiceNums, null);
                if (CollectionUtils.isNotEmpty(list3)) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + list3.stream().collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
                }
                invoiceList.stream().forEach(invoice -> invoice.setQuoteFlag("1"));
                this.erpInvoiceService.saveOrUpdateBatch(invoiceList, invoiceList.size(), false);
            }
            if (!(ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode()).isSuccess()) {
                this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)saveEntity.getSourceId(), (Object)ejcCloudSystemCode.getMsg());
            }
            saveEntity.setSystemId((String)ejcCloudSystemCode.getData());
            if (CollectionUtils.isNotEmpty(saveEntity.getDetailList())) {
                saveEntity.setInvoiceHeader(saveEntity.getDetailList().get(0).getInvoiceHeader());
            }
            List<MatInvoiceFileEntity> subFileList = saveEntity.getFileList();
            for (MatInvoiceFileEntity matInvoiceFileEntity : subFileList) {
                matInvoiceFileEntity.setSourceId(matInvoiceFileEntity.getId());
                matInvoiceFileEntity.setSourceMainId(matInvoiceFileEntity.getMainId());
                CommonUtils.clearInvalidData(matInvoiceFileEntity);
                matInvoiceFileEntity.setCreateUserCode(craetor.getUserCode());
                matInvoiceFileEntity.setId(IdWorker.getId());
                if (null != matInvoiceFileEntity.getFileId()) {
                    Long fileId = this.pushFileUtil.uploadFileFormNet(BILL_TYPE, matInvoiceFileEntity.getId(), "file01", matInvoiceFileEntity.getFileId());
                    matInvoiceFileEntity.setFileId(fileId);
                    matInvoiceFileEntity.setFileUrl(this.BASE_HOST + "/ejc-file-web/attachment/filePreview?fileId=" + fileId);
                    continue;
                }
                matInvoiceFileEntity.setFileId(null);
                matInvoiceFileEntity.setFileUrl(null);
            }
            List<MatInvoiceOcrEntity> ocrList = saveEntity.getOcrList();
            for (MatInvoiceOcrEntity file : ocrList) {
                file.setSourceId(file.getId());
                file.setSourceMainId(file.getMainId());
                CommonUtils.clearInvalidData(file);
                file.setCreateUserCode(craetor.getUserCode());
                file.setId(IdWorker.getId());
                if (null != file.getFileId()) {
                    Long fileId = this.pushFileUtil.uploadFileFormNet(BILL_TYPE, file.getId(), "file01", file.getFileId());
                    file.setFileId(fileId);
                    file.setFileUrl(this.BASE_HOST + "/ejc-file-web/attachment/filePreview?fileId=" + fileId);
                    continue;
                }
                file.setFileId(null);
                file.setFileUrl(null);
            }
            saveEntity.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER);
            HashMap hashMap = new HashMap();
            if (CollectionUtils.isNotEmpty(saveEntity.getDetailList())) {
                List<MatInvoiceDetailEntity> detailList = saveEntity.getDetailList();
                List invoiceDetailIds = detailList.stream().map(MatInvoiceDetailEntity::getInvoiceDetailId).collect(Collectors.toList());
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.in(BaseEntity::getId, invoiceDetailIds);
                List invoiceDetailEntityList = this.erpInvoiceDetailService.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)invoiceDetailEntityList)) {
                    Map map = invoiceDetailEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
                }
                for (MatInvoiceDetailEntity matInvoiceDetailEntity : detailList) {
                    void var20_30;
                    if (!var20_30.containsKey(matInvoiceDetailEntity.getInvoiceDetailId())) continue;
                    ErpInvoiceDetailEntity erpInvoiceDetailEntity = (ErpInvoiceDetailEntity)((Object)var20_30.get(matInvoiceDetailEntity.getInvoiceDetailId()));
                    matInvoiceDetailEntity.setInvoiceDetailSpec(erpInvoiceDetailEntity.getDetailSpec());
                    matInvoiceDetailEntity.setInvoiceDetailUnitName(erpInvoiceDetailEntity.getDetailUnitName());
                    matInvoiceDetailEntity.setInvoiceDetailNum(erpInvoiceDetailEntity.getDetailNum());
                    matInvoiceDetailEntity.setInvoiceDetailMny(erpInvoiceDetailEntity.getDetailMny());
                    matInvoiceDetailEntity.setInvoiceDetailPrice(ComputeUtil.safeDiv((BigDecimal)erpInvoiceDetailEntity.getDetailMny(), (BigDecimal)erpInvoiceDetailEntity.getDetailNum()));
                }
                saveEntity.setDetailList(detailList);
            }
            super.saveOrUpdate((Object)saveEntity, false);
            this.logger.info("\u4f9b\u65b9\u53d1\u7968\u63d0\u4ea4, \u5411\u53d1\u7968\u7ba1\u7406\u5458id-{}\u53d1\u9001\u6d88\u606f", (Object)saveEntity.getAdminId());
            PushMsgParameter parameter = new PushMsgParameter();
            parameter.setSubject("\u3010\u53d1\u7968\u5ba1\u6838\u3011\uff1a\u3010" + saveEntity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01\uff01");
            StringBuilder content = new StringBuilder();
            content.append("\u3010").append(saveEntity.getBillCode()).append("\u3011\uff0c\u3010").append(saveEntity.getProjectName()).append("\u3011\uff0c\u3010").append(saveEntity.getContractName()).append("\u3011\uff0c\u3010").append(saveEntity.getSupplierName()).append("\u3011\u63d0\u4ea4\u4e86\u53d1\u7968\uff0c\u8bf7\u60a8\u5ba1\u6838\uff01");
            parameter.setContent(content.toString());
            parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u7269\u8d44\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 + saveEntity.getId().toString());
            String[] recIds = new String[]{saveEntity.getAdminId()};
            parameter.setReceivers(recIds);
            this.sendMsg(parameter, saveEntity.getId(), "\u4f9b\u65b9\u53d1\u7968\u63d0\u4ea4 \u5411\u53d1\u7968\u7ba1\u7406\u5458\u53d1\u9001\u6d88\u606f");
            this.messageInfoService.sendTodo(Arrays.asList(saveEntity.getAdminId().split(",")), saveEntity.getId().toString(), BILL_TYPE, content.toString(), craetor.getId().toString(), this.BASE_HOST + CommonConstants.\u7269\u8d44\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 + saveEntity.getId().toString(), null, "\u5f85\u529e", "0", "\u4f9b\u65b9\u63a8\u9001\u7269\u8d44\u53d1\u7968\u767b\u8bb0", null, null);
            this.logger.info("\u4fdd\u5b58\u63a5\u53e3\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            this.logger.error("\u91c7\u8d2d\u53d1\u7968\u5355\u636esourceId-{}\u5904\u7406\u5f02\u5e38", (Object)vo.getId(), (Object)e);
            throw new BusinessException(null != e.getMessage() ? e.getMessage() : "\u64cd\u4f5c\u5931\u8d25\uff0c\u5904\u7406\u5355\u636e\u5931\u8d25\uff01");
        }
        finally {
            BillLockUtil.releaseLock(BILL_TYPE, vo.getId());
        }
        return saveEntity.getId();
    }

    private List<String> getQuoteInfoByInvoiceNums(List<String> invoiceNums, List<Long> exIncludMainIds) {
        ArrayList<String> resp = new ArrayList<String>();
        QueryWrapper detailQuery = new QueryWrapper();
        detailQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        detailQuery.in((Object)"invoice_number", invoiceNums);
        List detailList = this.detailService.list((Wrapper)detailQuery);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            ArrayList mainIds = new ArrayList(detailList.stream().map(MatInvoiceDetailEntity::getMainId).collect(Collectors.toSet()));
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"id", mainIds);
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            if (CollectionUtils.isNotEmpty(exIncludMainIds)) {
                query.notIn((Object)"id", exIncludMainIds);
            }
            query.ne((Object)"sign_state", (Object)Integer.valueOf("2"));
            List mainEntity = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)mainEntity)) {
                Map<Long, List<MatInvoiceDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(MatInvoiceDetailEntity::getMainId));
                for (MatInvoiceEntity m : mainEntity) {
                    for (MatInvoiceDetailEntity d : detailMap.get(m.getId())) {
                        if (resp.contains(d.getInvoiceNumber())) continue;
                        resp.add(d.getInvoiceNumber());
                    }
                }
            }
        }
        return resp;
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("{}-\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u5355\u636eId-{}\uff0c\u53d1\u9001\u6d88\u606f\u7ed3\u679c-{}", new Object[]{oprMsg, billId, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("{}-\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)oprMsg);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MatInvoiceVO confirmSign(Long id, boolean isConfirm, String rejectReason) {
        UserContext user = this.sessionManager.getUserContext();
        MatInvoiceEntity entity = (MatInvoiceEntity)((Object)super.selectById((Serializable)id));
        if (PlanConstant.SOURCE_TYPE_SUPPLIER == entity.getSourceType()) {
            try {
                List<String> invoiceNums;
                List<String> quotedNums;
                BillLockUtil.getLock(BILL_TYPE, entity.getId());
                HashMap nameSourceTypeMapping = new HashMap();
                if (isConfirm && CollectionUtils.isNotEmpty(quotedNums = this.getQuoteInfoByInvoiceNums(invoiceNums = entity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toList()), Collections.singletonList(id)))) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + quotedNums.stream().collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("nameSourceTypeMapping", JSONObject.toJSONString(nameSourceTypeMapping));
                params.put("billId", String.valueOf(entity.getSourceId()));
                params.put("operateId", String.valueOf(user.getUserId()));
                params.put("operateName", user.getUserName());
                params.put("signState", isConfirm ? "1" : "2");
                if (StringUtils.isNotBlank((CharSequence)rejectReason)) {
                    params.put("rejectReason", rejectReason);
                }
                this.logger.info("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\uff0c\u901a\u77e5\u5355\u636e\u63a8\u9001\u65b9systemId-{},\u53c2\u6570-{}", new Object[]{BILL_NAME, entity.getId(), entity.getSystemId(), JSONObject.toJSONString(params)});
                CommonResponse backResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_WITER_BACK_SERVER_URL, params, entity.getSupplierId().toString(), null);
                this.logger.error("\u5355\u636e-{}\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)BILL_NAME, (Object)JSONObject.toJSONString((Object)backResp));
                if (!backResp.isSuccess()) {
                    this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), backResp.getMsg()});
                    throw new BusinessException("\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25");
                }
                if ("\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01".equals(backResp.getData())) {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42URL-{}\u7ed9\u7cfb\u7edf-{}\u5931\u8d25, {}", new Object[]{BILL_WITER_BACK_SERVER_URL, entity.getSystemId(), backResp.getData()});
                    throw new BusinessException((String)backResp.getData());
                }
                CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)((String)backResp.getData()), CommonResponse.class);
                if (!operateResp.isSuccess()) {
                    this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), operateResp.getMsg()});
                    throw new BusinessException("\u66f4\u65b0\u72b6\u6001\u56de\u8c03\u5904\u7406\u5931\u8d25");
                }
                if (!isConfirm && CollectionUtils.isNotEmpty(entity.getDetailList())) {
                    List<ErpInvoiceEntity> invoiceList = this.erpInvoiceService.getAllByIds(entity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceId).collect(Collectors.toList()));
                    invoiceList.stream().forEach(invoice -> invoice.setQuoteFlag("0"));
                    this.erpInvoiceService.saveOrUpdateBatch(invoiceList, invoiceList.size(), false);
                }
                super.saveOrUpdate((Object)entity, false);
            }
            catch (Exception e) {
                this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u5f02\u5e38\uff0c", new Object[]{BILL_NAME, entity.getId(), e});
                throw new BusinessException(StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            finally {
                BillLockUtil.releaseLock(BILL_TYPE, entity.getId());
            }
        } else if (!isConfirm && CollectionUtils.isNotEmpty(entity.getDetailList())) {
            List<ErpInvoiceEntity> invoiceList = this.erpInvoiceService.getAllByIds(entity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceId).collect(Collectors.toList()));
            invoiceList.stream().forEach(invoice -> invoice.setQuoteFlag("0"));
            this.erpInvoiceService.saveOrUpdateBatch(invoiceList, invoiceList.size(), false);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(MatInvoiceEntity::getSignState, (Object)(isConfirm ? "1" : "2"));
        updateWrapper.set(MatInvoiceEntity::getRejectReason, (Object)rejectReason);
        updateWrapper.set(BaseEntity::getUpdateTime, (Object)new Date());
        updateWrapper.set(BaseEntity::getUpdateUserCode, (Object)InvocationInfoProxy.getUsercode());
        this.update((Wrapper)updateWrapper);
        this.messageInfoService.sendTodo(Arrays.asList(entity.getAdminId().split(",")), entity.getId().toString(), BILL_TYPE, null, entity.getOperateId().toString(), null, null, "\u5df2\u529e", "1", "\u7269\u8d44\u53d1\u7968\u767b\u8bb0\u5ba1\u6838", isConfirm ? "\u540c\u610f" : "\u4e0d\u540c\u610f", isConfirm ? "1" : "2");
        return (MatInvoiceVO)BeanMapper.map((Object)this.selectById(id), MatInvoiceVO.class);
    }

    @Override
    public MatInvoiceVO commitReview(Long id) {
        MatInvoiceEntity entity = (MatInvoiceEntity)((Object)super.selectById((Serializable)id));
        if (PlanConstant.SOURCE_TYPE_EL == entity.getSourceType() && CollectionUtils.isNotEmpty(entity.getDetailList())) {
            ArrayList<String> numbers = new ArrayList<String>(entity.getDetailList().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getInvoiceNumber())).map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet()));
            if (CollectionUtils.isNotEmpty(numbers)) {
                List<String> quotedInvoiceNums;
                List<ErpInvoiceEntity> list = this.erpInvoiceService.getAllByInvoiceNums(numbers);
                this.logger.info("\u91c7\u8d2d: \u6839\u636e\u53d1\u7968\u53f7\uff1a{}, EL\u67e5\u8be2\u5230\u53d1\u7968\u6570\uff1a{}", (Object)JSONObject.toJSONString(numbers), (Object)list.size());
                HashSet<String> quoteNumList = new HashSet<String>();
                for (ErpInvoiceEntity e : list) {
                    this.logger.info("\u91c7\u8d2d\u53d1\u7968id-{},number-{}, ERP\u5f15\u7528\u6807\u8bc6\uff1a{}", new Object[]{e.getId(), e.getNumber(), e.getErpQuoteFlag()});
                    if (!"1".equals(e.getQuoteFlag()) && !"1".equals(e.getErpQuoteFlag())) continue;
                    quoteNumList.add(e.getNumber());
                }
                if (CollectionUtils.isNotEmpty(quoteNumList)) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + quoteNumList.stream().collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
                }
                if (CollectionUtils.isNotEmpty(entity.getDetailList()) && CollectionUtils.isNotEmpty(quotedInvoiceNums = this.erpInvoiceService.checkQuote(new ArrayList<String>(entity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet())), "mat"))) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + quotedInvoiceNums.stream().collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
                }
                list.stream().forEach(invoice -> invoice.setQuoteFlag("1"));
                this.erpInvoiceService.saveOrUpdateBatch(list, list.size(), false);
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(MatInvoiceEntity::getSignState, (Object)"0");
            updateWrapper.set(BaseEntity::getUpdateTime, (Object)new Date());
            updateWrapper.set(BaseEntity::getUpdateUserCode, (Object)InvocationInfoProxy.getUsercode());
            this.update((Wrapper)updateWrapper);
        }
        if (null == entity.getAdminId()) {
            Long checkerId = this.contractManagerService.getContractOperator(entity.getContractId(), "1");
            if (null == checkerId) {
                checkerId = this.matCheckerSettingService.getByContractId(entity.getContractId());
            }
            if (null == checkerId && StringUtils.isNotBlank((CharSequence)entity.getAdminId())) {
                checkerId = Long.valueOf(entity.getAdminId());
            }
            if (null == checkerId) {
                throw new BusinessException("\u672a\u83b7\u53d6\u5230\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u4e86\u5bf9\u5e94\u7684\u53d1\u7968\u5ba1\u6838\u4eba\uff01");
            }
            CommonResponse creatorResp = this.employeeApi.getById(checkerId);
            if (!creatorResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u5931\u8d25,{}", (Object)checkerId, (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
            }
            if (null == creatorResp.getData()) {
                this.logger.error("\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u4e3a\u7a7a,{}", (Object)checkerId, (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
            }
            EmployeeVO craetor = (EmployeeVO)creatorResp.getData();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(MatInvoiceEntity::getAdminId, (Object)craetor.getId());
            updateWrapper.set(MatInvoiceEntity::getAdminCode, (Object)craetor.getCode());
            updateWrapper.set(MatInvoiceEntity::getAdminName, (Object)craetor.getName());
            this.update((Wrapper)updateWrapper);
        }
        this.logger.info("\u4f9b\u65b9\u53d1\u7968\u63d0\u4ea4, \u5411\u53d1\u7968\u7ba1\u7406\u5458id-{}\u53d1\u9001\u6d88\u606f", (Object)entity.getAdminId());
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setSubject("\u3010\u53d1\u7968\u5ba1\u6838\u3011\uff1a\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01\uff01");
        StringBuilder content = new StringBuilder();
        content.append("\u3010").append(entity.getBillCode()).append("\u3011\uff0c\u3010").append(entity.getProjectName()).append("\u3011\uff0c\u3010").append(entity.getContractName()).append("\u3011\uff0c\u3010").append(entity.getSupplierName()).append("\u3011\u63d0\u4ea4\u4e86\u53d1\u7968\uff0c\u8bf7\u60a8\u5ba1\u6838\uff01");
        parameter.setContent(content.toString());
        parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u7269\u8d44\u81ea\u5236\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 + entity.getId().toString());
        String[] recIds = new String[]{entity.getAdminId()};
        parameter.setReceivers(recIds);
        this.sendMsg(parameter, entity.getId(), "\u81ea\u5236\u53d1\u7968\u63d0\u4ea4 \u5411\u53d1\u7968\u7ba1\u7406\u5458\u53d1\u9001\u6d88\u606f");
        this.messageInfoService.sendTodo(Arrays.asList(entity.getAdminId().split(",")), entity.getId().toString(), BILL_TYPE, content.toString(), entity.getOperateId().toString(), this.BASE_HOST + CommonConstants.\u7269\u8d44\u81ea\u5236\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 + entity.getId().toString(), null, "\u5f85\u529e", "0", "\u7269\u8d44\u81ea\u5236\u53d1\u7968\u767b\u8bb0", null, null);
        return (MatInvoiceVO)BeanMapper.map((Object)this.selectById(id), MatInvoiceVO.class);
    }

    @Override
    public String changeAminEmp(JSONObject changeParam) {
        List billIds = JSONArray.parseArray((String)JSONObject.toJSONString((Object)changeParam.get((Object)"ids")), Long.class);
        Long adminId = changeParam.getLong("adminId");
        String adminCode = changeParam.getString("adminCode");
        String adminName = changeParam.getString("adminName");
        List billList = (List)super.listByIds((Collection)billIds);
        if (CollectionUtils.isNotEmpty((Collection)billList)) {
            for (MatInvoiceEntity entity : billList) {
                PushMsgParameter parameter = new PushMsgParameter();
                parameter.setSubject("\u3010\u53d1\u7968\u5ba1\u6838\u3011\uff1a\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01\uff01");
                StringBuilder content = new StringBuilder();
                content.append("\u3010").append(entity.getBillCode()).append("\u3011\uff0c\u3010").append(entity.getProjectName()).append("\u3011\uff0c\u3010").append(entity.getContractName()).append("\u3011\uff0c\u3010").append(entity.getSupplierName()).append("\u3011\u63d0\u4ea4\u4e86\u53d1\u7968\uff0c\u8bf7\u60a8\u5ba1\u6838\uff01");
                parameter.setContent(content.toString());
                parameter.setPcUrl(this.BASE_HOST + (null != entity.getSourceType() && Integer.valueOf(1).equals(entity.getSourceType()) ? CommonConstants.\u7269\u8d44\u81ea\u5236\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 : CommonConstants.\u7269\u8d44\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5) + entity.getId().toString());
                String[] recIds = new String[]{entity.getAdminId()};
                parameter.setReceivers(recIds);
                this.sendMsg(parameter, entity.getId(), "\u7269\u8d44\u53d1\u7968\u767b\u8bb0\u8f6c\u7b7e \u5411\u53d1\u7968\u7ba1\u7406\u5458\u53d1\u9001\u6d88\u606f");
                this.messageInfoService.sendTodo(Arrays.asList(entity.getAdminId().split(",")), entity.getId().toString(), BILL_TYPE, content.toString(), entity.getOperateId().toString(), this.BASE_HOST + CommonConstants.\u7269\u8d44\u81ea\u5236\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 + entity.getId().toString(), null, "\u5df2\u529e", "1", "\u7269\u8d44\u53d1\u7968\u767b\u8bb0\u8f6c\u7b7e", "\u7269\u8d44\u53d1\u7968\u767b\u8bb0\u8f6c\u7b7e", "1");
                this.messageInfoService.sendTodo(Collections.singletonList(adminId.toString()), entity.getId().toString(), BILL_TYPE, content.toString(), entity.getOperateId().toString(), this.BASE_HOST + CommonConstants.\u7269\u8d44\u81ea\u5236\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 + entity.getId().toString(), null, "\u5f85\u529e", "0", "\u7269\u8d44\u53d1\u7968\u767b\u8bb0\u8f6c\u7b7e", null, null);
                entity.setAdminId(adminId.toString());
                entity.setAdminCode(adminCode);
                entity.setAdminName(adminName);
            }
            super.saveOrUpdateBatch(billList, billList.size(), false);
        }
        return null;
    }

    @Override
    public void updateBillPrintInfo(List<Long> ids) {
        UserContext user = this.sessionManager.getUserContext();
        LambdaUpdateWrapper update = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)update.in(BaseEntity::getId, ids)).set(MatInvoiceEntity::getPrintFlag, (Object)PlanConstant.INTEGER_YES)).set(MatInvoiceEntity::getLastPrintUserId, (Object)user.getUserId())).set(MatInvoiceEntity::getLastPrintUserCode, (Object)user.getUserCode())).set(MatInvoiceEntity::getLastPrintUserName, (Object)user.getUserName());
        super.update((Wrapper)update);
    }

    @Override
    public String pushToErp(Long id) {
        this.logger.info("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0id-{}\u81f3ERP   start*********", (Object)id);
        Map<String, String> headers = null;
        MatInvoiceEntity entity = (MatInvoiceEntity)((Object)super.selectById((Serializable)id));
        String pushErpFlag = "0";
        try {
            String checkMsg = this.checkInvoiceQuoteInfo(entity);
            if (null != checkMsg) {
                if ("quoted".equals(checkMsg)) {
                    this.queueUtils.sendMq("bill_cus_update_queue_" + this.profile, JSONObject.toJSONString((Object)new BillStatusUpdateVO("matInvoice", "2", entity.getId())));
                    this.logger.info("\u63a8\u9001\u7ec8\u6b62\uff0c\u53d1\u7968\u767b\u8bb0id-{}\u4e2d\u53d1\u7968\u5df2\u88ab\u5f15\u7528", (Object)id);
                    return "\u63a8\u9001\u7ec8\u6b62\uff0c\u53d1\u7968\u767b\u8bb0\u5355\u4e2d\u5b58\u5728\u5df2\u88ab\u5f15\u7528\u7684\u53d1\u7968\u6216\u67e5\u8be2\u5f15\u7528\u5f02\u5e38";
                }
                this.queueUtils.sendMq("bill_cus_update_queue_" + this.profile, JSONObject.toJSONString((Object)new BillStatusUpdateVO("matInvoice", "3", entity.getId())));
                this.logger.info("\u63a8\u9001\u7ec8\u6b62\uff0c\u53d1\u7968\u767b\u8bb0id-{}\u4e2d\u53d1\u7968\u5f15\u7528\u67e5\u8be2\u5f02\u5e38", (Object)id);
                return "\u63a8\u9001\u7ec8\u6b62\uff0c\u67e5\u8be2\u53d1\u7968\u5f15\u7528\u5f02\u5e38";
            }
            this.logger.info("\u53d1\u7968\u767b\u8bb0id-{}\u5f15\u7528\u67e5\u8be2\u901a\u8fc7********* Suc ****");
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0id-{}ERP\u5f53\u524d\u5f15\u7528\u60c5\u51b5\u5f02\u5e38 \u53d1\u7968\u7ec8\u6b62\u63a8\u9001,", (Object)entity.getId());
            this.logger.error("\u67e5\u8be2\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0ERP\u5f53\u524d\u5f15\u7528\u60c5\u51b5\u5f02\u5e38,", (Throwable)e);
            pushErpFlag = "3";
        }
        try {
            if ("0".equals(pushErpFlag)) {
                JSONArray syncData = this.transferToErpParam(entity);
                headers = ZDSInterfaceCommonUtil.getErpHeaders();
                String reqResp = HttpTookit.postByJson((String)(ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/AddProcureMEBillLists"), (String)JSONObject.toJSONString((Object)syncData), headers, (Integer)180000, (Integer)180000);
                this.logger.info("\u91c7\u8d2d\u53d1\u7968\u63a8\u9001ERP\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{"/cefoc/yql/AddProcureMEBillLists", JSONObject.toJSONString((Object)syncData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
                JSONObject reqJson = JSONObject.parseObject((String)reqResp);
                if ("true".equals(reqJson.getString("status"))) {
                    this.logger.info("\u4e2d\u7535\u56db \u91c7\u8d2d\u53d1\u7968\u767b\u8bb0id-{}\u63a8\u9001ERP\u6210\u529f!", (Object)id);
                    pushErpFlag = "1";
                } else {
                    this.logger.error("\u4e2d\u7535\u56db \u91c7\u8d2d\u53d1\u7968\u767b\u8bb0id-{}\u63a8\u9001ERP\u5931\u8d25!", (Object)id);
                    pushErpFlag = "3";
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968id-{}\u5f02\u5e38\uff0c", (Object)id, (Object)e);
            pushErpFlag = "3";
        }
        this.queueUtils.sendMq("bill_cus_update_queue_" + this.profile, JSONObject.toJSONString((Object)new BillStatusUpdateVO("matInvoice", pushErpFlag, entity.getId())));
        if ("3".equals(pushErpFlag)) {
            this.messageInfoService.sendWarnMsg("\u91c7\u8d2d\u53d1\u7968\u63a8\u9001ERP\uff0cERP\u5904\u7406\u5931\u8d25", (null != entity.getSourceType() && Integer.valueOf(1).equals(entity.getSourceType()) ? "\u3010\u81ea\u5236\u3011" : "\u3010\u4f9b\u65b9\u7533\u8bf7\u3011") + "\u7684\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0\u3010" + entity.getBillCode() + "\u3011\u63a8\u9001ERP\uff0cERP\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\uff01", this.BASE_HOST + (null != entity.getSourceType() && Integer.valueOf(1).equals(entity.getSourceType()) ? CommonConstants.\u7269\u8d44\u81ea\u5236\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 : CommonConstants.\u7269\u8d44\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5) + entity.getId().toString());
        }
        this.logger.info("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968id-{}\u81f3ERP   end*********", (Object)id);
        return "3".equals(pushErpFlag) ? "ERP\u5904\u7406\u5931\u8d25\uff01" : "\u63a8\u9001ERP\u6210\u529f\uff01";
    }

    private void initContext(Long userId) {
        this.logger.info("*****************\u521d\u59cb\u5316\u7528\u6237id-{}\u4e0a\u4e0b\u6587 START*****************");
        String initContextUrl = this.BASE_HOST + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        if (null != userId) {
            initContextUrl = initContextUrl + "&userId=" + userId.toString();
        }
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
        CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        try {
            if (userContextResponse.isSuccess()) {
                JSONObject userContext = ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if (null != userContext) {
                    authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
                }
                if (authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
                    InvocationInfoProxy.setParameter((String)"authority", (String)authtoken.toString());
                }
                if (null != userContext) {
                    InvocationInfoProxy.setTenantid((Long)userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid((Long)userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode((String)userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId((Long)userContext.getLong("orgId"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38\uff1a", (Throwable)e);
        }
        this.logger.info("*****************\u521d\u59cb\u5316\u7528\u6237id-{}\u4e0a\u4e0b\u6587 END*****************");
    }

    @Override
    @Async(value="maCommonTask")
    public void syncToErp(Long id, Long curUserId) {
        this.logger.info("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0id-{}\u81f3ERP   start*********", (Object)id);
        this.initContext(curUserId);
        this.pushToErp(id);
        this.logger.info("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968id-{}\u81f3ERP   end*********", (Object)id);
    }

    @Override
    public String validateMny(Long id) {
        MatInvoiceEntity entity = (MatInvoiceEntity)((Object)super.selectById((Serializable)id));
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)entity.getContractId()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List list = super.queryList(param);
        list.add(entity);
        BigDecimal invoiceMny = list.stream().map(e -> e.getTotalTaxMny()).reduce(BigDecimal.ZERO, com.ejianc.business.zdsmaterial.util.ComputeUtil::safeAdd);
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        if (contract == null) {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u8be5\u5408\u540c\uff01");
            return "\u7d2f\u8ba1\u53d1\u7968\u91d1\u989d\u8d85\u8fc7\u4e86\u5408\u540c\u91d1\u989d\uff0c\u5ba1\u6838\u8bf7\u6ce8\u610f\uff01";
        }
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.and(e -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.eq(ContractEntity::getMainContractId, (Object)contract.getId())).or()).eq(ContractEntity::getMainContractSid, (Object)contract.getSourceContractId()));
        List contList = this.contractService.list((Wrapper)ew);
        contList.add(contract);
        BigDecimal contractMny = contList.stream().map(e -> e.getTaxMny()).reduce(BigDecimal.ZERO, com.ejianc.business.zdsmaterial.util.ComputeUtil::safeAdd);
        if (com.ejianc.business.zdsmaterial.util.ComputeUtil.isGreaterThan(invoiceMny, contractMny)) {
            this.logger.info("\u7d2f\u8ba1\u53d1\u7968\u91d1\u989d\u3010{}\u3011\u8d85\u8fc7\u4e86\u5408\u540c\u91d1\u989d\u3010{}\u3011\uff0c\u5ba1\u6838\u8bf7\u6ce8\u610f\uff01", (Object)invoiceMny.toPlainString(), (Object)contractMny.toPlainString());
            return "\u7d2f\u8ba1\u53d1\u7968\u91d1\u989d\u8d85\u8fc7\u4e86\u5408\u540c\u91d1\u989d\uff0c\u5ba1\u6838\u8bf7\u6ce8\u610f\uff01";
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String checkInvoiceQuoteInfo(MatInvoiceEntity entity) {
        String checkMsg = null;
        ArrayList<String> numbers = new ArrayList<String>(entity.getDetailList().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getInvoiceNumber())).map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet()));
        if (CollectionUtils.isNotEmpty(numbers)) {
            List<ErpInvoiceEntity> list = this.erpInvoiceService.getAllByInvoiceNums(numbers);
            this.logger.info("\u91c7\u8d2d: \u6839\u636e\u53d1\u7968\u53f7\uff1a{}, EL\u67e5\u8be2\u5230\u53d1\u7968\u6570\uff1a{}", (Object)JSONObject.toJSONString(numbers), (Object)list.size());
            for (ErpInvoiceEntity e : list) {
                this.logger.info("\u91c7\u8d2d\u53d1\u7968id-{},number-{}, ERP\u5f15\u7528\u6807\u8bc6\uff1a{}", new Object[]{e.getId(), e.getNumber(), e.getErpQuoteFlag()});
                if (!"1".equals(e.getErpQuoteFlag())) continue;
                checkMsg = "quoted";
            }
            if (null != checkMsg) {
                return checkMsg;
            }
        }
        try {
            CommonResponse companyListResp = this.defdocApi.queryDetailListByDefdocCodeList(Collections.singletonList(INVOICE_CHECK_LIST_CODE));
            if (!companyListResp.isSuccess()) {
                this.logger.error("********INVOICE  CHECK ERR ******\u6839\u636e \u7f16\u7801\uff1a{}\u67e5\u8be2 \u53d1\u7968\u67e5\u9a8c\u516c\u53f8\u5217\u8868\u5931\u8d25, \u6b63\u5e38\u8fdb\u884cERP\u67e5\u9a8c\u903b\u8f91********INVOICE  CHECK ERR ******", (Object)INVOICE_CHECK_LIST_CODE);
            } else {
                ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
                String partyAName = contract.getContractPartyA();
                List companyList = (List)companyListResp.getData();
                List companyNameList = companyList.stream().map(DefdocDetailVO::getName).distinct().collect(Collectors.toList());
                this.logger.info("********INVOICE  CHECK INFO ****** \u53d1\u7968\u67e5\u9a8c\u516c\u53f8\u5217\u8868\uff1a\u3010{}\u3011 , \u672c\u6b21\u53d1\u7968 \u7532\u65b9\uff1a\u3010{}\u3011,\u4e59\u65b9\uff1a\u3010{}\u3011 ********INVOICE  CHECK INFO ******", new Object[]{JSONObject.toJSONString(companyNameList), partyAName, entity.getSupplierName()});
                if (!companyNameList.contains(entity.getSupplierName()) && !companyNameList.contains(partyAName)) {
                    this.logger.info("********INVOICE  CHECK RESULT ******\u7269\u8d44\u53d1\u7968\u767b\u8bb0id:\u3010{}\u3011\uff0c\u7f16\u7801\uff1a\u3010{}\u3011\uff0c\u7532\u65b9\uff1a\u3010{}\u3011,\u4e59\u65b9\uff1a\u3010{}\u3011\u5747\u4e0d\u5728\u53d1\u7968\u67e5\u9a8c\u516c\u53f8\u5217\u8868\u4e2d\uff0c\u4e0d\u8fdb\u884cERP\u5f15\u7528\u67e5\u8be2\uff01********INVOICE  CHECK RESULT ******", new Object[]{entity.getId(), entity.getBillCode(), partyAName, entity.getSupplierName()});
                    return null;
                }
            }
            JSONArray josnArr = this.erpInvoiceService.syncTodayQuotedInvoice("mat");
            Map<String, List<MatInvoiceDetailEntity>> detailMap = entity.getDetailList().stream().collect(Collectors.groupingBy(MatInvoiceDetailEntity::getInvoiceNumber));
            if (null != josnArr && josnArr.size() > 0) {
                JSONObject json = null;
                for (Object obj : josnArr) {
                    json = (JSONObject)obj;
                    if (!detailMap.containsKey(json.getString("InvoiceHM"))) continue;
                    checkMsg = "quoted";
                    for (MatInvoiceDetailEntity detail : detailMap.get(json.getString("InvoiceHM"))) {
                        detail.setErpQuoteBillCode(json.getString("Ma_id"));
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u91c7\u8d2d: \u6839\u636e\u53d1\u7968\u53f7\uff1a{}, \u67e5\u8be2ERP\u5f15\u7528\u60c5\u51b5\u5f02\u5e38", numbers);
            this.logger.error("\u91c7\u8d2d\u53d1\u7968\u67e5\u8be2ERP\u5f15\u7528\u60c5\u51b5\u5f02\u5e38", (Throwable)e);
            return "checkErr";
        }
        return checkMsg;
    }

    private JSONArray transferToErpParam(MatInvoiceEntity entity) {
        AttachmentVO tmpAttach;
        HashMap<Long, AttachmentVO> attachMap;
        CommonResponse attachResp;
        JSONObject params;
        List sourceIds;
        JSONArray resp = new JSONArray();
        JSONObject data = new JSONObject();
        resp.add((Object)data);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        CommonResponse prjResp = this.projectPoolApi.getById(contract.getProjectId());
        if (!prjResp.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76eeid-{}\u4fe1\u606f\u5931\u8d25\uff01", (Object)entity.getProjectId());
            throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ProjectPoolSetVO project = (ProjectPoolSetVO)prjResp.getData();
        if (null == project) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76eeid-{}\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)entity.getProjectId());
            throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        CommonResponse supplierResp = this.matSupplierApi.getOneById(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u4f9b\u5e94\u5546id-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString((Object)supplierResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u4f9b\u5e94\u5546id-" + entity.getSupplierId() + "\u4fe1\u606f\u5931\u8d25");
        }
        MatSupplierVO supplier = (MatSupplierVO)supplierResp.getData();
        if (null == supplier) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u4f9b\u5e94\u5546id-{}\u4e3a\u7a7a", (Object)entity.getSupplierId());
            throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u4f9b\u5e94\u5546id-" + entity.getSupplierId() + "\u4fe1\u606f\u4e3a\u7a7a");
        }
        CommonResponse empResp = this.employeeApi.getById(Long.valueOf(entity.getAdminId()));
        if (!empResp.isSuccess()) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)entity.getAdminId(), (Object)JSONObject.toJSONString((Object)empResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-" + entity.getAdminId() + "\u4fe1\u606f\u5931\u8d25");
        }
        EmployeeVO emp = (EmployeeVO)empResp.getData();
        if (null == emp) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-{}\u4e3a\u7a7a", (Object)entity.getAdminId());
            throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-" + entity.getAdminId() + "\u4fe1\u606f\u4e3a\u7a7a");
        }
        EmployeeVO finalEmp = null;
        if (null != entity.getFinalApproveUserId()) {
            CommonResponse finalEmpResp = this.employeeApi.getById(Long.valueOf(entity.getFinalApproveUserId()));
            if (!finalEmpResp.isSuccess()) {
                this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6700\u7ec8\u6838\u51c6\u4ebaid-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)entity.getFinalApproveUserId(), (Object)JSONObject.toJSONString((Object)finalEmpResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6700\u7ec8\u6838\u51c6\u4ebaid-" + entity.getFinalApproveUserId() + "\u4fe1\u606f\u5931\u8d25");
            }
            finalEmp = (EmployeeVO)finalEmpResp.getData();
            if (null == finalEmp) {
                this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6700\u7ec8\u6838\u51c6\u4ebaid-{}\u4e3a\u7a7a", (Object)entity.getFinalApproveUserId());
                throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6700\u7ec8\u6838\u51c6\u4ebaid-" + entity.getFinalApproveUserId() + "\u4fe1\u606f\u4e3a\u7a7a");
            }
        }
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        entity.getDetailList().stream().forEach(detail -> {
            if (!invoiceIds.contains(detail.getInvoiceId())) {
                invoiceIds.add(detail.getInvoiceId());
            }
        });
        List<ErpInvoiceEntity> invoiceList = this.erpInvoiceService.getAllByIds(invoiceIds);
        List<ErpInvoiceDetailEntity> invoiceDetailList = this.invoiceDetailService.getAllByInvoiceIds(invoiceIds);
        if (CollectionUtils.isEmpty(invoiceList)) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968ids-{}\u4fe1\u606f\u4e3a\u7a7a", (Object)JSONObject.toJSONString(invoiceIds));
            throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a");
        }
        HashMap<Long, ErpInvoiceDetailEntity> invoiceDetailMap = new HashMap<Long, ErpInvoiceDetailEntity>();
        HashMap<Long, ErpInvoiceEntity> invoiceMap = new HashMap<Long, ErpInvoiceEntity>();
        if (CollectionUtils.isNotEmpty(invoiceDetailList)) {
            invoiceDetailMap.putAll(invoiceDetailList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        if (CollectionUtils.isNotEmpty(invoiceList)) {
            invoiceMap.putAll(invoiceList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        data.put("Company_Sid", (Object)supplier.getThirdSourceId());
        data.put("MeContract_Money", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeAdd(entity.getMainContMny(), entity.getChildContMny()).toPlainString());
        data.put("MeOrderMoney", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeAdd(entity.getOrderMny(), BigDecimal.ZERO).toPlainString());
        data.put("BillTitle", (Object)entity.getInvoiceHeader());
        data.put("IsDK", (Object)entity.getTaxCreateState().toString());
        data.put("IsDKValue", (Object)(Integer.valueOf("1").equals(entity.getTaxCreateState()) ? "\u662f" : "\u5426"));
        data.put("BillType", PlanConstant.INVOICE_TYPE.get(entity.getInvoiceCty()));
        data.put("TaxType", (Object)entity.getTaxCtyName());
        data.put("TaxRate", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeAdd(entity.getInvoiceRate(), BigDecimal.ZERO).toPlainString());
        data.put("NoTaxAmount", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeAdd(entity.getTotalMny(), BigDecimal.ZERO).toPlainString());
        data.put("TaxAmount", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeAdd(entity.getTotalTax(), BigDecimal.ZERO).toPlainString());
        data.put("BillMoney", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeAdd(entity.getTotalTaxMny(), BigDecimal.ZERO).toPlainString());
        data.put("IsAdvancePayment", (Object)entity.getPreState());
        data.put("IsAdvancePaymentValue", (Object)(Integer.valueOf(1).equals(entity.getPreState()) ? "\u662f" : "\u5426"));
        data.put("Memo", (Object)entity.getMemo());
        data.put("Ma_id", (Object)entity.getBillCode());
        data.put("Register_Name", (Object)entity.getOperateName());
        data.put("SYS_Created", (Object)sdf.format(entity.getCreateTime()));
        data.put("ApprHuman", (Object)emp.getName());
        data.put("ApprHuman_sid", (Object)emp.getSourceId());
        data.put("CON_EMP_NUM", (Object)emp.getCode());
        data.put("ApprDate", (Object)sdf.format(null != entity.getUpdateTime() ? entity.getUpdateTime() : new Date()));
        data.put("Position_Name", (Object)emp.getPostName());
        data.put("Division_Name", (Object)emp.getDeptName());
        data.put("Org_Name", (Object)emp.getOrgName());
        data.put("YQL_SID", (Object)entity.getId());
        data.put("SubContractInfo_Sid", (Object)contract.getSourceContractId());
        data.put("Project_Id", (Object)project.getCode());
        data.put("Project_Name", (Object)project.getName());
        data.put("Account_Project_Sid", (Object)project.getSourceId());
        data.put("Company_Name", (Object)contract.getSupplierName());
        if (null != finalEmp) {
            data.put("Reviewer", (Object)finalEmp.getName());
            data.put("ReviewerSid", (Object)finalEmp.getSourceId());
        }
        data.put("ReviewTime", (Object)sdf.format(null != entity.getEffectiveDate() ? entity.getEffectiveDate() : new Date()));
        JSONArray detailList = new JSONArray();
        data.put("MEBill_SubCList", (Object)detailList);
        JSONObject detailJson = null;
        ErpInvoiceDetailEntity tmpDetail = null;
        ErpInvoiceEntity invoice = null;
        for (MatInvoiceDetailEntity detail2 : entity.getDetailList()) {
            detailJson = new JSONObject();
            tmpDetail = (ErpInvoiceDetailEntity)((Object)invoiceDetailMap.get(detail2.getInvoiceDetailId()));
            if (null == tmpDetail) {
                throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968[id-" + detail2.getMainId() + "]\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u53d1\u7968\u8be6\u60c5id-" + detail2.getInvoiceDetailId() + "\u4fe1\u606f");
            }
            invoice = (ErpInvoiceEntity)((Object)invoiceMap.get(detail2.getInvoiceId()));
            if (null == invoice) {
                throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0[id-" + detail2.getMainId() + "]\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u53d1\u7968id-" + detail2.getInvoiceId() + "\u4fe1\u606f");
            }
            detailJson.put("InvoiceDM", (Object)invoice.getCode());
            detailJson.put("InvoiceHM", (Object)invoice.getNumber());
            detailJson.put("KPDate", (Object)(null != invoice.getInvoiceDate() ? sdf.format(invoice.getInvoiceDate()) : ""));
            detailJson.put("InvoiceTT", (Object)invoice.getInvoiceTitle());
            detailJson.put("GoodsName", (Object)tmpDetail.getDetailName());
            detailJson.put("InvoiceType", (Object)invoice.getTypeCode());
            detailJson.put("InvoiceTypeValue", (Object)invoice.getTypeName());
            detailJson.put("ModelNorm", (Object)tmpDetail.getDetailSpec());
            detailJson.put("MeteringUnit", (Object)tmpDetail.getDetailUnitName());
            detailJson.put("Quantity", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeAdd(tmpDetail.getDetailNum(), BigDecimal.ZERO).toPlainString());
            detailJson.put("Price", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeDiv(tmpDetail.getDetailMny(), tmpDetail.getDetailNum()).toPlainString());
            detailJson.put("TaxRate", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeAdd(tmpDetail.getDetailRate(), BigDecimal.ZERO).toPlainString());
            detailJson.put("Money", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeAdd(tmpDetail.getDetailMny(), BigDecimal.ZERO).toPlainString());
            detailJson.put("TaxMoney", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeAdd(tmpDetail.getDetailTax(), BigDecimal.ZERO).toPlainString());
            detailJson.put("MoneyTax", (Object)com.ejianc.business.zdsmaterial.util.ComputeUtil.safeAdd(tmpDetail.getInvoiceMny(), BigDecimal.ZERO).toPlainString());
            detailJson.put("PS_InvoiceInfo_FK", (Object)tmpDetail.getInvoiceSid());
            detailJson.put("YQL_SID", (Object)detail2.getId());
            detailList.add((Object)detailJson);
        }
        JSONArray attaches = new JSONArray();
        data.put("ArchivesInforList", (Object)attaches);
        JSONObject tmpFileJson = null;
        if (CollectionUtils.isNotEmpty(entity.getFileList())) {
            sourceIds = entity.getFileList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            params = new JSONObject();
            params.put("sourceIds", sourceIds);
            attachResp = this.attachmentApi.queryAllBySourceIdList(params);
            if (!attachResp.isSuccess()) {
                this.logger.error("\u6839\u636esourceId\u5217\u8868-{}\u67e5\u8be2\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(sourceIds), (Object)JSONObject.toJSONString((Object)attachResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else {
                attachMap = new HashMap<Long, AttachmentVO>();
                if (CollectionUtils.isNotEmpty((Collection)((Collection)attachResp.getData()))) {
                    attachMap.putAll(((List)attachResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
                }
                tmpAttach = null;
                for (MatInvoiceFileEntity matInvoiceFileEntity : entity.getFileList()) {
                    if (null == matInvoiceFileEntity.getFileId()) continue;
                    tmpAttach = (AttachmentVO)attachMap.get(matInvoiceFileEntity.getId());
                    if (null == tmpAttach) {
                        this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5e94\u53d1\u7968\u9644\u4ef6\u8be6\u60c5sourceId-{}\u4fe1\u606f", (Object)matInvoiceFileEntity.getId());
                        throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5e94\u53d1\u7968\u9644\u4ef6\u8be6\u60c5\u4fe1\u606f");
                    }
                    tmpFileJson = new JSONObject();
                    tmpFileJson.put("Attach_Name", (Object)(StringUtils.isBlank((CharSequence)matInvoiceFileEntity.getFileName()) ? tmpAttach.getFileName() : matInvoiceFileEntity.getFileName() + (matInvoiceFileEntity.getFileName().indexOf(".") < 0 ? tmpAttach.getFileName().substring(tmpAttach.getFileName().lastIndexOf(".")) : "")));
                    tmpFileJson.put("Attach_Type", (Object)tmpAttach.getFileName().substring(tmpAttach.getFileName().lastIndexOf(".") + 1));
                    tmpFileJson.put("Attach_Extension", (Object)tmpAttach.getFileName().substring(tmpAttach.getFileName().lastIndexOf(".")));
                    tmpFileJson.put("AttachBase64", (Object)(this.BASE_HOST + "filepreview/" + tmpAttach.getFilePath()));
                    tmpFileJson.put("YQL_SID", (Object)matInvoiceFileEntity.getId());
                    tmpFileJson.put("Is_Add_Del", (Object)1);
                    try {
                        if (StringUtils.isNotBlank((CharSequence)tmpFileJson.getString("Attach_Name")) && StringUtils.isNotBlank((CharSequence)tmpFileJson.getString("Attach_Extension")) && !tmpFileJson.getString("Attach_Name").toLowerCase().endsWith(tmpFileJson.getString("Attach_Extension").toLowerCase())) {
                            tmpFileJson.put("Attach_Name", (Object)(tmpFileJson.getString("Attach_Name") + tmpFileJson.getString("Attach_Extension")));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("\u91c7\u8d2d\u53d1\u7968\u9644\u4ef6id-{}\u5904\u7406\u540e\u7f00\u540d\u79f0\u5f02\u5e38:", (Object)matInvoiceFileEntity.getId(), (Object)e);
                    }
                    attaches.add((Object)tmpFileJson);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getOcrList())) {
            sourceIds = entity.getOcrList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            params = new JSONObject();
            params.put("sourceIds", sourceIds);
            attachResp = this.attachmentApi.queryAllBySourceIdList(params);
            if (!attachResp.isSuccess()) {
                this.logger.error("\u6839\u636esourceId\u5217\u8868-{}\u67e5\u8be2\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(sourceIds), (Object)JSONObject.toJSONString((Object)attachResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else {
                attachMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)((Collection)attachResp.getData()))) {
                    attachMap.putAll(((List)attachResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
                }
                tmpAttach = null;
                for (MatInvoiceOcrEntity matInvoiceOcrEntity : entity.getOcrList()) {
                    if (null == matInvoiceOcrEntity.getFileId()) continue;
                    tmpAttach = (AttachmentVO)attachMap.get(matInvoiceOcrEntity.getId());
                    if (null == tmpAttach) {
                        this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5e94\u53d1\u7968\u9644\u4ef6\u8be6\u60c5sourceId-{}\u4fe1\u606f", (Object)matInvoiceOcrEntity.getId());
                        throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5e94\u53d1\u7968\u9644\u4ef6\u8be6\u60c5\u4fe1\u606f");
                    }
                    tmpFileJson = new JSONObject();
                    tmpFileJson.put("Attach_Name", (Object)(StringUtils.isNotBlank((CharSequence)matInvoiceOcrEntity.getFileName()) ? matInvoiceOcrEntity.getFileName() + (matInvoiceOcrEntity.getFileName().indexOf(".") < 0 ? tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")) : "") : tmpAttach.getFileName()));
                    tmpFileJson.put("Attach_Extension", (Object)tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")));
                    tmpFileJson.put("Attach_Type", (Object)tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".") + 1));
                    tmpFileJson.put("AttachBase64", (Object)(this.BASE_HOST + "filepreview/" + tmpAttach.getFilePath()));
                    tmpFileJson.put("YQL_SID", (Object)matInvoiceOcrEntity.getId());
                    tmpFileJson.put("Is_Add_Del", (Object)1);
                    try {
                        if (StringUtils.isNotBlank((CharSequence)tmpFileJson.getString("Attach_Name")) && StringUtils.isNotBlank((CharSequence)tmpFileJson.getString("Attach_Extension")) && !tmpFileJson.getString("Attach_Name").toLowerCase().endsWith(tmpFileJson.getString("Attach_Extension").toLowerCase())) {
                            tmpFileJson.put("Attach_Name", (Object)(tmpFileJson.getString("Attach_Name") + tmpFileJson.getString("Attach_Extension")));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("\u91c7\u8d2d\u53d1\u7968\u9644\u4ef6id-{}\u5904\u7406\u540e\u7f00\u540d\u79f0\u5f02\u5e38:", (Object)matInvoiceOcrEntity.getId(), (Object)e);
                    }
                    attaches.add((Object)tmpFileJson);
                }
            }
        }
        return resp;
    }
}

