/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.subvisa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.InstructionSetEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.IInstructionSetService;
import com.ejianc.business.zdsmaterial.sub.subvisa.vo.InstructionSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"instructionSet"})
public class InstructionSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "INSET-CODE";
    @Autowired
    private IInstructionSetService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InstructionSetVO> saveOrUpdate(@RequestBody InstructionSetVO saveOrUpdateVO) {
        InstructionSetVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InstructionSetVO> queryDetail(Long id) {
        InstructionSetEntity entity = (InstructionSetEntity)((Object)this.service.selectById(id));
        InstructionSetVO vo = (InstructionSetVO)BeanMapper.map((Object)((Object)entity), InstructionSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InstructionSetVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (InstructionSetVO instructionSetVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InstructionSetVO>> queryList(@RequestBody QueryParam param) {
        String authOrgIds;
        UserContext userContextCache;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("setName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subContractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("queryCoverage")) {
            if (((Parameter)param.getParams().get("queryCoverage")).getValue().equals("1")) {
                param.getParams().put("createUserCode", new Parameter("eq", (Object)UserContext.getUserContext().getUserCode()));
            } else {
                userContextCache = this.sessionManager.getUserContext();
                authOrgIds = userContextCache.getAuthOrgIds();
                List orgVOList = null;
                orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            param.getParams().remove("queryCoverage");
        } else {
            userContextCache = this.sessionManager.getUserContext();
            authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InstructionSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List orgVOList;
        String authOrgIds;
        UserContext userContextCache;
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("setName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subContractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("queryCoverage")) {
            if (((Parameter)param.getParams().get("queryCoverage")).getValue().equals("1")) {
                param.getParams().put("createUserCode", new Parameter("eq", (Object)UserContext.getUserContext().getUserCode()));
            } else {
                userContextCache = this.sessionManager.getUserContext();
                authOrgIds = userContextCache.getAuthOrgIds();
                orgVOList = null;
                orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            param.getParams().remove("queryCoverage");
        } else {
            userContextCache = this.sessionManager.getUserContext();
            authOrgIds = userContextCache.getAuthOrgIds();
            orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List instructionSetVOS = BeanMapper.mapList((Iterable)list, InstructionSetVO.class);
        instructionSetVOS.forEach(i -> {
            i.setPacketChangeFlagStr(i.getPacketChangeFlag().equals(InstructionStatusEnum.\u6b63\u5e38.getStatus()) ? "\u5426" : "\u662f");
            i.setAdditionalRecordingFlagStr(i.getAdditionalRecordingFlag().equals(InstructionStatusEnum.\u8865\u5f55.getStatus()) ? "\u662f" : "\u5426");
            if (i.getInstructionSetStatus().equals(InstructionStatusEnum.\u672a\u5f15\u7528.getStatus())) {
                i.setInstructionSetStatusStr(InstructionStatusEnum.\u672a\u5f15\u7528.getStatusName());
            } else if (i.getInstructionSetStatus().equals(InstructionStatusEnum.\u5df2\u5f15\u7528.getStatus())) {
                i.setInstructionSetStatusStr(InstructionStatusEnum.\u5df2\u5f15\u7528.getStatusName());
            } else if (i.getInstructionSetStatus().equals(InstructionStatusEnum.\u4f5c\u5e9f.getStatus())) {
                i.setInstructionSetStatusStr(InstructionStatusEnum.\u4f5c\u5e9f.getStatusName());
            } else if (i.getInstructionSetStatus().equals(InstructionStatusEnum.\u4f5c\u5e9f.getStatus())) {
                i.setInstructionSetStatusStr(null);
            }
            i.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)i.getBillState()).getDescription());
        });
        beans.put("records", instructionSetVOS);
        ExcelExport.getInstance().export("InstructionSet-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInstructionSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstructionSetVO>> refInstructionSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"supplierId")) {
                param.getParams().put("supplierId", new Parameter("in", (Object)_con.getString("supplierId")));
            }
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("in", (Object)_con.getString("projectId")));
            }
            if (_con.containsKey((Object)"subContractId")) {
                param.getParams().put("subContractId", new Parameter("in", (Object)_con.getString("subContractId")));
            }
        }
        param.getParams().put("instructionSetStatus", new Parameter("eq", (Object)InstructionStatusEnum.\u672a\u5f15\u7528.getStatus()));
        param.getParams().put("additionalRecordingFlag", new Parameter("eq", (Object)InstructionStatusEnum.\u8865\u5f55.getStatus()));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List instructionSetVOS = BeanMapper.mapList((Iterable)page.getRecords(), InstructionSetVO.class);
        instructionSetVOS.forEach(i -> i.setPacketChangeFlagStr(i.getPacketChangeFlag().equals(InstructionStatusEnum.\u6b63\u5e38.getStatus()) ? "\u5426" : "\u662f"));
        pageData.setRecords(instructionSetVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pushStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InstructionSetVO> pushStatus(@RequestBody InstructionSetVO saveOrUpdateVO) {
        return this.service.pushStatus(saveOrUpdateVO);
    }
}

