/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.subvisa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.InstructionSetDetailEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.bean.InstructionSetEntity;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsmaterial.sub.subvisa.mapper.InstructionSetMapper;
import com.ejianc.business.zdsmaterial.sub.subvisa.service.IInstructionSetService;
import com.ejianc.business.zdsmaterial.sub.subvisa.vo.InstructionSetVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="instructionSetService")
public class InstructionSetServiceImpl
extends BaseServiceImpl<InstructionSetMapper, InstructionSetEntity>
implements IInstructionSetService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "INSET-CODE";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/instructionSet/syncBill";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String OPERATE = "InstructionSetBill";

    @Override
    public InstructionSetVO saveOrUpdate(InstructionSetVO saveOrUpdateVO) {
        InstructionSetEntity entity = (InstructionSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, InstructionSetEntity.class));
        if (StringUtils.isNotBlank((CharSequence)entity.getBillCode())) {
            this.checkCode(entity);
        } else {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        InstructionSetVO vo = (InstructionSetVO)BeanMapper.map((Object)((Object)entity), InstructionSetVO.class);
        return vo;
    }

    public void checkCode(InstructionSetEntity entity) {
        List list;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bill_code", (Object)entity.getBillCode());
        queryWrapper.eq((Object)"dr", (Object)0);
        if (entity.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)queryWrapper)))) {
            throw new BusinessException("\u6307\u4ee4\u5355\u7f16\u53f7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushBill(InstructionSetEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "InstructionSetBill::" + entity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"InstructionSetBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "InstructionSetBill");
                String string = "\u6307\u4ee4\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c\u52a0\u9501\u5931\u8d25\uff01";
                return string;
            }
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u6307\u4ee4\u5355-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
                String string = "\u63a8\u9001\u6307\u4ee4\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
                return string;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            if (InstructionStatusEnum.\u672a\u5f15\u7528.getStatus().equals(entity.getInstructionSetStatus())) {
                HashMap fileNames = new HashMap();
                HashMap files = new HashMap();
                if (entity.getDetailList() != null && entity.getDetailList().size() > 0) {
                    HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                    for (InstructionSetDetailEntity detail : entity.getDetailList()) {
                        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(detail.getId(), null, null, null);
                        if (!fileResp.isSuccess()) continue;
                        List fileList = (List)fileResp.getData();
                        ArrayList<Long> fileIds = new ArrayList<Long>();
                        for (AttachmentVO attach : fileList) {
                            fileIds.add(attach.getId());
                            detail.setAttachmentLinkUrl(attach.getFilePath());
                            detail.setAttachmentName(attach.getFileName());
                            detail.setAttachmentId(attach.getId());
                            fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                        }
                        if (!CollectionUtils.isNotEmpty((Collection)fileList)) continue;
                        Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                        fileMap.keySet().stream().forEach(fileKey -> {
                            HashMap file = new HashMap(1);
                            file.put((String)fileKey, fileMap.get(fileKey));
                            files.put(fileKey, file);
                        });
                    }
                    params.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                }
                params.put("transData", JSONObject.toJSONString((Object)((Object)entity)));
                this.logger.info("\u6307\u4ee4\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0: url-{}, \u6307\u4ee4\u5355\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/instructionSet/syncBill", (Object)JSONObject.toJSONString((Object)((Object)entity)));
                CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/instructionSet/syncBill", params, entity.getSupplierId().toString(), files);
                this.logger.error("\u6307\u4ee4\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
                if (!writeBackResp.isSuccess()) {
                    this.releaseLock(jedis, true, key, "InstructionSetBill");
                    this.logger.error("\u6307\u4ee4\u5355id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)writeBackResp.getMsg());
                    String string = "\u6307\u4ee4\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                    return string;
                }
                String operateRespStr = (String)writeBackResp.getData();
                CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
                if (!operateResp.isSuccess()) {
                    this.logger.error("\u6307\u4ee4\u5355id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)operateResp.getMsg());
                    this.releaseLock(jedis, true, key, "InstructionSetBill");
                    String string = "\u6307\u4ee4\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                    return string;
                }
            } else {
                params.put("transData", JSONObject.toJSONString((Object)((Object)entity)));
                this.logger.info("\u6307\u4ee4\u5355\u4f5c\u5e9f\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0: url-{}, \u53d1\u8d27\u5355\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/instructionSet/syncBill", (Object)JSONObject.toJSONString((Object)((Object)entity)));
                CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/instructionSet/syncBill", params, entity.getSupplierId().toString(), null);
                this.logger.info("\u6307\u4ee4\u5355\u4f5c\u5e9f\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
                if (!writeBackResp.isSuccess()) {
                    this.releaseLock(jedis, true, key, "InstructionSetBill");
                    this.logger.error("\u6307\u4ee4\u5355id-{}\u4f5c\u5e9f\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)writeBackResp.getMsg());
                    String files = "\u6307\u4ee4\u5355\u4f5c\u5e9f\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                    return files;
                }
                String operateRespStr = (String)writeBackResp.getData();
                CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
                if (!operateResp.isSuccess()) {
                    this.logger.error("\u6307\u4ee4\u5355\u4f5c\u5e9fid-{}\u63a8\u9001\u4f9b\u5e94\u94fe\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)operateResp.getMsg());
                    this.releaseLock(jedis, true, key, "InstructionSetBill");
                    String string = "\u6307\u4ee4\u5355\u4f5c\u5e9f\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                    return string;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6307\u4ee4\u5355id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u6307\u4ee4\u5355\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "InstructionSetBill");
        }
        return msg;
    }

    @Override
    public CommonResponse<InstructionSetVO> pushStatus(InstructionSetVO saveOrUpdateVO) {
        InstructionSetEntity entity = (InstructionSetEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        entity.setInstructionSetStatus(InstructionStatusEnum.\u4f5c\u5e9f.getStatus());
        String s = this.pushBill(entity);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            throw new BusinessException(s);
        }
        super.saveOrUpdate((Object)entity, false);
        InstructionSetVO instructionSetVO = (InstructionSetVO)BeanMapper.map((Object)((Object)entity), InstructionSetVO.class);
        return CommonResponse.success((String)"\u4f5c\u5e9f\u6210\u529f", (Object)instructionSetVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void changeInstructionSetStatus(Long id, Integer s) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        updateWrapper.set((Object)"instruction_set_status", (Object)s);
        boolean update = super.update((Wrapper)updateWrapper);
        if (!update) {
            throw new BusinessException("\u6307\u4ee4\u5355\u72b6\u6001\u4fee\u6539\u5931\u8d25");
        }
    }

    @Override
    public Integer queryInstructionSetStatus(Long id) {
        InstructionSetEntity instructionSetEntity = (InstructionSetEntity)((Object)super.selectById((Serializable)id));
        this.logger.info("\u67e5\u8be2\u5bf9\u5e94\u7684\u6307\u4ee4\u5355---\u6307\u4ee4\u5355id: {}, \u6307\u4ee4\u5355\u72b6\u6001: {}", (Object)id, (Object)instructionSetEntity.getInstructionSetStatus());
        return instructionSetEntity.getInstructionSetStatus();
    }
}

