package com.ejianc.business.zdsmaterial.erp.service;

import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationEntity;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationVO;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 品牌关系
 * 
 * @author generator
 * 
 */
public interface IBrandRelationService extends IBaseService<BrandRelationEntity> {

    List<BrandRelationEntity> checkRelation(List<BrandRelationEntity> saveRelations);

    List<BrandRelationEntity> getAllByCategoryId(Long categoryId);

    List<BrandRelationEntity> getByBrandId(Long brandId);

    List<BrandRelationEntity> getAllByIds(List<Long> ids);

    void syncRelationToErp(DataPushErpParam pushParam);

    List<BrandRelationEntity> getAllByCategoryIds(List<Long> categoryIds, String brandName, String supplierName);

    /**
     * 批量新增或更新品牌关系
     *
     * @param relations
     * @return
     */
    String saveOrUpdateRelations(List<BrandRelationVO> relations);

    /**
     * 查询供应商所有的品牌关系
     *
     * @param supplierId
     * @return
     */
    List<BrandRelationEntity> getAllBySupplierId(Long supplierId);

    /**
     * 查询对应供货内容到期的品牌关系列表
     *
     * @return
     */
    List<BrandRelationEntity> getTerminatedRelations();
}
