package com.ejianc.business.zdsmaterial.erp.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.vo.DeliveryVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 发货单
 *
 * @author generator
 *
 */
public interface IDeliveryService extends IBaseService<DeliveryEntity> {

    /**
     * 保存供方推送的发货单
     *
     * @param deliveryVO
     * @return
     */
    DeliveryVO saveSupDelivery(DeliveryVO deliveryVO);

    /**
     * 根据发货单id 修改验收状态
     * @param id
     * @param acceptStatus
     */
    void updateAcceptStatus(Long id,Integer acceptStatus);

    DeliveryEntity getBySourceId(String sourceId);

    /**
     * 供方发货单作废
     *
     * @param delivery
     * @return
     */
    String billDel(DeliveryEntity delivery);

    /**
     * 发货单同步更新供方
     *
     * @param deliveryEntity
     * @return
     */
    String updateSupDelivery(DeliveryEntity deliveryEntity);


    void returnDeliveryOrOrder(AcceptEntity entity, Boolean status);

    List<DeliveryVO> getAllByOrderId(Long id);

    List<DeliveryVO> queryPageData(Page<DeliveryVO> page, QueryWrapper wrapper);
}
