package com.ejianc.business.zdsmaterial.material.controller.api;

import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2023/12/20 18:02
 */
@RestController
@RequestMapping(value = "/api/zdsMaterialApi/")
public class MaterialApi {

    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @PostMapping("queryExitFlag")
    public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO) {
        MaterialVO vo = materialService.queryExitFlag(materialVO.getName(), materialVO.getPropertyShowName(),
                materialVO.getUnitName(), materialVO.getCategoryId());
        return CommonResponse.success("查询成功！", vo);
    }
    @PostMapping("queryExcelFlag")
    public CommonResponse<List<MaterialVO>> queryExcelFlag(@RequestBody MaterialVO materialVO) {
        List<MaterialVO> list = materialService.queryExcelFlag(materialVO.getName(), materialVO.getPropertyShowName(), materialVO.getUnitName(), materialVO.getCategoryName());
        return CommonResponse.success("查询成功！", list);
    }

    @GetMapping("queryCategoryByCode")
    public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value = "code") String code) {
        List<MaterialCategoryEntity> list = materialCategoryService.queryByCode(String.valueOf(code));
        MaterialCategoryVO vo = null;
        if(ListUtil.isNotEmpty(list)){
            vo = BeanMapper.map(list.get(0),MaterialCategoryVO.class);
        }
        if(vo == null){
            return CommonResponse.error("查询失败,没有查询到该编码所属分类！");
        }
        return CommonResponse.success("查询成功！", vo);
    }

    @GetMapping("queryCategoryListByChildren")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value = "ids") List<Long> ids) {
        List<MaterialCategoryVO> list = materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success("查询成功！", list);
    }
    @PostMapping("queryCategoryListByChildrenNew")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildrenNew(@RequestBody List<Long> ids) {
        List<MaterialCategoryVO> list = materialCategoryService.queryCategoryListByChildren(ids);
        return CommonResponse.success("查询成功！", list);
    }

    @GetMapping("queryCategoryListByPid")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value = "id") Long id) {
        List<MaterialCategoryVO> list = materialCategoryService.queryAllByPid(id, ZDSMaterialCommonEnums.停启用_启用.getCode());
        return CommonResponse.success("查询成功！", list);
    }
    @GetMapping("queryCategoryAllListByPid")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryAllListByPid(@RequestParam(value = "id") Long id) {
        List<MaterialCategoryVO> list = materialCategoryService.queryAllByPid(id, ZDSMaterialCommonEnums.停启用_启用.getCode());
        return CommonResponse.success("查询成功！", list);
    }


    /**
     * 根据ids查询物资列表（包括物资来源id，物资分类来源id）
     *
     * @param ids
     * @return
     */
    @GetMapping(value = "queryMaterialByIds")
    CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value = "ids") List<Long> ids,
                                                        @RequestParam(value = "queryRelations", required = false, defaultValue = "false") Boolean queryRelations){
        List<MaterialVO> materialVOS = materialService.queryDetailList(ids, queryRelations);
        if(null != materialVOS && materialVOS.size() > 0){
            return CommonResponse.success(materialVOS);
        }
        return CommonResponse.error("查询失败,未查到相关物资。");
    };

    /**
     * 根据id查询物资
     *
     * @param ids
     * @param queryRelations
     * @return
     */
    @GetMapping(value = "queryMaterialItemByIds")
    CommonResponse<List<MaterialVO>> queryMaterialItemByIds(@RequestParam(value = "ids") List<Long> ids,
                                                            @RequestParam(value = "queryRelations", required = false, defaultValue = "false") Boolean queryRelations){
        List<MaterialVO> materialVOS = materialService.queryDetailList(ids, queryRelations);
        if(null != materialVOS && materialVOS.size() > 0){
            return CommonResponse.success(materialVOS);
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    };

    /**
     * 根据主键查询物料分类详情
     * @Author
     * @param id
     * @return
     */
    @GetMapping("queryCategoryById")
    public CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("查询成功！", materialCategoryService.queryDetail(id));
    }

    /**
     * 根据物资分类主键查询所有物料详情列表
     * @Author
     * @param ids
     * @return
     */
    @PostMapping("queryMaterialByCategoryId")
    public CommonResponse<List<MaterialVO>> queryMaterialByCategoryId(@RequestBody List<Long> ids) {
        return CommonResponse.success("查询成功！", materialService.queryListByCategoryId(ids));
    }

    /**
     * 根据编码查询物料详情
     * @Author
     * @param code
     * @return
     */
    @GetMapping("queryMaterialByCode")
    public CommonResponse<MaterialVO> queryMaterialByCode(@RequestParam(value = "code") String code) {
        List<MaterialVO> vos = materialService.getByCodes(Arrays.asList(new String[]{String.valueOf(code)}));
        if(CollectionUtils.isEmpty(vos)){
            return CommonResponse.error("查询失败,没有查询到该编码对应的物料！");
        }
        return CommonResponse.success("查询成功！", vos.get(0));
    }

    /**
     * 根据材料主键查对应的所有上级分类
     * @return
     */
    @GetMapping("queryCategoryListByMaterialId")
    public CommonResponse<Map<Long, List<MaterialCategoryVO>>> queryCategoryListByMaterialId(@RequestParam(value = "ids") List<Long> ids) {
        Map<Long,List<MaterialCategoryVO>> map = materialCategoryService.queryCategoryListByMaterialId(ids);
        return CommonResponse.success("查询成功！", map);
    }

    @GetMapping("queryCategoryListByIds")
    public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByIds(@RequestParam(value = "ids", required = false) List<Long> ids) {
        List<MaterialCategoryVO> list = materialCategoryService.queryCategoryListByIds(ids);
        return CommonResponse.success("查询成功！", list);
    }

    /**
     * 根据编码集合查询档案列表
     * @Author zhangwx
     * @param codeList
     * @return
     */
    @GetMapping("queryMaterialListByCodes")
    public CommonResponse<List<MaterialVO>> queryMaterialListByCodes(@RequestParam(value = "codeList") List<String> codeList) {
        List<MaterialVO> list = materialService.getByCodes(codeList);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.success("查询成功！", list);
        }
        return CommonResponse.error("查询失败,没有查询到该编码对应的物料！");
    }

    /**
     * 业务推送新增物料档案
     *
     * @param saveList
     * @return
     */
    @PostMapping(value = "addNewMaterialsFromBill")
    CommonResponse<List<MaterialVO>> addNewMaterialsFromBill(@RequestBody List<MaterialVO> saveList) {
        List<Long> typeIds = saveList.stream().map(MaterialVO::getCategoryId).distinct().collect(Collectors.toList());
        List<MaterialCategoryVO> typeList = materialCategoryService.queryCategoryListByIds(typeIds);

        Map<Long, MaterialCategoryVO> typeMap = typeList.stream().collect(Collectors.toMap(x->x.getId(), x->x));
        saveList.forEach(data->{
            data.setCategoryCode(typeMap.get(data.getCategoryId()).getCode());
        });

        return CommonResponse.success(materialService.addNewMaterialsFromBill(saveList));
    }

    /**
     * 业务撤回推送的物料档案
     *
     * @param sourceIds
     * @return
     */
    @PostMapping(value = "deleteMaterialsFromBill")
    CommonResponse<List<MaterialVO>> deleteMaterialsFromBill(@RequestBody List<Long> sourceIds) {
        return CommonResponse.success(materialService.deleteMaterialsFromBill(sourceIds));
    }

}
