/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.ContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceContentService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceContentVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.ConjectureManageFactory;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceCheckEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceContractEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceSettlementEntity;
import com.ejianc.business.zdsmaterial.pricelib.enums.OutFlagEnum;
import com.ejianc.business.zdsmaterial.pricelib.mapper.PriceContractMapper;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceCheckService;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceContractService;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceSettlementService;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceCheckVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceContractVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceSettlementVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceTrendVo;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.DateUtils;
import com.ejianc.business.zdsmaterial.util.ParamUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IPriceDepotPowerSetApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="priceContractService")
public class PriceContractServiceImpl
extends BaseServiceImpl<PriceContractMapper, PriceContractEntity>
implements IPriceContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IPriceDepotPowerSetApi priceDepotPowerSetApi;
    @Autowired
    private IPriceCheckService priceCheckService;
    @Autowired
    private IPriceSettlementService priceSettlementService;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private ConjectureManageFactory factory;
    @Value(value="${material.ai.handlerName:CJYT}")
    private String handlerName;
    @Autowired
    private IMaterialBasePriceContentService basePriceContentService;
    private final Integer DEFAULT_BATCH_INIT_SIZE = 10;

    @Override
    public void savePriceContractByTimingNew(Integer startPage) {
        int page;
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb===========================");
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("id", "asc");
        queryParam.getParams().put("sealed_flag", new Parameter("eq", (Object)"1"));
        int total = this.contractService.count((Wrapper)PriceContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam));
        queryParam.setPageSize(this.DEFAULT_BATCH_INIT_SIZE.intValue());
        int totalPages = total / this.DEFAULT_BATCH_INIT_SIZE + (total % this.DEFAULT_BATCH_INIT_SIZE == 0 ? 0 : 1);
        queryParam.setPageIndex(page);
        List contractList = null;
        QueryWrapper query = null;
        boolean unFinishFlag = true;
        for (page = null != startPage ? startPage : 1; page <= totalPages; ++page) {
            try {
                this.logger.info("*****\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1************* \u5f53\u524d\u5904\u7406\u7b2c " + page + " \u9875\u6570\u636e *************\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1***** ");
                queryParam.setPageIndex(page);
                query = PriceContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
                query.last(" limit " + (page - 1) * this.DEFAULT_BATCH_INIT_SIZE + ", " + this.DEFAULT_BATCH_INIT_SIZE);
                contractList = this.contractService.list((Wrapper)query);
                if (!CollectionUtils.isNotEmpty((Collection)contractList)) continue;
                this.batchInitPriceContract(contractList);
                continue;
            }
            catch (Exception e) {
                this.logger.error("*******\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1******\u5f02\u5e38", (Throwable)e);
            }
        }
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f===========================");
    }

    private void batchInitPriceContract(List<ContractEntity> contractList) {
        List<ContractDetailEntity> orderList;
        this.logger.info("\u67e5\u8be2\u5408\u540c\u6570\u636e\uff1a{}\u6761", (Object)(null != contractList ? contractList.size() : 0));
        if (CollectionUtils.isEmpty(contractList)) {
            return;
        }
        List<Object> detailList = new ArrayList();
        List<Long> contractIds = contractList.stream().filter(x -> new Integer(2).equals(x.getPriceType())).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(contractIds)) {
            detailList = ((PriceContractMapper)this.baseMapper).getContractDetailListByContractId(contractIds);
        }
        if (CollectionUtils.isNotEmpty(orderList = this.transferByOrder(contractIds = contractList.stream().filter(x -> new Integer(1).equals(x.getPriceType())).map(BaseEntity::getId).collect(Collectors.toList())))) {
            detailList.addAll(orderList);
        }
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        List<Long> materialTypeIds = detailList.stream().map(ContractDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
        List<MaterialCategoryVO> categoryList = this.categoryService.queryCategoryListByIds(materialTypeIds);
        Map<Long, String> categoryMap = categoryList.stream().collect(Collectors.toMap(BaseVO::getId, MaterialCategoryVO::getInnerCode, (key1, key2) -> key2));
        List projectIds = contractList.stream().map(ContractEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse projectResponse = this.projectSetApi.getProjectListIds(projectIds);
        Map<Object, Object> areaMap = new HashMap();
        Map<Object, Object> areaNameMap = new HashMap();
        if (projectResponse.isSuccess()) {
            List projectList = (List)projectResponse.getData();
            areaMap = projectList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getArea())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            areaNameMap = projectList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getAreaName())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }
        Map<Long, List<ContractDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(ContractDetailEntity::getContractId));
        ArrayList<PriceContractEntity> saveList = new ArrayList<PriceContractEntity>();
        for (ContractEntity entity : contractList) {
            List<ContractDetailEntity> list = detailMap.get(entity.getId());
            if (CollectionUtils.isEmpty(list)) continue;
            for (Object detail : list) {
                if (detail.getMaterialId() == null) continue;
                PriceContractEntity vo = (PriceContractEntity)((Object)BeanMapper.map((Object)((Object)entity), PriceContractEntity.class));
                vo.setArea((String)areaMap.get(entity.getProjectId()));
                vo.setAreaName((String)areaNameMap.get(entity.getProjectId()));
                vo.setSourceId(entity.getId());
                vo.setSourceType("material");
                vo.setSourceDetailId(detail.getId());
                vo.setMaterialId(detail.getMaterialId());
                vo.setMaterialCode(detail.getMaterialCode());
                vo.setMaterialName(detail.getMaterialName());
                vo.setMaterialTypeId(detail.getMaterialTypeId());
                vo.setMaterialTypeName(detail.getMaterialTypeName());
                vo.setInnerCode(categoryMap.get(detail.getMaterialTypeId()));
                vo.setSpec(detail.getPropertyValue());
                vo.setUnitId(detail.getDetailUnitId());
                vo.setUnitName(detail.getDetailUnitName());
                vo.setBrand(detail.getBrandName());
                vo.setContractNum(detail.getPurNum());
                vo.setContractPrice(detail.getDetailPrice());
                vo.setContractMny(detail.getDetailMny());
                vo.setContractTaxRate(detail.getDetailTaxRate());
                vo.setContractTaxMny(detail.getDetailTaxMny());
                vo.setContractTaxPrice(detail.getDetailTaxPrice());
                vo.setMemo(detail.getDetailRemark());
                vo.setOrderCode(detail.getOrderCode());
                vo.setOrderId(detail.getOrderId());
                vo.setOutFlag(OutFlagEnum.\u672a\u79fb\u9664.getCode());
                vo.setId(null);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setDr(detail.getDr());
                vo.setBillState("1".equals(entity.getSealedFlag()) ? 1 : 0);
                saveList.add(vo);
            }
        }
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        QueryParam priceParam = new QueryParam();
        List sourceDetailIds = saveList.stream().map(PriceContractEntity::getSourceDetailId).collect(Collectors.toList());
        priceParam.getParams().put("sourceDetailId", new Parameter("in", sourceDetailIds));
        List priceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty((Collection)priceList)) {
            Map priceMap = priceList.stream().collect(Collectors.toMap(PriceContractEntity::getSourceDetailId, Function.identity(), (key1, key2) -> key2));
            for (PriceContractEntity entity : saveList) {
                PriceContractEntity price = (PriceContractEntity)((Object)priceMap.get(entity.getSourceDetailId()));
                if (price == null) continue;
                entity.setId(price.getId());
                entity.setOutFlag(price.getOutFlag());
                entity.setCreateTime(price.getCreateTime());
                entity.setCreateUserCode(price.getCreateUserCode());
            }
        }
        this.logger.info("\u5165\u5e93\u6570\u636e\uff1a{} \u6761", (Object)saveList.size());
        boolean saveFlag = super.saveOrUpdateBatch(saveList, saveList.size(), false);
        this.logger.info("\u4ef7\u683c\u5e93\u5165\u5e93\u6570\u636e\uff1a{} \u6761\uff0c\u7ed3\u679c\uff1a{}", (Object)saveList.size(), (Object)saveFlag);
        List delIds = saveList.stream().filter(t -> t.getDr() != 0).map(BaseEntity::getId).collect(Collectors.toList());
        this.logger.info("\u5220\u9664\u6570\u636eid\uff1a{} \u6761", (Object)delIds.size());
        if (CollectionUtils.isNotEmpty(delIds)) {
            super.removeByIds(delIds, false);
        }
    }

    @Override
    public void savePriceContractByTiming(Date date) {
        List<ContractDetailEntity> orderList;
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb===========================");
        QueryParam queryParam = new QueryParam();
        String outLogDate = "";
        if (date != null) {
            Date qDate = DateUtils.calculationDay(date, -1);
            outLogDate = DateUtils.transformationDefaultDate(date);
            this.logger.info("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)qDate);
            QueryParam param = new QueryParam();
            Parameter parameter = new Parameter("ge", (Object)outLogDate);
            param.getComplexParams().add(ParamUtil.getOrParam("create_time", "update_time", "sys_last_upd", parameter));
            List orderList2 = this.orderService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)orderList2)) {
                Date createTime = orderList2.stream().filter(x -> null != x.getCreateTime()).min((v1, v2) -> DateUtil.compareDate(v1.getCreateTime(), v2.getCreateTime())).orElse(new OrderEntity()).getCreateTime();
                Date updateTime = orderList2.stream().filter(x -> null != x.getUpdateTime()).min((v1, v2) -> DateUtil.compareDate(v1.getUpdateTime(), v2.getUpdateTime())).orElse(new OrderEntity()).getUpdateTime();
                Date min = DateUtil.minDate(createTime, updateTime, qDate);
                outLogDate = DateUtils.transformationDefaultDate(min);
            }
            queryParam.getComplexParams().add(ParamUtil.getOrParam("create_time", "update_time", "sys_last_upd", new Parameter("ge", (Object)outLogDate)));
        } else {
            queryParam.getParams().put("sealed_flag", new Parameter("eq", (Object)"1"));
        }
        List contractList = this.contractService.queryList(queryParam, false);
        this.logger.info("\u6267\u884c\u65e5\u671f\uff1a{}\uff0c\u67e5\u8be2\u5408\u540c\u7ed3\u679c\uff1a{}", (Object)outLogDate, (Object)JSONObject.toJSONString((Object)contractList));
        if (CollectionUtils.isEmpty((Collection)contractList)) {
            return;
        }
        List<Object> detailList = new ArrayList();
        List<Long> contractIds = contractList.stream().filter(x -> new Integer(2).equals(x.getPriceType())).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(contractIds)) {
            detailList = ((PriceContractMapper)this.baseMapper).getContractDetailListByContractId(contractIds);
        }
        if (CollectionUtils.isNotEmpty(orderList = this.transferByOrder(contractIds = contractList.stream().filter(x -> new Integer(1).equals(x.getPriceType())).map(BaseEntity::getId).collect(Collectors.toList())))) {
            detailList.addAll(orderList);
        }
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        List<Long> materialTypeIds = detailList.stream().map(ContractDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
        List<MaterialCategoryVO> categoryList = this.categoryService.queryCategoryListByIds(materialTypeIds);
        this.logger.info("\u67e5\u8be2\u6750\u6599\u5185\u7801\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(categoryList));
        Map<Long, String> categoryMap = categoryList.stream().collect(Collectors.toMap(BaseVO::getId, MaterialCategoryVO::getInnerCode, (key1, key2) -> key2));
        List projectIds = contractList.stream().map(ContractEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse projectResponse = this.projectSetApi.getProjectListIds(projectIds);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u5730\u5740\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)projectResponse));
        Map<Object, Object> areaMap = new HashMap();
        Map<Object, Object> areaNameMap = new HashMap();
        if (projectResponse.isSuccess()) {
            List projectList = (List)projectResponse.getData();
            areaMap = projectList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getArea())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            areaNameMap = projectList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getAreaName())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }
        Map<Long, List<ContractDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(ContractDetailEntity::getContractId));
        ArrayList<PriceContractEntity> saveList = new ArrayList<PriceContractEntity>();
        for (ContractEntity entity : contractList) {
            List<ContractDetailEntity> list = detailMap.get(entity.getId());
            if (CollectionUtils.isEmpty(list)) continue;
            for (ContractDetailEntity detail : list) {
                if (detail.getMaterialId() == null) continue;
                PriceContractEntity vo = (PriceContractEntity)((Object)BeanMapper.map((Object)((Object)entity), PriceContractEntity.class));
                vo.setArea((String)areaMap.get(entity.getProjectId()));
                vo.setAreaName((String)areaNameMap.get(entity.getProjectId()));
                vo.setSourceId(entity.getId());
                vo.setSourceType("material");
                vo.setSourceDetailId(detail.getId());
                vo.setMaterialId(detail.getMaterialId());
                vo.setMaterialCode(detail.getMaterialCode());
                vo.setMaterialName(detail.getMaterialName());
                vo.setMaterialTypeId(detail.getMaterialTypeId());
                vo.setMaterialTypeName(detail.getMaterialTypeName());
                vo.setInnerCode(categoryMap.get(detail.getMaterialTypeId()));
                vo.setSpec(detail.getPropertyValue());
                vo.setUnitId(detail.getDetailUnitId());
                vo.setUnitName(detail.getDetailUnitName());
                vo.setBrand(detail.getBrandName());
                vo.setContractNum(detail.getPurNum());
                vo.setContractPrice(detail.getDetailPrice());
                vo.setContractMny(detail.getDetailMny());
                vo.setContractTaxRate(detail.getDetailTaxRate());
                vo.setContractTaxMny(detail.getDetailTaxMny());
                vo.setContractTaxPrice(detail.getDetailTaxPrice());
                vo.setMemo(detail.getDetailRemark());
                vo.setOrderCode(detail.getOrderCode());
                vo.setOrderId(detail.getOrderId());
                vo.setOutFlag(OutFlagEnum.\u672a\u79fb\u9664.getCode());
                vo.setId(null);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setDr(detail.getDr());
                vo.setBillState("1".equals(entity.getSealedFlag()) ? 1 : 0);
                saveList.add(vo);
            }
        }
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        QueryParam priceParam = new QueryParam();
        List sourceDetailIds = saveList.stream().map(PriceContractEntity::getSourceDetailId).collect(Collectors.toList());
        priceParam.getParams().put("sourceDetailId", new Parameter("in", sourceDetailIds));
        List priceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty((Collection)priceList)) {
            Map priceMap = priceList.stream().collect(Collectors.toMap(PriceContractEntity::getSourceDetailId, Function.identity(), (key1, key2) -> key2));
            for (PriceContractEntity entity : saveList) {
                PriceContractEntity price = (PriceContractEntity)((Object)priceMap.get(entity.getSourceDetailId()));
                if (price == null) continue;
                entity.setId(price.getId());
                entity.setOutFlag(price.getOutFlag());
                entity.setCreateTime(price.getCreateTime());
                entity.setCreateUserCode(price.getCreateUserCode());
            }
        }
        this.logger.info("\u5165\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(saveList));
        super.saveOrUpdateBatch(saveList);
        List delIds = saveList.stream().filter(t -> t.getDr() != 0).map(BaseEntity::getId).collect(Collectors.toList());
        this.logger.info("\u5220\u9664\u6570\u636eid\uff1a{}", (Object)JSONObject.toJSONString(delIds));
        if (CollectionUtils.isNotEmpty(delIds)) {
            super.removeByIds(delIds, false);
        }
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f===========================");
    }

    private List<ContractDetailEntity> transferByOrder(List<Long> contractIds) {
        if (CollectionUtils.isEmpty(contractIds)) {
            return new ArrayList<ContractDetailEntity>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("in", contractIds));
        List orderList = this.orderService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return new ArrayList<ContractDetailEntity>();
        }
        Map<Long, OrderEntity> map = orderList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orderId", new Parameter("in", new ArrayList<Long>(map.keySet())));
        List detailList = this.orderDetailService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return new ArrayList<ContractDetailEntity>();
        }
        ArrayList<ContractDetailEntity> result = new ArrayList<ContractDetailEntity>();
        for (OrderDetailEntity detail : detailList) {
            ContractDetailEntity vo = new ContractDetailEntity();
            OrderEntity order = map.get(detail.getOrderId());
            vo.setContractId(order.getContractId());
            vo.setOrderCode(order.getBillCode());
            vo.setOrderId(order.getId());
            vo.setId(detail.getId());
            vo.setDr(detail.getDr());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setPropertyValue(detail.getPropertyValue());
            vo.setProductCode(detail.getProductCode());
            vo.setDetailUnitId(detail.getDetailUnitId());
            vo.setDetailUnitName(detail.getDetailUnitName());
            vo.setBrandId(detail.getBrandId());
            vo.setBrandName(detail.getBrandName());
            vo.setPurNum(detail.getDetailNum());
            vo.setDetailPrice(detail.getDetailPrice());
            vo.setDetailTaxPrice(detail.getDetailTaxPrice());
            vo.setDetailMny(detail.getDetailMny());
            vo.setDetailTaxMny(detail.getDetailTaxMny());
            vo.setDetailTax(detail.getDetailTax());
            vo.setDetailTaxRate(detail.getDetailTaxRate());
            vo.setDetailRemark(detail.getMemo());
            result.add(vo);
        }
        return result;
    }

    @Override
    public IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param) {
        HashMap<Long, MaterialConjectureVO> searchList = new HashMap<Long, MaterialConjectureVO>();
        if (param.getParams().containsKey("searchAI")) {
            List<Long> materialIds = null;
            searchList.putAll(this.factory.similarSearch(this.handlerName, ((Parameter)param.getParams().get("searchAI")).getValue().toString(), null, new String[0]));
            materialIds = MapUtils.isNotEmpty(searchList) ? new ArrayList(searchList.keySet()) : Collections.singletonList(-9L);
            param.getParams().put("materialId", Parameter.getInInstance(materialIds));
            param.getParams().remove("searchAI");
        }
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        if (param.getParams().containsKey("searchAI") && !searchList.isEmpty()) {
            for (PriceLibVO p : priceLibList) {
                if (!searchList.containsKey(p.getMaterialId())) continue;
                p.setSimilarCoefficient(((MaterialConjectureVO)searchList.get(p.getMaterialId())).getSimilarCoefficient());
            }
            priceLibList.sort((v1, v2) -> ComputeUtil.safeSub(v2.getSimilarCoefficient(), v1.getSimilarCoefficient()).intValue());
        }
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString(priceLibList));
        Map<Object, Object> priceMap = new HashMap();
        ArrayList materialCodes = new ArrayList(priceLibList.stream().map(PriceLibVO::getMaterialCode).collect(Collectors.toSet()));
        if (CollectionUtils.isNotEmpty(materialCodes)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("materialCode", Parameter.getInInstance(materialCodes));
            queryParam.getParams().put("status", Parameter.getEqInstance((Object)"1"));
            List<MaterialBasePriceContentVO> basePriceContentVOS = this.basePriceContentService.getLatestPrice(queryParam);
            if (CollectionUtils.isNotEmpty(basePriceContentVOS)) {
                priceMap = basePriceContentVOS.stream().collect(Collectors.groupingBy(MaterialBasePriceContentVO::getMaterialCode));
            }
        }
        ArrayList<PriceLibVO> actualList = new ArrayList<PriceLibVO>();
        PriceLibVO tmp = null;
        for (PriceLibVO p : priceLibList) {
            if (priceMap.containsKey(p.getMaterialCode())) {
                for (MaterialBasePriceContentVO mp : (List)priceMap.get(p.getMaterialCode())) {
                    tmp = (PriceLibVO)BeanMapper.map((Object)p, PriceLibVO.class);
                    tmp.setId(Long.valueOf(IdWorker.getId()));
                    tmp.setBrand(mp.getBrandName());
                    tmp.setSupplierName(mp.getSupplierName());
                    tmp.setArea(mp.getArea());
                    tmp.setAreaName(mp.getAreaName());
                    tmp.setBaseMaterialPrice(mp.getBasePrice());
                    tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                    actualList.add(tmp);
                }
                continue;
            }
            actualList.add(p);
        }
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)actualList.size());
        pageDate.setRecords(actualList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).map(item -> {
            if (searchList.containsKey(item.getMaterialId())) {
                item.setSimilarCoefficient(((MaterialConjectureVO)searchList.get(item.getMaterialId())).getSimilarCoefficient());
            }
            return item;
        }).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public List<PriceLibVO> queryPriceLibListByTimeExcel(QueryParam param) {
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        return priceLibList;
    }

    @Override
    public PriceLibVO queryPriceLibDetail(QueryParam param) {
        List<Long> orgIdList;
        Date endDate;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate = checkMap.get("endDate"), orgIdList = this.queryOrgIdList(), param);
        if (CollectionUtils.isEmpty(priceLibList)) {
            throw new BusinessException("\u67e5\u8be2\u8be6\u60c5\u5931\u8d25\uff01");
        }
        return priceLibList.get(0);
    }

    @Override
    public List<PriceLibVO> queryPriceLibList(Date startDate, Date endDate, String materialTypeId) {
        QueryParam queryParam = new QueryParam();
        if (StringUtils.isNotEmpty((CharSequence)materialTypeId)) {
            String[] materialTypeIdList = materialTypeId.split(",");
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            for (String str : materialTypeIdList) {
                ComplexParam c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("innerCode", new Parameter("like_right", (Object)str));
                c1.getComplexParams().add(c2);
            }
            queryParam.getComplexParams().add(c1);
        }
        return this.queryPriceLibListAll(startDate, endDate, null, queryParam);
    }

    @Override
    public IPage<PriceContractVO> queryPriceContractListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("signDate", "desc");
            param.getOrderMap().put("contractMny", "desc");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)priceContractList.size());
        if (CollectionUtils.isEmpty(priceContractList)) {
            return pageDate;
        }
        List voList = BeanMapper.mapList(priceContractList, PriceContractVO.class);
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceContractVO vo : voList) {
            int targetType = vo.getTargetResultId() == null ? 1 : 0;
            String url = "/ejc-zdsmaterial-frontend/#/contract/card?id=" + vo.getSourceId() + "&supplementFlag=" + vo.getSupplementFlag() + "&performanceStatus=" + vo.getPerformanceStatus() + "&targetType=" + targetType;
            String orderUrl = null;
            if (null != vo.getOrderId()) {
                orderUrl = "/ejc-zdsmaterial-frontend/#/order/card?id=" + vo.getOrderId();
            }
            if (!myOrgList.contains(vo.getOrgId())) continue;
            vo.setContractUrl(url);
            vo.setOrderUrl(orderUrl);
        }
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public IPage<PriceCheckVO> queryPriceCheckListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("checkDate", "desc");
            param.getOrderMap().put("checkMny", "desc");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceCheckEntity> list = this.queryPriceCheckList(startDate, endDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)list.size());
        if (CollectionUtils.isEmpty(list)) {
            return pageDate;
        }
        List voList = BeanMapper.mapList(list, PriceCheckVO.class);
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceCheckVO vo : voList) {
            String url = "/ejc-zdsmaterial-frontend/#/accept/card?id=" + vo.getSourceId();
            if (!myOrgList.contains(vo.getOrgId())) continue;
            vo.setCheckUrl(url);
        }
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public IPage<PriceSettlementVO> queryPriceSettleListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("settlementDate", "desc");
            param.getOrderMap().put("settleMny", "desc");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceSettlementEntity> list = this.queryPriceSettlementList(startDate, endDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)list.size());
        if (CollectionUtils.isEmpty(list)) {
            return pageDate;
        }
        HashMap<String, PriceSettlementEntity> map = new HashMap<String, PriceSettlementEntity>();
        for (PriceSettlementEntity entity : list) {
            String key = String.valueOf(entity.getSourceId()) + entity.getMaterialId() + entity.getSettlePrice() + entity.getSettleTaxRate();
            if (map.containsKey(key)) {
                PriceSettlementEntity value = (PriceSettlementEntity)((Object)map.get(key));
                value.setSettleNum(value.getSettleNum().add(entity.getSettleNum()));
                value.setSettleMny(value.getSettleMny().add(entity.getSettleMny()));
                value.setSettleTaxMny(value.getSettleTaxMny().add(entity.getSettleTaxMny()));
                value.setMemo(value.getMemo() + "," + value.getMemo());
                continue;
            }
            map.put(key, entity);
        }
        List voList = BeanMapper.mapList(new ArrayList(map.values()), PriceSettlementVO.class);
        pageDate.setTotal((long)voList.size());
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceSettlementVO vo : voList) {
            String url = null;
            if (vo.getSettlementType() == 0) {
                url = vo.getContractId() == null ? "/ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + vo.getSourceId() : "/ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + vo.getSourceId();
            } else if (vo.getSettlementType() == 1) {
                url = vo.getContractId() == null ? "/ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + vo.getSourceId() : "/ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + vo.getSourceId();
            }
            if (!myOrgList.contains(vo.getOrgId())) continue;
            vo.setSettleUrl(url);
        }
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendContractList(QueryParam param) {
        ArrayList<PriceTrendVo> rtnList;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        HashMap<String, PriceTrendVo> trendMap = new HashMap<String, PriceTrendVo>();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(priceContractList)) {
            Map<Date, List<PriceContractEntity>> contractMap = priceContractList.stream().collect(Collectors.groupingBy(PriceContractEntity::getSignDate));
            for (Map.Entry<Date, List<PriceContractEntity>> entry : contractMap.entrySet()) {
                PriceTrendVo vo;
                String dateStr;
                List<PriceContractEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceContractEntity priceContractEntity = list.get(0);
                List priceList = list.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
                List taxPriceList = list.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceContractEntity entity : list) {
                    num = ComputeUtil.safeAdd(num, entity.getContractNum());
                    mny = ComputeUtil.safeAdd(mny, entity.getContractMny());
                    taxMny = ComputeUtil.safeAdd(taxMny, entity.getContractTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, 4);
                    taxAvgPrice = taxMny.divide(num, 4, 4);
                }
                if (trendMap.containsKey(dateStr = DateUtils.transformationDefaultDate(entry.getKey()))) {
                    vo = (PriceTrendVo)trendMap.get(dateStr);
                } else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setContractPrice(priceContractEntity.getContractPrice());
                vo.setContractTaxPrice(priceContractEntity.getContractTaxPrice());
                vo.setContractNum(num);
                vo.setContractAvgPrice(avgPrice);
                vo.setContractMaxPrice(((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractMinPrice(((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxAvgPrice(taxAvgPrice);
                vo.setContractTaxMaxPrice(((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxMinPrice(((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setPriceDate(DateUtils.transformationDefaultDate(entry.getKey()));
            }
        }
        if (CollectionUtils.isNotEmpty(rtnList = new ArrayList<PriceTrendVo>(trendMap.values()))) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendCheckList(QueryParam param) {
        ArrayList<PriceTrendVo> rtnList;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        HashMap<String, PriceTrendVo> trendMap = new HashMap<String, PriceTrendVo>();
        List<PriceCheckEntity> checkList = this.queryPriceCheckList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(checkList)) {
            Map<Date, List<PriceCheckEntity>> priceCheckMap = checkList.stream().collect(Collectors.groupingBy(PriceCheckEntity::getCheckDate));
            for (Map.Entry<Date, List<PriceCheckEntity>> entry : priceCheckMap.entrySet()) {
                PriceTrendVo vo;
                String dateStr;
                List<PriceCheckEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceCheckEntity priceCheckEntity = list.get(0);
                List priceList = list.stream().map(PriceCheckEntity::getCheckPrice).collect(Collectors.toList());
                List taxPriceList = list.stream().map(PriceCheckEntity::getCheckTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceCheckEntity entity : list) {
                    num = num.add(entity.getCheckNum());
                    mny = mny.add(entity.getCheckMny());
                    taxMny = taxMny.add(entity.getCheckTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, 4);
                    taxAvgPrice = taxMny.divide(num, 4, 4);
                }
                if (trendMap.containsKey(dateStr = DateUtils.transformationDefaultDate(entry.getKey()))) {
                    vo = (PriceTrendVo)trendMap.get(dateStr);
                } else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setCheckPrice(priceCheckEntity.getCheckPrice());
                vo.setCheckTaxPrice(priceCheckEntity.getCheckTaxPrice());
                vo.setCheckNum(num);
                vo.setCheckAvgPrice(avgPrice);
                vo.setCheckMaxPrice(((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setCheckMinPrice(((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setCheckTaxAvgPrice(taxAvgPrice);
                vo.setCheckTaxMaxPrice(((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setCheckTaxMinPrice(((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setPriceDate(dateStr);
            }
        }
        if (CollectionUtils.isNotEmpty(rtnList = new ArrayList<PriceTrendVo>(trendMap.values()))) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendSettleList(QueryParam param) {
        ArrayList<PriceTrendVo> rtnList;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        HashMap<String, PriceTrendVo> trendMap = new HashMap<String, PriceTrendVo>();
        List<PriceSettlementEntity> settleList = this.queryPriceSettlementList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(settleList)) {
            Map<Date, List<PriceSettlementEntity>> settleMap = settleList.stream().collect(Collectors.groupingBy(PriceSettlementEntity::getSettlementDate));
            for (Map.Entry<Date, List<PriceSettlementEntity>> entry : settleMap.entrySet()) {
                PriceTrendVo vo;
                String dateStr;
                List<PriceSettlementEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceSettlementEntity settlementEntity = list.get(0);
                List priceList = list.stream().map(PriceSettlementEntity::getSettlePrice).collect(Collectors.toList());
                List taxPriceList = list.stream().map(PriceSettlementEntity::getSettleTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceSettlementEntity entity : list) {
                    num = num.add(entity.getSettleNum());
                    mny = mny.add(entity.getSettleMny());
                    taxMny = taxMny.add(entity.getSettleTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, 4);
                    taxAvgPrice = taxMny.divide(num, 4, 4);
                }
                if (trendMap.containsKey(dateStr = DateUtils.transformationDefaultDate(entry.getKey()))) {
                    vo = (PriceTrendVo)trendMap.get(dateStr);
                } else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setSettlePrice(settlementEntity.getSettlePrice());
                vo.setSettleTaxPrice(settlementEntity.getSettleTaxPrice());
                vo.setSettleNum(num);
                vo.setSettleAvgPrice(avgPrice);
                vo.setSettleMaxPrice(((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setSettleMinPrice(((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setSettleTaxAvgPrice(taxAvgPrice);
                vo.setSettleTaxMaxPrice(((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setSettleTaxMinPrice(((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setPriceDate(dateStr);
            }
        }
        if (CollectionUtils.isNotEmpty(rtnList = new ArrayList<PriceTrendVo>(trendMap.values()))) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    @Override
    public void removePriceContractDetail(Long id) {
        PriceContractEntity entity = (PriceContractEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        entity.setOutFlag(OutFlagEnum.\u5df2\u79fb\u9664.getCode());
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public void removePriceCheckDetail(Long id) {
        PriceCheckEntity entity = (PriceCheckEntity)((Object)this.priceCheckService.selectById(id));
        if (entity == null) {
            throw new BusinessException("\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        entity.setOutFlag(OutFlagEnum.\u5df2\u79fb\u9664.getCode());
        this.priceCheckService.saveOrUpdate((Object)entity, false);
    }

    @Override
    public void removePriceSettleDetail(Long id) {
        PriceSettlementEntity entity = (PriceSettlementEntity)((Object)this.priceSettlementService.selectById(id));
        if (entity == null) {
            throw new BusinessException("\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        entity.setOutFlag(OutFlagEnum.\u5df2\u79fb\u9664.getCode());
        this.priceSettlementService.saveOrUpdate((Object)entity, false);
    }

    private Map<String, Date> checkQueryParam(QueryParam param) {
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        if (!paramMap.containsKey("materialId")) {
            throw new BusinessException("\u67e5\u8be2\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Date> rtnMap = new HashMap<String, Date>();
        rtnMap.put("startDate", startDate);
        rtnMap.put("endDate", endDate);
        return rtnMap;
    }

    @Override
    public List<PriceLibVO> queryPriceLibListAll(Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        HashMap<Long, PriceLibVO> map = new HashMap<Long, PriceLibVO>();
        this.queryPriceContractGroupByMaterialId(map, startDate, orgIdList, param);
        this.logger.debug("\u67e5\u8be2\u5408\u540c\u540e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(map));
        this.queryPriceCheckGroupByMaterialId(map, startDate, endDate, orgIdList, param);
        this.queryPriceGuide(map);
        this.logger.debug("\u67e5\u8be2\u6307\u5bfc\u4ef7\u540e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(map));
        ArrayList<PriceLibVO> priceLibList = new ArrayList<PriceLibVO>(map.values());
        this.logger.debug("\u67e5\u8be2\u540e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(priceLibList));
        return priceLibList;
    }

    private List<PriceContractEntity> queryPriceContractList(Date startDate, List<Long> orgIdList, QueryParam param) {
        QueryParam contractParam = new QueryParam();
        List fuzzyFields = contractParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("areaName");
        contractParam.setSearchText(param.getSearchText());
        contractParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        contractParam.getParams().put("outFlag", new Parameter("eq", (Object)OutFlagEnum.\u672a\u79fb\u9664.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            contractParam.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        if (param != null) {
            contractParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty((Collection)param.getComplexParams())) {
                contractParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                contractParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        this.logger.info("\u67e5\u8be2\u5408\u540c\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)contractParam));
        return super.queryList(contractParam, false);
    }

    public BigDecimal getHighFrequencyPrice(List<BigDecimal> priceList) {
        HashMap map = Maps.newHashMap();
        Integer MaxNum = 0;
        BigDecimal HighFrequencyPrice = null;
        for (BigDecimal price : priceList) {
            if (map.containsKey(price)) {
                Integer num = (Integer)map.get(price) + 1;
                map.put(price, num);
                if (num <= MaxNum) continue;
                MaxNum = num;
                HighFrequencyPrice = price;
                continue;
            }
            map.put(price, 1);
        }
        return HighFrequencyPrice;
    }

    private List<PriceCheckEntity> queryPriceCheckList(Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("areaName");
        queryParam.setSearchText(param.getSearchText());
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("outFlag", new Parameter("eq", (Object)OutFlagEnum.\u672a\u79fb\u9664.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            queryParam.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        if (param != null) {
            queryParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty((Collection)param.getComplexParams())) {
                queryParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                queryParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        if (null != startDate && null != endDate) {
            String sb = DateUtils.transformationDefaultDate(startDate) + "," + DateUtils.transformationDefaultDate(endDate);
            queryParam.getParams().put("checkDate", new Parameter("between", (Object)sb));
        }
        this.logger.info("\u67e5\u8be2\u9a8c\u6536\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryParam));
        return this.priceCheckService.queryList(queryParam, false);
    }

    private void queryPriceCheckGroupByMaterialId(Map<Long, PriceLibVO> libMap, Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        List<PriceCheckEntity> checkList = this.queryPriceCheckList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isEmpty(checkList)) {
            return;
        }
        Map<Long, List<PriceCheckEntity>> priceCheckMap = checkList.stream().collect(Collectors.groupingBy(PriceCheckEntity::getMaterialId));
        for (Map.Entry<Long, List<PriceCheckEntity>> entry : priceCheckMap.entrySet()) {
            PriceLibVO priceLibVO;
            Long key = entry.getKey();
            List<PriceCheckEntity> value = entry.getValue();
            List<BigDecimal> priceList = value.stream().filter(item -> null != item.getCheckPrice()).map(PriceCheckEntity::getCheckPrice).collect(Collectors.toList());
            List<BigDecimal> taxPriceList = value.stream().filter(item -> null != item.getCheckTaxPrice()).map(PriceCheckEntity::getCheckTaxPrice).collect(Collectors.toList());
            BigDecimal highFrequencyPrice = this.getHighFrequencyPrice(priceList);
            BigDecimal highFrequencyTaxPrice = this.getHighFrequencyPrice(taxPriceList);
            PriceCheckEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            BigDecimal avgPrice = BigDecimal.ZERO;
            BigDecimal maxPrice = Collections.max(priceList).divide(BigDecimal.ONE, 4, 4);
            BigDecimal minPrice = Collections.min(priceList).divide(BigDecimal.ONE, 4, 4);
            String priceArea = minPrice + "-" + maxPrice;
            BigDecimal taxAvgPrice = BigDecimal.ZERO;
            BigDecimal taxMaxPrice = Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, 4);
            BigDecimal taxMinPrice = Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, 4);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
            for (PriceCheckEntity entity : value) {
                num = num.add(entity.getCheckNum() == null ? BigDecimal.ZERO : entity.getCheckNum());
                mny = mny.add(entity.getCheckMny() == null ? BigDecimal.ZERO : entity.getCheckMny());
                taxMny = taxMny.add(entity.getCheckTaxMny() == null ? BigDecimal.ZERO : entity.getCheckTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, 4);
                taxAvgPrice = taxMny.divide(num, 4, 4);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            } else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setMaterialId(priceContract.getMaterialId());
                priceLibVO.setMaterialCode(priceContract.getMaterialCode());
                priceLibVO.setMaterialName(priceContract.getMaterialName());
                priceLibVO.setMaterialTypeId(priceContract.getMaterialTypeId());
                priceLibVO.setMaterialTypeName(priceContract.getMaterialTypeName());
                priceLibVO.setSpec(priceContract.getSpec());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setInnerCode(priceContract.getInnerCode());
                libMap.put(priceContract.getMaterialId(), priceLibVO);
            }
            priceLibVO.setCheckNum(num);
            priceLibVO.setCheckMny(mny);
            priceLibVO.setCheckTaxRate(taxRate);
            priceLibVO.setCheckTaxMny(taxMny);
            priceLibVO.setCheckAvgPrice(avgPrice);
            priceLibVO.setCheckMaxPrice(maxPrice);
            priceLibVO.setCheckMinPrice(minPrice);
            priceLibVO.setCheckPriceArea(priceArea);
            priceLibVO.setCheckTaxAvgPrice(taxAvgPrice);
            priceLibVO.setCheckTaxMaxPrice(taxMaxPrice);
            priceLibVO.setCheckTaxMinPrice(taxMinPrice);
            priceLibVO.setCheckTaxPriceArea(taxPriceArea);
            priceLibVO.setCheckHigjFrequencyPrice(highFrequencyPrice);
            priceLibVO.setCheckHigjFrequencyTaxPrice(highFrequencyTaxPrice);
            priceLibVO.setCheckTax(taxMny.subtract(mny));
        }
    }

    private List<PriceSettlementEntity> queryPriceSettlementList(Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("areaName");
        queryParam.setSearchText(param.getSearchText());
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("outFlag", new Parameter("eq", (Object)OutFlagEnum.\u672a\u79fb\u9664.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            queryParam.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        if (param != null) {
            queryParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty((Collection)param.getComplexParams())) {
                queryParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                queryParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        if (null != startDate && null != endDate) {
            String sb = DateUtils.transformationDefaultDate(startDate) + "," + DateUtils.transformationDefaultDate(endDate);
            queryParam.getParams().put("settlementDate", new Parameter("between", (Object)sb));
        }
        this.logger.info("\u67e5\u8be2\u7ed3\u7b97\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryParam));
        return this.priceSettlementService.queryList(queryParam, false);
    }

    private void queryPriceSettlementGroupByMaterialId(Map<Long, PriceLibVO> libMap, Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        List<PriceSettlementEntity> settleList = this.queryPriceSettlementList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isEmpty(settleList)) {
            return;
        }
        Map<Long, List<PriceSettlementEntity>> priceCheckMap = settleList.stream().collect(Collectors.groupingBy(PriceSettlementEntity::getMaterialId));
        for (Map.Entry<Long, List<PriceSettlementEntity>> entry : priceCheckMap.entrySet()) {
            PriceLibVO priceLibVO;
            Long key = entry.getKey();
            List<PriceSettlementEntity> value = entry.getValue();
            List<BigDecimal> priceList = value.stream().map(PriceSettlementEntity::getSettlePrice).collect(Collectors.toList());
            List<BigDecimal> taxPriceList = value.stream().map(PriceSettlementEntity::getSettleTaxPrice).collect(Collectors.toList());
            BigDecimal highFrequencyPrice = this.getHighFrequencyPrice(priceList);
            BigDecimal highFrequencyTaxPrice = this.getHighFrequencyPrice(taxPriceList);
            PriceSettlementEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            BigDecimal avgPrice = BigDecimal.ZERO;
            BigDecimal maxPrice = Collections.max(priceList).divide(BigDecimal.ONE, 4, 4);
            BigDecimal minPrice = Collections.min(priceList).divide(BigDecimal.ONE, 4, 4);
            String priceArea = minPrice + "-" + maxPrice;
            BigDecimal taxAvgPrice = BigDecimal.ZERO;
            BigDecimal taxMaxPrice = Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, 4);
            BigDecimal taxMinPrice = Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, 4);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
            for (PriceSettlementEntity entity : value) {
                num = ComputeUtil.safeAdd(num, entity.getSettleNum());
                mny = ComputeUtil.safeAdd(mny, entity.getSettleMny());
                taxMny = ComputeUtil.safeAdd(taxMny, entity.getSettleTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = ComputeUtil.safeDiv(mny, num).setScale(4, 4);
                taxAvgPrice = ComputeUtil.safeDiv(taxMny, num).setScale(4, 4);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            } else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setMaterialId(priceContract.getMaterialId());
                priceLibVO.setMaterialCode(priceContract.getMaterialCode());
                priceLibVO.setMaterialName(priceContract.getMaterialName());
                priceLibVO.setMaterialTypeId(priceContract.getMaterialTypeId());
                priceLibVO.setMaterialTypeName(priceContract.getMaterialTypeName());
                priceLibVO.setSpec(priceContract.getSpec());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setInnerCode(priceContract.getInnerCode());
                libMap.put(priceContract.getMaterialId(), priceLibVO);
            }
            priceLibVO.setSettleNum(num);
            priceLibVO.setSettleMny(mny);
            priceLibVO.setSettleTaxRate(taxRate);
            priceLibVO.setSettleTaxMny(taxMny);
            priceLibVO.setSettleAvgPrice(avgPrice);
            priceLibVO.setSettleMaxPrice(maxPrice);
            priceLibVO.setSettleMinPrice(minPrice);
            priceLibVO.setSettlePriceArea(priceArea);
            priceLibVO.setSettleTaxAvgPrice(taxAvgPrice);
            priceLibVO.setSettleTaxMaxPrice(taxMaxPrice);
            priceLibVO.setSettleTaxMinPrice(taxMinPrice);
            priceLibVO.setSettleTaxPriceArea(taxPriceArea);
            priceLibVO.setSettleHigjFrequencyPrice(highFrequencyPrice);
            priceLibVO.setSettleHigjFrequencyTaxPrice(highFrequencyTaxPrice);
            priceLibVO.setSettleTax(taxMny.subtract(mny));
        }
    }

    private void queryPriceGuide(Map<Long, PriceLibVO> libMap) {
        if (libMap.isEmpty()) {
            return;
        }
        ArrayList<Long> materialIdList = new ArrayList<Long>(libMap.keySet());
        List<PriceGuideDetailEntity> list = this.priceGuideDetailService.queryPriceGuideDetailByMaterialIds(materialIdList);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map guideMap = list.stream().collect(Collectors.toMap(PriceGuideDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, PriceLibVO> entry : libMap.entrySet()) {
            Long materialId = entry.getKey();
            PriceLibVO vo = entry.getValue();
            if (!guideMap.containsKey(materialId)) continue;
            PriceGuideDetailEntity guide = (PriceGuideDetailEntity)((Object)guideMap.get(materialId));
            BigDecimal min = guide.getMinMny() == null ? BigDecimal.ZERO : guide.getMinMny();
            BigDecimal max = guide.getMaxMny() == null ? BigDecimal.ZERO : guide.getMaxMny();
            min = min.divide(BigDecimal.ONE, 4, 4);
            max = max.divide(BigDecimal.ONE, 4, 4);
            vo.setGuidePriceArea(min + "-" + max);
        }
    }

    @Override
    public List<Long> queryOrgIdList() {
        CommonResponse orgIdListResponse = this.priceDepotPowerSetApi.queryOrgList(InvocationInfoProxy.getOrgId());
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)orgIdListResponse));
        if (!orgIdListResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\u5931\u8d25:" + orgIdListResponse.getMsg());
        }
        return (List)orgIdListResponse.getData();
    }

    private List<Long> getMyOrgList() {
        CommonResponse orgVOResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgVOResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)orgVOResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)orgVOList)) {
            return orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private BigDecimal calculationTaxRate(BigDecimal taxMny, BigDecimal mny) {
        BigDecimal b = new BigDecimal("100");
        if (mny.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return taxMny.divide(mny, 4, 4).subtract(BigDecimal.ONE).multiply(b);
    }

    private void queryPriceContractGroupByMaterialId(Map<Long, PriceLibVO> libMap, Date startDate, List<Long> orgIdList, QueryParam param) {
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isEmpty(priceContractList)) {
            return;
        }
        Map<Long, List<PriceContractEntity>> priceContractMap = priceContractList.stream().collect(Collectors.groupingBy(PriceContractEntity::getMaterialId));
        for (Map.Entry<Long, List<PriceContractEntity>> entry : priceContractMap.entrySet()) {
            PriceLibVO priceLibVO;
            PriceContractEntity priceContract;
            Long key = entry.getKey();
            List<PriceContractEntity> value = entry.getValue();
            List<BigDecimal> priceList = value.stream().filter(item -> null != item.getContractPrice()).map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
            List<BigDecimal> taxPriceList = value.stream().filter(item -> null != item.getContractTaxPrice()).map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
            if (key == 1501897401892007938L) {
                this.logger.info("\u5355\u4ef7-----" + JSONObject.toJSONString(priceList));
                this.logger.info("\u542b\u7a0e\u5355\u4ef7-----" + JSONObject.toJSONString(taxPriceList));
            }
            BigDecimal highFrequencyPrice = this.getHighFrequencyPrice(priceList);
            BigDecimal highFrequencyTaxPrice = this.getHighFrequencyPrice(taxPriceList);
            if (key == 1501897401892007938L) {
                this.logger.info("\u9ad8\u9891\u5355\u4ef7-----" + JSONObject.toJSONString((Object)highFrequencyPrice));
                this.logger.info("\u9ad8\u9891\u542b\u7a0e\u5355\u4ef7-----" + JSONObject.toJSONString((Object)highFrequencyTaxPrice));
            }
            if ((priceContract = value.get(0)) == null) continue;
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            BigDecimal avgPrice = BigDecimal.ZERO;
            BigDecimal maxPrice = CollectionUtils.isNotEmpty(priceList) ? Collections.max(priceList).divide(BigDecimal.ONE, 4, 4) : BigDecimal.ZERO;
            BigDecimal minPrice = CollectionUtils.isNotEmpty(priceList) ? Collections.min(priceList).divide(BigDecimal.ONE, 4, 4) : BigDecimal.ZERO;
            String priceArea = minPrice + "-" + maxPrice;
            BigDecimal taxAvgPrice = BigDecimal.ZERO;
            BigDecimal taxMaxPrice = CollectionUtils.isNotEmpty(priceList) ? Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, 4) : BigDecimal.ZERO;
            BigDecimal taxMinPrice = CollectionUtils.isNotEmpty(priceList) ? Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, 4) : BigDecimal.ZERO;
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
            for (PriceContractEntity entity : value) {
                num = ComputeUtil.safeAdd(num, entity.getContractNum());
                mny = ComputeUtil.safeAdd(mny, entity.getContractMny());
                taxMny = ComputeUtil.safeAdd(taxMny, entity.getContractTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, 4);
                taxAvgPrice = taxMny.divide(num, 4, 4);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            } else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setMaterialId(priceContract.getMaterialId());
                priceLibVO.setMaterialCode(priceContract.getMaterialCode());
                priceLibVO.setMaterialName(priceContract.getMaterialName());
                priceLibVO.setMaterialTypeId(priceContract.getMaterialTypeId());
                priceLibVO.setMaterialTypeName(priceContract.getMaterialTypeName());
                priceLibVO.setSpec(priceContract.getSpec());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setInnerCode(priceContract.getInnerCode());
                libMap.put(priceContract.getMaterialId(), priceLibVO);
            }
            priceLibVO.setContractNum(num);
            priceLibVO.setContractMny(mny);
            priceLibVO.setContractTaxRate(taxRate);
            priceLibVO.setContractTaxMny(taxMny);
            priceLibVO.setContractAvgPrice(avgPrice);
            priceLibVO.setContractMaxPrice(maxPrice);
            priceLibVO.setContractMinPrice(minPrice);
            priceLibVO.setContractPriceArea(priceArea);
            priceLibVO.setContractTaxAvgPrice(taxAvgPrice);
            priceLibVO.setContractTaxMaxPrice(taxMaxPrice);
            priceLibVO.setContractTaxMinPrice(taxMinPrice);
            priceLibVO.setContractTaxPriceArea(taxPriceArea);
            priceLibVO.setContractHigjFrequencyPrice(highFrequencyPrice);
            priceLibVO.setContractHigjFrequencyTaxPrice(highFrequencyTaxPrice);
            priceLibVO.setContractTax(taxMny.subtract(mny));
        }
    }
}

