package com.ejianc.business.zdsmaterial.erp.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.SubTypeEntity;
import com.ejianc.business.zdsmaterial.erp.service.ISubTypeService;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/26 13:45
 */
@RestController
@RequestMapping(value = "/api/zdsSubType/")
public class SubTypeApi {

    @Autowired
    private ISubTypeService service;

    @PostMapping(value = "getAllBySourceIds")
    CommonResponse<List<SubTypeVO>> getAllBySourceIds(@RequestBody List<String> sourceIds) {
        List<SubTypeVO> resp = new ArrayList<>();
        QueryWrapper<SubTypeEntity> query = new QueryWrapper<>();
        query.in("source_id", sourceIds);
        query.eq("enabled", 1);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<SubTypeEntity> eList = service.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, SubTypeVO.class);
        }

        return CommonResponse.success(resp);
    }

    @GetMapping(value = "getOneById")
    CommonResponse<SubTypeVO> getOneById(@RequestParam Long id) {
        SubTypeVO resp = null;
        SubTypeEntity subType = service.selectById(id);
        if(null != subType) {
            resp = BeanMapper.map(subType, SubTypeVO.class);
        }
        return CommonResponse.success("查询成功！", resp);
    }


    @PostMapping(value = "getAllByIds")
    CommonResponse<List<SubTypeVO>> getAllByIds(@RequestParam List<Long> ids) {
        return CommonResponse.success("查询成功！", service.getAllByIds(ids));
    }


    @PostMapping(value = "getSubTypeList")
    CommonResponse<List<SubTypeVO>> getSubTypeList() {
        List<SubTypeVO> resp = new ArrayList<>();
        QueryWrapper<SubTypeEntity> query = new QueryWrapper<>();
        query.eq("enabled", 1);
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<SubTypeEntity> eList = service.list(query);
        if (CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, SubTypeVO.class);
        }
        return CommonResponse.success(resp);
    }
}
