/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.cloudstore.shelf.controller.api;

import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/goods/"})
public class ZdsGoodsApi {
    @Autowired
    private IGoodsService service;

    @PostMapping(value={"querySurplusShelfMny"})
    public CommonResponse<List<GoodsVO>> querySurplusShelfMny(@RequestBody List<Long> storeIds) {
        ArrayList result = new ArrayList();
        if (CollectionUtils.isEmpty(storeIds)) {
            return CommonResponse.success((String)"\u5165\u53c2\u4e3a\u7a7a\uff01", result);
        }
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter("eq", (Object)PlanConstant.GOODS_STATUS_ON));
        param.getParams().put("cloudStoreId", new Parameter("in", storeIds));
        List list = this.service.queryList(param);
        HashMap<Long, GoodsVO> map = new HashMap<Long, GoodsVO>();
        for (GoodsEntity entity : list) {
            GoodsVO vo = new GoodsVO();
            vo.setCloudStoreId(entity.getCloudStoreId());
            if (map.containsKey(entity.getCloudStoreId())) {
                vo = (GoodsVO)map.get(entity.getCloudStoreId());
            }
            BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)entity.getTaxPrice(), (BigDecimal)entity.getSurplusNum());
            vo.setTaxMny(ComputeUtil.safeAdd((BigDecimal)vo.getTaxMny(), (BigDecimal)taxMny));
            map.put(entity.getCloudStoreId(), vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", new ArrayList(map.values()));
    }
}

