package com.ejianc.business.zdsmaterial.erp.service;

import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2023/12/11 16:37
 */
public interface IBrandService extends IBaseService<BrandEntity> {
    Map<String, BrandEntity> getAllByNames(List<String> names);
    Map<String, BrandVO> getAllVoMapByNames(List<String> names);
    BrandEntity getOneByName(String name);

    List<BrandEntity> getAllBySourceIds(List<String> sourceIds);

    List<BrandVO> getAllByIds(List<Long> ids);

    void pushBrandToErp(DataPushErpParam pushParam);

    void updateBrandEnable(BrandVO brand);

    long countBrandPool(Map<String, Object> param);

    List<BrandVO> pageBrandPool(Map<String, Object> param);

    void updateRelationEnable(BrandVO brand);
}
