package com.ejianc.business.zdsmaterial.material.controller.api;

import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/5/15 19:02
 */
@RestController
@RequestMapping(value = "/api/zdsMaterialCategory")
public class MaterialCategoryApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialCategoryService service;

    @PostMapping(value = "/getAllByIds")
    CommonResponse<List<MaterialCategoryVO>> getAllByIds(@RequestBody List<Long> ids) {
        return CommonResponse.success("查询成功！", service.getAllByIds(ids));
    }

    @PostMapping(value = "/getAllBySourceIdsAndPropertyFlag")
    CommonResponse<List<MaterialCategoryVO>> getAllBySourceIdsAndPropertyFlag(@RequestBody List<String> sourceIds, @RequestParam Integer propertyFlag) {
        return CommonResponse.success("查询成功！", service.getAllBySourceIds(sourceIds, propertyFlag));
    }

    @PostMapping(value = "/getAllBySourceIds")
    CommonResponse<List<MaterialCategoryVO>> getAllBySourceIds(@RequestBody List<String> sourceIds) {
        return CommonResponse.success("查询成功！", service.getAllBySourceIds(sourceIds, null));
    }


    @PostMapping(value = "/getMaterialSecondCategoryList")
    CommonResponse<List<MaterialCategoryVO>> getMaterialSecondCategoryList() {
        return CommonResponse.success("查询成功！", service.getMaterialSecondCategoryList());
    }
}
