/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.invoice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdsmaterial.cloudstore.constants.CommonConstants;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractManagerService;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.erp.service.IMessageInfoService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceFileEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceOcrEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.mapper.SubInvoiceMapper;
import com.ejianc.business.zdsmaterial.sub.invoice.service.ISubInvoiceDetailService;
import com.ejianc.business.zdsmaterial.sub.invoice.service.ISubInvoiceService;
import com.ejianc.business.zdsmaterial.sub.invoice.vo.SubInvoiceVO;
import com.ejianc.business.zdsmaterial.sub.setting.service.ISubCheckerSettingService;
import com.ejianc.business.zdsmaterial.util.BillLockUtil;
import com.ejianc.business.zdsmaterial.util.CommonUtils;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.PushFileUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="subInvoiceService")
public class SubInvoiceServiceImpl
extends BaseServiceImpl<SubInvoiceMapper, SubInvoiceEntity>
implements ISubInvoiceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "EJCBT202403000027";
    private static final String BILL_NAME = "\u5206\u5305\u53d1\u7968\u767b\u8bb0";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/subInvoice/supSignSync";
    private static final String BILL_CODE = "SUB_INVOICE";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private PushFileUtil pushFileUtil;
    @Autowired
    private IErpInvoiceService erpInvoiceService;
    @Autowired
    private ISubSupplierApi subSupplierApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private ISubContractService subContractService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IErpInvoiceDetailService invoiceDetailService;
    @Autowired
    private ISubCheckerSettingService subCheckerSettingService;
    @Autowired
    private IMessageInfoService messageInfoService;
    private final String COMPANY_SOCIAL_CODE = "company_social_code";
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IContractManagerService contractManagerService;
    @Autowired
    private ISubInvoiceDetailService detailService;

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        this.logger.info("\u8fdb\u5165\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        String nameSourceIdMapping = request.getParameter("nameSourceIdMapping");
        Map nameSourceTypemap = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        Map nameSourceIdMap = (Map)JSONObject.parseObject((String)nameSourceIdMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u6570\u636etransData\uff1a{}\uff0cnameSourceTypeMapping\uff1a{}, nameSourceIdMap\uff1a{}", new Object[]{transData, nameSourceTypeMapping, nameSourceIdMap});
        SubInvoiceVO vo = (SubInvoiceVO)((Object)JSONObject.parseObject((String)transData, SubInvoiceVO.class));
        if (vo == null || vo.getId() == null) {
            throw new BusinessException("\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        SubInvoiceEntity saveEntity = (SubInvoiceEntity)((Object)BeanMapper.map((Object)((Object)vo), SubInvoiceEntity.class));
        try {
            CommonResponse commonResponse;
            BillCodeParam billCodeParam;
            CommonResponse billCode;
            Long checkerId;
            boolean lock = BillLockUtil.getLock(BILL_TYPE, vo.getId(), 600);
            if (!lock) {
                throw new BusinessException("\u5355\u636e\u4fe1\u606f\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            saveEntity.setPrintFlag(PlanConstant.INTEGER_NO);
            if ("1".equals(saveEntity.getOpenOcrState())) {
                Set inValidNumbers = saveEntity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && !"1".equals(x.getOcrState())).map(x -> x.getInvoiceNumber()).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(inValidNumbers)) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25, \u53f7\u7801\u4e3a\u3010" + inValidNumbers.stream().collect(Collectors.joining("\u3001")) + "\u3011\u7684\u53d1\u7968\u672a\u4e0a\u4f20\u53d1\u7968\u9644\u4ef6\uff01");
                }
                inValidNumbers = saveEntity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && !"\u67e5\u9a8c\u901a\u8fc7".equals(x.getOcrCheckMsg())).map(x -> x.getInvoiceNumber()).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(inValidNumbers)) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25, \u53d1\u7968\u3010" + inValidNumbers.stream().collect(Collectors.joining("\u3001")) + "\u3011\u4e0b\u5b58\u5728\u67e5\u9a8c\u672a\u901a\u8fc7\u7684\u6e05\u5355\uff01");
                }
            } else if (CollectionUtils.isEmpty(saveEntity.getFileList())) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25, \u672a\u4e0a\u4f20\u53d1\u7968\u9644\u4ef6!");
            }
            EmployeeVO craetor = null;
            SubContractEntity contract = (SubContractEntity)((Object)this.subContractService.selectById(saveEntity.getContractId()));
            if (null == contract) {
                this.logger.error("\u6839\u636e\u5206\u5305\u5408\u540cid-{}\uff0c\u67e5\u8be2\u5bf9\u5e94\u5206\u5305\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)saveEntity.getContractId());
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25, \u67e5\u8be2\u53d1\u7968\u5bf9\u5e94\u5408\u540c\u4fe1\u606f\u5931\u8d25!");
            }
            if (CollectionUtils.isEmpty(saveEntity.getDetailList())) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53d1\u7968\u6e05\u5355\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)contract.getContractPartyA())) {
                Set invoiceNumers;
                String partA = contract.getContractPartyA();
                if (StringUtils.isNotBlank((CharSequence)partA) && CollectionUtils.isNotEmpty(invoiceNumers = saveEntity.getDetailList().stream().filter(item -> !partA.replaceAll("\uff08", "(").replaceAll("\uff09", ")").equals(item.getInvoiceHeader().replaceAll("\uff08", "(").replaceAll("\uff09", ")"))).map(item -> item.getInvoiceNumber()).collect(Collectors.toSet()))) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53d1\u7968\u3010" + invoiceNumers.stream().collect(Collectors.joining("\u3001")) + "\u3011\u62ac\u5934\u4e0e\u5408\u540c\u7532\u65b9\u4fe1\u606f\u4e0d\u4e00\u81f4\uff01");
                }
                if ("1".equals(saveEntity.getOpenOcrState()) && CollectionUtils.isNotEmpty(saveEntity.getOcrList())) {
                    List companySocialVos;
                    String socialCode = null;
                    CommonResponse defDetails = this.defdocApi.detailListByDetailNamesAndDocCode(new String[]{partA}, "company_social_code");
                    if (!defDetails.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)defDetails.getData()))) {
                        this.logger.info("*******\u83b7\u53d6\u7532\u65b9\uff1a{}\u5bf9\u5e94\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u5931\u8d25\u6216\u4e3a\u7a7a*********\uff01");
                    }
                    if (CollectionUtils.isNotEmpty(companySocialVos = ((List)defDetails.getData()).stream().filter(item -> item.getName().equals(partA)).collect(Collectors.toList()))) {
                        socialCode = ((DefdocDetailVO)companySocialVos.get(0)).getCode();
                    }
                    JSONObject identifyResult = null;
                    for (SubInvoiceOcrEntity subInvoiceOcrEntity : saveEntity.getOcrList()) {
                        identifyResult = JSONObject.parseObject((String)subInvoiceOcrEntity.getIdentifyResult());
                        if (StringUtils.isNotBlank((CharSequence)partA) && !partA.replaceAll("\uff08", "(").replaceAll("\uff09", ")").equals(identifyResult.getString("purchaserName").replaceAll("\uff08", "(").replaceAll("\uff09", ")"))) {
                            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff1a\u8d2d\u4e70\u65b9\u4e0e\u5408\u540c\u7532\u65b9\u4fe1\u606f\u4e0d\u4e00\u81f4");
                        }
                        if (!StringUtils.isNotBlank((CharSequence)socialCode) || socialCode.equalsIgnoreCase(identifyResult.getString("purchaserTaxNumber"))) continue;
                        throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff1a\u8d2d\u4e70\u65b9\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u9519\u8bef");
                    }
                }
            }
            if (null == (checkerId = this.contractManagerService.getContractOperator(saveEntity.getContractId(), "2"))) {
                checkerId = this.subCheckerSettingService.getByContractId(saveEntity.getContractId());
            }
            if (null == checkerId && StringUtils.isNotBlank((CharSequence)saveEntity.getAdminId())) {
                checkerId = Long.valueOf(saveEntity.getAdminId());
            }
            if (null == checkerId) {
                this.logger.error("\u67e5\u8be2\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25,\u6839\u636e\u53d1\u7968\u5bf9\u5e94\u5206\u5305\u5408\u540cid-{}\u83b7\u53d6\u5ba1\u6838\u4eba\u4e3a\u7a7a", (Object)saveEntity.getContractId());
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u53d1\u7968\u672a\u8bbe\u7f6e\u5bf9\u5e94\u5ba1\u6838\u4eba!");
            }
            CommonResponse creatorResp = this.employeeApi.getById(checkerId);
            if (!creatorResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u5931\u8d25,{}", (Object)checkerId, (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
            }
            if (null == creatorResp.getData()) {
                this.logger.error("\u67e5\u8be2\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u4e3a\u7a7a,{}", (Object)checkerId, (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
            }
            craetor = (EmployeeVO)creatorResp.getData();
            if (!checkerId.equals(saveEntity.getAdminId())) {
                saveEntity.setAdminId(craetor.getId().toString());
                saveEntity.setAdminCode(craetor.getCode());
                saveEntity.setAdminName(craetor.getName());
            }
            if ((billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo))).isSuccess()) {
                saveEntity.setBillCode((String)billCode.getData());
            }
            saveEntity.setSourceId(saveEntity.getId());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setSignState(Integer.valueOf("0"));
            saveEntity.setRejectReason(null);
            if (CollectionUtils.isNotEmpty(saveEntity.getDetailList())) {
                saveEntity.setInvoiceHeader(saveEntity.getDetailList().get(0).getInvoiceHeader());
            }
            saveEntity.setMainContMny(contract.getContractMoney());
            saveEntity.setChildContMny(contract.getFuJiaMoney());
            saveEntity.setPushErpFlag("0");
            ArrayList<Long> invoiceIds = new ArrayList<Long>();
            CommonUtils.clearInvalidData(saveEntity);
            saveEntity.setCreateUserName(craetor.getUserName());
            saveEntity.setCreateUserId(craetor.getUserId());
            saveEntity.setCreateUserCode(craetor.getCode());
            ArrayList<String> invoiceNums = new ArrayList();
            for (SubInvoiceDetailEntity detail : saveEntity.getDetailList()) {
                detail.setSourceId(detail.getId());
                detail.setSourceMainId(detail.getMainId());
                CommonUtils.clearInvalidData(detail);
                detail.setCreateUserCode(craetor.getUserCode());
                invoiceIds.add(detail.getInvoiceId());
            }
            if (CollectionUtils.isNotEmpty(invoiceIds)) {
                List<String> list;
                List<ErpInvoiceEntity> list2 = this.erpInvoiceService.getAllByIds(invoiceIds);
                invoiceNums = list2.stream().map(ErpInvoiceEntity::getNumber).collect(Collectors.toList());
                HashSet<String> quoteNumberList = new HashSet<String>();
                List<ErpInvoiceEntity> list3 = this.erpInvoiceService.getAllByInvoiceNums(invoiceNums);
                this.logger.info("\u5206\u5305: \u6839\u636e\u53d1\u7968\u53f7\uff1a{}, EL\u67e5\u8be2\u5230\u53d1\u7968\u6570\uff1a{}", (Object)JSONObject.toJSONString(invoiceNums), (Object)list3.size());
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    ErpInvoiceEntity e = (ErpInvoiceEntity)((Object)iterator.next());
                    this.logger.info("\u5206\u5305\u53d1\u7968id-{},number-{}, ERP\u5f15\u7528\u6807\u8bc6\uff1a{}", new Object[]{e.getId(), e.getNumber(), e.getErpQuoteFlag()});
                    if (!"1".equals(e.getQuoteFlag()) && !"1".equals(e.getErpQuoteFlag())) continue;
                    quoteNumberList.add(e.getNumber());
                }
                if (CollectionUtils.isNotEmpty(quoteNumberList)) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a[" + quoteNumberList.stream().collect(Collectors.joining(",")) + "]\u7684\u53d1\u7968\u5df2\u88ab\u5f15\u7528");
                }
                if (CollectionUtils.isNotEmpty(saveEntity.getDetailList()) && CollectionUtils.isNotEmpty(list = this.erpInvoiceService.checkQuote(new ArrayList<String>(saveEntity.getDetailList().stream().map(SubInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet())), "sub"))) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + list.stream().collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
                }
                List<String> list4 = this.getQuoteInfoByInvoiceNums(invoiceNums, null);
                if (CollectionUtils.isNotEmpty(list4)) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + list4.stream().collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
                }
                list2.stream().forEach(invoice -> invoice.setQuoteFlag("1"));
                this.erpInvoiceService.saveOrUpdateBatch(list2, list2.size(), false);
            }
            if (!(commonResponse = this.proSupplierApi.getEjcCloudSystemCode()).isSuccess()) {
                this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)saveEntity.getSourceId(), (Object)commonResponse.getMsg());
            }
            saveEntity.setSystemId((String)commonResponse.getData());
            List<SubInvoiceFileEntity> subFileList = saveEntity.getFileList();
            for (SubInvoiceFileEntity subInvoiceFileEntity : subFileList) {
                subInvoiceFileEntity.setSourceId(subInvoiceFileEntity.getId());
                subInvoiceFileEntity.setSourceMainId(subInvoiceFileEntity.getMainId());
                CommonUtils.clearInvalidData(subInvoiceFileEntity);
                subInvoiceFileEntity.setCreateUserCode(craetor.getUserCode());
                subInvoiceFileEntity.setId(IdWorker.getId());
                if (null != subInvoiceFileEntity.getFileId()) {
                    Long fileId = this.pushFileUtil.uploadFileFormNet(BILL_TYPE, subInvoiceFileEntity.getId(), "file01", subInvoiceFileEntity.getFileId());
                    subInvoiceFileEntity.setFileId(fileId);
                    subInvoiceFileEntity.setFileUrl(this.BASE_HOST + "/ejc-file-web/attachment/filePreview?fileId=" + fileId);
                    continue;
                }
                subInvoiceFileEntity.setFileId(null);
                subInvoiceFileEntity.setFileUrl(null);
            }
            List<SubInvoiceOcrEntity> ocrList = saveEntity.getOcrList();
            for (SubInvoiceOcrEntity file : ocrList) {
                file.setSourceId(file.getId());
                file.setSourceMainId(file.getMainId());
                CommonUtils.clearInvalidData(file);
                file.setCreateUserCode(craetor.getUserCode());
                file.setId(IdWorker.getId());
                if (null != file.getFileId()) {
                    Long fileId = this.pushFileUtil.uploadFileFormNet(BILL_TYPE, file.getId(), "file01", file.getFileId());
                    file.setFileId(fileId);
                    file.setFileUrl(this.BASE_HOST + "/ejc-file-web/attachment/filePreview?fileId=" + fileId);
                    continue;
                }
                file.setFileId(null);
                file.setFileUrl(null);
            }
            saveEntity.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER);
            super.saveOrUpdate((Object)saveEntity, false);
            this.logger.info("\u4f9b\u65b9\u53d1\u7968\u63d0\u4ea4, \u5411\u53d1\u7968\u7ba1\u7406\u5458id-{}\u53d1\u9001\u6d88\u606f", (Object)saveEntity.getAdminId());
            PushMsgParameter pushMsgParameter = new PushMsgParameter();
            pushMsgParameter.setSubject("\u3010\u53d1\u7968\u5ba1\u6838\u3011\uff1a\u3010" + saveEntity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01");
            StringBuilder content = new StringBuilder();
            content.append("\u3010").append(saveEntity.getBillCode()).append("\u3011\uff0c\u3010").append(saveEntity.getProjectName()).append("\u3011\uff0c\u3010").append(saveEntity.getContractName()).append("\u3011\uff0c\u3010").append(saveEntity.getSupplierName()).append("\u3011\u63d0\u4ea4\u4e86\u53d1\u7968\uff0c\u8bf7\u60a8\u5ba1\u6838\uff01");
            pushMsgParameter.setContent(content.toString());
            pushMsgParameter.setPcUrl(this.BASE_HOST + CommonConstants.\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 + saveEntity.getId().toString());
            String[] recIds = new String[]{saveEntity.getAdminId()};
            pushMsgParameter.setReceivers(recIds);
            this.sendMsg(pushMsgParameter, saveEntity.getId(), "\u4f9b\u65b9\u53d1\u7968\u63d0\u4ea4 \u5411\u53d1\u7968\u7ba1\u7406\u5458\u53d1\u9001\u6d88\u606f");
            this.messageInfoService.sendTodo(Arrays.asList(saveEntity.getAdminId().split(",")), saveEntity.getId().toString(), BILL_TYPE, content.toString(), craetor.getId().toString(), this.BASE_HOST + CommonConstants.\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 + saveEntity.getId().toString(), null, "\u5f85\u529e", "0", "\u4f9b\u65b9\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0", null, null);
            this.logger.info("\u4fdd\u5b58\u63a5\u53e3\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            this.logger.error("\u5206\u5305\u53d1\u7968\u5355\u636esourceId-{}\u5904\u7406\u5f02\u5e38", (Object)vo.getId(), (Object)e);
            throw new BusinessException(null != e.getMessage() ? e.getMessage() : "\u64cd\u4f5c\u5931\u8d25\uff0c\u5904\u7406\u5355\u636e\u5931\u8d25\uff01");
        }
        finally {
            BillLockUtil.releaseLock(BILL_TYPE, vo.getId());
        }
        return saveEntity.getId();
    }

    private List<String> getQuoteInfoByInvoiceNums(List<String> invoiceNums, List<Long> exIncludMainIds) {
        ArrayList<String> resp = new ArrayList<String>();
        QueryWrapper detailQuery = new QueryWrapper();
        detailQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        detailQuery.in((Object)"invoice_number", invoiceNums);
        List detailList = this.detailService.list((Wrapper)detailQuery);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            ArrayList mainIds = new ArrayList(detailList.stream().map(SubInvoiceDetailEntity::getMainId).collect(Collectors.toSet()));
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"id", mainIds);
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            if (CollectionUtils.isNotEmpty(exIncludMainIds)) {
                query.notIn((Object)"id", exIncludMainIds);
            }
            query.ne((Object)"sign_state", (Object)Integer.valueOf("2"));
            List mainEntity = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)mainEntity)) {
                Map<Long, List<SubInvoiceDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(SubInvoiceDetailEntity::getMainId));
                for (SubInvoiceEntity m : mainEntity) {
                    for (SubInvoiceDetailEntity d : detailMap.get(m.getId())) {
                        if (resp.contains(d.getInvoiceNumber())) continue;
                        resp.add(d.getInvoiceNumber());
                    }
                }
            }
        }
        return resp;
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("{}-\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u5355\u636eId-{}\uff0c\u53d1\u9001\u6d88\u606f\u7ed3\u679c-{}", new Object[]{oprMsg, billId, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("{}-\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)oprMsg);
        }
    }

    @Override
    public SubInvoiceVO confirmSign(Long id, boolean isConfirm, String rejectReason) {
        UserContext user = this.sessionManager.getUserContext();
        SubInvoiceEntity entity = (SubInvoiceEntity)((Object)super.selectById((Serializable)id));
        if (PlanConstant.SOURCE_TYPE_SUPPLIER == entity.getSourceType()) {
            try {
                List<String> invoiceNums;
                List<String> quotedNums;
                BillLockUtil.getLock(BILL_TYPE, entity.getId());
                HashMap nameSourceTypeMapping = new HashMap();
                if (isConfirm && CollectionUtils.isNotEmpty(quotedNums = this.getQuoteInfoByInvoiceNums(invoiceNums = entity.getDetailList().stream().map(SubInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toList()), Collections.singletonList(id)))) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + quotedNums.stream().collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("nameSourceTypeMapping", JSONObject.toJSONString(nameSourceTypeMapping));
                params.put("billId", String.valueOf(entity.getSourceId()));
                params.put("operateId", String.valueOf(user.getUserId()));
                params.put("operateName", user.getUserName());
                params.put("signState", isConfirm ? "1" : "2");
                if (StringUtils.isNotBlank((CharSequence)rejectReason)) {
                    params.put("rejectReason", rejectReason);
                }
                this.logger.info("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\uff0c\u901a\u77e5\u5355\u636e\u63a8\u9001\u65b9systemId-{},\u53c2\u6570-{}", new Object[]{BILL_NAME, entity.getId(), entity.getSystemId(), JSONObject.toJSONString(params)});
                CommonResponse backResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_WITER_BACK_SERVER_URL, params, entity.getSupplierId().toString(), null);
                this.logger.error("\u5355\u636e-{}\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)BILL_NAME, (Object)JSONObject.toJSONString((Object)backResp));
                if (!backResp.isSuccess()) {
                    this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), backResp.getMsg()});
                    throw new BusinessException("\u5206\u5305\u53d1\u7968\u767b\u8bb0\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25");
                }
                if ("\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01".equals(backResp.getData())) {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42URL-{}\u7ed9\u7cfb\u7edf-{}\u5931\u8d25, {}", new Object[]{BILL_WITER_BACK_SERVER_URL, entity.getSystemId(), backResp.getData()});
                    throw new BusinessException((String)backResp.getData());
                }
                CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)((String)backResp.getData()), CommonResponse.class);
                if (!operateResp.isSuccess()) {
                    this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), operateResp.getMsg()});
                    throw new BusinessException("\u66f4\u65b0\u72b6\u6001\u56de\u8c03\u5904\u7406\u5931\u8d25");
                }
                if (!isConfirm && CollectionUtils.isNotEmpty(entity.getDetailList())) {
                    List<ErpInvoiceEntity> invoiceList = this.erpInvoiceService.getAllByIds(entity.getDetailList().stream().map(SubInvoiceDetailEntity::getInvoiceId).collect(Collectors.toList()));
                    invoiceList.stream().forEach(invoice -> invoice.setQuoteFlag("0"));
                    this.erpInvoiceService.saveOrUpdateBatch(invoiceList, invoiceList.size(), false);
                }
                super.saveOrUpdate((Object)entity, false);
            }
            catch (Exception e) {
                this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u5f02\u5e38\uff0c", new Object[]{BILL_NAME, entity.getId(), e});
                throw new BusinessException(StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            finally {
                BillLockUtil.releaseLock(BILL_TYPE, entity.getId());
            }
        } else if (!isConfirm && CollectionUtils.isNotEmpty(entity.getDetailList())) {
            List<ErpInvoiceEntity> invoiceList = this.erpInvoiceService.getAllByIds(entity.getDetailList().stream().map(SubInvoiceDetailEntity::getInvoiceId).collect(Collectors.toList()));
            invoiceList.stream().forEach(invoice -> invoice.setQuoteFlag("0"));
            this.erpInvoiceService.saveOrUpdateBatch(invoiceList, invoiceList.size(), false);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(SubInvoiceEntity::getSignState, (Object)(isConfirm ? "1" : "2"));
        updateWrapper.set(SubInvoiceEntity::getRejectReason, (Object)rejectReason);
        updateWrapper.set(BaseEntity::getUpdateTime, (Object)new Date());
        updateWrapper.set(BaseEntity::getUpdateUserCode, (Object)InvocationInfoProxy.getUsercode());
        this.update((Wrapper)updateWrapper);
        this.messageInfoService.sendTodo(Arrays.asList(entity.getAdminId().split(",")), entity.getId().toString(), BILL_TYPE, null, entity.getOperateId().toString(), null, null, "\u5df2\u529e", "1", "\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838", isConfirm ? "\u540c\u610f" : "\u4e0d\u540c\u610f", isConfirm ? "1" : "2");
        return (SubInvoiceVO)((Object)BeanMapper.map((Object)this.selectById(id), SubInvoiceVO.class));
    }

    @Override
    public SubInvoiceVO commitReview(Long id) {
        SubInvoiceEntity entity = (SubInvoiceEntity)((Object)super.selectById((Serializable)id));
        if (PlanConstant.SOURCE_TYPE_EL == entity.getSourceType() && CollectionUtils.isNotEmpty(entity.getDetailList())) {
            ArrayList<String> numbers = new ArrayList<String>(entity.getDetailList().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getInvoiceNumber())).map(SubInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet()));
            if (CollectionUtils.isNotEmpty(numbers)) {
                List<String> quotedInvoiceNums;
                ArrayList<String> quoteNumberList = new ArrayList<String>();
                List<ErpInvoiceEntity> list = this.erpInvoiceService.getAllByInvoiceNums(numbers);
                this.logger.info("\u5206\u5305: \u6839\u636e\u53d1\u7968\u53f7\uff1a{}, EL\u67e5\u8be2\u5230\u53d1\u7968\u6570\uff1a{}", (Object)JSONObject.toJSONString(numbers), (Object)list.size());
                for (ErpInvoiceEntity e : list) {
                    this.logger.info("\u5206\u5305\u53d1\u7968id-{},number-{}, ERP\u5f15\u7528\u6807\u8bc6\uff1a{}", new Object[]{e.getId(), e.getNumber(), e.getErpQuoteFlag()});
                    if (!"1".equals(e.getQuoteFlag()) && !"1".equals(e.getErpQuoteFlag())) continue;
                    quoteNumberList.add(e.getNumber());
                }
                if (CollectionUtils.isNotEmpty(quoteNumberList)) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a[" + quoteNumberList.stream().collect(Collectors.joining(",")) + "]\u7684\u53d1\u7968\u5df2\u88ab\u5f15\u7528");
                }
                if (CollectionUtils.isNotEmpty(entity.getDetailList()) && CollectionUtils.isNotEmpty(quotedInvoiceNums = this.erpInvoiceService.checkQuote(new ArrayList<String>(entity.getDetailList().stream().map(SubInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet())), "sub"))) {
                    throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + quotedInvoiceNums.stream().collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
                }
                list.stream().forEach(invoice -> invoice.setQuoteFlag("1"));
                this.erpInvoiceService.saveOrUpdateBatch(list, list.size(), false);
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(SubInvoiceEntity::getSignState, (Object)"0");
            updateWrapper.set(BaseEntity::getUpdateTime, (Object)new Date());
            updateWrapper.set(BaseEntity::getUpdateUserCode, (Object)InvocationInfoProxy.getUsercode());
            this.update((Wrapper)updateWrapper);
        }
        if (null == entity.getAdminId()) {
            Long checkerId = this.contractManagerService.getContractOperator(entity.getContractId(), "2");
            if (null == checkerId) {
                checkerId = this.subCheckerSettingService.getByContractId(entity.getContractId());
            }
            if (null == checkerId && StringUtils.isNotBlank((CharSequence)entity.getAdminId())) {
                checkerId = Long.valueOf(entity.getAdminId());
            }
            if (null == checkerId) {
                throw new BusinessException("\u672a\u83b7\u53d6\u5230\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u4e86\u5bf9\u5e94\u7684\u53d1\u7968\u5ba1\u6838\u4eba\uff01");
            }
            CommonResponse creatorResp = this.employeeApi.getById(checkerId);
            if (!creatorResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u5931\u8d25,{}", (Object)checkerId, (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
            }
            if (null == creatorResp.getData()) {
                this.logger.error("\u67e5\u8be2\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u4e3a\u7a7a,{}", (Object)checkerId, (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
            }
            EmployeeVO craetor = (EmployeeVO)creatorResp.getData();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(SubInvoiceEntity::getAdminId, (Object)craetor.getId());
            updateWrapper.set(SubInvoiceEntity::getAdminCode, (Object)craetor.getCode());
            updateWrapper.set(SubInvoiceEntity::getAdminName, (Object)craetor.getName());
            this.update((Wrapper)updateWrapper);
        }
        this.logger.info("\u4f9b\u65b9\u53d1\u7968\u63d0\u4ea4, \u5411\u53d1\u7968\u7ba1\u7406\u5458id-{}\u53d1\u9001\u6d88\u606f", (Object)entity.getAdminId());
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setSubject("\u3010\u53d1\u7968\u5ba1\u6838\u3011\uff1a\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01");
        StringBuilder content = new StringBuilder();
        content.append("\u3010").append(entity.getBillCode()).append("\u3011\uff0c\u3010").append(entity.getProjectName()).append("\u3011\uff0c\u3010").append(entity.getContractName()).append("\u3011\uff0c\u3010").append(entity.getSupplierName()).append("\u3011\u63d0\u4ea4\u4e86\u53d1\u7968\uff0c\u8bf7\u60a8\u5ba1\u6838\uff01");
        parameter.setContent(content.toString());
        parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u5206\u5305\u81ea\u5236\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 + entity.getId().toString());
        String[] recIds = new String[]{entity.getAdminId()};
        parameter.setReceivers(recIds);
        this.sendMsg(parameter, entity.getId(), "\u81ea\u5236\u53d1\u7968\u63d0\u4ea4 \u5411\u53d1\u7968\u7ba1\u7406\u5458\u53d1\u9001\u6d88\u606f");
        this.messageInfoService.sendTodo(Arrays.asList(entity.getAdminId().split(",")), entity.getId().toString(), BILL_TYPE, content.toString(), entity.getOperateId().toString(), this.BASE_HOST + CommonConstants.\u5206\u5305\u81ea\u5236\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 + entity.getId().toString(), null, "\u5f85\u529e", "0", "\u5206\u5305\u81ea\u5236\u53d1\u7968\u767b\u8bb0", null, null);
        return (SubInvoiceVO)((Object)BeanMapper.map((Object)this.selectById(id), SubInvoiceVO.class));
    }

    @Override
    public String changeAminEmp(JSONObject changeParam) {
        List billIds = JSONArray.parseArray((String)JSONObject.toJSONString((Object)changeParam.get((Object)"ids")), Long.class);
        Long adminId = changeParam.getLong("adminId");
        String adminCode = changeParam.getString("adminCode");
        String adminName = changeParam.getString("adminName");
        List billList = (List)super.listByIds((Collection)billIds);
        if (CollectionUtils.isNotEmpty((Collection)billList)) {
            for (SubInvoiceEntity entity : billList) {
                PushMsgParameter parameter = new PushMsgParameter();
                parameter.setSubject("\u3010\u53d1\u7968\u5ba1\u6838\u3011\uff1a\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01\uff01");
                StringBuilder content = new StringBuilder();
                content.append("\u3010").append(entity.getBillCode()).append("\u3011\uff0c\u3010").append(entity.getProjectName()).append("\u3011\uff0c\u3010").append(entity.getContractName()).append("\u3011\uff0c\u3010").append(entity.getSupplierName()).append("\u3011\u63d0\u4ea4\u4e86\u53d1\u7968\uff0c\u8bf7\u60a8\u5ba1\u6838\uff01");
                parameter.setContent(content.toString());
                parameter.setPcUrl(this.BASE_HOST + (null != entity.getSourceType() && Integer.valueOf(1).equals(entity.getSourceType()) ? CommonConstants.\u5206\u5305\u81ea\u5236\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 : CommonConstants.\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5) + entity.getId().toString());
                String[] recIds = new String[]{entity.getAdminId()};
                parameter.setReceivers(recIds);
                this.sendMsg(parameter, entity.getId(), "\u5206\u5305\u53d1\u7968\u767b\u8bb0\u8f6c\u7b7e \u5411\u53d1\u7968\u7ba1\u7406\u5458\u53d1\u9001\u6d88\u606f");
                this.messageInfoService.sendTodo(Arrays.asList(entity.getAdminId().split(",")), entity.getId().toString(), BILL_TYPE, content.toString(), entity.getOperateId().toString(), parameter.getPcUrl(), null, "\u5df2\u529e", "1", "\u5206\u5305\u53d1\u7968\u767b\u8bb0\u8f6c\u7b7e", "\u5206\u5305\u53d1\u7968\u767b\u8bb0\u8f6c\u7b7e", "1");
                this.messageInfoService.sendTodo(Collections.singletonList(adminId.toString()), entity.getId().toString(), BILL_TYPE, content.toString(), entity.getOperateId().toString(), parameter.getPcUrl(), null, "\u5f85\u529e", "0", "\u5206\u5305\u53d1\u7968\u767b\u8bb0\u8f6c\u7b7e", null, null);
                entity.setAdminId(adminId.toString());
                entity.setAdminCode(adminCode);
                entity.setAdminName(adminName);
            }
            super.saveOrUpdateBatch(billList, billList.size(), false);
        }
        return null;
    }

    @Override
    public void updateBillPrintInfo(List<Long> ids) {
        UserContext user = this.sessionManager.getUserContext();
        LambdaUpdateWrapper update = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)update.in(BaseEntity::getId, ids)).set(SubInvoiceEntity::getPrintFlag, (Object)PlanConstant.INTEGER_YES)).set(SubInvoiceEntity::getLastPrintUserId, (Object)user.getUserId())).set(SubInvoiceEntity::getLastPrintUserCode, (Object)user.getUserCode())).set(SubInvoiceEntity::getLastPrintUserName, (Object)user.getUserName());
        super.update((Wrapper)update);
    }

    @Override
    public String pushToErp(Long id) {
        this.logger.info("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0id-{}\u81f3ERP   start*********", (Object)id);
        Map<String, String> headers = null;
        SubInvoiceEntity entity = (SubInvoiceEntity)((Object)super.selectById((Serializable)id));
        String pushErpFlag = "0";
        try {
            if (this.checkInvoiceQuoteInfo(entity)) {
                this.logger.info("\u63a8\u9001\u7ec8\u6b62\uff0c\u5206\u5305\u53d1\u7968\u767b\u8bb0id-{}\u53d1\u7968\u5df2\u88ab\u5f15\u7528", (Object)id);
                return "\u63a8\u9001\u7ec8\u6b62\uff0c\u53d1\u7968\u767b\u8bb0\u5355\u4e2d\u5b58\u5728\u5df2\u88ab\u5f15\u7528\u7684\u53d1\u7968\u6216\u67e5\u8be2\u5f15\u7528\u5f02\u5e38";
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5206\u5305\u53d1\u7968\u767b\u8bb0id-{}ERP\u5f53\u524d\u5f15\u7528\u60c5\u51b5\u5f02\u5e38 \u53d1\u7968\u7ec8\u6b62\u63a8\u9001,", (Object)entity.getId());
            this.logger.error("\u67e5\u8be2\u5206\u5305\u53d1\u7968\u767b\u8bb0ERP\u5f53\u524d\u5f15\u7528\u60c5\u51b5\u5f02\u5e38,", (Throwable)e);
            pushErpFlag = "3";
        }
        try {
            if ("0".equals(pushErpFlag)) {
                JSONArray syncData = this.transferToErpParam(entity);
                headers = ZDSInterfaceCommonUtil.getErpHeaders();
                String reqResp = HttpTookit.postByJson((String)(ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/AddSubContractorBillLists"), (String)JSONObject.toJSONString((Object)syncData), headers, (Integer)180000, (Integer)180000);
                this.logger.info("\u5206\u5305\u53d1\u7968\u767b\u8bb0\u63a8\u9001ERP\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{"/cefoc/yql/AddSubContractorBillLists", JSONObject.toJSONString((Object)syncData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
                JSONObject reqJson = JSONObject.parseObject((String)reqResp);
                if ("true".equals(reqJson.getString("status"))) {
                    this.logger.info("\u4e2d\u7535\u56db \u5206\u5305\u53d1\u7968\u767b\u8bb0\u767b\u8bb0id-{}\u63a8\u9001ERP\u6210\u529f!", (Object)id);
                    pushErpFlag = "1";
                } else {
                    this.logger.error("\u4e2d\u7535\u56db \u5206\u5305\u53d1\u7968\u767b\u8bb0\u767b\u8bb0id-{}\u63a8\u9001ERP\u5931\u8d25!", (Object)id);
                    pushErpFlag = "3";
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0id-{}\u5f02\u5e38\uff0c", (Object)id, (Object)e);
            pushErpFlag = "3";
        }
        this.logger.info("********\u66f4\u65b0\u5206\u5305\u53d1\u7968id-{}\u63a8\u9001ERP\u72b6\u6001\uff1a{}********", (Object)id, (Object)pushErpFlag);
        LambdaUpdateWrapper update = new LambdaUpdateWrapper();
        update.eq(BaseEntity::getId, (Object)id);
        update.set(SubInvoiceEntity::getPushErpFlag, (Object)pushErpFlag);
        super.update((Wrapper)update);
        if ("3".equals(pushErpFlag)) {
            this.messageInfoService.sendWarnMsg("\u5206\u5305\u53d1\u7968\u63a8\u9001ERP\uff0cERP\u5904\u7406\u5931\u8d25", (null != entity.getSourceType() && Integer.valueOf(1).equals(entity.getSourceType()) ? "\u3010\u81ea\u5236\u3011" : "\u3010\u4f9b\u65b9\u7533\u8bf7\u3011") + "\u7684\u5206\u5305\u53d1\u7968\u767b\u8bb0\u3010" + entity.getBillCode() + "\u3011\u63a8\u9001ERP\uff0cERP\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\uff01", this.BASE_HOST + (null != entity.getSourceType() && Integer.valueOf(1).equals(entity.getSourceType()) ? CommonConstants.\u5206\u5305\u81ea\u5236\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 : CommonConstants.\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5) + entity.getId().toString());
        }
        this.logger.info("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0id-{}\u81f3ERP   end*********", (Object)id);
        return "3".equals(pushErpFlag) ? "ERP\u5904\u7406\u5931\u8d25\uff01" : "\u63a8\u9001ERP\u6210\u529f\uff01";
    }

    @Override
    @Async(value="maCommonTask")
    public void syncToErp(Long id, Long curUserId) {
        this.logger.info("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0id-{}\u81f3ERP   start*********", (Object)id);
        this.initContext(curUserId);
        this.pushToErp(id);
        this.logger.info("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0id-{}\u81f3ERP   end*********", (Object)id);
    }

    @Override
    public String validateMny(Long id) {
        SubInvoiceEntity entity = (SubInvoiceEntity)((Object)super.selectById((Serializable)id));
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)entity.getContractId()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List list = super.queryList(param);
        list.add(entity);
        BigDecimal invoiceMny = list.stream().map(e -> e.getTotalTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        SubContractEntity contract = (SubContractEntity)((Object)this.subContractService.selectById(entity.getContractId()));
        if (contract == null) {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u8be5\u5408\u540c\uff01");
            return "\u7d2f\u8ba1\u53d1\u7968\u91d1\u989d\u8d85\u8fc7\u4e86\u5408\u540c\u91d1\u989d\uff0c\u5ba1\u6838\u8bf7\u6ce8\u610f\uff01";
        }
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.and(e -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.eq(SubContractEntity::getContractId, (Object)contract.getId())).or()).eq(SubContractEntity::getSubContractParentSid, (Object)contract.getSourceContractId()));
        List contList = this.subContractService.list((Wrapper)ew);
        contList.add(contract);
        BigDecimal contractMny = contList.stream().map(e -> e.getContractMoney()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        if (ComputeUtil.isGreaterThan(invoiceMny, contractMny)) {
            this.logger.info("\u7d2f\u8ba1\u53d1\u7968\u91d1\u989d\u3010{}\u3011\u8d85\u8fc7\u4e86\u5408\u540c\u91d1\u989d\u3010{}\u3011\uff0c\u5ba1\u6838\u8bf7\u6ce8\u610f\uff01", (Object)invoiceMny.toPlainString(), (Object)contractMny.toPlainString());
            return "\u7d2f\u8ba1\u53d1\u7968\u91d1\u989d\u8d85\u8fc7\u4e86\u5408\u540c\u91d1\u989d\uff0c\u5ba1\u6838\u8bf7\u6ce8\u610f\uff01";
        }
        return null;
    }

    private boolean checkInvoiceQuoteInfo(SubInvoiceEntity entity) {
        ArrayList<String> numbers = new ArrayList<String>(entity.getDetailList().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getInvoiceNumber())).map(SubInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet()));
        boolean quoteFlag = false;
        if (CollectionUtils.isNotEmpty(numbers)) {
            List<ErpInvoiceEntity> list = this.erpInvoiceService.getAllByInvoiceNums(numbers);
            this.logger.info("\u5206\u5305: \u6839\u636e\u53d1\u7968\u53f7\uff1a{}, EL\u67e5\u8be2\u5230\u53d1\u7968\u6570\uff1a{}", (Object)JSONObject.toJSONString(numbers), (Object)list.size());
            for (ErpInvoiceEntity e : list) {
                this.logger.info("\u5206\u5305\u53d1\u7968id-{},number-{}, ERP\u5f15\u7528\u6807\u8bc6\uff1a{}", new Object[]{e.getId(), e.getNumber(), e.getErpQuoteFlag()});
                if (!"1".equals(e.getErpQuoteFlag())) continue;
                quoteFlag = true;
            }
            if (quoteFlag) {
                return quoteFlag;
            }
        }
        try {
            JSONArray josnArr = this.erpInvoiceService.syncTodayQuotedInvoice("sub");
            Map<String, List<SubInvoiceDetailEntity>> detailMap = entity.getDetailList().stream().collect(Collectors.groupingBy(SubInvoiceDetailEntity::getInvoiceNumber));
            if (null != josnArr && josnArr.size() > 0) {
                JSONObject json = null;
                for (Object obj : josnArr) {
                    json = (JSONObject)obj;
                    if (!detailMap.containsKey(json.getString("InvoiceHM"))) continue;
                    quoteFlag = true;
                    for (SubInvoiceDetailEntity detail : detailMap.get(json.getString("InvoiceHM"))) {
                        detail.setErpQuoteBillCode(json.getString("Ma_id"));
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u5206\u5305: \u6839\u636e\u53d1\u7968\u53f7\uff1a{}, \u67e5\u8be2ERP\u5f15\u7528\u60c5\u51b5\u5f02\u5e38", numbers);
            this.logger.error("\u5206\u5305\u53d1\u7968\u67e5\u8be2ERP\u5f15\u7528\u60c5\u51b5\u5f02\u5e38", (Throwable)e);
            entity.setPushErpFlag("3");
            super.saveOrUpdate((Object)entity, false);
            return true;
        }
        if (quoteFlag) {
            entity.setPushErpFlag("2");
            super.saveOrUpdate((Object)entity, false);
        }
        return quoteFlag;
    }

    private JSONArray transferToErpParam(SubInvoiceEntity entity) {
        AttachmentVO tmpAttach;
        HashMap<Long, AttachmentVO> attachMap;
        CommonResponse attachResp;
        JSONObject params;
        List sourceIds;
        JSONArray resp = new JSONArray();
        JSONObject data = new JSONObject();
        resp.add((Object)data);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SupplierVO supplier = null;
        CommonResponse supplierResp = this.subSupplierApi.getOneById(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u4f9b\u5e94\u5546id-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString((Object)supplierResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            supplier = this.subContractService.getSubSupInfoById(entity.getSupplierId());
        } else {
            supplier = (SupplierVO)supplierResp.getData();
        }
        if (null == supplier) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u4f9b\u5e94\u5546id-{}\u4fe1\u606f\u5931\u8d25", (Object)entity.getSupplierId());
            throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        CommonResponse empResp = this.employeeApi.getById(Long.valueOf(entity.getAdminId()));
        if (!empResp.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)entity.getAdminId(), (Object)JSONObject.toJSONString((Object)empResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-" + entity.getAdminId() + "\u4fe1\u606f\u5931\u8d25");
        }
        EmployeeVO emp = (EmployeeVO)empResp.getData();
        if (null == emp) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-{}\u4e3a\u7a7a", (Object)entity.getAdminId());
            throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-" + entity.getAdminId() + "\u4fe1\u606f\u4e3a\u7a7a");
        }
        SubContractEntity contract = (SubContractEntity)((Object)this.subContractService.getById(entity.getContractId()));
        CommonResponse prjResp = this.projectPoolApi.getById(contract.getProjectId());
        if (!prjResp.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76eeid-{}\u4fe1\u606f\u5931\u8d25\uff01", (Object)entity.getProjectId());
            throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ProjectPoolSetVO project = (ProjectPoolSetVO)prjResp.getData();
        if (null == project) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76eeid-{}\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)entity.getProjectId());
            throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        entity.getDetailList().stream().forEach(detail -> {
            if (!invoiceIds.contains(detail.getInvoiceId())) {
                invoiceIds.add(detail.getInvoiceId());
            }
        });
        List<ErpInvoiceEntity> invoiceList = this.erpInvoiceService.getAllByIds(invoiceIds);
        List<ErpInvoiceDetailEntity> invoiceDetailList = this.invoiceDetailService.getAllByInvoiceIds(invoiceIds);
        if (CollectionUtils.isEmpty(invoiceList)) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968ids-{}\u4fe1\u606f\u4e3a\u7a7a", (Object)JSONObject.toJSONString(invoiceIds));
            throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a");
        }
        HashMap<Long, ErpInvoiceDetailEntity> invoiceDetailMap = new HashMap<Long, ErpInvoiceDetailEntity>();
        HashMap<Long, ErpInvoiceEntity> invoiceMap = new HashMap<Long, ErpInvoiceEntity>();
        if (CollectionUtils.isNotEmpty(invoiceDetailList)) {
            invoiceDetailMap.putAll(invoiceDetailList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        if (CollectionUtils.isNotEmpty(invoiceList)) {
            invoiceMap.putAll(invoiceList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        EmployeeVO finalEmp = null;
        if (null != entity.getFinalApproveUserId()) {
            CommonResponse finalEmpResp = this.employeeApi.getById(entity.getFinalApproveUserId());
            if (!finalEmpResp.isSuccess()) {
                this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6700\u7ec8\u6838\u51c6\u4ebaid-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)entity.getFinalApproveUserId(), (Object)JSONObject.toJSONString((Object)finalEmpResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6700\u7ec8\u6838\u51c6\u4ebaid-" + entity.getFinalApproveUserId() + "\u4fe1\u606f\u5931\u8d25");
            }
            finalEmp = (EmployeeVO)finalEmpResp.getData();
            if (null == finalEmp) {
                this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6700\u7ec8\u6838\u51c6\u4ebaid-{}\u4e3a\u7a7a", (Object)entity.getFinalApproveUserId());
                throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6700\u7ec8\u6838\u51c6\u4ebaid-" + entity.getFinalApproveUserId() + "\u4fe1\u606f\u4e3a\u7a7a");
            }
        }
        data.put("SubContractInfo_Id", (Object)entity.getContractCode());
        data.put("Company_Sid", (Object)supplier.getThirdSourceId());
        data.put("SbcContractMoney", (Object)ComputeUtil.safeAdd(entity.getMainContMny(), entity.getChildContMny()).toPlainString());
        data.put("SettlementMoney", (Object)ComputeUtil.safeAdd(contract.getSettleSumMoney(), BigDecimal.ZERO).toPlainString());
        data.put("BillTitle", (Object)entity.getInvoiceHeader());
        data.put("IsDK", (Object)entity.getTaxCreateState().toString());
        data.put("IsDKValue", (Object)(Integer.valueOf("1").equals(entity.getTaxCreateState()) ? "\u662f" : "\u5426"));
        data.put("BillType", PlanConstant.INVOICE_TYPE.get(entity.getInvoiceCty()));
        data.put("TaxType", (Object)entity.getTaxCtyName());
        data.put("TaxRate", (Object)ComputeUtil.safeAdd(entity.getInvoiceRate(), BigDecimal.ZERO).toPlainString());
        data.put("NoTaxAmount", (Object)ComputeUtil.safeAdd(entity.getTotalMny(), BigDecimal.ZERO).toPlainString());
        data.put("TaxAmount", (Object)ComputeUtil.safeAdd(entity.getTotalTax(), BigDecimal.ZERO).toPlainString());
        data.put("BillMoney", (Object)ComputeUtil.safeAdd(entity.getTotalTaxMny(), BigDecimal.ZERO).toPlainString());
        data.put("Memo", (Object)entity.getMemo());
        data.put("Ma_id", (Object)entity.getBillCode());
        data.put("Register_Name", (Object)entity.getOperateName());
        data.put("SYS_Created", (Object)sdf.format(entity.getCreateTime()));
        data.put("ApprHuman", (Object)emp.getName());
        data.put("ApprHuman_sid", (Object)emp.getSourceId());
        data.put("CON_EMP_NUM", (Object)emp.getCode());
        data.put("ApprDate", (Object)sdf.format(null != entity.getUpdateTime() ? entity.getUpdateTime() : new Date()));
        data.put("Position_Name", (Object)emp.getPostName());
        data.put("Division_Name", (Object)emp.getDeptName());
        data.put("Org_Name", (Object)emp.getOrgName());
        data.put("YQL_SID", (Object)entity.getId());
        data.put("SubContractInfo_Sid", (Object)contract.getSourceContractId());
        data.put("Project_Id", (Object)project.getCode());
        data.put("Project_Name", (Object)project.getName());
        data.put("Account_Project_Sid", (Object)project.getSourceId());
        data.put("Company_Name", (Object)contract.getSupplierName());
        if (null != finalEmp) {
            data.put("Reviewer", (Object)finalEmp.getName());
            data.put("ReviewerSid", (Object)finalEmp.getSourceId());
        }
        data.put("ReviewTime", (Object)sdf.format(null != entity.getEffectiveDate() ? entity.getEffectiveDate() : new Date()));
        JSONArray detailList = new JSONArray();
        data.put("MEBill_SubBList", (Object)detailList);
        JSONObject detailJson = null;
        ErpInvoiceDetailEntity tmpDetail = null;
        ErpInvoiceEntity invoice = null;
        for (SubInvoiceDetailEntity detail2 : entity.getDetailList()) {
            detailJson = new JSONObject();
            tmpDetail = (ErpInvoiceDetailEntity)((Object)invoiceDetailMap.get(detail2.getInvoiceDetailId()));
            if (null == tmpDetail) {
                throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0[id-" + detail2.getMainId() + "]\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u53d1\u7968\u8be6\u60c5id-" + detail2.getInvoiceDetailId() + "\u4fe1\u606f");
            }
            invoice = (ErpInvoiceEntity)((Object)invoiceMap.get(detail2.getInvoiceId()));
            if (null == invoice) {
                throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0[id-" + detail2.getMainId() + "]\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u53d1\u7968id-" + detail2.getInvoiceId() + "\u4fe1\u606f");
            }
            detailJson.put("InvoiceDM", (Object)invoice.getCode());
            detailJson.put("InvoiceHM", (Object)invoice.getNumber());
            detailJson.put("KPDate", (Object)(null != invoice.getInvoiceDate() ? sdf.format(invoice.getInvoiceDate()) : ""));
            detailJson.put("InvoiceTT", (Object)invoice.getInvoiceTitle());
            detailJson.put("GoodsName", (Object)tmpDetail.getDetailName());
            detailJson.put("InvoiceType", (Object)invoice.getTypeCode());
            detailJson.put("InvoiceTypeValue", (Object)invoice.getTypeName());
            detailJson.put("ModelNorm", (Object)tmpDetail.getDetailSpec());
            detailJson.put("MeteringUnit", (Object)tmpDetail.getDetailUnitName());
            detailJson.put("Quantity", (Object)ComputeUtil.safeAdd(tmpDetail.getDetailNum(), BigDecimal.ZERO).toPlainString());
            detailJson.put("Price", (Object)ComputeUtil.safeDiv(tmpDetail.getDetailMny(), tmpDetail.getDetailNum()).toPlainString());
            detailJson.put("TaxRate", (Object)ComputeUtil.safeAdd(tmpDetail.getDetailRate(), BigDecimal.ZERO).toPlainString());
            detailJson.put("Money", (Object)ComputeUtil.safeAdd(tmpDetail.getDetailMny(), BigDecimal.ZERO).toPlainString());
            detailJson.put("TaxMoney", (Object)ComputeUtil.safeAdd(tmpDetail.getDetailTax(), BigDecimal.ZERO).toPlainString());
            detailJson.put("MoneyTax", (Object)ComputeUtil.safeAdd(tmpDetail.getInvoiceMny(), BigDecimal.ZERO).toPlainString());
            detailJson.put("PS_InvoiceInfo_FK", (Object)tmpDetail.getInvoiceSid());
            detailJson.put("YQL_SID", (Object)detail2.getId());
            detailList.add((Object)detailJson);
        }
        JSONArray attaches = new JSONArray();
        data.put("ArchivesInforList", (Object)attaches);
        JSONObject tmpFileJson = null;
        if (CollectionUtils.isNotEmpty(entity.getFileList())) {
            sourceIds = entity.getFileList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            params = new JSONObject();
            params.put("sourceIds", sourceIds);
            attachResp = this.attachmentApi.queryAllBySourceIdList(params);
            if (!attachResp.isSuccess()) {
                this.logger.error("\u6839\u636esourceId\u5217\u8868-{}\u67e5\u8be2\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(sourceIds), (Object)JSONObject.toJSONString((Object)attachResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else {
                attachMap = new HashMap<Long, AttachmentVO>();
                if (CollectionUtils.isNotEmpty((Collection)((Collection)attachResp.getData()))) {
                    attachMap.putAll(((List)attachResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
                }
                tmpAttach = null;
                for (SubInvoiceFileEntity subInvoiceFileEntity : entity.getFileList()) {
                    tmpAttach = (AttachmentVO)attachMap.get(subInvoiceFileEntity.getId());
                    if (null == tmpAttach) {
                        this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5e94\u53d1\u7968\u9644\u4ef6\u8be6\u60c5sourceId-{}\u4fe1\u606f", (Object)subInvoiceFileEntity.getId());
                        continue;
                    }
                    tmpFileJson = new JSONObject();
                    tmpFileJson.put("Attach_Name", (Object)(StringUtils.isNotBlank((CharSequence)subInvoiceFileEntity.getFileName()) ? subInvoiceFileEntity.getFileName() + (subInvoiceFileEntity.getFileName().indexOf(".") < 0 ? tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")) : "") : tmpAttach.getFileName()));
                    tmpFileJson.put("Attach_Extension", (Object)tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")));
                    tmpFileJson.put("Attach_Type", (Object)tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".") + 1));
                    tmpFileJson.put("AttachBase64", (Object)(this.BASE_HOST + "filepreview/" + tmpAttach.getFilePath()));
                    tmpFileJson.put("YQL_SID", (Object)subInvoiceFileEntity.getId());
                    tmpFileJson.put("Is_Add_Del", (Object)1);
                    try {
                        if (StringUtils.isNotBlank((CharSequence)tmpFileJson.getString("Attach_Name")) && StringUtils.isNotBlank((CharSequence)tmpFileJson.getString("Attach_Extension")) && !tmpFileJson.getString("Attach_Name").toLowerCase().endsWith(tmpFileJson.getString("Attach_Extension").toLowerCase())) {
                            tmpFileJson.put("Attach_Name", (Object)(tmpFileJson.getString("Attach_Name") + tmpFileJson.getString("Attach_Extension")));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("\u5206\u5305\u53d1\u7968\u9644\u4ef6id-{}\u5904\u7406\u540e\u7f00\u540d\u79f0\u5f02\u5e38:", (Object)subInvoiceFileEntity.getId(), (Object)e);
                    }
                    attaches.add((Object)tmpFileJson);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getOcrList())) {
            sourceIds = entity.getOcrList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            params = new JSONObject();
            params.put("sourceIds", sourceIds);
            attachResp = this.attachmentApi.queryAllBySourceIdList(params);
            if (!attachResp.isSuccess()) {
                this.logger.error("\u6839\u636esourceId\u5217\u8868-{}\u67e5\u8be2\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(sourceIds), (Object)JSONObject.toJSONString((Object)attachResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else {
                attachMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)((Collection)attachResp.getData()))) {
                    attachMap.putAll(((List)attachResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
                }
                tmpAttach = null;
                for (SubInvoiceOcrEntity subInvoiceOcrEntity : entity.getOcrList()) {
                    tmpAttach = (AttachmentVO)attachMap.get(subInvoiceOcrEntity.getId());
                    if (null == tmpAttach) {
                        this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5e94\u53d1\u7968\u9644\u4ef6\u8be6\u60c5sourceId-{}\u4fe1\u606f", (Object)subInvoiceOcrEntity.getId());
                        continue;
                    }
                    tmpFileJson = new JSONObject();
                    tmpFileJson.put("Attach_Name", (Object)(StringUtils.isNotBlank((CharSequence)subInvoiceOcrEntity.getFileName()) ? subInvoiceOcrEntity.getFileName() + (subInvoiceOcrEntity.getFileName().indexOf(".") < 0 ? tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")) : "") : tmpAttach.getFileName()));
                    tmpFileJson.put("Attach_Extension", (Object)tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")));
                    tmpFileJson.put("Attach_Type", (Object)tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".") + 1));
                    tmpFileJson.put("AttachBase64", (Object)(this.BASE_HOST + "filepreview/" + tmpAttach.getFilePath()));
                    tmpFileJson.put("YQL_SID", (Object)subInvoiceOcrEntity.getId());
                    tmpFileJson.put("Is_Add_Del", (Object)1);
                    try {
                        if (StringUtils.isNotBlank((CharSequence)tmpFileJson.getString("Attach_Name")) && StringUtils.isNotBlank((CharSequence)tmpFileJson.getString("Attach_Extension")) && !tmpFileJson.getString("Attach_Name").toLowerCase().endsWith(tmpFileJson.getString("Attach_Extension").toLowerCase())) {
                            tmpFileJson.put("Attach_Name", (Object)(tmpFileJson.getString("Attach_Name") + tmpFileJson.getString("Attach_Extension")));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("\u5206\u5305\u53d1\u7968\u9644\u4ef6id-{}\u5904\u7406\u540e\u7f00\u540d\u79f0\u5f02\u5e38:", (Object)subInvoiceOcrEntity.getId(), (Object)e);
                    }
                    attaches.add((Object)tmpFileJson);
                }
            }
        }
        return resp;
    }

    private void initContext(Long userId) {
        this.logger.info("*****************\u521d\u59cb\u5316\u7528\u6237id-{}\u4e0a\u4e0b\u6587 START*****************");
        String initContextUrl = this.BASE_HOST + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        if (null != userId) {
            initContextUrl = initContextUrl + "&userId=" + userId.toString();
        }
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
        CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        try {
            if (userContextResponse.isSuccess()) {
                JSONObject userContext = ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if (null != userContext) {
                    authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
                }
                if (authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
                    InvocationInfoProxy.setParameter((String)"authority", (String)authtoken.toString());
                }
                if (null != userContext) {
                    InvocationInfoProxy.setTenantid((Long)userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid((Long)userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode((String)userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId((Long)userContext.getLong("orgId"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38\uff1a", (Throwable)e);
        }
        this.logger.info("*****************\u521d\u59cb\u5316\u7528\u6237id-{}\u4e0a\u4e0b\u6587 END*****************");
    }
}

