package com.ejianc.business.zdsmaterial.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceGuideEntity;
import com.ejianc.business.zdsmaterial.pricelib.mapper.PriceGuideMapper;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceGuideService;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceGuideDetailVO;
//import com.ejianc.foundation.share.api.IShareMaterialApi;
//import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物资指导价主表
 * 
 * @author generator
 * 
 */
@Service("priceGuideService")
public class PriceGuideServiceImpl extends BaseServiceImpl<PriceGuideMapper, PriceGuideEntity> implements IPriceGuideService{

//    @Autowired
//    private IShareMaterialApi materialApi;

    @Autowired
    private IMaterialService materialService;

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PriceGuideDetailVO> successList = new ArrayList<>();
        List<PriceGuideDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                Map<String, MaterialVO> map = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(0));//取材料编码  用来校验
                }
                List<MaterialVO> list =  materialService.getByCodes(materialCodeList);
                map = list.stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PriceGuideDetailVO detailVO = new PriceGuideDetailVO();
                    detailVO.setId(IdWorker.getId());
                    String materialCode = datas.get(0);
                    if(map.containsKey(materialCode)){
                        MaterialVO materialVO =   map.get(materialCode);
                        detailVO.setMaterialTypeId(materialVO.getCategoryId());
                        detailVO.setMaterialTypeName(materialVO.getCategoryName());
                        detailVO.setMaterialId(materialVO.getId());
                        detailVO.setMaterialName(materialVO.getName());
                        detailVO.setSpec(materialVO.getPropertyShowName());
                        detailVO.setUnitId(materialVO.getUnitId());
                        detailVO.setUnitName(materialVO.getUnitName());
                    }else{
                        detailVO.setErrorMsg("材料编码不匹配！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String minMny = datas.get(1);
                        detailVO.setMinMny(StringUtils.isNotBlank(minMny) ? new BigDecimal(minMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("最低价格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String maxMny = datas.get(2);
                        detailVO.setMaxMny(StringUtils.isNotBlank(maxMny) ? new BigDecimal(maxMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("最高价格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
