package com.ejianc.business.zdsmaterial.util;

import com.ejianc.framework.core.util.EnvironmentTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;


@Configuration
@EnableAsync
public class MaTaskPoolConfig {

	@Autowired
	private EnvironmentTools environmentTools;

	@Bean(name = "maContextCommonTask")
	public Executor maContextCommonTask() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		//核心线程池大小
		executor.setCorePoolSize(2);
		//最大线程数
		executor.setMaxPoolSize(8);
		//队列容量
		executor.setQueueCapacity(16);
		//活跃时间
		executor.setKeepAliveSeconds(60);
		executor.setTaskDecorator(new ThreadContextDecorator(environmentTools.getBaseHost()));
		//线程名字前缀
		executor.setThreadNamePrefix("commonTaskExecutor-");
		executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
		return executor;
	}

	@Bean(name = "maCommonTask")
	public Executor commonTaskExecutor() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		//核心线程池大小
		executor.setCorePoolSize(2);
		//最大线程数
		executor.setMaxPoolSize(8);
		//队列容量
		executor.setQueueCapacity(16);
		//活跃时间
		executor.setKeepAliveSeconds(60);
		executor.setTaskDecorator(new ThreadContextDecorator(environmentTools.getBaseHost(), false));
		//线程名字前缀
		executor.setThreadNamePrefix("commonTaskExecutor-");
		executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
		return executor;
	}

	@Bean(name = "maNoContextTask")
	public Executor maNoContextTask() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		//核心线程池大小
		executor.setCorePoolSize(2);
		//最大线程数
		executor.setMaxPoolSize(8);
		//队列容量
		executor.setQueueCapacity(16);
		//活跃时间
		executor.setKeepAliveSeconds(60);
		//线程名字前缀
		executor.setThreadNamePrefix("maNoContextTask-");
		executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
		return executor;
	}

	@Bean(name = "materialConjectureTaskPool")
	public Executor materialConjectureTaskPool() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		// 使用CPU核心数作为核心线程数
		executor.setCorePoolSize(Runtime.getRuntime().availableProcessors() > 2 ? Runtime.getRuntime().availableProcessors() - 1 : 1);
		// 最大线程数设置为核心数的1.5倍
		executor.setMaxPoolSize(Double.valueOf(Math.ceil(Runtime.getRuntime().availableProcessors() * 1.5)).intValue());
		//活跃时间
		executor.setKeepAliveSeconds(60);
		// 设置队列容量
		executor.setQueueCapacity(1000);
		// 设置线程名前缀
		executor.setThreadNamePrefix("materialConjecturePool-");
		executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
		return executor;
	}
}
