package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料分类属性可选值
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("materialCategoryPropertySubItem")
public class MaterialCategoryPropertySubItemController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMaterialCategoryPropertySubItemService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialCategoryPropertySubItemVO> saveOrUpdate(@RequestBody MaterialCategoryPropertySubItemVO saveOrUpdateVO) {
    	MaterialCategoryPropertySubItemEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialCategoryPropertySubItemEntity.class);

        QueryWrapper<MaterialCategoryPropertySubItemEntity> query = new QueryWrapper<>();
        query.eq("property_id", saveOrUpdateVO.getPropertyId());
        query.eq("category_id", saveOrUpdateVO.getCategoryId());
        query.eq("name", saveOrUpdateVO.getName());

        List<MaterialCategoryPropertySubItemEntity> nameList = service.list(query);
        if(CollectionUtils.isNotEmpty(nameList)) {
            if(null != saveOrUpdateVO.getValidFlag() && null != nameList.get(0).getValidFlag()
                    && saveOrUpdateVO.getValidFlag().equals(nameList.get(0).getValidFlag())) {
                entity = nameList.get(0);
                //新增临时属性值，且已存在相同的未生效属性值,则将当前人维护到属性值可用人员列表中
                if(saveOrUpdateVO.getValidFlag().equals(ZDSMaterialCommonEnums.分类设置属性值是否生效_否.getCode())) {
                    if(entity.getRelatedUserIds().indexOf(InvocationInfoProxy.getUserid().toString()) < 0) {
                        entity.setRelatedUserIds(entity.getRelatedUserIds()+","+InvocationInfoProxy.getUserid());
                    }
                }
            } else if(saveOrUpdateVO.getValidFlag().equals(ZDSMaterialCommonEnums.分类设置属性值是否生效_是.getCode())) {
                //新增生效属性值，且已存在相同的未生效属性值，则将属性值置为生效状态
                entity = nameList.get(0);
                entity.setValidFlag(ZDSMaterialCommonEnums.分类设置属性值是否生效_是.getCode());
            } else {
                return CommonResponse.error("属性值重复，请修改");
            }
        }


        //查询当前属性下序号最大值
        QueryWrapper<MaterialCategoryPropertySubItemEntity> seqQuery = new QueryWrapper<>();
        seqQuery.eq("property_id", saveOrUpdateVO.getPropertyId());
        seqQuery.eq("category_id", saveOrUpdateVO.getCategoryId());
        seqQuery.eq("dr", BaseVO.DR_UNDELETE);
        List<MaterialCategoryPropertySubItemEntity> checkList = service.list(seqQuery);
        Integer maxSeq = 0;
        if(CollectionUtils.isNotEmpty(checkList)) {
            MaterialCategoryPropertySubItemEntity maxItem = checkList.stream().filter(item -> null != item.getSequence()).max((v1,v2) -> v1.getSequence() - v2.getSequence()).get();
            maxSeq = null == maxItem.getSequence() ? 0 : maxItem.getSequence();
        }

        entity.setSequence(maxSeq+1);


    	service.saveOrUpdate(entity, false);
    	MaterialCategoryPropertySubItemVO vo = BeanMapper.map(entity, MaterialCategoryPropertySubItemVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialCategoryPropertySubItemVO> queryDetail(Long id) {
    	MaterialCategoryPropertySubItemEntity entity = service.selectById(id);
    	MaterialCategoryPropertySubItemVO vo = BeanMapper.map(entity, MaterialCategoryPropertySubItemVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialCategoryPropertySubItemVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MaterialCategoryPropertySubItemVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialCategoryPropertySubItemVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 根据属性值模糊匹配
     *
     * @param searchVO
     * @return
     */
    @PostMapping(value = "searchList")
     CommonResponse<List<MaterialCategoryPropertySubItemVO>> searchList(@RequestBody MaterialCategoryPropertySubItemVO searchVO) {
        return CommonResponse.success(service.searchList(searchVO));
     }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialCategoryPropertySubItemVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<MaterialCategoryPropertySubItemEntity> page = service.queryPage(param,false);
        IPage<MaterialCategoryPropertySubItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialCategoryPropertySubItemVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialCategoryPropertySubItemEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialCategoryPropertySubItem-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refMaterialCategoryPropertySubItemData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialCategoryPropertySubItemVO>> refMaterialCategoryPropertySubItemData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        @RequestParam(required = false) String relyCondition,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("validFlag", new Parameter(QueryParam.EQ, 1));
        if(StringUtils.isBlank(relyCondition) && StringUtils.isBlank(condition)) {
            return CommonResponse.error("缺少物料属性id参数");
        }
        Long propertyId = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("propertyId")) {
                propertyId = Long.valueOf(_con.get("propertyId").toString());
            }
        }

        if (null == propertyId && StringUtils.isNotEmpty(relyCondition) && relyCondition.contains("propertyId")) {
            propertyId = Long.valueOf(relyCondition.split("=")[1]);
        }
        if(null == propertyId) {
            return CommonResponse.error("查询失败，缺少分类属性id");
        }

        param.getParams().put("propertyId", Parameter.getEqInstance(propertyId));

        IPage<MaterialCategoryPropertySubItemEntity> page = service.queryPage(param,false);
        IPage<MaterialCategoryPropertySubItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialCategoryPropertySubItemVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @RequestMapping(value = "/download")
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "zdsmaterial-category-propertysub-import.xlsx", "材料分类导入模板");
    }

    @PostMapping(value = "/excelImport")
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String proertyId = request.getParameter("proertyId");

        List<MaterialCategoryPropertySubItemVO> processList = new ArrayList<>();
        List<MaterialCategoryPropertySubItemVO> errorList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("分类数据超过10000条，请分批上传！");
            }
            Map<String, MaterialCategoryPropertySubItemVO> valueMapCache = new HashMap<>();
            MaterialCategoryPropertySubItemVO importVo = null;
            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                importVo = new MaterialCategoryPropertySubItemVO();
                importVo.setId(IdWorker.getId());
                importVo.setSequence(StringUtils.isBlank(datas.get(0)) ? 1 : Integer.valueOf(datas.get(0)));
                importVo.setName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1).trim() : null);
                importVo.setProductCode(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2).trim() : null);

                if(StringUtils.isBlank(importVo.getName())) {
                    importVo.setDescription("属性值为空！");
                    errorList.add(importVo);
                    continue;
                }
                if(valueMapCache.containsKey(importVo.getName())) {
                    importVo.setDescription("属性值重复！");
                    errorList.add(importVo);
                    continue;
                }

                importVo.setId(IdWorker.getId());
                importVo.setEnabled(1);
                importVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                importVo.setCreateTime(new Date());
                importVo.setTenantId(InvocationInfoProxy.getTenantid());
                processList.add(importVo);
                valueMapCache.put(importVo.getName(), importVo);
            }

            if(ListUtil.isNotEmpty(processList)){
                if(null != proertyId) {
                    //检查编码是否重复
                    List<MaterialCategoryPropertySubItemEntity> codeList = service.queryByNames(new ArrayList<>(valueMapCache.keySet()), Long.valueOf(proertyId));

                    if(CollectionUtils.isNotEmpty(codeList)) {
                        for(MaterialCategoryPropertySubItemEntity repeatCode : codeList) {
                            importVo = valueMapCache.get(repeatCode.getName());
                            valueMapCache.remove(repeatCode.getName());
                            processList.remove(importVo);
                            importVo.setDescription("属性值重复！");
                            errorList.add(importVo);
                            continue;
                        }
                    }
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", processList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @PostMapping(value = "/saveImportExcelCategory")
    public CommonResponse<String> saveImportExcelCategory(@RequestBody List<MaterialCategoryPropertySubItemVO> saveImportVos) {
//        if(ListUtil.isEmpty(saveImportVos)){
//            return CommonResponse.error("导入的数据为空！");
//        }
//        List<MaterialCategoryPropertySubItemEntity> saveList = BeanMapper.mapList(saveImportVos, MaterialCategoryPropertySubItemEntity.class);
//        service.saveOrUpdateBatch(saveList, saveList.size(), false);
        return CommonResponse.success("保存成功！");
    }
}
