package com.ejianc.business.zdsmaterial.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialPropertyRelationEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialPropertyRelationMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialPropertyRelationService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialRelationAiVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料属性关系
 * 
 * @author generator
 * 
 */
@Service("materialPropertyRelationService")
public class MaterialPropertyRelationServiceImpl extends BaseServiceImpl<MaterialPropertyRelationMapper, MaterialPropertyRelationEntity> implements IMaterialPropertyRelationService{

    @Autowired
    private MaterialPropertyRelationMapper mapper;

    @Override
    public void deleteByMaterialIds(List<Long> materialIds) {
        mapper.deleteByMaterialIds(materialIds);
    }

    @Override
    public List<MaterialPropertyRelationVO> getAllByMaterialIds(List<Long> ids) {
        List<MaterialPropertyRelationVO> resp = new ArrayList<>();
        QueryWrapper<MaterialPropertyRelationEntity> query = new QueryWrapper<>();
        query.in("material_id", ids);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<MaterialPropertyRelationEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, MaterialPropertyRelationVO.class);
        }

        return resp;
    }

    @Override
    public List<Long> matchedMaterialIdsByPropertyVal(Map<String, Object> propertyFilterParam) {
        return mapper.matchedMaterialIdsByPropertyVal(propertyFilterParam);
    }

    @Override
    public List<MaterialPropertyRelationVO> getAllByPropertyIds(List<Long> propertyIds) {
        List<MaterialPropertyRelationVO> resp = new ArrayList<>();
        QueryWrapper<MaterialPropertyRelationEntity> query = new QueryWrapper<>();
        query.in("property_id", propertyIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<MaterialPropertyRelationEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, MaterialPropertyRelationVO.class);
        }
        return resp;
    }

    @Override
    public List<MaterialPropertyRelationVO> getAllByPropertyValueIds(List<Long> propertyValueIds) {
        List<MaterialPropertyRelationVO> resp = new ArrayList<>();
        QueryWrapper<MaterialPropertyRelationEntity> query = new QueryWrapper<>();
        query.in("property_item_id", propertyValueIds);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<MaterialPropertyRelationEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, MaterialPropertyRelationVO.class);
        }
        return resp;
    }

    @Override
    public String checkMaterialPropertyValue(Long materialId) {
        String msg = null;
        List<String> propertyNames = mapper.checkMaterialPropertyValue(materialId);
        if(CollectionUtils.isNotEmpty(propertyNames)) {
            msg = "材料属性：" + propertyNames.stream().collect(Collectors.joining(",")) + "与分类下属性值不匹配";
        }
        return msg;
    }

    @Override
    public List<MaterialPropertyRelationVO> getAllByCategoryId(Long categoryId) {
        List<MaterialPropertyRelationVO> resp = new ArrayList<>();
        QueryWrapper<MaterialPropertyRelationEntity> query = new QueryWrapper<>();
        query.eq("category_id", categoryId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<MaterialPropertyRelationEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, MaterialPropertyRelationVO.class);
        }
        return resp;
    }

    @Override
    public List<Long> validMaterialHasNewPropertyItem(List<Long> materialIds) {
        return this.validMaterialHasNewPropertyItem(materialIds, null);
    }
    @Override
    public List<Long> validMaterialHasNewPropertyItem(List<Long> materialIds, List<Long> categoryIds) {
        return mapper.validMaterialHasNewPropertyItem(materialIds,categoryIds);
    }

    @Override
    public List<MaterialRelationAiVO> getAiRelationsByMaterialIds(List<Long> materialIds) {
        return mapper.getAiRelationsByMaterialIds(materialIds);
    }
}
