package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.SubTypeEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.SubTypeMapper;
import com.ejianc.business.zdsmaterial.erp.service.ISubTypeService;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 分包类型实体
 * 
 * @author generator
 * 
 */
@Service("subTypeService")
public class SubTypeServiceImpl extends BaseServiceImpl<SubTypeMapper, SubTypeEntity> implements ISubTypeService {

    @Autowired
    private SubTypeMapper mapper;

    @Override
    public List<SubTypeEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper<SubTypeEntity> query = new QueryWrapper<>();
        query.in("source_id", sourceIds);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }

    @Override
    public JSONObject querySubTypeTree(QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        Map<String,Object> condition = new HashMap<>();
        for(Map.Entry<String, Parameter> entry:param.getParams().entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());

        List<SubTypeVO> dataList = mapper.querySubTypeTree(condition);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("leafFlag").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });

        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return jsonObject;
    }

    @Override
    public List<SubTypeVO> getAllByIds(List<Long> ids) {
        List<SubTypeVO> resp = new ArrayList<>();

        QueryWrapper<SubTypeEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        List<SubTypeEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = BeanMapper.mapList(dbList, SubTypeVO.class);
        }
        return resp;
    }
}
