package com.ejianc.business.zdsmaterial.material.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MaterialBasePriceContentEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialBasePriceEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceContentService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceContentVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.constants.ConjectureConstants;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.ConjectureEditVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.ResultAsTree;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IUnitApi;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 基准价格导入
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialBasePrice")
public class MaterialBasePriceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialConjectureService materialConjectureService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IUnitApi unitApi;

    private static final String BILL_CODE = "BASE-PRICE-IMPORT";//此处需要根据实际修改

    @Autowired
    private IMaterialBasePriceService service;
    @Autowired
    private IMaterialBasePriceContentService materialBasePriceContentService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialBasePriceVO> saveOrUpdate(@RequestBody MaterialBasePriceVO saveOrUpdateVO) {
        if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getMaterialBasePriceContentList())) {
            List<String> repeatMaterialCodeList =
                    saveOrUpdateVO.getMaterialBasePriceContentList().stream()
                            .collect(Collectors.groupingBy(MaterialBasePriceContentVO::getMaterialCode, Collectors.counting()))
                            .entrySet().stream().filter(entry -> entry.getValue() > 1)
                            .map(Map.Entry::getKey).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(repeatMaterialCodeList)) {
                return CommonResponse.error("保存失败，存在重复的物料,编码为["+repeatMaterialCodeList.stream().collect(Collectors.joining())+"]，请修改或删除！");
            }
        }
        return service.saves(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialBasePriceVO> queryDetail(Long id) {
    	MaterialBasePriceEntity entity = service.selectById(id);
    	MaterialBasePriceVO vo = BeanMapper.map(entity, MaterialBasePriceVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialBasePriceVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MaterialBasePriceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialBasePriceVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialBasePriceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","topicName","brandName","supplierName","materialClass","employeeName","areaName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<MaterialBasePriceEntity> page = service.queryPage(param,false);
        IPage<MaterialBasePriceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialBasePriceVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","topicName","brandName","supplierName","materialClass","employeeName","areaName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialBasePriceEntity> list = service.queryList(param);
        List<MaterialBasePriceVO> materialBasePriceVOS = BeanMapper.mapList(list, MaterialBasePriceVO.class);
        materialBasePriceVOS.forEach(vo->{
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            Integer status = vo.getStatus();
            vo.setStatusName(status == 1 ? "启用" : "禁用");
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", materialBasePriceVOS);
        ExcelExport.getInstance().export("MaterialBasePrice-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialBasePriceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialBasePriceVO>> refMaterialBasePriceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialBasePriceEntity> page = service.queryPage(param,false);
        IPage<MaterialBasePriceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialBasePriceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/changeStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeStatus(@RequestBody MaterialBasePriceVO saveOrUpdateVO) {
        return service.changeStatus(saveOrUpdateVO);
    }


    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "BasePriceImport-material-import.xlsx", "基准价格库导入模板");
    }


    @PostMapping(value = "/excelImport")
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId"); //导入序列
        String mode = request.getParameter("mode"); //识别渠道
        if(StringUtils.isBlank(mode)) { //默认长江云通
            mode = ConjectureConstants.CONJECTURE_TYPE_CJTY;
        }
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<MaterialConjectureVO> successList = new ArrayList<>();
        List<MaterialConjectureVO> processList = new ArrayList<>();
        List<MaterialConjectureVO> errorList = new ArrayList<>();
        Set<String> unitNames = new HashSet<>();

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("数据超过10000条，请分批上传！");
            }
            MaterialConjectureVO vo = null;

            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4"); //默认待识别
                vo.setConjectureMateType("4"); //默认待识别
                vo.setDelFlag("0");//未作废
                vo.setIgnoreFlag("0");//未忽略
                vo.setLoadState("0");//未加载
                vo.setIdentificationDate(new Date());
                vo.setId(IdWorker.getId());
                vo.setImportSeq(datas.get(0)); //序号
                vo.setSourceMaterialName(datas.get(1)); //物料名称
                vo.setSourceUnitName(datas.get(3)); //单位
                vo.setSourceMaterialSpec(datas.get(2)); //描述
                try {
                    vo.setSourceBasePrice(ComputeUtil.toBigDecimal(datas.get(4))); //基准价格
                } catch (Exception e) {
                    vo.setErrorMsg("【基准价格】需为数值类型！");
                    errorList.add(vo);
                    continue;
                }
                vo.setActualBasePrice(ComputeUtil.toBigDecimal(datas.get(4))); //基准价格

                try {
                    vo.setSourceBaseOriginPrice(ComputeUtil.toBigDecimal(datas.get(5))); //基准原材料同价
                } catch (Exception e) {
                    vo.setErrorMsg("【基准原材料同价】需为数值类型！");
                    errorList.add(vo);
                    continue;
                }
                vo.setActualBaseOriginPrice(ComputeUtil.toBigDecimal(datas.get(5))); //基准原材料同价
                if(StringUtils.isBlank(datas.get(1))){
                    vo.setErrorMsg("【物料名称】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(2))){
                    vo.setErrorMsg("【描述】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(3))){
                    vo.setErrorMsg("【单位】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(4))){
                    vo.setErrorMsg("【基准价格(单价)】不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(5))){
                    vo.setErrorMsg("【基准原材料同价】不能为空！");
                    errorList.add(vo);
                    continue;
                }

                if(StringUtils.isNotBlank(datas.get(6))) {
                    try {
                        vo.setSourceBaseTwoPrice(ComputeUtil.toBigDecimal(datas.get(6))); //第二基准价格
                    } catch (Exception e) {
                        vo.setErrorMsg("【第二基准价格】需为数值类型！");
                        errorList.add(vo);
                        continue;
                    }

                    vo.setActualBaseTwoPrice(ComputeUtil.toBigDecimal(datas.get(6))); //第二基准价格
                }
                if(StringUtils.isNotBlank(datas.get(7))){
                    vo.setContractName(datas.get(7)); //
                }
                if(StringUtils.isNotBlank(datas.get(8))){
                    vo.setContractCode(datas.get(8)); //
                }
                if(StringUtils.isNotBlank(datas.get(9))){
                    vo.setProjectName(datas.get(9)); //
                }
                if(StringUtils.isNotBlank(datas.get(10))){
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        String time = datas.get(10);
                        Date date = sdf.parse(time);
                        vo.setSignDate(date);
                    } catch (Exception e) {
                        vo.setErrorMsg("【签订日期】需为日期类型！");
                        errorList.add(vo);
                        continue;
                    }
                }
                if(StringUtils.isNotBlank(datas.get(11))){
                    vo.setSupplierName(datas.get(11)); //
                }
                if(StringUtils.isNotBlank(datas.get(12))){
                    try {
                        vo.setPurchaseNum(ComputeUtil.toBigDecimal(datas.get(12))); //
                    } catch (Exception e) {
                        vo.setErrorMsg("【采购数量】需为数值类型！");
                        errorList.add(vo);
                        continue;
                    }
                }
                if(StringUtils.isNotBlank(datas.get(13))){
                    try {
                        vo.setExtParam1(ComputeUtil.toBigDecimal(datas.get(13)).toPlainString()); //
                    } catch (Exception e) {
                        vo.setErrorMsg("【槽重】需为数值类型！");
                        errorList.add(vo);
                        continue;
                    }
                }
                if(StringUtils.isNotBlank(datas.get(14))){
                    try {
                        vo.setExtParam2(ComputeUtil.toBigDecimal(datas.get(14)).toPlainString()); //
                    } catch (Exception e) {
                        vo.setErrorMsg("【盖重】需为数值类型！");
                        errorList.add(vo);
                        continue;
                    }
                }


                unitNames.add(vo.getSourceUnitName());

                vo.setRowState("add");
                processList.add(vo);
            }
        }

        if(CollectionUtils.isNotEmpty(processList)) {
            CommonResponse<List<UnitShareVO>> unitListResp = unitApi.findAllEnabledList(new ArrayList<>(unitNames));
            if(!unitListResp.isSuccess()) {
                logger.error("物料ai导入识别失败，获取单据信息失败,names:{}, 结果：{}", JSONObject.toJSONString(unitNames), JSONObject.toJSONString(unitListResp));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }
            if(CollectionUtils.isEmpty(unitListResp.getData())) {
                logger.error("物料ai导入识别失败，获取单据信息为空, names:{}", JSONObject.toJSONString(unitNames));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }

            Map<String, Long> unitNameIdMap = new HashMap<>();
            Map<String, Long> unitAliasNameIdMap = new HashMap<>();
            unitNameIdMap.putAll(unitListResp.getData().stream().collect(Collectors.toMap(UnitShareVO::getUnitName, UnitShareVO::getId, (k1, k2) -> k1)));
            unitAliasNameIdMap.putAll(unitListResp.getData().stream().filter(item -> StringUtils.isNotBlank(item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), UnitShareVO::getId, (k1,k2) -> k1)));

            for(MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());

                if(unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId(unitNameIdMap.get(m.getSourceUnitName()));
                }
                for(String key : unitAliasNameIdMap.keySet()) {
                    if(key.contains(","+m.getSourceUnitName()+",")) {
                        m.setActualUnitId(unitAliasNameIdMap.get(key));
                    }
                }

                if(null == m.getActualUnitId()) {
                    m.setErrorMsg("计量单位与在系统中不存在！");
                    errorList.add(m);
                    continue;
                }
                successList.add(m);
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    @PostMapping(value = "/saveImport")
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<MaterialConjectureVO> saveList, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        //保存入库
        materialConjectureService.saveOrUpdateBatch(BeanMapper.mapList(saveList, MaterialConjectureEntity.class), saveList.size(), false);

        //启动异步识别
        materialConjectureService.startConjecture(saveList.get(0).getIdentificationId(), authority, saveList.get(0).getMode());

        return CommonResponse.success("操作成功,物料识别中！");
    }

    @GetMapping(value = "/getConjectureProgress")
    @ResponseBody
    public CommonResponse<JSONObject> saveImport(@RequestParam String identificationId,
                                                 @RequestParam(required = false) String mateType,
                                                 @RequestParam(required = false) String actualCategoryName,
                                                 @RequestParam(required = false) String actualMaterialCode,
                                                 @RequestParam(required = false) String actualMaterialName,
                                                 @RequestParam(required = false) String actualMaterialSpec,
                                                 @RequestParam(required = false) String actualUnitName,
                                                 @RequestParam(required = false) BigDecimal actualNum) {
        JSONObject resp = new JSONObject();
        List<MaterialConjectureEntity> identifyList = materialConjectureService
                .getAllByIdentifyId(identificationId, null,actualCategoryName,actualMaterialCode,actualMaterialName,actualMaterialSpec,actualUnitName,actualNum);

        resp.put("total", identifyList.size());
        Integer completeMatch = 0, partialMatch = 0, misMatch = 0;

        resp.put("conjecturedNum", identifyList.stream().filter(item -> !"3".equals(item.getMateType())&&!"4".equals(item.getMateType())).count());
        List<MaterialConjectureEntity> respList = new ArrayList<>();
        for(MaterialConjectureEntity m :identifyList) {
            switch (m.getMateType()) {
                case "0": //不匹配
                    misMatch++;
                    break;
                case "1": //部分匹配
                    partialMatch++;
                    break;
                case "2": //完全匹配
                    completeMatch++;
                    break;
                default:;
            }
            if(StringUtils.isBlank(mateType) || "-1".equals(mateType) || (m.getMateType().equals(mateType))) {
                respList.add(m);
            }
        }

        resp.put("completeMatch", completeMatch);
        resp.put("partialMatch", partialMatch);
        resp.put("misMatch", misMatch);
        resp.put("identifyList", CollectionUtils.isNotEmpty(respList) ?
                BeanMapper.mapList(respList, MaterialConjectureVO.class) : new ArrayList<>());

        return CommonResponse.success(resp);
    }
    @PostMapping(value = "/saveConjecture")
    @ResponseBody
    public CommonResponse<MaterialConjectureVO> saveConjecture(@RequestBody ConjectureEditVO materialVO) {
        MaterialConjectureEntity entity = materialConjectureService.selectById(materialVO.getConjectureId());
        entity.setActualMaterialId(materialVO.getMaterialId()); //最终物料Id
        entity.setActualCategoryId(materialVO.getCategoryId()); //最终物料分类Id
        entity.setActualCategoryName(materialVO.getCategoryName()); //最终物料分类名称
        entity.setActualMaterialSpec(materialVO.getPropertyShowName()); //最终规格型号
        entity.setActualMaterialCode(materialVO.getCode()); //最终物料编码
        if(CollectionUtils.isNotEmpty(materialVO.getRelationList())) {
            JSONArray specArr = new JSONArray();
            JSONObject json = null;
            for(MaterialPropertyRelationVO s : materialVO.getRelationList()) {
                json = BeanMapper.map(s, JSONObject.class);
                json.put("propertyItemId", s.getPropertyItemId().toString());
                json.put("id", s.getPropertyItemId().toString());
                json.put("categoryId", s.getCategoryId().toString());
                json.put("propertyId", s.getPropertyId().toString());
                specArr.add(json);
            }

            entity.setActualMaterialSpecs(specArr.toJSONString());
        }
        entity.setActualNum(materialVO.getNum());
        entity.setActualBasePrice(materialVO.getBasePrice());
        entity.setActualBaseOriginPrice(materialVO.getBaseOriginPrice());
        entity.setActualBaseTwoPrice(materialVO.getBaseTwoPrice());

        entity.setActualUnitId(materialVO.getUnitId());
        entity.setActualUnitName(materialVO.getUnitName());
        entity.setActualMaterialName(materialVO.getName());
        entity.setAdjustFlag(PlanConstant.INTEGER_YES); //是否调整：已调整
        entity.setMateType("2"); //调整为完全匹配

        materialConjectureService.saveOrUpdate(entity, false);

        return CommonResponse.success("操作成功!", BeanMapper.map(entity, MaterialConjectureVO.class));
    }

    @RequestMapping(value = "/loadMaterialCategoryTree",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String,Object>>> loadMaterialCategoryTree() {
        List<MaterialBasePriceContentEntity>list=materialBasePriceContentService.select(null);
        if (CollectionUtils.isNotEmpty(list)){
            List<Long> classIds = list.stream().map(MaterialBasePriceContentEntity::getMaterialClassId).collect(Collectors.toList());
            List<MaterialCategoryVO> materialCategoryVOS = materialCategoryService.queryCategoryListByChildren(classIds);
            return CommonResponse.success(ResultAsTree.createTreeData(BeanMapper.mapList(materialCategoryVOS, Map.class)));
        }
        return CommonResponse.success(new ArrayList<>());
    }

    @RequestMapping(value = "/queryByCategoryId",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialBasePriceContentVO>> queryByCategoryId(@RequestBody QueryParam param){
        Parameter category = param.getParams().get("categoryId");
        Long categoryId = null;
        if (ObjectUtil.isNotEmpty(category)){
            Object value = param.getParams().get("categoryId").getValue();
            String id=null;
            if (value != null){
                id = value.toString();
            }
            categoryId = StringUtils.isBlank(id) ? null : Long.parseLong(id);
        }
        param.getParams().remove("categoryId");

        if (categoryId==null){
            return CommonResponse.success("查询列表数据成功！",new Page<>());
        }
        List<MaterialCategoryEntity> allCategoryByLeafNodeId = materialCategoryService.getChildrenByPid(categoryId);
        List<Long> ids = allCategoryByLeafNodeId.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
//        ids.add(categoryId);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("materialCode","areaName","brandName","supplierName","contractCode"));
        IPage<MaterialBasePriceContentVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
//        param.getParams().put("materialClassId", new Parameter(QueryParam.IN, ids));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<MaterialBasePriceContentEntity> select = materialBasePriceContentService.selectData(param,page,ids);
        List<MaterialBasePriceContentVO> materialBasePriceContentVOS1 = BeanMapper.mapList(select, MaterialBasePriceContentVO.class);
        IPage<MaterialBasePriceContentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(materialBasePriceContentVOS1);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {

        Parameter category = param.getParams().get("categoryId");
        Long categoryId = null;
        if (ObjectUtil.isNotEmpty(category)){
            categoryId = Long.parseLong(param.getParams().get("categoryId").getValue().toString());
        }
        param.getParams().remove("categoryId");
        List<MaterialCategoryEntity> allCategoryByLeafNodeId = materialCategoryService.getChildrenByPid(categoryId);
        List<Long> ids = allCategoryByLeafNodeId.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("materialCode","areaName","brandName","supplierName","contractCode"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<MaterialBasePriceContentVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<MaterialBasePriceContentEntity> select = materialBasePriceContentService.selectData(param,page,ids);
        List<MaterialBasePriceContentVO> materialBasePriceContentVOS = BeanMapper.mapList(select, MaterialBasePriceContentVO.class);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", materialBasePriceContentVOS);
        ExcelExport.getInstance().export("MaterialBasePriceReport-export.xlsx", beans, response);
    }


}
