package com.ejianc.business.zdsmaterial.pick.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.pick.bean.ProPickSettingEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubPickerEntity;
import com.ejianc.business.zdsmaterial.pick.mapper.ProPickSettingMapper;
import com.ejianc.business.zdsmaterial.pick.service.IProPickSettingService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubPickerService;
import com.ejianc.business.zdsmaterial.pick.vo.*;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包领料设置主表
 *
 * @author generator
 */
@Service("proPickSettingService")
public class ProPickSettingServiceImpl extends BaseServiceImpl<ProPickSettingMapper, ProPickSettingEntity> implements IProPickSettingService {

    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IProSubPickerService pickerService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ProPickSettingMapper mapper;

    @Override
    public CommonResponse<ProPickSettingVO> saveOrUpdate(ProPickSettingVO saveOrUpdateVO) {
        ProPickSettingEntity entity = BeanMapper.map(saveOrUpdateVO, ProPickSettingEntity.class);
        List<ProSubPickerEntity> proSubPickerList = entity.getProSubPickerList();
        List<ProSubPickerEntity> delPickerList = proSubPickerList.stream().filter(e ->null!=e.getRowState()&&e.getRowState().equals("del")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(delPickerList)){
            //删除对应领料人

            //查询当前被删除的领料人是否存在于当前供应商
            pickerService.resultDelList(delPickerList);
        }


        if(null != saveOrUpdateVO.getId()) {
            ProPickSettingEntity dbInfo = super.selectById(saveOrUpdateVO.getId());
            List<Long> disabledDetailIds = dbInfo.getProSubPickerList().stream()
                    .filter(e -> PlanConstant.STRING_NO.equals(e.getEnabledState()))
                    .map(e -> e.getId()).collect(Collectors.toList());


            List<ProSubPickerEntity> disabledPickerList = proSubPickerList.stream()
                    .filter(e -> null != e.getId() && PlanConstant.STRING_NO.equals(e.getEnabledState()) && !disabledDetailIds.contains(e.getId())).collect(Collectors.toList());
            //批量停用领料人
            if(CollectionUtils.isNotEmpty(disabledPickerList)) {
                //查询当前被删除的领料人是否存在于当前供应商
                pickerService.resultDelList(disabledPickerList);

                disabledPickerList.stream().forEach(item -> {
                    item.setCoordination(PlanConstant.STRING_NO);
                    item.setSupTenantId(null);
                    item.setSupUserId(null);
                });
            }
        }


        super.saveOrUpdate(entity, false);
        CommonResponse<ProPickSettingVO> proPickSettingVOCommonResponse = settingByProjectId(entity.getProjectId());
        return CommonResponse.success("保存或修改单据成功！",proPickSettingVOCommonResponse.getData()) ;
    }

    @Override
    public List<Long> queryContractIds(Map<String, Object> queryParams) {
        return mapper.queryContractIds(queryParams);
    }

    @Override
    public CommonResponse<ProPickSettingVO> settingByProjectId(Long projectId) {
        ProPickSettingEntity proPickSettingEntity = new ProPickSettingEntity();
        QueryWrapper<ProPickSettingEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("project_id", projectId);
        List<ProPickSettingEntity> list = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            proPickSettingEntity = super.selectById(list.get(0).getId());
        } else {
            //根据当前项目新增一个
            CommonResponse<JSONArray> projectResp = projectPoolApi.queryProjectPoolById(projectId);
            logger.error("根据项目Id-{}获取项目信息结果，{}", projectId, JSONObject.toJSONString(projectResp, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            if (!projectResp.isSuccess() || projectResp.getData().size() == 0) {
                //未查询到当前项目信息
                return CommonResponse.error("网络异常,未查询到当前项目信息！");
            }
            ProjectPoolSetVO p = JSONObject.parseObject(JSONObject.toJSONString(projectResp.getData().get(0)), ProjectPoolSetVO.class);
            proPickSettingEntity.setProjectId(p.getId());
            proPickSettingEntity.setProjectName(p.getName());
            proPickSettingEntity.setProjectCode(p.getCode());
            proPickSettingEntity.setOrgId(p.getProjectDepartmentId());
            proPickSettingEntity.setOrgName(p.getProjectDepartmentName());
            proPickSettingEntity.setOrgCode(p.getProjectDepartmentCode());
            proPickSettingEntity.setParentOrgId(p.getOrgId());
            proPickSettingEntity.setParentOrgName(p.getOrgName());
            proPickSettingEntity.setParentOrgCode(p.getOrgCode());
            boolean b = super.saveOrUpdate(proPickSettingEntity);

        }
        ProPickSettingVO map = BeanMapper.map(proPickSettingEntity, ProPickSettingVO.class);
        if (CollectionUtils.isNotEmpty(map.getProSubContractorList())) {
            List<ProSubContractorVO> proSubContractorList = map.getProSubContractorList();
            List<ProSubPickerVO> proSubPickerList = map.getProSubPickerList();
            List<ProSubRangeVo> proSubRangeList = map.getProSubRangeList();
            List<ProSubSignerVO> proSubSignerList = map.getProSubSignerList();
            Map<Long, List<ProSubPickerVO>> collect = proSubPickerList.stream().collect(Collectors.groupingBy(e -> e.getContractId()));
            Map<Long, List<ProSubRangeVo>> collect1 = proSubRangeList.stream().collect(Collectors.groupingBy(e -> e.getContractId()));
            Map<Long, List<ProSubSignerVO>> collect2 = proSubSignerList.stream().collect(Collectors.groupingBy(e -> e.getContractId()));

            for (ProSubContractorVO vo : proSubContractorList) {
                if (CollectionUtils.isNotEmpty(proSubPickerList)&&collect.containsKey(vo.getContractId())){
                    vo.getProSubPickerList().addAll(collect.get(vo.getContractId()));
                }
                if (CollectionUtils.isNotEmpty(proSubRangeList)&&collect1.containsKey(vo.getContractId())){
                    vo.getProSubRangeList().addAll(collect1.get(vo.getContractId()));
                }
                if (CollectionUtils.isNotEmpty(proSubSignerList)&&collect2.containsKey(vo.getContractId())){
                    vo.getProSubSignerList().addAll(collect2.get(vo.getContractId()));
                }
            }
            map.setProSubPickerList(null);
            map.setProSubRangeList(null);
            map.setProSubSignerList(null);
        }
        return CommonResponse.success("查询成功!",map);
    }



}
