package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractManagerEntity;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractManagerService;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.erp.vo.ContractManagerVO;
import com.ejianc.business.zdsmaterial.erp.vo.SyncJobExecRecordsVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 合同负责人实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("contractManager")
public class ContractManagerController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractManagerService service;
    @Autowired
    private SessionManager sessionManager;

    @Value("${erp.appId}")
    private String appId;

    @Value("${erp.secret}")
    private String secret;

    @Value("${erp.reqHost}")
    private String reqHost;

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private QueueUtils queueUtils;


    private final String MATERIAL_CONTRACT_MANAGER_ERP_REQ_URL = "/cefoc/yql/getMEContractOwnerList";
    private final String SUB_CONTRACT_MANAGER_ERP_REQ_URL = "/cefoc/yql/getSubContractOwnerList";

    private final String ERP_EMPTY_VALUE = "00000000-0000-0000-0000-000000000000";

    @Autowired
    private IContractService matContractService;

    @Autowired
    private ISubContractService subContractService;

    @Autowired
    private IEmployeeApi employeeApi;


    @GetMapping(value = "syncErpMaterialContractManager")
    public CommonResponse<String> syncErpMaterialContractManager() {
        return syncErpContractManager("采购");
    }
    @GetMapping(value = "syncErpSubContractManager")
    public CommonResponse<String> syncErpSubContractManager() {
        return syncErpContractManager("分包");
    }

    private CommonResponse<String> syncErpContractManager(String contractType) {
        logger.info("*********************中电四-{}合同负责人信息同步任务 开始*********************", contractType);
        Map<String, Integer> param = new HashMap<>();
        String reqUrl = reqHost + ("采购".equals(contractType) ? MATERIAL_CONTRACT_MANAGER_ERP_REQ_URL : SUB_CONTRACT_MANAGER_ERP_REQ_URL);
        String reqResp = null;

        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
            JSONObject reqJson = null;
            JSONArray pageData =null;

            logger.info("中电四-{}合同负责人信息同步,地址：{}, 参数：{}", contractType, JSONObject.toJSONString(param));

            reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                    ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
            reqJson = JSONObject.parseObject(reqResp);

            if("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                if(null != pageData && pageData.size() > 0) {
                    logger.info("中电四{}合同负责人信息同步同步, {}条数据", contractType, pageData.size());
                    handleErpPage(pageData, "采购".equals(contractType) ? "1" : "2");
                } else {
                    logger.info("中电四{}合同负责人同步 处理数据完成！！！总共{}条数据！", contractType, pageData.size());
                }
            } else {
                logger.error("请求中电四{}合同负责人信息 结果返回失败：请求地址-{},参数-{},header-{},结果-{}", contractType, reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                queueUtils.sendMq(SyncJobExecRecordsVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(
                        new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), PlanConstant.STRING_YES, reqResp, null)));
            }
        } catch (Exception e) {
            logger.error("获取中电四{}合同负责人信息异常, 请求地址：{}, 请求参数：{}", contractType,reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat));
            queueUtils.sendMq(SyncJobExecRecordsVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(
                    new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), PlanConstant.STRING_YES, reqResp, e.getMessage())));
            return CommonResponse.error("同步中电四"+contractType+"合同负责人异常");
        }

        logger.info("*********************中电四-{}合同负责人信息同步任务 结束*********************", contractType);
        queueUtils.sendMq(SyncJobExecRecordsVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), PlanConstant.STRING_YES)));
        return CommonResponse.success("中电四"+contractType+"合同负责人信息同步完成！");
    }

    private void handleErpPage(JSONArray data, String contractType) {
        JSONObject tmp = null;
        ContractManagerEntity tmpManager = null;
        Map<Long, ContractManagerEntity> managerMap = new HashMap<>();
        List<ContractManagerEntity> processList = new ArrayList<>();
        List<ContractManagerEntity> saveList = new ArrayList<>();
        List<ContractManagerEntity> updateList = new ArrayList<>();
        String contractPrefix = "1".equals(contractType) ? "ME":"Sub";

        Set<String> empSourceIds = new HashSet<>();
        Set<String> contractSourceIds = new HashSet<>();
        List<ContractManagerEntity> dbManagers = null;

        for(Object obj : data) {
            tmp = (JSONObject) obj;
            if((StringUtils.isBlank(tmp.getString(contractPrefix+"Contract_Operator_Sid")) || ERP_EMPTY_VALUE.equals(tmp.getString(contractPrefix+"Contract_Operator_Sid"))) &&
                    (StringUtils.isBlank(tmp.getString(contractPrefix+"Contract_Settler_Sid")) || ERP_EMPTY_VALUE.equals(tmp.getString(contractPrefix+"Contract_Settler_Sid")))) {
                logger.info("{}合同SID-{} 履约人和结算日人都为空，跳过~", "1".equals(contractType) ? "采购":"分包");
                continue;
            }

            tmpManager = new ContractManagerEntity();
            tmpManager.setContractSid(tmp.getString(contractPrefix+"ContractInfo_Sid"));
            tmpManager.setContractName(tmp.getString("Contract_Title"));

            tmpManager.setProjectSid(tmp.getString("Account_Project_Sid"));
            tmpManager.setProjectCode(tmp.getString("Account_Project_id"));
            tmpManager.setProjectName(tmp.getString("Project_Name"));

            tmpManager.setOperatorSid(tmp.getString(contractPrefix+"Contract_Operator_Sid"));
            tmpManager.setOperatorName(tmp.getString(contractPrefix+"Contract_Operator"));
            if(StringUtils.isNotBlank(tmpManager.getOperatorSid()) && !ERP_EMPTY_VALUE.equals(tmpManager.getOperatorSid())) {
                empSourceIds.add(tmpManager.getOperatorSid());
            }

            tmpManager.setSettlerSid(tmp.getString(contractPrefix+"Contract_Settler_Sid"));
            tmpManager.setSettlerName(tmp.getString(contractPrefix+"Contract_Settler"));
            if(StringUtils.isNotBlank(tmpManager.getSettlerSid()) && !ERP_EMPTY_VALUE.equals(tmpManager.getSettlerSid())) {
                empSourceIds.add(tmpManager.getSettlerSid());
            }
            tmpManager.setContractType(contractType);
            contractSourceIds.add(tmpManager.getContractSid());
            processList.add(tmpManager);
        }

        //查询合同
        if("1".equals(contractType)) {
            List<ContractEntity> contracts = matContractService.getBySourceIds(new ArrayList<>(contractSourceIds));
            dbManagers = (List<ContractManagerEntity>) service.listByIds(contracts.stream().map(ContractEntity::getId).collect(Collectors.toList()));
            Map<String, ContractEntity> contractMap = contracts.stream().collect(Collectors.toMap(ContractEntity::getSourceContractId, Function.identity()));
            ContractEntity tmpContract = null;
            for(ContractManagerEntity con : processList) {
                tmpContract = contractMap.get(con.getContractSid());
                if(null != tmpContract) {
                    con.setContractId(tmpContract.getId());
                    con.setProjectId(tmpContract.getProjectId());
                    con.setId(tmpContract.getId());
                }
            }
        } else {
            List<SubContractEntity> contracts = subContractService.getAllBySourceIds(new ArrayList<>(contractSourceIds));
            dbManagers = (List<ContractManagerEntity>) service.listByIds(contracts.stream().map(SubContractEntity::getId).collect(Collectors.toList()));
            Map<String, SubContractEntity> contractMap = contracts.stream().collect(Collectors.toMap(SubContractEntity::getSourceContractId, Function.identity()));
            SubContractEntity tmpContract = null;
            for(ContractManagerEntity con : processList) {
                tmpContract = contractMap.get(con.getContractSid());
                if(null != tmpContract) {
                    con.setContractId(tmpContract.getId());
                    con.setProjectId(tmpContract.getProjectId());
                    con.setId(tmpContract.getId());
                }
            }
        }

        //查询人员信息
        CommonResponse<List<EmployeeVO>> empResp = employeeApi.getAllBySourceIds(new ArrayList<>(empSourceIds));
        if(!empResp.isSuccess() || CollectionUtils.isEmpty(empResp.getData())) {
            logger.error("合同履约人同步失败，根据人员SID-{}，获取人员信息失败或为空, {}", JSONObject.toJSONString(empSourceIds),
                    JSONObject.toJSONString(empResp));
            throw new BusinessException("合同履约人同步失败，人员信息查询失败！");
        }

        Map<String, EmployeeVO> empMap = empResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item ->item));
        managerMap.putAll(dbManagers.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        for(ContractManagerEntity con : processList) {
            tmpManager = managerMap.get(con.getId());
            if(StringUtils.isNotBlank(con.getOperatorSid()) && empMap.containsKey(con.getOperatorSid())) {
                con.setOperatorId(empMap.get(con.getOperatorSid()).getId());
                con.setOperatorCode(empMap.get(con.getOperatorSid()).getCode());
            }
            if(StringUtils.isNotBlank(con.getSettlerSid()) && empMap.containsKey(con.getSettlerSid())) {
                con.setSettlerId(empMap.get(con.getSettlerSid()).getId());
                con.setSettlerCode(empMap.get(con.getSettlerSid()).getCode());
            }
            if(null != tmpManager) {
                tmpManager.setOperatorId(con.getOperatorId());
                tmpManager.setOperatorCode(con.getOperatorCode());
                tmpManager.setOperatorName(con.getOperatorName());
                tmpManager.setOperatorSid(con.getOperatorSid());

                tmpManager.setSettlerCode(con.getSettlerCode());
                tmpManager.setSettlerId(con.getSettlerId());
                tmpManager.setSettlerName(con.getSettlerName());
                tmpManager.setSettlerSid(con.getSettlerSid());
                updateList.add(tmpManager);
                continue;
            }

            saveList.add(con);
        }

        //本次更新
        logger.info("{}合同履约人同步,本次更新{}条~", "1".equals(contractType) ? "采购":"分包", updateList.size());
        if(CollectionUtils.isNotEmpty(updateList)) {
            service.saveOrUpdateBatch(updateList, updateList.size(), false);
        }

        //保存入库
        logger.info("{}合同履约人同步，本次保存{}条", "1".equals(contractType) ? "采购":"分包", saveList.size());
        if(CollectionUtils.isNotEmpty(saveList)) {
            service.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractManagerVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ContractManagerEntity> page = service.queryPage(param,false);
        IPage<ContractManagerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractManagerVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ContractManagerEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ContractManager-export.xlsx", beans, response);
    }
}
