package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.enums.DeliveryAcceptStatusEnums;
import com.ejianc.business.zdsmaterial.erp.mapper.DeliveryDetailMapper;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 发货单-物资清单
 *
 * @author generator
 */
@Service("deliveryDetailService")
public class DeliveryDetailServiceImpl extends BaseServiceImpl<DeliveryDetailMapper, DeliveryDetailEntity> implements IDeliveryDetailService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private DeliveryDetailMapper mapper;

    /**
     * 发货量 计算释放发货金额
     *
     * @param entity
     * @param flag
     */
    @Override
    public void updateDeliveryResNum(AcceptEntity entity, boolean flag) {
        QueryWrapper<DeliveryDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("delivery_id", entity.getDeliveryBillId());
        List<DeliveryDetailEntity> list = super.list(queryWrapper);
        Map<Long, BigDecimal> returnOrderMap = new HashMap<>();
        BigDecimal deliveryTaxMny = BigDecimal.ZERO;
        BigDecimal deliveryMny = BigDecimal.ZERO;
        for (DeliveryDetailEntity detail : list) {
            BigDecimal decimal = BigDecimal.ZERO;
            if (flag) {
                BigDecimal deliveryNum = detail.getDeliveryNum();
                BigDecimal alreadyNum = detail.getAlreadyNum();
                decimal = ComputeUtil.safeSub(deliveryNum, alreadyNum);
                returnOrderMap.put(detail.getSourceDetailId(), decimal);
                BigDecimal taxMny = ComputeUtil.safeMultiply(alreadyNum, detail.getDetailTaxPrice());
                BigDecimal mny = ComputeUtil.safeMultiply(alreadyNum, detail.getDetailPrice());
                BigDecimal tax = ComputeUtil.safeSub(taxMny, mny);
                detail.setDetailTaxMny(taxMny);
                detail.setDetailMny(mny);
                detail.setDetailTax(tax);
                deliveryTaxMny = ComputeUtil.safeAdd(deliveryTaxMny, taxMny);
                deliveryMny = ComputeUtil.safeAdd(deliveryMny, mny);
            } else {
                returnOrderMap.put(detail.getSourceDetailId(), detail.getReleaseNum());
                BigDecimal releaseNum = detail.getReleaseNum();
                BigDecimal alreadyNum = detail.getAlreadyNum();
                BigDecimal decimal1 = ComputeUtil.safeAdd(releaseNum, alreadyNum);
                BigDecimal taxMny = ComputeUtil.safeMultiply(decimal1, detail.getDetailTaxPrice());
                BigDecimal mny = ComputeUtil.safeMultiply(decimal1, detail.getDetailPrice());
                BigDecimal tax = ComputeUtil.safeSub(taxMny, mny);
                detail.setDetailTaxMny(taxMny);
                detail.setDetailMny(mny);
                detail.setDetailTax(tax);
                deliveryTaxMny = ComputeUtil.safeAdd(deliveryTaxMny, taxMny);
                deliveryMny = ComputeUtil.safeAdd(deliveryMny, mny);
            }
            detail.setReleaseNum(decimal);
        }

        UpdateWrapper<DeliveryEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", entity.getDeliveryBillId());
        updateWrapper.set("delivery_tax_mny", deliveryTaxMny);
        updateWrapper.set("delivery_mny", deliveryMny);
        deliveryService.update(updateWrapper);
        orderDetailService.returnDeliveryNum(returnOrderMap, flag);
        super.saveOrUpdateBatch(list);
    }


    @Override
    public boolean returnAlreadyNum(AcceptEntity entity, boolean addFlag) {
        Map<Long, AcceptDetailEntity> detailNumMapNew = new HashMap<>();
        for (AcceptDetailEntity detail : entity.getDetailList()) {
            detailNumMapNew.put(detail.getSourceDetailId(), detail);
        }
        QueryWrapper<DeliveryDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("id", detailNumMapNew.keySet());
        List<DeliveryDetailEntity> list = super.list(queryWrapper);
        for (DeliveryDetailEntity detail : list) {
            if (detailNumMapNew.containsKey(detail.getId())) {
                BigDecimal decimal = detailNumMapNew.get(detail.getId()).getCheckNum();
                BigDecimal checkNum = decimal;
                BigDecimal alreadyNum = detail.getAlreadyNum();
                if (addFlag) {
                    if ("del".equals(detailNumMapNew.get(detail.getId()).getRowState())) {
                        checkNum =ComputeUtil.safeSub(BigDecimal.ZERO, decimal);
                        alreadyNum = ComputeUtil.safeSub(alreadyNum, decimal);
                    } else {
                        alreadyNum = ComputeUtil.safeAdd(alreadyNum, decimal);
                        checkNum = decimal;
                    }
                } else {
                    alreadyNum = ComputeUtil.safeSub(alreadyNum, decimal);
                    checkNum = decimal;
                }

                detail.setCheckNum(checkNum);

                detail.setAlreadyNum(alreadyNum);
            }
        }
        DeliveryEntity deliveryEntity = new DeliveryEntity();
        deliveryEntity.setDetailList(list);
        deliveryEntity.setOrderId(entity.getOrderBillId());
        //订单验收金额回写
        orderService.returnAcceptedNum(deliveryEntity, addFlag);
        super.saveOrUpdateBatch(list);
        return true;
    }

    @Override
    public void checkAcceptStatus(Long id) {
        DeliveryEntity deliveryEntity = deliveryService.selectById(id);
        List<DeliveryDetailEntity> detailList = deliveryEntity.getDetailList();
        boolean allFlag = false;
        for (DeliveryDetailEntity detail : detailList) {
            if (ComputeUtil.isGreaterThan(detail.getAlreadyNum(), BigDecimal.ZERO)) {
                allFlag = true;
                break;
            }
        }
        if (allFlag) {
            deliveryService.updateAcceptStatus(id, DeliveryAcceptStatusEnums.分批验收.getCode());
        } else {
            deliveryService.updateAcceptStatus(id, DeliveryAcceptStatusEnums.待验收.getCode());
        }
    }

    @Override
    public List<DeliveryDetailEntity> getAllByDeliveryId(Long deliveryId) {
        QueryWrapper<DeliveryDetailEntity> query = new QueryWrapper<>();
        query.eq("delivery_id", deliveryId);
        return super.list(query);
    }

    @Override
    public void deleteByDeliveryId(Long deliveryId) {
        mapper.deleteByDeliveryId(deliveryId);
    }

}
