package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.WorkSpecializeEntity;
import com.ejianc.business.zdsmaterial.erp.service.IWorkSpecializeService;
import com.ejianc.business.zdsmaterial.erp.vo.WorkSpecializeVo;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/specialize/")
public class WorkSpecializeController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String ENGINEER_CONTRACT_ERP_REQ_URL = "/cefoc/yql/getEngineerBaseList";

    @Autowired
    private IWorkSpecializeService service;

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkSpecializeVo>> refData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){

        }
        param.getOrderMap().put("sort_ord",QueryParam.DESC);
        IPage<WorkSpecializeEntity> page = service.queryPage(param,false);
        IPage<WorkSpecializeVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkSpecializeVo.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * ERP专业同步
     *
     * @param params: start:开始日期 end:结束日期
     * @return
     */
    @PostMapping(value = "syncZDSWorkSpecialize")
    public CommonResponse<String> syncZDSWorkSpecialize(@RequestBody Map<String, String> params) {
        logger.info("*********************中电四-工作专业同步任务 开始*********************");

        Map<String, Object> param = new HashMap<>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + ENGINEER_CONTRACT_ERP_REQ_URL;
        JSONObject reqJson = null;
        JSONArray pageData = null;
        Integer pageNum = 0;
        Integer pageSize = Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());

        String reqDateStr = null;

        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", pageSize);

            param.put("PageNum", ++pageNum);
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                    ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
            reqJson = JSONObject.parseObject(reqResp);

            if ("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                if (null != pageData && pageData.size() > 0) {
                    logger.info("中电四工作专业同步，处理第{}页, {}条数据", pageNum, pageData.size());
                    handleWorkSpecializeData(pageData);
                } else {
                    logger.info("中电四工作专业同步 处理数据完成！！！总共{}页数据！", pageNum);
                }
            } else {
                logger.error("请求中电四获取工作专业结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取中电四工作专业信息异常, 请求地址：{}, 请求参数：{},e:{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat),e);
            return CommonResponse.error("同步中电四工作专业信息异常");
        }

        logger.info("*********************中电四-工作专业信息同步任务 结束*********************");

        return CommonResponse.success("中电四工作专业任务执行结束！");
    }

    private void handleWorkSpecializeData(JSONArray pageData) {
        JSONObject tmp = null;
        WorkSpecializeEntity tmpEntity = null;
        Map<String, WorkSpecializeEntity> sourceIdMap = new HashMap<>();
        List<WorkSpecializeEntity> saveList = new ArrayList<>();

        for (Object obj : pageData) {
            tmp = (JSONObject) obj;
            tmpEntity = new WorkSpecializeEntity();
            tmpEntity.setBillCode(tmp.getString("C_AA_EngineerBaseOID"));
            tmpEntity.setName(tmp.getString("Title"));
            tmpEntity.setSortOrd(tmp.getString("Sort_ID"));

            tmpEntity.setMemo(tmp.getString("Memo"));
            tmpEntity.setIsEnable(tmp.getString("IsEnable"));
            sourceIdMap.put(tmpEntity.getBillCode(), tmpEntity);
        }
        //记录需要查询的项目
        List<WorkSpecializeEntity> dbListBySourceId =service.getAllBySourceIds(new ArrayList<>(sourceIdMap.keySet()));
        if (CollectionUtils.isNotEmpty(dbListBySourceId)) {
            //更新列表
            for (WorkSpecializeEntity dbEntity : dbListBySourceId) {
                tmpEntity = sourceIdMap.get(dbEntity.getBillCode());
                dbEntity.setName(tmpEntity.getName());
                dbEntity.setSortOrd(tmpEntity.getSortOrd());
                dbEntity.setMemo(tmpEntity.getMemo());
                dbEntity.setIsEnable(tmpEntity.getIsEnable());
                saveList.add(dbEntity);
                sourceIdMap.remove(dbEntity.getBillCode());
            }
        }
        if (!sourceIdMap.isEmpty()) {
            saveList.addAll(sourceIdMap.values());
        }
        service.saveOrUpdateBatch(saveList, saveList.size(), false);
    }
}
