package com.ejianc.business.zdsmaterial.out.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.BillPushStatusEnum;
import com.ejianc.business.zdsmaterial.cons.enums.ClaimTypeEnum;
import com.ejianc.business.zdsmaterial.out.bean.OutStoreEntity;
import com.ejianc.business.zdsmaterial.out.bean.OutStoreSubEntity;
import com.ejianc.business.zdsmaterial.out.mapper.OutStoreMapper;
import com.ejianc.business.zdsmaterial.out.service.IOutStoreService;
import com.ejianc.business.zdsmaterial.out.vo.OutStoreSubVO;
import com.ejianc.business.zdsmaterial.out.vo.OutStoreVO;
import com.ejianc.business.zdsmaterial.out.vo.SupOutStoreSubVO;
import com.ejianc.business.zdsmaterial.out.vo.SupOutStoreVO;
import com.ejianc.business.zdsmaterial.pick.bean.ProPickSettingEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubContractorEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubPickerEntity;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubSignerEntity;
import com.ejianc.business.zdsmaterial.pick.service.*;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.business.zdsstore.vo.UseMaterialPriceVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import feign.Response;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 领料出库
 *
 * @author generator
 *
 */
@Service("outStoreService")
public class OutStoreServiceImpl extends BaseServiceImpl<OutStoreMapper, OutStoreEntity> implements IOutStoreService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String OPERATE = "ZDS_MATERIAL_OUT";
    private static final String BILL_TYPE = PlanConstant.OUT_STORE_BILL_TYPE;
    private final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/outRecord/saveOutStore";
    private final String DELPUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/outRecord/deleteOutStore";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/outRecord/supSignSync";
    private static final String BILL_CODE = "ZDS_MATERIAL_OUT";//此处需要根据实际修改
    private static final String supSignFileSourceType = "stopMSupplier";
    private static final String BILL_NAME = "领料出库";
    /** 无权访问 */
    private static final String noPower = "无权限访问该服务，请先联系管理员进行授权！";

    private static final String DEV_TEST_SUPPLIER_ID = "589112141802405909";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IStoreManageApi storeManageApi;

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IStoreFlowApi storeFlowApi;

    @Autowired
    private ISubsetMaterialService subsetService;

    @Autowired
    private IProSubContractorService contractorService;

    @Autowired
    private IProSubSignerService signerService;

    @Autowired
    private IProPickSettingService settingService;

    @Autowired
    private IProSubPickerService subPickerService;

    @Override
    public CommonResponse<OutStoreVO> saveOrUpdate(OutStoreVO outStoreVO) {
        List<OutStoreSubVO> saveList = outStoreVO.getOutStoreSubList().stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(saveList)){
            throw new BusinessException("材料明细不能为空!");
        }
        // 校验出库数量
        this.validateStoreNum(outStoreVO);
        // 校验限额数量
        this.validateOutNum(outStoreVO);

        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(outStoreVO.getParentOrgCode()) && outStoreVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(outStoreVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                outStoreVO.setParentOrgCode(orgResponse.getData().getCode());
            }
        }
        // orgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(outStoreVO.getOrgCode()) && outStoreVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(outStoreVO.getOrgId());
            if (orgResponse.isSuccess()) {
                outStoreVO.setOrgCode(orgResponse.getData().getCode());
            }
        }
        OutStoreEntity entity = BeanMapper.map(outStoreVO, OutStoreEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),outStoreVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setSignStatus(0);//签字信息初始化
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        if(entity.getCreateUserId() == null){
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }

        super.saveOrUpdate(entity, false);

//        // 调用库存逻辑
//        this.inOutStore(entity, false);
//        OutStoreVO vo = BeanMapper.map(entity, OutStoreVO.class);
        return CommonResponse.success("保存或修改单据成功！", this.queryDetail(entity.getId()));
    }

    @Override
    public Boolean inOutStore(OutStoreEntity entity, Boolean outEffectiveON) {
        Map<Long, List<OutStoreSubEntity>> map = entity.getOutStoreSubList().stream().collect(Collectors.groupingBy(OutStoreSubEntity::getStoreId));
        if(map.values().stream().flatMap(Collection::stream).count() == 0){
            return true;
        }
        for(Long storeId : map.keySet()){
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(storeId);
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料出库);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            for(OutStoreSubEntity t : map.get(storeId)){
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.领料出库, 0);
                flowVO.setStoreId(t.getStoreId());
                flowVO.setStoreName(t.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setSupplierId(entity.getSubSupplierId());
                flowVO.setSupplierName(entity.getSubSupplierName());
                flowVO.setMaterialCategoryId(t.getMaterialTypeId());
                flowVO.setMaterialCategoryName(t.getMaterialTypeName());
                flowVO.setMaterialCategoryCode(t.getMaterialTypeCode());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialCode(t.getMaterialCode());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getPropertyValue());
                flowVO.setBrandId(t.getBrandId());
                flowVO.setBrandName(t.getBrandName());
                flowVO.setProductCode(t.getProductCode());
                flowVO.setMaterialUnitId(t.getUnitId());
                flowVO.setMaterialUnitName(t.getUnitName());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxRate(t.getTaxRate());
                flowVO.setTaxPrice(t.getTaxPrice());
                flowVO.setPrice(t.getPrice());
                flowVO.setNum(t.getNum());
                flowVO.setTaxMny(t.getTaxMoney());
                flowVO.setMny(t.getMoney());
                flowVO.setTax(t.getOutTax());
                flowVO.setUseFor(entity.getUseFor());
                flowVO.setSubEmployeeName(entity.getSubEmployeeName());
                flowVO.setPickUnitId(entity.getSubSupplierId());
                flowVO.setPickUnitName(entity.getSubSupplierName());
                flowVO.setPickContractId(entity.getSubContractId());
                flowVO.setPickContractName(entity.getSubContractName());

                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getOutDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillTypeCode(PlanConstant.OUT_STORE_BILL_TYPE);
                flowVO.setSourceBillTypeName("领料出库");
                flowVO.setSourceType(1);//  0-自制,1-订单
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVO.setPickType(entity.getClaimType());//claimType; // 领料方式，1-分包领料,2-内部领料
                flowVO.setPickTypeName(ClaimTypeEnum.getEnumByStateCode(entity.getClaimType()).getDescription());
                flowVOS.add(flowVO);
            }
            storeManageVO.setFlowVOList(flowVOS);
            logger.info("调用库存参数：————"+JSONObject.toJSONString(storeManageVO));
            CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
            if(!response.isSuccess()) {
                throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
            }
        }
        return true;
    }

    @Override
    public Boolean inOutStoreRollback(OutStoreEntity entity, Boolean outEffectiveON) {
        Map<Long, List<OutStoreSubEntity>> map = entity.getOutStoreSubList().stream().collect(Collectors.groupingBy(OutStoreSubEntity::getStoreId));
        for(Long storeId : map.keySet()){
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(storeId);
//            List<Long> ids = map.get(storeId).stream().map(OutStoreSubEntity::getId).collect(Collectors.toList());
            storeManageVO.setSourceIdsForRollBack(new ArrayList<>(Arrays.asList(entity.getId())));
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料出库);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            logger.info("调用库存参数：————"+JSONObject.toJSONString(storeManageVO));
            CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
            if(!response.isSuccess()) {
                throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
            }
        }
        return true;
    }

    @Override
    public CommonResponse<String> del(List<OutStoreVO> vos) {
        List<Long> ids = vos.stream().map(OutStoreVO::getId).collect(Collectors.toList());
//        List<OutStoreEntity> list = new ArrayList<>(super.listByIds(ids));
//        DetailListUtil.setDetailList(list);
//        list.forEach(e->{
//            // 调用库存删除
//            this.inOutStoreRollback(e, false);
//        });
        super.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }
    /*供方签字确认*/
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        OutStoreEntity outStoreEntity = super.selectById(billId);
        //设置供方签字信息
        outStoreEntity.setSupOperateTime(supOperateTime);
        outStoreEntity.setSupOperatorName(supOperatorName);
        outStoreEntity.setSupOperatorPhone(supOperatorPhone);
        outStoreEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + outStoreEntity.getId().toString();
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", outStoreEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, outStoreEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            outStoreEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：0-未签字 1-已签字
            // 乙方已签字状态即待甲方签字
            outStoreEntity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(outStoreEntity, false);

            // 调用库存逻辑
            this.inOutStore(outStoreEntity, true);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", outStoreEntity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }

    /*推送供方*/
    @Override
    public boolean pushBillToSupCenter(OutStoreEntity entity) {
        if(null!=entity.getClaimType() && 2==entity.getClaimType()){//1-分包领料，2-内部领料   当领料方式为【内部领料】时，不推协同；历史数据的值都为【分包领料】；
            return false;
        }
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = BILL_TYPE + "::" + entity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());

        //查询对应分包领料人信息
        OutStoreEntity copyEntity = BeanMapper.map(entity, OutStoreEntity.class);
        if(null != copyEntity.getSubEmployeeId()) {
            ProSubPickerEntity picker =  subPickerService.selectById(copyEntity.getSubEmployeeId());
            if(null != picker) {
                copyEntity.setSubEmployeeId(picker.getSupUserId());
            }
        }

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupOutStoreVO supOutStoreVO = BeanMapper.map(copyEntity, SupOutStoreVO.class);
            List<SupOutStoreSubVO> subVOS = BeanMapper.mapList(copyEntity.getOutStoreSubList(), SupOutStoreSubVO.class);
            supOutStoreVO.setOutStoreSubList(subVOS);
            paramMap.put("transData", JSONObject.toJSONString(supOutStoreVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, null, null);
            Map<String, Map<String, InputStream>> files = new HashMap<>();
            if (fileResp.isSuccess()) {
                List<AttachmentVO> fileList = fileResp.getData();
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                //当前单据携带有附件信息
//                if (CollectionUtils.isNotEmpty(fileList)) {
//                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
//                    fileMap.keySet().stream().forEach(fileKey -> {
//                        Map<String, InputStream> file = new HashMap<>(1);
//                        file.put(fileKey, fileMap.get(fileKey));
//                        files.put(fileKey, file);
//                    });
//                }
            } else {
                logger.error("获取出库单据id-{}对应附件信息失败, {}", entity.getId(), fileResp.getMsg());
            }
            logger.info("向供应商-{}推送计量单据参数-{}", entity.getSubSupplierId(), JSONObject.toJSONString(paramMap));
            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                    paramMap, entity.getSubSupplierId().toString(), files);
//                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
//                        paramMap, DEV_TEST_SUPPLIER_ID.toString(), files);
            if (syncReqResp.isSuccess()) {
                CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    logger.error("供方id-{}处理推送订单单据id-{}失败, {}", entity.getSubSupplierId(), entity.getId(), billPushResp.getMsg());
                }
            } else {
                logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", entity.getId(), entity.getSubSupplierId(), syncReqResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("推送出库单据id-{}给供方id-{} 异常，", entity.getId(), entity.getSubSupplierId(), e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }
        return syncFlag;
    }

    /*
     * 撤回推送供方
     *  */
    @Override
    public CommonResponse<String> updatePushBill(OutStoreEntity entity) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = BILL_TYPE + "::" + entity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        baseMapper.updateById(entity);
        logger.info("修改签字信息：{}", JSONObject.toJSONString(entity));
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", entity.getSubSupplierId(), entity.getId());
            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(DELPUSH_BILL_SERVER_URL,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    entity.getSubSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return supHandleResp;
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", entity.getSubSupplierId(), entity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", entity.getSubSupplierId(), entity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", entity.getId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }

    @Override
    public String updateBillConfirmState(OutStoreVO vo) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = BILL_TYPE + "::" + vo.getId().toString() + "::sup";

        //查询当前单据的签字文件
        CommonResponse<List<AttachmentVO>> attachsResp = attachmentApi.queryListBySourceId(vo.getId(), BILL_TYPE, supSignFileSourceType, null);
        if(!attachsResp.isSuccess()) {
            logger.error("查询id-{}单据类型-{}当前签字文件-{},信息失败， {}", vo.getId(), BILL_TYPE, supSignFileSourceType, attachsResp.getMsg());
            return "查询签字文件信息失败!";
        }
//        if(CollectionUtils.isEmpty(attachsResp.getData())) {
//            logger.info("查询id-{}单据类型-{}当前签字文件-{}为空", vo.getId(), BILL_TYPE, supSignFileSourceType);
//            return "没找到匹配的签字文件";
//        }
        AttachmentVO supSignFile = attachsResp.getData().stream().findFirst().orElse(new AttachmentVO());

        CommonResponse<UserVO> userResp = userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if(!userResp.isSuccess()) {
            logger.error("查询当前用户id-{},信息失败， {}", InvocationInfoProxy.getUserid(), userResp.getMsg());
            return "查询当前用户信息失败!";
        }
        UserVO user = userResp.getData();

        //查询当前用户信息
        logger.info("用户{}对单据id-{}进行确认操作！", user.getUserName(), vo.getId());
        OutStoreEntity entity = super.selectById(vo.getId());
        // 校验上架数量
        this.validateStoreNum(BeanMapper.map(entity, OutStoreVO.class));
        // 校验限额数量
        this.validateOutNum(BeanMapper.map(entity, OutStoreVO.class));

        //将当前操作人信息记录在单据中
        entity.setSupOperateTime(new Date());
        entity.setSupOperatorPhone(user.getUserMobile());
        entity.setSupOperatorName(user.getUserName());
        entity.setSupOperatorUserCode(user.getUserCode());
        entity.setSupOperateFileId(supSignFile.getId());
//        entity.setSignStatus(1);// 乙方已签字
        entity.setConfirmState(vo.getConfirmState());

        try {
            //对单据进行加锁
            jedis = jedisPool.getResource();
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if(!locked) {//加锁失败
                releaseLock(jedis, false, key, OPERATE);
                return "单据已被修改，请勿重复操作！";
            }
            //查询用户签字文件流
            Response fileResp = attachmentApi.downloadFileById(supSignFile.getId());
            Map<String, InputStream> signFile = new HashMap<>();
            Map<String, Map<String, InputStream>> files = new HashMap<>();
            Map<String, String> nameSourceTypeMapping = new HashMap<>();
            if(supSignFile.getId() != null){
                signFile.put(supSignFile.getFileName(), fileResp.body().asInputStream());
                files.put(supSignFile.getFileName(), signFile);
                nameSourceTypeMapping.put(supSignFile.getFileName(), supSignFile.getSourceType());
            }

            // 回写参数
            Map<String, String> params = new HashMap<>();
            params.put("nameSourceTypeMapping", JSONObject.toJSONString(nameSourceTypeMapping));
            params.put("billId", entity.getSourceId());
            params.put("supOperatorName", entity.getSupOperatorName());
            params.put("supOperatorPhone", entity.getSupOperatorPhone());
            params.put("supOperatorUserCode", entity.getSupOperatorUserCode());
            params.put("supOperateTime", String.valueOf(entity.getSupOperateTime().getTime()));
            params.put("confirmState", entity.getConfirmState());

            //回写单据签字状态
            logger.info("单据-{}id-{}已签字，通知单据推送方systemId-{},参数-{}", BILL_NAME, entity.getId(), entity.getSystemId(), JSONObject.toJSONString(params));
            CommonResponse<String> backResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_WITER_BACK_SERVER_URL, params, entity.getSubSupplierId().toString(), files);
            logger.error("单据-{}签字信息回写发送请求结果，{}", BILL_NAME, JSONObject.toJSONString(backResp));
            if(!backResp.isSuccess()) {
                logger.error("单据-{}id-{}签字信息回写发送请求失败，{}", BILL_NAME, entity.getId(), backResp.getMsg());
                return BILL_NAME + "确认信息回写发送请求失败";
            }
            if(noPower.equals(backResp.getData())){
                logger.error("发送请求URL-{}给系统-{}失败, {}", BILL_WITER_BACK_SERVER_URL, entity.getSystemId(), backResp.getData());
                return backResp.getData();
            }
            CommonResponse<String> operateResp = JSONObject.parseObject(backResp.getData(), CommonResponse.class);
            if(!operateResp.isSuccess()) {
                logger.error("单据-{}id-{}签字信息回调处理失败，{}", BILL_NAME, entity.getId(), operateResp.getMsg());
                return "确认信息回调处理失败";
            }

            //更新单据
            super.saveOrUpdate(entity, false);

            // 调用库存逻辑
            if("1".equals(vo.getConfirmState())){
                this.inOutStore(entity, true);
            } else if("2".equals(vo.getConfirmState())){
                this.inOutStoreRollback(entity, false);
            }
        } catch (Exception e) {
            logger.error("单据-{}id-{}签字异常，", BILL_NAME, entity.getId(), e);
            msg = "操作失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

    @Override
    public Map<Long, Boolean> queryConfirmEnable(List<Long> projectIds, List<Long> contractIds) {
        if(CollectionUtils.isEmpty(contractIds)){
            return new HashMap<>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        List<ProPickSettingEntity> list = settingService.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return new HashMap<>();
        }
        List<Long> settingIds = list.stream().map(ProPickSettingEntity::getId).collect(Collectors.toList());
        QueryParam cparam = new QueryParam();
        cparam.getParams().put("settingId", new Parameter(QueryParam.IN, settingIds));
        cparam.getParams().put("contractId", new Parameter(QueryParam.IN, contractIds));
        List<ProSubContractorEntity> contList = contractorService.queryList(cparam);
        if(CollectionUtils.isEmpty(contList)){
            return new HashMap<>();
        }
        List<Long> ids = contList.stream().map(x->x.getId()).distinct().collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.IN, contractIds));
//        queryParam.getParams().put("settingSubcontractorId", new Parameter(QueryParam.IN, ids));
        List<ProSubSignerEntity> userList = signerService.queryList(queryParam);
        if(CollectionUtils.isEmpty(userList)){
            return new HashMap<>();
        }
        Map<Long, Boolean> map = new HashMap<>();
        for(ProSubSignerEntity vo : userList){
            if(InvocationInfoProxy.getUserid().equals(vo.getSignEmpId())){
                map.put(vo.getContractId(), true);
            }
        }
        return map;
    }

    @Override
    public OutStoreVO queryDetail(Long id) {
        OutStoreEntity entity = super.selectById(id);
        OutStoreVO vo = BeanMapper.map(entity, OutStoreVO.class);
        // 赋值是否确认人
        List<Long> projectIds = new ArrayList<>(Arrays.asList(vo.getProjectId()));
        List<Long> contractIds = new ArrayList<>(Arrays.asList(vo.getSubContractId()));
        Map<Long, Boolean> confirmMap = this.queryConfirmEnable(projectIds, contractIds);
        if(confirmMap.containsKey(vo.getSubContractId())){
            vo.setConfirmEnable(confirmMap.get(vo.getSubContractId()));
        }
        if(BillStateEnum.COMMITED_STATE.equals(entity.getBillState()) || BillStateEnum.PASSED_STATE.equals(entity.getBillState()) ){
            return vo;
        }
        // 获取库存数量
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List<OutStoreSubVO> detailList = vo.getOutStoreSubList();
        for(OutStoreSubVO detail : detailList){
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if(storeMap.containsKey(key)){
                detail.setStoreNum(storeMap.get(key).getSurplusNum());
            } else {
                detail.setStoreNum(null);
            }
//            // 库存保存即占用，剩余可用量不包含占用量，导致剩余可用量无法包含自身，校验不通过
//            detail.setStoreNum(detail.getStoreNum());
        }
        return vo;
    }

    /**
     * 获取库存数量
     * @param vo
     * @return
     */
    private Map<String, SurplusVO> getStoreMap(OutStoreVO vo){
        Map<Long, List<OutStoreSubVO>> map = vo.getOutStoreSubList().stream().filter(x->x.getStoreId() != null).
                collect(Collectors.groupingBy(OutStoreSubVO::getStoreId));
        Map<String, SurplusVO> storeMap = new HashMap<>();
        if(map.values().stream().flatMap(Collection::stream).count() == 0){
            return storeMap;
        }
        for(Long storeId : map.keySet()){
            ArrayList<SurplusVO> vos = new ArrayList<>();
            for(OutStoreSubVO t : map.get(storeId)){
                SurplusVO surplusVO = new SurplusVO();
                surplusVO.setStoreId(t.getStoreId());
                surplusVO.setMaterialCategoryId(t.getMaterialTypeId());
                surplusVO.setMaterialId(t.getMaterialId());
                surplusVO.setBrandId(t.getBrandId());
                vos.add(surplusVO);
            }
            logger.info("调用库存参数：————"+JSONObject.toJSONString(vos));
            CommonResponse<List<SurplusVO>> response = storeFlowApi.getNewSurplusNum(vos);
            if(!response.isSuccess() || CollectionUtils.isEmpty(response.getData())){
                continue;
            }
            Map<String, SurplusVO> priceMap = response.getData().stream().
                    collect(Collectors.toMap(k ->k.getMaterialId() + "-" + k.getBrandId(), (k) -> k));
            storeMap.putAll(priceMap);
        }
        return storeMap;
    }

    @Override
    public Boolean validateStoreNum(OutStoreVO vo) {
        OutStoreEntity dbEntity = null;
        if(!PlanConstant.INTEGER_YES.equals(vo.getSourceType()) && null != vo.getId()) {
            dbEntity = super.selectById(vo.getId());
        }
        // 获取库存数量
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List<OutStoreSubVO> detailList = vo.getOutStoreSubList().stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        for(OutStoreSubVO detail : detailList){
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if(storeMap.containsKey(key)){
                detail.setStoreNum(storeMap.get(key).getSurplusNum());
                logger.info("key:{}, storeNum:{}", key, detail.getStoreNum());
                if(vo.getId() != null && ((PlanConstant.INTEGER_YES.equals(vo.getSourceType())
                        && (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(vo.getBillState())) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(vo.getBillState()))
                        || (!PlanConstant.INTEGER_YES.equals(vo.getSourceType()) && null != dbEntity))){
                    //自制领料出库，提交占用，非自制的自由态单据  实际库存剩余量 = 将验收量 + 库存剩余量
                    //供方发起，领料单入库即占用，即入库后 实际库存剩余量 = 将验收量 + 库存剩余量
                    detail.setStoreNum(ComputeUtil.safeAdd(detail.getStoreNum(), detail.getNum()));
                }
                if(ComputeUtil.isLessThan(detail.getStoreNum(), detail.getNum())){
                    throw new BusinessException("【" + detail.getMaterialCode() + "】出库数量大于库存可用数量，不允许出库");
                }
            }
        }
        return true;
    }

    @Override
    public Boolean validateOutNum(OutStoreVO vo) {
        if(ClaimTypeEnum.分包领料.getCode().equals(vo.getClaimType())){
            List<OutStoreSubVO> detailList = vo.getOutStoreSubList().stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
            List<Long> materialIds = detailList.stream().map(x->x.getMaterialId()).collect(Collectors.toList());
            Map<Long, BigDecimal> numMap = subsetService.getNumMap(vo.getProjectId(), vo.getSubContractId(), materialIds);
            for(OutStoreSubVO detail : detailList){
                if(numMap.containsKey(detail.getMaterialId()) && ComputeUtil.isGreaterThan(detail.getNum(), numMap.get(detail.getMaterialId()))){
                    throw new BusinessException("【" + detail.getMaterialCode() + "】出库数量大于限额数量，不允许领料出库!");
                }
            }
        }
        return true;
    }

    /**
     * 接收施工方领料出库
     *
     * @param request 施工方领料出库信息
     * @return 保存结果
     */
    @Override
    public boolean saveOutStore(HttpServletRequest request) {
        logger.info("进入领料出库保存接口>>>>>>>>>>>>>>>>>>>>>>>>");
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
        logger.info("接收到数据transData：{}，nameSourceTypeMapping：{}", transData, nameSourceTypeMapping);
        OutStoreVO storeVO = JSONObject.parseObject(transData, OutStoreVO.class);
        if (storeVO == null || storeVO.getId() == null) {
            throw new BusinessException("领料出库信息为空！");
        }
        OutStoreEntity checkEntity = super.selectById(storeVO.getId());
        if (checkEntity != null) {
            logger.info("存在相同sourceID的数据，原数据:{}", JSONObject.toJSONString(checkEntity));
//            throw new BusinessException("领料出库单已在存在！");
        } else {
            storeVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        }

        List<OutStoreSubVO> saveList = storeVO.getOutStoreSubList().stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(saveList)){
            throw new BusinessException("处置清单不能为空!");
        }

        // 校验上架数量
        this.validateStoreNum(storeVO);
        // 校验限额数量
        this.validateOutNum(storeVO);

        OutStoreEntity saveEntity = BeanMapper.map(storeVO, OutStoreEntity.class);
        saveEntity.setTenantId(InvocationInfoProxy.getTenantid());
        saveEntity.setSourceId(String.valueOf(saveEntity.getId()));
        //当前是直接生效状态，如果要调整为非生效状态，需要调整审批回调逻辑
        saveEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        saveEntity.setSignStatus(PlanConstant.SIGN_STATUS_NO);
        for(OutStoreSubEntity detail : saveEntity.getOutStoreSubList()){
            detail.setSourceId(detail.getOutStoreId());
            detail.setSourceDetailId(detail.getId());
        }
        //保存单据中附件并获取到上传后附件的Id
        Map<String, List<Long>> attachIdsMap = FileUtil.getInstance()
                .handleReqFile((MultipartHttpServletRequest) request, mp, BILL_TYPE, authority, null);
        List<Long> attchIdsList = new ArrayList<>();
        for (List<Long> attachIds : attachIdsMap.values()) {
            if (CollectionUtils.isNotEmpty(attachIds)) {
                attchIdsList.addAll(attachIds);
            }
        }
        saveEntity.setAttachIds(attchIdsList);

        List<StoreManageVO> calcVo = getCalcParam(saveEntity);
        //重算价格
        CommonResponse<List<StoreManageVO>> calcResult = storeManageApi.surplusMaterialPriceBatch(calcVo);
        if(!calcResult.isSuccess()) {
            logger.error("接收供方申请 出库单sourceId:{},进行出库单价、金额计算失败: {}", saveEntity.getSourceId(),
                    JSONObject.toJSONString(saveEntity));
            throw new BusinessException("出库单价、金额计算失败！");
        }
        List<StoreManageVO> calcData = calcResult.getData();
        Map<String, UseMaterialPriceVO> priceMap = new HashMap<>();
        for(StoreManageVO m : calcData) {
            priceMap.putAll(m.getUseMaterialPriceVOList()
                    .stream().collect(Collectors.toMap(item -> item.getBrandId().toString()
                            + item.getMaterialId().toString() + m.getStoreId().toString(), item -> item, (v1,v2) -> v1)));
        }

        saveEntity.setOutTaxMny(BigDecimal.ZERO);
        saveEntity.setOutMny(BigDecimal.ZERO);

        saveEntity.getOutStoreSubList().stream().filter(sub ->
                priceMap.containsKey(sub.getBrandId().toString() + sub.getMaterialId().toString() + sub.getStoreId().toString()))
                .forEach(sub -> {
            sub.setTaxMoney(priceMap.get(sub.getBrandId().toString() + sub.getMaterialId().toString() + sub.getStoreId().toString()).getTaxMny());
            sub.setMoney(priceMap.get(sub.getBrandId().toString() + sub.getMaterialId().toString() + sub.getStoreId().toString()).getMny());
            sub.setPrice(ComputeUtil.safeDiv(sub.getMoney(), sub.getNum()));
            sub.setTaxPrice(ComputeUtil.safeDiv(sub.getTaxMoney(), sub.getNum()));
            sub.setOutTax(ComputeUtil.safeSub(sub.getTaxMoney(), sub.getMoney()));
            sub.setTaxRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(sub.getOutTax(), sub.getMoney()), new BigDecimal("100")));

            //重算总金额
            saveEntity.setOutMny(ComputeUtil.safeAdd(saveEntity.getOutMny(), sub.getMoney()));
            saveEntity.setOutTaxMny(ComputeUtil.safeAdd(saveEntity.getOutTaxMny(), sub.getTaxMoney()));
        });




        boolean flag = super.saveOrUpdate(saveEntity, false);

        // 调用库存逻辑
        this.inOutStore(saveEntity, false);

        logger.info("领料出库保存接口结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    private List<StoreManageVO> getCalcParam(OutStoreEntity saveEntity) {
        List<StoreManageVO> resp = new ArrayList<>();
        FlowVO tmpF = null;

        Map<Long, List<OutStoreSubEntity>> storeVosMap = saveEntity.getOutStoreSubList().stream().collect(Collectors.groupingBy(OutStoreSubEntity::getStoreId));

        for(Long storeId : storeVosMap.keySet()) {
            StoreManageVO s = new StoreManageVO();
            s.setSourceId(saveEntity.getId());
            s.setStoreId(storeId);
            for(OutStoreSubEntity sub : storeVosMap.get(storeId)) {
                tmpF = new FlowVO();
                tmpF.setStoreId(storeId);
                tmpF.setMaterialCategoryId(sub.getMaterialTypeId());
                tmpF.setMaterialCategoryCode(sub.getMaterialTypeCode());
                tmpF.setMaterialCategoryName(sub.getMaterialTypeName());
                tmpF.setMaterialId(sub.getMaterialId());
                tmpF.setMaterialCode(sub.getMaterialCode());
                tmpF.setMaterialName(sub.getMaterialName());
                tmpF.setBrandId(sub.getBrandId());
                tmpF.setBrandName(sub.getBrandName());
                tmpF.setNum(sub.getNum());
                if(null == s.getFlowVOList()) {
                    s.setFlowVOList(new ArrayList<>());
                }
                s.getFlowVOList().add(tmpF);
            }
            resp.add(s);
        }

        return resp;
    }

    /**
     * 施工方撤回领料出库
     *
     * @param vo 领料出库信息
     * @return 撤回结果
     */
    @Override
    public boolean delOutStore(OutStoreVO vo) {
        logger.info("进入领料出库单撤回接口>>>>>>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据：{}", JSONObject.toJSONString(vo));
        if (vo.getId() == null) {
            throw new BusinessException("领料出库单不存在");
        }
        OutStoreEntity checkEntity = super.selectById(vo.getId());
        if (checkEntity == null) {
            throw new BusinessException("领料出库单不存在");
        }
        if (vo.getSystemId() == null || !vo.getSystemId().equals(checkEntity.getSystemId())) {
            throw new BusinessException("系统来源不匹配");
        }
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(checkEntity.getId(), BILL_TYPE, null, null);
        // 查询成功并有相应的文件
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
                    .collect(Collectors.joining(","));
            attachmentApi.delete(ids);
        }
        // 调用库存逻辑
        this.inOutStoreRollback(checkEntity, false);
        boolean flag = baseMapper.deleteOutStore(vo.getId());
        logger.info("领料出库单撤回成功<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    /**
     * 查询领料出库列表
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<OutStoreVO> queryOutStoreList(QueryParam param) {
        // 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("storeName");
        // 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<OutStoreEntity> page = super.queryPage(param, false);
        IPage<OutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutStoreVO.class));
        return pageData;
    }

//    /**
//     * 领料出库签字
//     *
//     * @param storeVO 需要签字的领料出库信息
//     * @return 签字结果
//     */
//    @Override
//    public OutStoreVO saveSignStatus(OutStoreVO storeVO) {
//        logger.info("开始通知施工方领料出库单信息>>>>>>>>>>>>>>>>>>>");
//        OutStoreEntity saveEntity = super.selectById(storeVO.getId());
//        saveEntity.setSignStatus(PlanConstant.SIGN_STATUS_YES);
//        saveEntity.setSupOperateTime(new Date());
//        saveEntity.setSupOperatorName(storeVO.getSupOperatorName());
//        saveEntity.setSupOperatorPhone(storeVO.getSupOperatorPhone());
//        saveEntity.setSupOperatorUserCode(storeVO.getSupOperatorUserCode());
//        Map<String, String> paramMap = new HashMap<>();
////        MaterialCheckTbVO tbVO = BeanMapper.map(saveEntity, MaterialCheckTbVO.class);
////        tbVO.setCheckDetailList(BeanMapper.mapList(saveEntity.getMaterialCheckDetailList(), MaterialCheckDetailTbVO
////        .class));
////        paramMap.put("transData", JSONObject.toJSONString(tbVO));
//
//        paramMap.put("billId", CommonUtils.createString(saveEntity.getId()));
//        paramMap.put("supOperatorName", CommonUtils.createString(saveEntity.getSupOperatorName()));
//        paramMap.put("supOperatorPhone", CommonUtils.createString(saveEntity.getSupOperatorPhone()));
//        paramMap.put("supOperatorUserCode", CommonUtils.createString(saveEntity.getSupOperatorUserCode()));
//        paramMap.put("supOperateTime", CommonUtils.createString(saveEntity.getSupOperateTime().getTime()));
//        paramMap.put("confirmState", CommonUtils.createString(saveEntity.getConfirmState()));
//        // 查询文件信息
//        //查询单据附件信息并下载
//        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
//                .queryListBySourceId(saveEntity.getId(), BILL_TYPE, supSignFileSourceType, null);
//        if (!fileResp.isSuccess()) {
//            throw new BusinessException("查询文件信息失败！");
//        }
//        Map<String, Map<String, InputStream>> files = new HashMap<>();
//        List<AttachmentVO> fileList = fileResp.getData();
//
//        //Map<fileName, fileSourceType>
//        Map<String, String> fileSourceTypeMap = new HashMap<>();
//        List<Long> fileIds = new ArrayList<>();
//
//        //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
//        for (AttachmentVO attach : fileList) {
//            fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
//            fileIds.add(attach.getId());
//        }
//        paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
//        //当前单据携带有附件信息
//        if (CollectionUtils.isNotEmpty(fileList)) {
//            Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
//            fileMap.keySet().stream().forEach(fileKey -> {
//                Map<String, InputStream> file = new HashMap<>(1);
//                file.put(fileKey, fileMap.get(fileKey));
//                files.put(fileKey, file);
//            });
//        }
////        String url = pushMaterialCheck;
//        String url = BILL_WITER_BACK_SERVER_URL;
//        String systemId = saveEntity.getSystemId();
//        logger.info("发送参数===url:{},paramMap:[{}],systemId:{},files:{}", url, paramMap, systemId, files);
//        CommonResponse<String> commonResponse = systemDataPushService
//                .exchangeDataAndFilesWithEachLinkSystem(url, paramMap, saveEntity.getSubSupplierId().toString(), files);
//        CommonUtils.checkCommonResponse(commonResponse, logger);
//        super.saveOrUpdate(saveEntity, false);
//        logger.info("通知施工方领料出库单信息结束<<<<<<<<<<<<<<<<<<<<<<");
//        return BeanMapper.map(saveEntity, OutStoreVO.class);
//    }
}
