package com.ejianc.business.zdsmaterial.sub.settle.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleRecordEntity;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleTemplateEntity;
/**
 * 分包结算管理
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_sub_settle")
public class SubSettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 指令单编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_management_id")
    private Long projectManagementId; // 项目经理
    @TableField(value="project_management_name")
    private String projectManagementName; // 项目经理名称
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="sub_contract_id")
    private Long subContractId; // 合同id
    @TableField(value="sub_contract_name")
    private String subContractName; // 合同名称
    @TableField(value="sub_contract_code")
    private String subContractCode; // 合同编码
    @TableField(value="sub_link_id")
    private Long subLinkId; // 分包联系人主键
    @TableField(value="sub_link_name")
    private String subLinkName; // 分包联系人名称
    @TableField(value="sub_link_code")
    private String subLinkCode; // 分包联系人code
    @TableField(value="memo")
    private String memo; // 指令单说明
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="supplier_code")
    private String supplierCode; // 供应商编码
    @TableField(value="price_type")
    private String priceType; // 定价方式
    @TableField(value="specialty_type")
    private String specialtyType; // 专业类别
    @TableField(value="main_contract_mny")
    private BigDecimal mainContractMny; // 主合同金额
    @TableField(value="append_contract_mny")
    private BigDecimal appendContractMny; // 附加合同金额
    @TableField(value="fill_status")
    private Integer fillStatus; // 填报状态,1-待分包上传资料,2-已上传资料,3-审核通过
    @TableField(value="content")
    private String content; // 合同内容
    @TableField(value="source_id")
    private String sourceId; // 来源id
    @TableField(value = "source_system_id")
    private String sourceSystemId;
    @TableField(value="sub_manager_name")
    private String subManagerName; // 乙方项目经理
    @TableField(value="sub_manager_id")
    private Long subManagerId; // 乙方项目经理id
    @TableField(value="create_user_id")
    private Long createUserId; // 创建人id
    @TableField(value="create_user_name")
    private String createUserName; // 创建人name
    @TableField(value="sup_sub_manager_id")
    private Long supSubManagerId; //供方乙方项目经理id
    @TableField(value="sup_sub_link_id")
    private Long supSubLinkId; //供方分包联系人主键
    @TableField(value="settle_mny")
    private BigDecimal settleMny; // 拟报结算金额

    @TableField(exist=false)
    @SubEntity(serviceName="subSettleRecordService", pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<SubSettleRecordEntity> subSettleRecordList = new ArrayList<>(); // 分包结算管理-流转记录表
    @TableField(exist=false)
    @SubEntity(serviceName="subSettleTemplateService", pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<SubSettleTemplateEntity> subSettleTemplateList = new ArrayList<>(); // 分包结算管理-附件模版
    @TableField(exist=false)
    @SubEntity(serviceName="subSettleFileService", pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<SubSettleFileEntity> subSettleFileList = new ArrayList<>(); // 分包结算管理-供方附件


    @TableField(value="mat_worker_id")
    private Long matWorkerId; // 采购工程师
    @TableField(value="mat_worker_name")
    private String matWorkerName; // 采购工程师名称
    @TableField(value="mat_worker_phone")
    private String matWorkerPhone; // 采购工程师电话
    @TableField(value="reject_cause")
    private String rejectCause;//驳回原因

    public String getRejectCause() {
        return rejectCause;
    }

    public void setRejectCause(String rejectCause) {
        this.rejectCause = rejectCause;
    }

    public String getMatWorkerPhone() {
        return matWorkerPhone;
    }

    public void setMatWorkerPhone(String matWorkerPhone) {
        this.matWorkerPhone = matWorkerPhone;
    }

    public Long getMatWorkerId() {
        return matWorkerId;
    }

    public void setMatWorkerId(Long matWorkerId) {
        this.matWorkerId = matWorkerId;
    }

    public String getMatWorkerName() {
        return matWorkerName;
    }

    public void setMatWorkerName(String matWorkerName) {
        this.matWorkerName = matWorkerName;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getSupSubManagerId() {
        return supSubManagerId;
    }

    public void setSupSubManagerId(Long supSubManagerId) {
        this.supSubManagerId = supSubManagerId;
    }

    public Long getSupSubLinkId() {
        return supSubLinkId;
    }

    public void setSupSubLinkId(Long supSubLinkId) {
        this.supSubLinkId = supSubLinkId;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getSubManagerName() {
        return subManagerName;
    }

    public void setSubManagerName(String subManagerName) {
        this.subManagerName = subManagerName;
    }

    public Long getSubManagerId() {
        return subManagerId;
    }

    public void setSubManagerId(Long subManagerId) {
        this.subManagerId = subManagerId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public List<SubSettleFileEntity> getSubSettleFileList() {
        return subSettleFileList;
    }

    public void setSubSettleFileList(List<SubSettleFileEntity> subSettleFileList) {
        this.subSettleFileList = subSettleFileList;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getProjectManagementId() {
        return projectManagementId;
    }

    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }
    public String getProjectManagementName() {
        return projectManagementName;
    }

    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getSubContractId() {
        return subContractId;
    }

    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }
    public String getSubContractName() {
        return subContractName;
    }

    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    public String getSubContractCode() {
        return subContractCode;
    }

    public void setSubContractCode(String subContractCode) {
        this.subContractCode = subContractCode;
    }
    public Long getSubLinkId() {
        return subLinkId;
    }

    public void setSubLinkId(Long subLinkId) {
        this.subLinkId = subLinkId;
    }
    public String getSubLinkName() {
        return subLinkName;
    }

    public void setSubLinkName(String subLinkName) {
        this.subLinkName = subLinkName;
    }
    public String getSubLinkCode() {
        return subLinkCode;
    }

    public void setSubLinkCode(String subLinkCode) {
        this.subLinkCode = subLinkCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSpecialtyType() {
        return specialtyType;
    }

    public void setSpecialtyType(String specialtyType) {
        this.specialtyType = specialtyType;
    }

    public String getPriceType() {
        return priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public BigDecimal getMainContractMny() {
        return mainContractMny;

    }

    public void setMainContractMny(BigDecimal mainContractMny) {
        this.mainContractMny = mainContractMny;
    }
    public BigDecimal getAppendContractMny() {
        return appendContractMny;
    }

    public void setAppendContractMny(BigDecimal appendContractMny) {
        this.appendContractMny = appendContractMny;
    }
    public Integer getFillStatus() {
        return fillStatus;
    }

    public void setFillStatus(Integer fillStatus) {
        this.fillStatus = fillStatus;
    }
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
    
    public List<SubSettleRecordEntity> getSubSettleRecordList() {
        return subSettleRecordList;
    }

    public void setSubSettleRecordList(List<SubSettleRecordEntity> subSettleRecordList) {
        this.subSettleRecordList = subSettleRecordList;
    }
    public List<SubSettleTemplateEntity> getSubSettleTemplateList() {
        return subSettleTemplateList;
    }

    public void setSubSettleTemplateList(List<SubSettleTemplateEntity> subSettleTemplateList) {
        this.subSettleTemplateList = subSettleTemplateList;
    }
}
