/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.fee.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.controller.SubContractController;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractDetailService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.erp.vo.SubContractDetailVO;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"subFeeApplyDetail"})
public class SubFeeApplyDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISubFeeApplyDetailService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISubContractService contractService;
    @Autowired
    private ISubContractDetailService contractDetailService;
    @Autowired
    private SubContractController contractController;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubFeeApplyDetailVO> saveOrUpdate(@RequestBody SubFeeApplyDetailVO saveOrUpdateVO) {
        SubFeeApplyDetailEntity entity = (SubFeeApplyDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SubFeeApplyDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        SubFeeApplyDetailVO vo = (SubFeeApplyDetailVO)BeanMapper.map((Object)((Object)entity), SubFeeApplyDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubFeeApplyDetailVO> queryDetail(Long id) {
        SubFeeApplyDetailEntity entity = (SubFeeApplyDetailEntity)((Object)this.service.selectById(id));
        SubFeeApplyDetailVO vo = (SubFeeApplyDetailVO)BeanMapper.map((Object)((Object)entity), SubFeeApplyDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubFeeApplyDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SubFeeApplyDetailVO subFeeApplyDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubFeeApplyDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubFeeApplyDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubFeeApplyDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubFeeApplyDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubFeeApplyDetailVO>> refSubFeeApplyDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubFeeApplyDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/excelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        List infoCodes;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        ArrayList<SubFeeApplyDetailVO> successList = new ArrayList<SubFeeApplyDetailVO>();
        ArrayList<SubFeeApplyDetailVO> errorList = new ArrayList<SubFeeApplyDetailVO>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            SubFeeApplyDetailVO vo = null;
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                vo = new SubFeeApplyDetailVO();
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setInfoCode((String)datas.get(0));
                vo.setNum(com.ejianc.business.zdsmaterial.util.ComputeUtil.toBigDecimal((String)datas.get(12)));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    vo.setErrorMsg("\u6e05\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(12)))) {
                    vo.setErrorMsg("\u672c\u671f\u5b8c\u5de5\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                vo.setRowState("add");
                successList.add(vo);
            }
        }
        if (CollectionUtils.isNotEmpty(infoCodes = successList.stream().map(x -> x.getInfoCode()).collect(Collectors.toList()))) {
            JSONObject condition = new JSONObject();
            condition.put("contractId", (Object)request.getParameter("contractId"));
            CommonResponse<IPage<SubContractDetailVO>> resp = this.contractController.refSubContractDetailData(0, -1, JSONObject.toJSONString((Object)condition), null, null);
            List list = ((IPage)resp.getData()).getRecords();
            Map<String, SubContractDetailVO> map = list.stream().collect(Collectors.toMap(x -> x.getDetailCode(), x -> x));
            for (SubFeeApplyDetailVO vo : successList) {
                if (!map.containsKey(vo.getInfoCode())) continue;
                SubContractDetailVO detail = map.get(vo.getInfoCode());
                this.transferDetailVO(vo, detail);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", (Object)successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private void transferDetailVO(SubFeeApplyDetailVO vo, SubContractDetailVO detail) {
        vo.setInfoId(detail.getId());
        vo.setContractId(detail.getContractId());
        vo.setSourceInfoId(detail.getSourceDetailId());
        vo.setSourceContractId(detail.getSourceContractId());
        vo.setContractType(String.valueOf(detail.getSourceType() - 1));
        vo.setProjectContent(detail.getProjectContent());
        vo.setPropertyValue(detail.getPropertyValue());
        vo.setUnitId(detail.getDetailUnitId());
        vo.setUnitName(detail.getDetailUnitName());
        vo.setBrandId(String.valueOf(detail.getBrandId()));
        vo.setBrandName(detail.getBrandName());
        vo.setContractNum(detail.getDetailNum());
        vo.setTaxRate(detail.getDetailTaxRate());
        vo.setMaterialPrice(detail.getMaterialPrice());
        vo.setMaterialTaxPrice(detail.getMaterialTaxPrice());
        vo.setHumanPrice(detail.getHumanPrice());
        vo.setHumanTaxPrice(detail.getHumanTaxPrice());
        vo.setComparePrice(detail.getComparePrice());
        vo.setCompareTaxPrice(detail.getCompareTaxPrice());
        vo.setSortId(detail.getSortId());
        vo.setCostCodingId(detail.getCostCodingId());
        vo.setCostCodingName(detail.getCostCodingName());
        vo.setSourceId(detail.getContractId());
        vo.setSourceDetailId(detail.getId());
        vo.setMny(com.ejianc.business.zdsmaterial.util.ComputeUtil.safeMultiply(vo.getComparePrice(), vo.getNum()));
        vo.setTaxMny(com.ejianc.business.zdsmaterial.util.ComputeUtil.safeMultiply(vo.getCompareTaxPrice(), vo.getNum()));
        vo.setLastNum(detail.getLastNum());
        vo.setLastTaxMny(detail.getLastTaxMny());
        vo.setSumNum(ComputeUtil.safeAdd((BigDecimal)detail.getLastNum(), (BigDecimal)vo.getNum()));
        vo.setSumTaxMny(ComputeUtil.safeAdd((BigDecimal)detail.getLastTaxMny(), (BigDecimal)vo.getTaxMny()));
    }
}

