package com.ejianc.business.zdsmaterial.plan.conjecture.handler;

import com.ejianc.business.zdsmaterial.plan.conjecture.ConjectureEnum;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

/**
 * @Author: caojie
 * @CreateTime:2025-02-10 16:12
 * @Version: 1.0
 */
@Component
public class ConjectureManageFactory {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * @description: 获取物料智能识别处理器
     */
    public Future<List<MaterialConjectureVO>> handle(List<MaterialConjectureVO> handleList, String conversionType, String authority) {
        return ContextUtil.getBean(ConjectureEnum.getHandlerNameByCode(conversionType), IMaterialConjectureHandler.class).conjecture(handleList, authority);
    }

    /**
     * @description: 获取物料智能识别处理器
     */
    public Future<MaterialConjectureVO> handleSingle(MaterialConjectureVO handleList, String conversionType, String authority) {
        return ContextUtil.getBean(ConjectureEnum.getHandlerNameByCode(conversionType), IMaterialConjectureHandler.class).conjectureSingle(handleList, authority);
    }

    public Map<Long, MaterialConjectureVO> similarSearch(String conversionType, String searchText, Integer topLimit, String[] queryRange) {
        return similarSearch(conversionType, searchText, topLimit, queryRange, null);
    }
    public Map<Long, MaterialConjectureVO> similarSearch(String conversionType, String searchText, Integer topLimit, String[] queryRange, Integer exactMatch) {
        String handlerClazzName = ConjectureEnum.getHandlerNameByCode(conversionType);
        logger.info("物料相似识别处理类：{}", handlerClazzName);
        IMaterialConjectureHandler handler = ContextUtil.getBean(handlerClazzName, IMaterialConjectureHandler.class);
        return handler.similarSearch(searchText, topLimit, queryRange, exactMatch);
    }
}
