/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.purchase.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.mapper.PurchasePlanDetailMapper;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchasePlanDetailService")
public class PurchasePlanDetailServiceImpl
extends BaseServiceImpl<PurchasePlanDetailMapper, PurchasePlanDetailEntity>
implements IPurchasePlanDetailService {
    @Autowired
    private PurchasePlanDetailMapper mapper;

    @Override
    public List<PurchasePlanDetailVO> selectPlanSumByMaterialIds(List<Long> materialIds, Long projectId) {
        return this.mapper.selectPlanSumByMaterialIds(materialIds, projectId);
    }

    @Override
    public List<PurchaseAnalysisVo> countChangeNum(Map<String, Object> params) {
        return this.mapper.countChangeNum(params);
    }

    @Override
    public List<PurchasePlanDetailEntity> setMaterialNo(List<PurchasePlanDetailEntity> list) {
        for (PurchasePlanDetailEntity e : list) {
            if (null == e.getId()) {
                e.setId(IdWorker.getId());
            }
            e.setMaterialSerialNo("pd-" + e.getId());
        }
        return list;
    }

    @Override
    public List<PurchasePlanDetailVO> findAllByMaterialNos(List<String> materialSerialNos) {
        List<Object> resp = new ArrayList<PurchasePlanDetailVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"material_serial_no", materialSerialNos);
        List eList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, PurchasePlanDetailVO.class);
        }
        return resp;
    }

    @Override
    public List<PurchasePlanDetailEntity> getAllMaterialByProjectAndMaterialIds(Long projectId, List<Long> materialIds, Long planId, List<Integer> billStates) {
        return this.mapper.getAllMaterialByProjectAndMaterialIds(projectId, materialIds, planId, billStates);
    }
}

