package com.ejianc.business.zdsmaterial.erp.service;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 领航发票实体
 * 
 * @author generator
 * 
 */
public interface IErpInvoiceService extends IBaseService<ErpInvoiceEntity> {

    List<ErpInvoiceEntity> getAllBySourceIds(List<String> sourceIds);

    ErpInvoiceEntity getOneById(Long id);

    ErpInvoiceEntity getOneBySourceId(String sourceId);

    List<ErpInvoiceEntity> getAllByIds(List<Long> ids);

    List<ErpInvoiceEntity> getAllByInvoiceNums(List<String> strings);

    /**
     * 查询ERP当日引用发票数据是否包含指定的发票
     *
     * @param invoiceNums
     * @return
     */
    List<String> checkQuote(List<String> invoiceNums, String checkType);


    /**
     * 查询ERP当日引用的发票
     *
     * @return
     */
    JSONArray syncTodayQuotedInvoice(String checkType);
}
