/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.service.IErpMaterialPriceService;
import com.ejianc.business.zdsmaterial.erp.vo.ErpMaterialPriceVO;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceContentService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceContentVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.ConjectureManageFactory;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.pricelib.engine.PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.engine.PricingFactory;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcSubConditionService;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceContractService;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/materialPriceNew"})
public class MaterialPriceNewController {
    @Autowired
    private IMaterialConjectureService materialConjectureService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private ConjectureManageFactory factory;
    @Value(value="${material.ai.handlerName:CJYT}")
    private String handlerName;
    @Autowired
    private IMaterialService materialService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPriceContractService priceContractService;
    @Autowired
    private IMaterialPriceCalcService materialPriceCalcService;
    @Autowired
    private IErpMaterialPriceService erpMaterialPriceService;
    @Autowired
    private IMaterialBasePriceContentService materialBasePriceContentService;
    @Autowired
    private IMaterialPriceCalcSubConditionService priceCalcSubConditionService;
    @Autowired
    private IMaterialCategoryPropertyService propertyService;
    @Autowired
    private IMaterialCategoryPropertySubItemService itemService;

    @PostMapping(value={"/getCategoryTree"})
    public CommonResponse<List<Map<String, Object>>> getCategoryTree(@RequestBody QueryParam param) {
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
        boolean containBasePrice = false;
        List<Object> categoryIds = new ArrayList();
        ArrayList<PriceLibVO> actualList = new ArrayList<PriceLibVO>();
        QueryParam basePriceQuery = new QueryParam();
        List<PriceLibVO> priceLibList = null;
        long startTime = System.nanoTime();
        param.getOrderMap().put("materialTypeId", "asc");
        param.getOrderMap().put("id", "desc");
        JSONObject calcParams = null;
        if (param.getParams().containsKey("clacparams")) {
            calcParams = JSONObject.parseObject((String)((Parameter)param.getParams().get("clacparams")).getValue().toString());
            param.getParams().remove("clacparams");
        }
        if (param.getParams().containsKey("spec")) {
            param.getParams().put("spec", new Parameter("like", (Object)((Parameter)param.getParams().get("spec")).getValue().toString()));
        }
        HashMap<String, MaterialConjectureEntity> conMap = new HashMap<String, MaterialConjectureEntity>();
        if (param.getParams().containsKey("searchAI")) {
            Integer exactMath = null;
            if (param.getParams().containsKey("exactMath")) {
                exactMath = Integer.valueOf(((Parameter)param.getParams().get("exactMath")).getValue().toString());
                param.getParams().remove("exactMath");
            }
            HashMap<Long, MaterialConjectureVO> searchList = new HashMap<Long, MaterialConjectureVO>();
            ArrayList<Object> materialIds = new ArrayList<Object>();
            searchList.putAll(this.factory.similarSearch(this.handlerName, ((Parameter)param.getParams().get("searchAI")).getValue().toString(), null, new String[0], exactMath));
            if (MapUtils.isNotEmpty(searchList)) {
                materialIds.addAll(new ArrayList(searchList.keySet()));
            } else {
                materialIds.addAll(Collections.singletonList(-9L));
            }
            param.getParams().put("materialId", Parameter.getInInstance(materialIds));
            param.getParams().remove("searchAI");
            if (param.getParams().containsKey("categoryId")) {
                param.getParams().put("material_type_id", param.getParams().get("categoryId"));
                param.getParams().remove("categoryId");
            }
            this.logger.debug("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            List<Long> orgIdList = this.priceContractService.queryOrgIdList();
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
            for (PriceLibVO p : priceLibList) {
                if (searchList.containsKey(p.getMaterialId())) {
                    p.setSimilarCoefficient(((MaterialConjectureVO)searchList.get(p.getMaterialId())).getSimilarCoefficient());
                }
                if (categoryIds.contains(p.getMaterialTypeId())) continue;
                categoryIds.add(p.getMaterialTypeId());
            }
            priceLibList.sort((v1, v2) -> {
                if (null == v1.getSimilarCoefficient() && null == v2.getSimilarCoefficient()) {
                    return 0;
                }
                if (null == v1) {
                    return -1;
                }
                if (null == v2) {
                    return 1;
                }
                return v1.getSimilarCoefficient().compareTo(v2.getSimilarCoefficient());
            });
            actualList.addAll(priceLibList);
            basePriceQuery.getParams().put("material_class_id", Parameter.getInInstance(categoryIds));
            if (CollectionUtils.isEmpty(priceLibList)) {
                return CommonResponse.success(new ArrayList());
            }
        } else if (param.getParams().containsKey("curIdentifyId")) {
            List<MaterialConjectureEntity> list;
            HashSet materialIds = new HashSet();
            HashSet materialCode = new HashSet();
            Long categoryId = null;
            if (param.getParams().containsKey("categoryId")) {
                categoryId = Long.valueOf(((Parameter)param.getParams().get("categoryId")).getValue().toString());
                param.getParams().remove("categoryId");
                categoryIds = this.categoryService.queryChildrenIdsByPIds(Collections.singletonList(categoryId));
            }
            if (CollectionUtils.isNotEmpty(list = this.materialConjectureService.getAllByIdentifyId(((Parameter)param.getParams().get("curIdentifyId")).getValue().toString(), null, null, null, null, null, null, null, "1", categoryIds))) {
                ComplexParam c = new ComplexParam();
                c.setLogic("and");
                list.stream().forEach(m -> {
                    conMap.put(m.getActualMaterialCode() + m.getActualUnitName(), (MaterialConjectureEntity)((Object)m));
                    materialIds.add(m.getActualMaterialId());
                    materialCode.add(m.getActualMaterialCode());
                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic("or");
                    c2.getParams().put("material_id", Parameter.getEqInstance((Object)m.getActualMaterialId()));
                    if (null != m.getSupplierId()) {
                        c2.getParams().put("supplier_id", Parameter.getEqInstance((Object)m.getSupplierId()));
                    }
                    if (null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                    }
                    if (null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                    }
                    c.getComplexParams().add(c2);
                });
                param.getParams().put("materialCode", Parameter.getInInstance(new ArrayList(materialCode)));
            }
            param.getParams().remove("curIdentifyId");
            this.logger.debug("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            List<Long> orgIdList = this.priceContractService.queryOrgIdList();
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
            if (CollectionUtils.isEmpty(categoryIds)) {
                categoryIds = list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList());
            }
        } else {
            containBasePrice = true;
            List<Long> orgIdList = this.priceContractService.queryOrgIdList();
            Long categoryId = null;
            if (param.getParams().containsKey("materialClassId")) {
                categoryId = Long.valueOf(((Parameter)param.getParams().get("materialClassId")).getValue().toString());
                categoryIds = this.categoryService.queryChildrenIdsByPIds(Collections.singletonList(categoryId));
                param.getParams().put("materialTypeId", Parameter.getInInstance(categoryIds));
                param.getParams().remove("materialClassId");
            }
            if (param.getParams().containsKey("categoryId")) {
                categoryId = Long.valueOf(((Parameter)param.getParams().get("categoryId")).getValue().toString());
                categoryIds = this.categoryService.queryChildrenIdsByPIds(Collections.singletonList(categoryId));
                param.getParams().put("materialTypeId", Parameter.getInInstance(categoryIds));
                param.getParams().remove("categoryId");
            }
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
        }
        if (CollectionUtils.isEmpty(categoryIds)) {
            return CommonResponse.success(new ArrayList());
        }
        if (param.getParams().containsKey("supplierId")) {
            basePriceQuery.getParams().put("supplierId", param.getParams().get("supplierId"));
        }
        if (param.getParams().containsKey("spec")) {
            basePriceQuery.getParams().put("spec", param.getParams().get("spec"));
        }
        if (param.getParams().containsKey("materialCode")) {
            basePriceQuery.getParams().put("materialCode", param.getParams().get("materialCode"));
        }
        if (param.getParams().containsKey("materialName")) {
            basePriceQuery.getParams().put("materialName", param.getParams().get("materialName"));
        }
        if (param.getParams().containsKey("brand")) {
            basePriceQuery.getParams().put("brandName", param.getParams().get("brand"));
        }
        basePriceQuery.getParams().put("status", Parameter.getEqInstance((Object)"1"));
        basePriceQuery.getParams().put("materialClassId", Parameter.getInInstance(categoryIds));
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        long seconds = TimeUnit.NANOSECONDS.toSeconds(duration);
        this.logger.info("==============\u4ef7\u683c\u67e5\u8be2=\u6570\u636e \u3010\u67e5\u8be2\u3011  \u8017\u65f6 {} \u79d2", (Object)seconds);
        long startTimeTwo = System.nanoTime();
        actualList = this.fillPriceInfo(priceLibList, categoryIds, basePriceQuery, conMap, containBasePrice);
        List<PriceLibVO> pageList = this.getPageData(actualList, (IPage<PriceLibVO>)pageData);
        List<Long> pageCategoryIds = pageList.stream().map(PriceLibVO::getMaterialTypeId).distinct().collect(Collectors.toList());
        this.logger.info("^^^^^^^^^^^^^  pageList {}   ^^^^^^^^^^^^^  ", (Object)JSONObject.toJSONString(pageList));
        if (CollectionUtils.isNotEmpty(pageCategoryIds)) {
            List<MaterialCategoryVO> categoryVOS = this.categoryService.queryCategoryListByChildren(pageCategoryIds);
            List<MaterialPriceCalcVO> dataList = this.materialPriceCalcService.getAllByCategoryIds(pageCategoryIds);
            Map detailMap = dataList.stream().collect(Collectors.toMap(MaterialPriceCalcVO::getCategoryId, Function.identity()));
            categoryVOS.stream().filter(item -> detailMap.containsKey(item.getId())).forEach(item -> {
                item.setMaterialType(((MaterialPriceCalcVO)detailMap.get(item.getId())).getMaterialType());
                item.setMaterialTypeId(((MaterialPriceCalcVO)detailMap.get(item.getId())).getMaterialTypeId());
                item.setMaterialTypeName(((MaterialPriceCalcVO)detailMap.get(item.getId())).getMaterialTypeName());
                item.setEnabled(((MaterialPriceCalcVO)detailMap.get(item.getId())).getEnabled());
                item.setCalcFields(((MaterialPriceCalcVO)detailMap.get(item.getId())).getCalcFields());
            });
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)ResultAsTree.createTreeData((List)BeanMapper.mapList(categoryVOS, Map.class)));
        }
        return CommonResponse.success(new ArrayList());
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<IPage<PriceLibVO>> queryList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
        boolean containBasePrice = false;
        List<Object> categoryIds = new ArrayList();
        ArrayList<PriceLibVO> actualList = new ArrayList<PriceLibVO>();
        QueryParam basePriceQuery = new QueryParam();
        List<PriceLibVO> priceLibList = null;
        long startTime = System.nanoTime();
        param.getOrderMap().put("materialTypeId", "asc");
        param.getOrderMap().put("id", "desc");
        JSONObject calcParams = null;
        if (param.getParams().containsKey("clacparams")) {
            calcParams = JSONObject.parseObject((String)((Parameter)param.getParams().get("clacparams")).getValue().toString());
            param.getParams().remove("clacparams");
        }
        if (param.getParams().containsKey("spec")) {
            param.getParams().put("spec", new Parameter("like", (Object)((Parameter)param.getParams().get("spec")).getValue().toString()));
        }
        HashMap<String, MaterialConjectureEntity> conMap = new HashMap<String, MaterialConjectureEntity>();
        if (param.getParams().containsKey("searchAI")) {
            Integer exactMath = null;
            if (param.getParams().containsKey("exactMath")) {
                exactMath = Integer.valueOf(((Parameter)param.getParams().get("exactMath")).getValue().toString());
                param.getParams().remove("exactMath");
            }
            HashMap<Long, MaterialConjectureVO> searchList = new HashMap<Long, MaterialConjectureVO>();
            ArrayList<Object> materialIds = new ArrayList<Object>();
            searchList.putAll(this.factory.similarSearch(this.handlerName, ((Parameter)param.getParams().get("searchAI")).getValue().toString(), null, new String[0], exactMath));
            if (MapUtils.isNotEmpty(searchList)) {
                materialIds.addAll(new ArrayList(searchList.keySet()));
            } else {
                materialIds.addAll(Collections.singletonList(-9L));
            }
            param.getParams().put("materialId", Parameter.getInInstance(materialIds));
            param.getParams().remove("searchAI");
            if (param.getParams().containsKey("categoryId")) {
                param.getParams().put("material_type_id", param.getParams().get("categoryId"));
                param.getParams().remove("categoryId");
            }
            this.logger.debug("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            List<Long> orgIdList = this.priceContractService.queryOrgIdList();
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
            for (PriceLibVO p2 : priceLibList) {
                if (searchList.containsKey(p2.getMaterialId())) {
                    p2.setSimilarCoefficient(((MaterialConjectureVO)searchList.get(p2.getMaterialId())).getSimilarCoefficient());
                }
                if (categoryIds.contains(p2.getMaterialTypeId())) continue;
                categoryIds.add(p2.getMaterialTypeId());
            }
            priceLibList.sort((v1, v2) -> {
                if (null == v1.getSimilarCoefficient() && null == v2.getSimilarCoefficient()) {
                    return 0;
                }
                if (null == v1) {
                    return -1;
                }
                if (null == v2) {
                    return 1;
                }
                return v1.getSimilarCoefficient().compareTo(v2.getSimilarCoefficient());
            });
            actualList.addAll(priceLibList);
            basePriceQuery.getParams().put("material_class_id", Parameter.getInInstance(categoryIds));
            if (CollectionUtils.isEmpty(priceLibList)) {
                return CommonResponse.success((Object)pageData);
            }
        } else if (param.getParams().containsKey("curIdentifyId")) {
            List<MaterialConjectureEntity> list;
            HashSet materialIds = new HashSet();
            HashSet materialCode = new HashSet();
            Long categoryId = null;
            if (param.getParams().containsKey("categoryId")) {
                categoryId = Long.valueOf(((Parameter)param.getParams().get("categoryId")).getValue().toString());
                param.getParams().remove("categoryId");
                categoryIds = this.categoryService.queryChildrenIdsByPIds(Collections.singletonList(categoryId));
            }
            if (CollectionUtils.isNotEmpty(list = this.materialConjectureService.getAllByIdentifyId(((Parameter)param.getParams().get("curIdentifyId")).getValue().toString(), null, null, null, null, null, null, null, "1", categoryIds))) {
                ComplexParam c = new ComplexParam();
                c.setLogic("and");
                list.stream().forEach(m -> {
                    conMap.put(m.getActualMaterialCode() + m.getActualUnitName(), (MaterialConjectureEntity)((Object)m));
                    materialIds.add(m.getActualMaterialId());
                    materialCode.add(m.getActualMaterialCode());
                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic("or");
                    c2.getParams().put("material_id", Parameter.getEqInstance((Object)m.getActualMaterialId()));
                    if (null != m.getSupplierId()) {
                        c2.getParams().put("supplier_id", Parameter.getEqInstance((Object)m.getSupplierId()));
                    }
                    if (null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                    }
                    if (null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                    }
                    c.getComplexParams().add(c2);
                });
                param.getParams().put("materialCode", Parameter.getInInstance(new ArrayList(materialCode)));
            }
            param.getParams().remove("curIdentifyId");
            this.logger.debug("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            List<Long> orgIdList = this.priceContractService.queryOrgIdList();
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
            if (CollectionUtils.isEmpty(categoryIds)) {
                categoryIds = list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList());
            }
        } else {
            containBasePrice = true;
            List<Long> orgIdList = this.priceContractService.queryOrgIdList();
            Long categoryId = null;
            if (param.getParams().containsKey("materialClassId")) {
                categoryId = Long.valueOf(((Parameter)param.getParams().get("materialClassId")).getValue().toString());
                categoryIds = this.categoryService.queryChildrenIdsByPIds(Collections.singletonList(categoryId));
                param.getParams().put("materialTypeId", Parameter.getInInstance(categoryIds));
                param.getParams().remove("materialClassId");
            }
            if (param.getParams().containsKey("categoryId")) {
                categoryId = Long.valueOf(((Parameter)param.getParams().get("categoryId")).getValue().toString());
                categoryIds = this.categoryService.queryChildrenIdsByPIds(Collections.singletonList(categoryId));
                param.getParams().put("materialTypeId", Parameter.getInInstance(categoryIds));
                param.getParams().remove("categoryId");
            }
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
        }
        if (CollectionUtils.isEmpty(categoryIds)) {
            return CommonResponse.success((Object)pageData);
        }
        if (param.getParams().containsKey("supplierId")) {
            basePriceQuery.getParams().put("supplierId", param.getParams().get("supplierId"));
        }
        if (param.getParams().containsKey("spec")) {
            basePriceQuery.getParams().put("spec", param.getParams().get("spec"));
        }
        if (param.getParams().containsKey("materialCode")) {
            basePriceQuery.getParams().put("materialCode", param.getParams().get("materialCode"));
        }
        if (param.getParams().containsKey("materialName")) {
            basePriceQuery.getParams().put("materialName", param.getParams().get("materialName"));
        }
        if (param.getParams().containsKey("brand")) {
            basePriceQuery.getParams().put("brandName", param.getParams().get("brand"));
        }
        basePriceQuery.getParams().put("status", Parameter.getEqInstance((Object)"1"));
        basePriceQuery.getParams().put("materialClassId", Parameter.getInInstance(categoryIds));
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        long seconds = TimeUnit.NANOSECONDS.toSeconds(duration);
        this.logger.info("==============\u4ef7\u683c\u67e5\u8be2=\u6570\u636e \u3010\u67e5\u8be2\u3011  \u8017\u65f6 {} \u79d2", (Object)seconds);
        long startTimeTwo = System.nanoTime();
        actualList = this.fillPriceInfo(priceLibList, categoryIds, basePriceQuery, conMap, containBasePrice);
        List<PriceLibVO> pageList = this.getPageData(actualList, (IPage<PriceLibVO>)pageData);
        List pageCategoryIds = pageList.stream().map(PriceLibVO::getMaterialTypeId).distinct().collect(Collectors.toList());
        Map curParamMap = null;
        JSONObject calcFieldJson = null;
        if (null != calcParams && CollectionUtils.isNotEmpty(pageList)) {
            for (PriceLibVO p3 : pageList) {
                pageCategoryIds.add(p3.getMaterialTypeId());
                if (!calcParams.containsKey((Object)p3.getMaterialTypeId().toString())) continue;
                curParamMap = (Map)JSONObject.parseObject((String)calcParams.getString(p3.getMaterialTypeId().toString()), Map.class);
                calcFieldJson = new JSONObject();
                for (String key : curParamMap.keySet()) {
                    if ("baseMaterialNetPrice".equals(key)) {
                        p3.setBaseMaterialNetPrice(ComputeUtil.toBigDecimal(curParamMap.get(key).toString()));
                        continue;
                    }
                    calcFieldJson.put(key, (Object)curParamMap.get(key).toString());
                }
                p3.setCalcFields(calcFieldJson.toJSONString());
            }
        }
        if (CollectionUtils.isEmpty(pageCategoryIds)) {
            return CommonResponse.success((Object)pageData);
        }
        List<MaterialCategoryVO> categoryVOS = this.categoryService.queryCategoryListByIds(new ArrayList<Long>(pageCategoryIds));
        Map<Long, MaterialCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<Long, List<MaterialPriceCalcSubConditionVO>> conditionMap = this.materialPriceCalcService.getConditionMapByCategoryIds(categoryIds);
        Map<Long, List<MaterialCategoryPropertyVO>> categoryPropertyMap = this.propertyService.getAllByCategoryIds(new ArrayList<Long>(pageCategoryIds), 1);
        Map<Long, List<MaterialCategoryPropertySubItemVO>> categoryItemMap = this.itemService.getCategoryItemMap(new ArrayList<Long>(pageCategoryIds), 1);
        Map<Long, Map> propertyIdMapGroupCategory = categoryPropertyMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()))));
        Map<Long, Map> itemIdMapGroupCategory = categoryItemMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()))));
        long endTimeTwo = System.nanoTime();
        long durationTwo = endTimeTwo - startTimeTwo;
        long secondsTwo = TimeUnit.NANOSECONDS.toSeconds(durationTwo);
        this.logger.info("==============\u4ef7\u683c\u67e5\u8be2=\u6570\u636e \u3010\u51c6\u5907\u3011 \u8017\u65f6 {} \u79d2", (Object)secondsTwo);
        long startTimeThr = System.nanoTime();
        pageList.parallelStream().forEach(p -> {
            try {
                Long categoryId = p.getMaterialTypeId();
                this.logger.info("p-categoryId:{}\uff0cmaterialId:{}", (Object)categoryId, (Object)p.getMaterialId());
                if (null == categoryId) {
                    this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u7269\u6599\u5bf9\u5e94\u5206\u7c7b\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString((Object)p));
                    p.setAdjustedPrice(BigDecimal.ZERO);
                } else {
                    MaterialCategoryVO tmpC = (MaterialCategoryVO)categoryVOMap.get(p.getMaterialTypeId());
                    if (null == tmpC) {
                        this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u7269\u6599\u5bf9\u5e94\u5206\u7c7b\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString((Object)p));
                        p.setAdjustedPrice(BigDecimal.ZERO);
                    } else {
                        this.logger.debug("\u67e5\u8be2\u5206\u7c7bid-{},\u7f16\u7801-{}\u5bf9\u5e94\u7684\u5206\u7c7b\u5f15\u64ce", (Object)tmpC.getId(), (Object)tmpC.getCode());
                        p.setCategoryVO(tmpC);
                        p.setPropertyMap((Map)propertyIdMapGroupCategory.get(p.getMaterialTypeId()));
                        p.setItemMap((Map)itemIdMapGroupCategory.get(p.getMaterialTypeId()));
                        PricingEngine engine = PricingFactory.getEngine(((MaterialCategoryVO)categoryVOMap.get(p.getMaterialTypeId())).getCode());
                        if (null != engine) {
                            engine.calcPrice((PriceLibVO)p, (List)conditionMap.get(p.getMaterialTypeId()));
                        } else {
                            this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u5bf9\u5e94\u8ba1\u7b97\u5f15\u64ce\u4e3a\u7a7a", (Object)JSONObject.toJSONString((Object)p));
                            p.setAdjustedPrice(BigDecimal.ZERO);
                        }
                        tmpC = null;
                    }
                    categoryId = null;
                }
            }
            catch (Exception e) {
                this.logger.error("\u7269\u6599: {}\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)p));
                this.logger.error("\u7269\u6599\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
                p.setAdjustedPrice(BigDecimal.ZERO);
            }
            if (StringUtils.isNotBlank((CharSequence)p.getCalcContent()) && !p.getCalcContent().contains("\u672a\u8ba1\u7b97")) {
                p.setAdjustedRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeSub(p.getAdjustedPrice(), p.getBaseMaterialPrice()), p.getBaseMaterialPrice()), new BigDecimal("100")));
            }
            p.setCategoryVO(null);
            p.setPriceCheckList(null);
            p.setPriceContractList(null);
            p.setPriceSettlementList(null);
            p.setItemMap(null);
            p.setPropertyMap(null);
        });
        long endTimeThr = System.nanoTime();
        long durationThr = endTimeThr - startTimeThr;
        long secondsThr = TimeUnit.NANOSECONDS.toSeconds(durationThr);
        this.logger.info("==============\u4ef7\u683c\u67e5\u8be2=\u6570\u636e \u3010\u8ba1\u7b97\u3011 \u8017\u65f6 {} \u79d2,\u5904\u7406\u6570\u636e\uff1a{} \u6761", (Object)secondsThr, (Object)pageList.size());
        pageData.setRecords(pageList);
        return CommonResponse.success((Object)pageData);
    }

    private List<PriceLibVO> getPageData(List<PriceLibVO> allList, IPage<PriceLibVO> page) {
        List<PriceLibVO> pageList = new ArrayList<PriceLibVO>();
        if (CollectionUtils.isEmpty(allList)) {
            page.setPages(0L);
            page.setTotal(0L);
            page.setRecords(pageList);
            return pageList;
        }
        long pageNumber = page.getCurrent();
        long pageSize = page.getSize();
        page.setTotal((long)allList.size());
        int totalPages = (int)Math.ceil((double)allList.size() / (double)pageSize);
        page.setPages((long)totalPages);
        if (pageNumber < 1L) {
            pageNumber = 1L;
        }
        if (pageNumber > (long)totalPages && totalPages > 0) {
            pageNumber = totalPages;
        }
        Long fromIndex = (pageNumber - 1L) * pageSize;
        Long toIndex = Math.min(fromIndex + pageSize, page.getTotal());
        if (fromIndex >= page.getTotal()) {
            page.setRecords(pageList);
        } else {
            pageList = allList.subList(fromIndex.intValue(), toIndex.intValue());
        }
        return pageList;
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<Long> categoryIds = new ArrayList<Long>();
        List<Object> actualList = new ArrayList();
        QueryParam basePriceQuery = new QueryParam();
        List<PriceLibVO> priceLibList = null;
        HashMap<String, MaterialConjectureEntity> conMap = new HashMap<String, MaterialConjectureEntity>();
        JSONObject calcParams = null;
        if (param.getParams().containsKey("clacparams")) {
            calcParams = JSONObject.parseObject((String)((Parameter)param.getParams().get("clacparams")).getValue().toString());
            param.getParams().remove("clacparams");
        }
        if (param.getParams().containsKey("searchAI")) {
            Integer exactMath = null;
            if (param.getParams().containsKey("exactMath")) {
                exactMath = Integer.valueOf(((Parameter)param.getParams().get("exactMath")).getValue().toString());
                param.getParams().remove("exactMath");
            }
            HashMap<Long, MaterialConjectureVO> searchList = new HashMap<Long, MaterialConjectureVO>();
            ArrayList<Object> materialIds = new ArrayList<Object>();
            searchList.putAll(this.factory.similarSearch(this.handlerName, ((Parameter)param.getParams().get("searchAI")).getValue().toString(), null, new String[0], exactMath));
            if (MapUtils.isNotEmpty(searchList)) {
                materialIds.addAll(new ArrayList(searchList.keySet()));
            } else {
                materialIds.addAll(Collections.singletonList(-9L));
            }
            param.getParams().put("materialId", Parameter.getInInstance(materialIds));
            param.getParams().remove("searchAI");
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            List<Long> list = this.priceContractService.queryOrgIdList();
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, list, param);
            if (param.getParams().containsKey("categoryId")) {
                param.getParams().put("material_type_id", param.getParams().get("categoryId"));
                param.getParams().remove("categoryId");
            }
            for (PriceLibVO p2 : priceLibList) {
                if (searchList.containsKey(p2.getMaterialId())) {
                    p2.setSimilarCoefficient(((MaterialConjectureVO)searchList.get(p2.getMaterialId())).getSimilarCoefficient());
                }
                if (categoryIds.contains(p2.getMaterialTypeId())) continue;
                categoryIds.add(p2.getMaterialTypeId());
            }
            priceLibList.sort((v1, v2) -> {
                if (null == v1.getSimilarCoefficient() && null == v2.getSimilarCoefficient()) {
                    return 0;
                }
                if (null == v1) {
                    return -1;
                }
                if (null == v2) {
                    return 1;
                }
                return v1.getSimilarCoefficient().compareTo(v2.getSimilarCoefficient());
            });
            actualList.addAll(priceLibList);
            basePriceQuery.getParams().put("material_class_id", Parameter.getInInstance(categoryIds));
        } else if (param.getParams().containsKey("curIdentifyId")) {
            HashSet materialIds = new HashSet();
            HashSet materialCode = new HashSet();
            Map pageParams = param.getParams();
            List<MaterialConjectureEntity> list = this.materialConjectureService.getAllByIdentifyId(((Parameter)param.getParams().get("curIdentifyId")).getValue().toString(), null, null, null, pageParams.containsKey("materialName") ? ((Parameter)pageParams.get("materialName")).getValue().toString() : null, pageParams.containsKey("spec") ? ((Parameter)pageParams.get("spec")).getValue().toString() : null, null, null, "1");
            if (CollectionUtils.isNotEmpty(list)) {
                ComplexParam c = new ComplexParam();
                c.setLogic("and");
                list.stream().forEach(m -> {
                    conMap.put(m.getActualMaterialCode() + m.getActualUnitName(), (MaterialConjectureEntity)((Object)((Object)m)));
                    materialIds.add(m.getActualMaterialId());
                    materialCode.add(m.getActualMaterialCode());
                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic("or");
                    c2.getParams().put("material_id", Parameter.getEqInstance((Object)m.getActualMaterialId()));
                    if (null != m.getSupplierId()) {
                        c2.getParams().put("supplier_id", Parameter.getEqInstance((Object)m.getSupplierId()));
                    }
                    if (null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                    }
                    if (null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                    }
                    c.getComplexParams().add(c2);
                });
                param.getParams().put("materialCode", Parameter.getInInstance(new ArrayList(materialCode)));
            }
            param.getParams().remove("curIdentifyId");
            this.logger.debug("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            List<Long> orgIdList = this.priceContractService.queryOrgIdList();
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
            if (CollectionUtils.isEmpty(categoryIds)) {
                categoryIds = list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList());
            }
        }
        basePriceQuery.getParams().put("status", Parameter.getEqInstance((Object)"1"));
        basePriceQuery.getParams().put("materialClassId", Parameter.getInInstance(categoryIds));
        actualList = this.fillPriceInfo(priceLibList, categoryIds, basePriceQuery, conMap);
        Map curParamMap = null;
        JSONObject calcFieldJson = null;
        if (null != calcParams && CollectionUtils.isNotEmpty(actualList)) {
            for (PriceLibVO priceLibVO : actualList) {
                if (!calcParams.containsKey((Object)priceLibVO.getMaterialTypeId().toString())) continue;
                curParamMap = (Map)JSONObject.parseObject((String)calcParams.getString(priceLibVO.getMaterialTypeId().toString()), Map.class);
                calcFieldJson = new JSONObject();
                for (String key : curParamMap.keySet()) {
                    if ("baseMaterialNetPrice".equals(key)) {
                        priceLibVO.setBaseMaterialNetPrice(ComputeUtil.toBigDecimal(curParamMap.get(key).toString()));
                        continue;
                    }
                    calcFieldJson.put(key, (Object)curParamMap.get(key).toString());
                }
                priceLibVO.setCalcFields(calcFieldJson.toJSONString());
            }
        }
        List<MaterialCategoryVO> categoryVOS = this.categoryService.queryCategoryListByIds(categoryIds);
        Map<Long, MaterialCategoryVO> map = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<Long, List<MaterialPriceCalcSubConditionVO>> conditionMap = this.materialPriceCalcService.getConditionMapByCategoryIds(categoryIds);
        actualList.parallelStream().forEach(p -> {
            try {
                Long categoryId = p.getMaterialTypeId();
                this.logger.info("p-categoryId:{}\uff0cmaterialId:{}", (Object)categoryId, (Object)p.getMaterialId());
                if (null == categoryId) {
                    this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u7269\u6599\u5bf9\u5e94\u5206\u7c7b\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString((Object)p));
                    p.setAdjustedPrice(BigDecimal.ZERO);
                } else {
                    MaterialCategoryVO tmpC = (MaterialCategoryVO)categoryVOMap.get(p.getMaterialTypeId());
                    if (null == tmpC) {
                        this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u7269\u6599\u5bf9\u5e94\u5206\u7c7b\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString((Object)p));
                        p.setAdjustedPrice(BigDecimal.ZERO);
                    } else {
                        this.logger.debug("\u67e5\u8be2\u5206\u7c7bid-{},\u7f16\u7801-{}\u5bf9\u5e94\u7684\u5206\u7c7b\u5f15\u64ce", (Object)tmpC.getId(), (Object)tmpC.getCode());
                        PricingEngine engine = PricingFactory.getEngine(((MaterialCategoryVO)categoryVOMap.get(p.getMaterialTypeId())).getCode());
                        if (null != engine) {
                            engine.calcPrice((PriceLibVO)p, (List)conditionMap.get(p.getMaterialTypeId()));
                        } else {
                            this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u5bf9\u5e94\u8ba1\u7b97\u5f15\u64ce\u4e3a\u7a7a", (Object)JSONObject.toJSONString((Object)p));
                            p.setAdjustedPrice(BigDecimal.ZERO);
                        }
                        tmpC = null;
                    }
                    categoryId = null;
                }
            }
            catch (Exception e) {
                this.logger.error("\u7269\u6599: {}\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)p));
                this.logger.error("\u7269\u6599\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
                p.setAdjustedPrice(BigDecimal.ZERO);
            }
            if (StringUtils.isNotBlank((CharSequence)p.getCalcContent()) && !p.getCalcContent().contains("\u672a\u8ba1\u7b97")) {
                p.setAdjustedRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeSub(p.getAdjustedPrice(), p.getBaseMaterialPrice()), p.getBaseMaterialPrice()), new BigDecimal("100")));
            }
        });
        HashMap<String, List<Object>> beans = new HashMap<String, List<Object>>();
        beans.put("records", actualList);
        ExcelExport.getInstance().export("priceLib-export.xlsx", beans, response);
    }

    @PostMapping(value={"/changeLoadStatus"})
    @ResponseBody
    public CommonResponse<List<PriceLibVO>> changeLoadStatus(@RequestBody List<Long> ids, @RequestParam String loadState) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", ids);
        update.set((Object)"load_state", (Object)loadState);
        update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
        update.set((Object)"update_time", (Object)new Date());
        this.materialConjectureService.update((Wrapper)update);
        QueryParam param = new QueryParam();
        QueryParam basePriceQuery = new QueryParam();
        HashMap<String, MaterialConjectureEntity> conMap = new HashMap<String, MaterialConjectureEntity>();
        HashSet materialCodes = new HashSet();
        List list = (List)this.materialConjectureService.listByIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ComplexParam c = new ComplexParam();
            c.setLogic("and");
            list.stream().forEach(m -> {
                conMap.put(m.getActualMaterialCode() + m.getActualUnitName(), (MaterialConjectureEntity)((Object)m));
                materialCodes.add(m.getActualMaterialCode());
                ComplexParam c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("material_id", Parameter.getEqInstance((Object)m.getActualMaterialId()));
                if (null != m.getSupplierId()) {
                    c2.getParams().put("supplier_id", Parameter.getEqInstance((Object)m.getSupplierId()));
                }
                if (null != m.getBrandId()) {
                    c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                }
                if (null != m.getBrandId()) {
                    c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                }
                c.getComplexParams().add(c2);
            });
            param.getParams().put("materialCode", Parameter.getInInstance(new ArrayList(materialCodes)));
            param.getParams().remove("curIdentifyId");
        }
        this.logger.debug("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        List<Long> orgIdList = this.priceContractService.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
        List<Long> categoryIds = list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList());
        basePriceQuery.getParams().put("materialClassId", Parameter.getInInstance(categoryIds));
        List<PriceLibVO> actualList = this.fillPriceInfo(priceLibList, categoryIds, basePriceQuery, conMap);
        this.calcMaterial(categoryIds, actualList);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", actualList);
    }

    private List<PriceLibVO> calcMaterial(List<Long> categoryIds, List<PriceLibVO> actualList) {
        List<MaterialCategoryVO> categoryVOS = this.categoryService.queryCategoryListByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<Long, List<MaterialPriceCalcSubConditionVO>> conditionMap = this.materialPriceCalcService.getConditionMapByCategoryIds(categoryIds);
        actualList.parallelStream().forEach(p -> {
            try {
                PricingEngine engine = PricingFactory.getEngine(((MaterialCategoryVO)categoryVOMap.get(p.getMaterialTypeId())).getCode());
                if (null != engine) {
                    engine.calcPrice((PriceLibVO)p, (List)conditionMap.get(p.getMaterialTypeId()));
                } else {
                    this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u5bf9\u5e94\u8ba1\u7b97\u5f15\u64ce\u4e3a\u7a7a", (Object)JSONObject.toJSONString((Object)p));
                    p.setAdjustedPrice(BigDecimal.ZERO);
                    p.setCalcContent("\u672a\u5339\u914d\u5230\u5bf9\u5e94\u8ba1\u7b97\u5f15\u64ce");
                }
            }
            catch (Exception e) {
                this.logger.error("\u7269\u6599: {}\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)p));
                this.logger.error("\u7269\u6599\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
                p.setCalcContent("\u4ef7\u683c\u8ba1\u7b97\u5931\u8d25");
                p.setAdjustedPrice(BigDecimal.ZERO);
            }
            if (StringUtils.isNotBlank((CharSequence)p.getCalcContent()) && !p.getCalcContent().contains("\u672a\u8ba1\u7b97")) {
                p.setAdjustedRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeSub(p.getAdjustedPrice(), p.getBaseMaterialPrice()), p.getBaseMaterialPrice()), new BigDecimal("100")));
            }
        });
        return actualList;
    }

    @PostMapping(value={"/reCalc"})
    public CommonResponse<List<PriceLibVO>> reCalc(@RequestBody List<PriceLibVO> vos) {
        ArrayList<Long> categoryIds = new ArrayList<Long>(vos.stream().map(PriceLibVO::getMaterialTypeId).collect(Collectors.toSet()));
        List<MaterialCategoryVO> categoryVOS = this.categoryService.queryCategoryListByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        this.calcMaterial(categoryIds, vos);
        return CommonResponse.success((String)"\u8ba1\u7b97\u6210\u529f\uff01", vos);
    }

    public List<PriceLibVO> fillPriceInfo(List<PriceLibVO> vos, List<Long> categoryIds, QueryParam basePriceQuery, Map<String, MaterialConjectureEntity> conMap, boolean containBasePrice) {
        PriceLibVO tmpP;
        basePriceQuery.getOrderMap().put("materialClassId", "asc");
        basePriceQuery.getOrderMap().put("id", "desc");
        List<MaterialBasePriceContentVO> pricevos = this.materialBasePriceContentService.getLatestPrice(basePriceQuery);
        Map<Object, Object> priceMap = new HashMap();
        if (CollectionUtils.isNotEmpty(pricevos)) {
            priceMap = pricevos.stream().collect(Collectors.groupingBy(item -> item.getMaterialCode()));
        }
        List<MaterialCategoryVO> categoryVOS = this.categoryService.getAllByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        List<MaterialPriceCalcVO> priceCalcVOS = this.materialPriceCalcService.getAllByCategoryIds(categoryIds);
        HashMap<Long, MaterialPriceCalcVO> priceCalcVOMap = new HashMap<Long, MaterialPriceCalcVO>();
        priceCalcVOMap.putAll(priceCalcVOS.stream().collect(Collectors.toMap(item -> item.getCategoryId(), item -> item)));
        HashMap<Long, ErpMaterialPriceVO> netPriceMap = new HashMap<Long, ErpMaterialPriceVO>();
        if (CollectionUtils.isNotEmpty(priceCalcVOS)) {
            List<ErpMaterialPriceVO> erpMaterialPriceVOS = this.erpMaterialPriceService.getAllByErpMaterialIds(priceCalcVOS.stream().map(MaterialPriceCalcVO::getMaterialTypeId).collect(Collectors.toList()));
            netPriceMap.putAll(erpMaterialPriceVOS.stream().collect(Collectors.toMap(item -> item.getBaseMaterialId(), item -> item)));
        }
        MaterialConjectureEntity tmpC = null;
        ArrayList<PriceLibVO> actualList = new ArrayList<PriceLibVO>();
        PriceLibVO tmp = null;
        ArrayList<PriceLibVO> processList = new ArrayList<PriceLibVO>();
        HashSet<String> resultMaterialCodeList = new HashSet<String>();
        for (PriceLibVO priceLibVO : vos) {
            if (!categoryMap.containsKey(priceLibVO.getMaterialTypeId())) continue;
            tmpC = conMap.get(priceLibVO.getMaterialId().toString() + priceLibVO.getUnitName());
            if (null != tmpC) {
                conMap.remove(priceLibVO.getMaterialCode() + priceLibVO.getUnitName());
                priceLibVO.setId(tmpC.getId());
                priceLibVO.setBrand(tmpC.getBrandName());
                priceLibVO.setBrandId(tmpC.getBrandId());
                priceLibVO.setSupplierName(tmpC.getSupplierName());
                priceLibVO.setSupplierId(tmpC.getSupplierId());
                priceLibVO.setExtParam1(tmpC.getExtParam1());
                priceLibVO.setExtParam2(tmpC.getExtParam2());
                priceLibVO.setSourceNum(tmpC.getSourceNum());
                priceLibVO.setSourceMaterialName(tmpC.getSourceMaterialName());
                priceLibVO.setSourceUnitName(tmpC.getSourceUnitName());
                priceLibVO.setSourceMaterialSpec(tmpC.getSourceMaterialSpec());
            }
            resultMaterialCodeList.add(priceLibVO.getMaterialCode());
            processList.add(priceLibVO);
        }
        if (!conMap.isEmpty()) {
            tmpP = null;
            for (MaterialConjectureEntity c : conMap.values()) {
                if (!categoryMap.containsKey(c.getActualCategoryId())) continue;
                tmpP = new PriceLibVO();
                tmpP.setId(c.getId());
                tmpP.setMaterialId(c.getActualMaterialId());
                tmpP.setMaterialCode(c.getActualMaterialCode());
                tmpP.setMaterialName(c.getActualMaterialName());
                tmpP.setMaterialTypeId(c.getActualCategoryId());
                if (categoryMap.containsKey(c.getActualCategoryId())) {
                    tmpP.setMaterialTypeName(categoryMap.get(c.getActualCategoryId()).getName());
                }
                tmpP.setBrand(c.getBrandName());
                tmpP.setBrandId(c.getBrandId());
                tmpP.setSupplierName(c.getSupplierName());
                tmpP.setSupplierId(c.getSupplierId());
                tmpP.setSpec(c.getActualMaterialSpec());
                tmpP.setUnitName(c.getActualUnitName());
                tmpP.setUnitId(c.getActualUnitId());
                tmpP.setExtParam1(c.getExtParam1());
                tmpP.setExtParam2(c.getExtParam2());
                tmpP.setSourceNum(c.getSourceNum());
                tmpP.setSourceMaterialName(c.getSourceMaterialName());
                tmpP.setSourceUnitName(c.getSourceUnitName());
                tmpP.setSourceMaterialSpec(c.getSourceMaterialSpec());
                processList.add(tmpP);
            }
        }
        if (containBasePrice) {
            tmpP = null;
            for (MaterialBasePriceContentVO p : pricevos) {
                if (resultMaterialCodeList.contains(p.getMaterialCode())) continue;
                tmpP = new PriceLibVO();
                tmpP.setId(p.getId());
                tmpP.setBrand(p.getBrandName());
                tmpP.setBrandId(p.getBrandId());
                tmpP.setSupplierName(p.getSupplierName());
                tmpP.setSupplierId(p.getSupplierId());
                tmpP.setExtParam1(null != p.getGrooveWeight() ? p.getGrooveWeight().toPlainString() : null);
                tmpP.setExtParam2(null != p.getLidWeight() ? p.getLidWeight().toPlainString() : null);
                tmpP.setUnitName(p.getUnitName());
                tmpP.setSpec(p.getSpec());
                tmpP.setAreaName(p.getAreaName());
                tmpP.setArea(p.getAreaName());
                tmpP.setMaterialId(p.getMaterialId());
                tmpP.setMaterialName(p.getMaterialName());
                tmpP.setMaterialCode(p.getMaterialCode());
                tmpP.setMaterialTypeId(p.getMaterialClassId());
                tmpP.setMaterialTypeName(p.getMaterialClassName());
                tmpP.setContractName(p.getContractName());
                tmpP.setProjectId(p.getProjectId());
                tmpP.setProjectCode(p.getProjectCode());
                tmpP.setProjectCode(p.getProjectCode());
                tmpP.setUnitId(p.getUnitId());
                tmpP.setBaseMaterialPrice(p.getBasePrice());
                tmpP.setBaseTwoMaterialPrice(p.getBaseTwoPrice());
                tmpP.setBasepriceId(p.getBasepriceId());
                processList.add(tmpP);
            }
        }
        for (PriceLibVO priceLibVO : processList) {
            if (priceMap.containsKey(priceLibVO.getMaterialCode())) {
                boolean breakFlag = false;
                boolean addFlag = false;
                for (MaterialBasePriceContentVO mp : (List)priceMap.get(priceLibVO.getMaterialCode())) {
                    tmp = null;
                    if (null != priceLibVO.getSupplierId() && StringUtils.isNotBlank((CharSequence)priceLibVO.getArea())) {
                        if ((mp.getSupplierId().equals(priceLibVO.getSupplierId()) || StringUtils.equals((CharSequence)priceLibVO.getSupplierName(), (CharSequence)mp.getSupplierName())) && mp.getArea().equals(mp.getArea())) {
                            tmp = (PriceLibVO)BeanMapper.map((Object)priceLibVO, PriceLibVO.class);
                            tmp.setBaseMaterialPrice(mp.getBasePrice());
                            tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                            tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                            tmp.setBasepriceId(mp.getBasepriceId());
                            if (null != mp.getGrooveWeight()) {
                                tmp.setExtParam1(mp.getGrooveWeight().toPlainString());
                            }
                            if (null != mp.getLidWeight()) {
                                tmp.setExtParam2(mp.getLidWeight().toPlainString());
                            }
                            breakFlag = true;
                        }
                    } else if (null != priceLibVO.getSupplierId()) {
                        if (priceLibVO.getSupplierId().equals(mp.getSupplierId()) || StringUtils.equals((CharSequence)priceLibVO.getSupplierName(), (CharSequence)mp.getSupplierName())) {
                            tmp = (PriceLibVO)BeanMapper.map((Object)priceLibVO, PriceLibVO.class);
                            tmp.setBaseMaterialPrice(mp.getBasePrice());
                            tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                            tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                            tmp.setBasepriceId(mp.getBasepriceId());
                            if (null != mp.getGrooveWeight()) {
                                tmp.setExtParam1(mp.getGrooveWeight().toPlainString());
                            }
                            if (null != mp.getLidWeight()) {
                                tmp.setExtParam2(mp.getLidWeight().toPlainString());
                            }
                            breakFlag = true;
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)priceLibVO.getArea())) {
                        if (StringUtils.equals((CharSequence)priceLibVO.getArea(), (CharSequence)mp.getArea()) || "\u5168\u56fd".equals(priceLibVO.getArea())) {
                            tmp = (PriceLibVO)BeanMapper.map((Object)priceLibVO, PriceLibVO.class);
                            tmp.setBaseMaterialPrice(mp.getBasePrice());
                            tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                            tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                            tmp.setBasepriceId(mp.getBasepriceId());
                            if (null != mp.getGrooveWeight()) {
                                tmp.setExtParam1(mp.getGrooveWeight().toPlainString());
                            }
                            if (null != mp.getLidWeight()) {
                                tmp.setExtParam2(mp.getLidWeight().toPlainString());
                            }
                            breakFlag = true;
                        }
                    } else {
                        tmp = (PriceLibVO)BeanMapper.map((Object)priceLibVO, PriceLibVO.class);
                        tmp.setId(Long.valueOf(IdWorker.getId()));
                        tmp.setBaseMaterialPrice(mp.getBasePrice());
                        tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                        tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                        tmp.setBasepriceId(mp.getBasepriceId());
                        if (null != mp.getGrooveWeight()) {
                            tmp.setExtParam1(mp.getGrooveWeight().toPlainString());
                        }
                        if (null != mp.getLidWeight()) {
                            tmp.setExtParam2(mp.getLidWeight().toPlainString());
                        }
                    }
                    if (null == tmp) continue;
                    tmp.setId(Long.valueOf(IdWorker.getId()));
                    if (null != tmp.getMaterialTypeId() && priceCalcVOMap.containsKey(tmp.getMaterialTypeId())) {
                        tmp.setBaseMaterialId(((MaterialPriceCalcVO)priceCalcVOMap.get(tmp.getMaterialTypeId())).getMaterialTypeId());
                        tmp.setBaseMaterialCode(((MaterialPriceCalcVO)priceCalcVOMap.get(tmp.getMaterialTypeId())).getMaterialType());
                        tmp.setBaseMaterialName(((MaterialPriceCalcVO)priceCalcVOMap.get(tmp.getMaterialTypeId())).getMaterialTypeName());
                    }
                    if (null != tmp.getBaseMaterialId() && netPriceMap.containsKey(tmp.getBaseMaterialId())) {
                        tmp.setBaseMaterialNetPrice(((ErpMaterialPriceVO)netPriceMap.get(tmp.getBaseMaterialId())).getPrice());
                    }
                    addFlag = true;
                    actualList.add(tmp);
                    if (!breakFlag) continue;
                    break;
                }
                if (addFlag) continue;
                if (priceCalcVOMap.containsKey(priceLibVO.getMaterialTypeId())) {
                    priceLibVO.setBaseMaterialId(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialTypeId());
                    priceLibVO.setBaseMaterialCode(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialType());
                    priceLibVO.setBaseMaterialName(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialTypeName());
                }
                actualList.add(priceLibVO);
                continue;
            }
            if (priceCalcVOMap.containsKey(priceLibVO.getMaterialTypeId())) {
                priceLibVO.setBaseMaterialId(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialTypeId());
                priceLibVO.setBaseMaterialCode(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialType());
                priceLibVO.setBaseMaterialName(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialTypeName());
            }
            if (null != priceLibVO.getBaseMaterialId() && netPriceMap.containsKey(priceLibVO.getBaseMaterialId())) {
                priceLibVO.setBaseMaterialNetPrice(((ErpMaterialPriceVO)netPriceMap.get(priceLibVO.getBaseMaterialId())).getPrice());
            }
            priceLibVO.setId(Long.valueOf(IdWorker.getId()));
            actualList.add(priceLibVO);
        }
        return actualList;
    }

    public List<PriceLibVO> fillPriceInfo(List<PriceLibVO> vos, List<Long> categoryIds, QueryParam basePriceQuery, Map<String, MaterialConjectureEntity> conMap) {
        return this.fillPriceInfo(vos, categoryIds, basePriceQuery, conMap, false);
    }
}

