/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

public class DetailListUtil<T> {
    public static <T> T selectById(Long id, IBaseService service) {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        ew.eq((Object)"id", (Object)id);
        Object entity = service.getOne((Wrapper)ew);
        entity = DetailListUtil.setDetailList(new ArrayList<Object>(Arrays.asList(entity))).get(0);
        return (T)entity;
    }

    public static <T> T selectById(Long id, Class<?> serviceClass) {
        String serviceName = serviceClass.getAnnotation(Service.class).value();
        BaseServiceImpl service = (BaseServiceImpl)ContextUtil.getBean((String)serviceName, BaseServiceImpl.class);
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        ew.eq((Object)"id", (Object)id);
        Object entity = service.getOne((Wrapper)ew);
        entity = DetailListUtil.setDetailList(new ArrayList<Object>(Arrays.asList(entity))).get(0);
        return (T)entity;
    }

    public static <T> List<T> setDetailList(List<T> list) {
        if (list != null && list.size() > 0) {
            Map<Long, Map<String, List<BaseEntity>>> listSubMap = DetailListUtil.getListSubMap(list);
            for (T entity : list) {
                Field[] fields;
                Class<?> mainClass = entity.getClass();
                for (Field field : fields = mainClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(SubEntity.class)) continue;
                    SubEntity subEntity = field.getAnnotation(SubEntity.class);
                    String serviceName = subEntity.serviceName();
                    String fieldName = field.getName();
                    if (StringUtils.isBlank((CharSequence)serviceName)) {
                        throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u6ce8\u89e3SubEntity\u672a\u8bbe\u7f6e\u5b50\u8868\u5b9e\u73b0\u7c7b\u670d\u52a1\u540d\uff01");
                    }
                    BaseServiceImpl subService = (BaseServiceImpl)ContextUtil.getBean((String)serviceName, BaseServiceImpl.class);
                    if (subService == null) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u5b50\u8868\u6ca1\u6709\u5b9e\u73b0\u7c7b\uff01");
                    }
                    try {
                        Method m = mainClass.getMethod("getId", null);
                        Long id = (Long)m.invoke(entity, null);
                        Map<Object, Object> subMap = new HashMap();
                        if (listSubMap.containsKey(id)) {
                            subMap = listSubMap.get(id);
                        }
                        List subList = new ArrayList();
                        if (subMap.containsKey(fieldName)) {
                            subList = (List)subMap.get(fieldName);
                        }
                        if (ListUtil.isEmpty(subList)) continue;
                        Class[] cArg = new Class[]{field.getType()};
                        Method setSubList = mainClass.getDeclaredMethod("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), cArg);
                        setSubList.invoke(entity, subList);
                    }
                    catch (NoSuchMethodException e) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u672a\u5b9a\u4e49set\u65b9\u6cd5\uff01");
                    }
                    catch (IllegalAccessException e) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u9700\u8981\u662fpublic\u5c5e\u6027\uff01");
                    }
                    catch (InvocationTargetException e) {
                        throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u6267\u884c\u51fa\u9519\uff01");
                    }
                }
            }
        }
        return list;
    }

    private static <T> Map<Long, Map<String, List<BaseEntity>>> getListSubMap(List<T> list) {
        Future future;
        Map<String, Future> futureMap;
        HashMap<Long, Map<String, ListCallable>> listCallMap = new HashMap<Long, Map<String, ListCallable>>();
        int size = DetailListUtil.getListCallMap(list, listCallMap);
        ExecutorService threadPool = null;
        if (size > 0) {
            threadPool = Executors.newFixedThreadPool(size);
        }
        HashMap<Object, Map<String, Future>> listFutMap = new HashMap<Object, Map<String, Future>>();
        for (Object id : listCallMap.keySet()) {
            Map callableMap = (Map)listCallMap.get(id);
            futureMap = new HashMap();
            if (listFutMap.containsKey(id)) {
                futureMap = (Map)listFutMap.get(id);
            }
            for (String fieldName : callableMap.keySet()) {
                Callable callable = (Callable)callableMap.get(fieldName);
                future = threadPool.submit(callable);
                futureMap.put(fieldName, future);
            }
            listFutMap.put(id, futureMap);
        }
        HashMap<Long, Map<String, List<BaseEntity>>> listSubMap = new HashMap<Long, Map<String, List<BaseEntity>>>();
        try {
            for (Long id : listFutMap.keySet()) {
                futureMap = (Map)listFutMap.get(id);
                Map<String, List> subMap = new HashMap();
                if (listSubMap.containsKey(id)) {
                    subMap = (Map)listSubMap.get(id);
                }
                for (String fieldName : futureMap.keySet()) {
                    future = (Future)futureMap.get(fieldName);
                    List subList = (List)future.get(30L, TimeUnit.SECONDS);
                    if (!CollectionUtils.isNotEmpty((Collection)subList)) continue;
                    subMap.put(fieldName, subList);
                }
                listSubMap.put(id, subMap);
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            if (null != threadPool) {
                threadPool.shutdown();
            }
        }
        return listSubMap;
    }

    private static <T> int getListCallMap(List<T> list, Map<Long, Map<String, ListCallable>> listCallMap) {
        int size = 0;
        for (T entity : list) {
            Field[] fields;
            Class<?> mainClass = entity.getClass();
            for (Field field : fields = mainClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(SubEntity.class)) continue;
                SubEntity subEntity = field.getAnnotation(SubEntity.class);
                String serviceName = subEntity.serviceName();
                String fieldName = field.getName();
                if (StringUtils.isBlank((CharSequence)serviceName)) {
                    throw new BusinessException("\u5b50\u8868\u5b57\u6bb5\u3010" + fieldName + "\u3011\u6ce8\u89e3SubEntity\u672a\u8bbe\u7f6e\u5b50\u8868\u5b9e\u73b0\u7c7b\u670d\u52a1\u540d\uff01");
                }
                BaseServiceImpl subService = (BaseServiceImpl)ContextUtil.getBean((String)serviceName, BaseServiceImpl.class);
                if (subService == null) {
                    throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u5b50\u8868\u6ca1\u6709\u5b9e\u73b0\u7c7b\uff01");
                }
                try {
                    Method m = mainClass.getMethod("getId", null);
                    Long id = (Long)m.invoke(entity, null);
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put(subEntity.pidName(), new Parameter("eq", (Object)id));
                    queryParam.getOrderMap().put("id", "asc");
                    Map<String, ListCallable> callableMap = new HashMap<String, ListCallable>();
                    if (listCallMap.containsKey(id)) {
                        callableMap = listCallMap.get(id);
                    }
                    callableMap.put(fieldName, new ListCallable(queryParam, subService));
                    listCallMap.put(id, callableMap);
                    ++size;
                }
                catch (NoSuchMethodException e) {
                    throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011\u672a\u5b9a\u4e49set\u65b9\u6cd5\uff01");
                }
                catch (IllegalAccessException e) {
                    throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u9700\u8981\u662fpublic\u5c5e\u6027\uff01");
                }
                catch (InvocationTargetException e) {
                    throw new BusinessException("\u5b57\u6bb5\u3010" + fieldName + "\u3011set\u65b9\u6cd5\u6267\u884c\u51fa\u9519\uff01");
                }
            }
        }
        return size;
    }

    static class ListCallable
    implements Callable<List<BaseEntity>> {
        private QueryParam queryParam;
        private BaseServiceImpl service;

        public ListCallable(QueryParam queryParam, BaseServiceImpl service) {
            this.queryParam = queryParam;
            this.service = service;
        }

        @Override
        public List<BaseEntity> call() throws Exception {
            List subList = this.service.queryList(this.queryParam, false);
            return subList;
        }
    }
}

