package com.ejianc.business.zdsmaterial.accept.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.accept.AcceptVO;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.accept.enums.BillPushStatusEnum;
import com.ejianc.business.zdsmaterial.accept.enums.SignatureStatusEnum;
import com.ejianc.business.zdsmaterial.accept.mapper.AcceptMapper;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptDetailService;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptService;
import com.ejianc.business.zdsmaterial.cloudstore.constants.CommonConstants;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.enums.DeliveryAcceptStatusEnums;
import com.ejianc.business.zdsmaterial.erp.service.*;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubPickerEntity;
import com.ejianc.business.zdsmaterial.pick.service.IProSubPickerService;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资验收
 *
 * @author generator
 */
@Service("acceptService")
public class AcceptServiceImpl extends BaseServiceImpl<AcceptMapper, AcceptEntity> implements IAcceptService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZDS-ACC";//此处需要根据实际修改
    private static final String OTHER_BILL_CODE = "ZDS-OTH-ACC";//此处需要根据实际修改
    private static final String BILL_TYPE_CODE = "EJCBT202312000001";
    private static final String OTHER_BILL_TYPE_CODE = "EJCBT202312000020";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAcceptDetailService acceptDetailService;
    @Autowired
    private IOrderService orderService;
    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;
    private final String OPERATE = "ACCEPT_TO_SUB";
    private final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/accept/pushSubAccept";
    private final String PUSH_BILL_RETURN_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/outRecord/saveAcceptOutStore";
    private final String BILL_DEL_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/accept/billDel";//删除接口
    private final String DELPUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/outRecord/delAcceptOutStore";//直入直出删除


    private static final String SOURCE_TYPE_004 = "type004";//供应商签字

    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IExpenseAccountDetailService expenseAccountDetailService;

    @Autowired
    private IProSubPickerService subPickerService;

    @Autowired
    private EnvironmentTools environmentTools;

    @Override
    public AcceptVO saveOrUpdate(AcceptVO saveOrUpdateVO) {
        AcceptEntity entity = BeanMapper.map(saveOrUpdateVO, AcceptEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            if(!PlanConstant.零星材料入库.equals(saveOrUpdateVO.getAcceptMaterialType())) {
                if (null != entity.getDeliveryBillId() && 0 == entity.getSourceType()) {
                    QueryWrapper<AcceptEntity> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("delivery_bill_id", entity.getDeliveryBillId());
                    queryWrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                            BillStateEnum.PASSED_STATE.getBillStateCode()));
                    int count = super.count(queryWrapper);
                    if (count > 0) {
                        throw new BusinessException("一个发货单只能存在一个自由态的验收单!");
                    }
                }
                if (null != entity.getContractId()) {
                    QueryWrapper<AcceptEntity> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("order_bill_id", entity.getOrderBillId());
                    queryWrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                            BillStateEnum.PASSED_STATE.getBillStateCode()));
                    int count = super.count(queryWrapper);
                    if (count > 0) {
                        throw new BusinessException("一个订单只能存在一个自由态的验收单!");
                    }
                }
            }

            String type = BILL_CODE;
            if (entity.getSourceType() == 2) {
                type = OTHER_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(type, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setSignatureStatus(SignatureStatusEnum.已签字.getStatus());
            entity.setMaterialSignatureStatus(SignatureStatusEnum.未签字.getStatus());
            entity.setSubSignatureStatus(SignatureStatusEnum.未签字.getStatus());
            entity.setSignatureUserId(sessionManager.getUserContext().getUserId());
            entity.setSignatureUserName(sessionManager.getUserContext().getUserName());
            entity.setSignatureUserPhone(sessionManager.getUserContext().getUserMobile());
        }
        //校验子表与发货单的数量关系
        if(!PlanConstant.零星材料入库.equals(saveOrUpdateVO.getAcceptMaterialType())) {
            if (CollectionUtils.isNotEmpty(entity.getDetailList()) && (entity.getSourceType() == 1 || entity.getSourceType() == 0)) {
                saveCheckDetailList(entity);
            } else {
                entity.setFinalAcceptFlag(0);
            }
            if ((entity.getSourceType() == 0 || entity.getSourceType() == 1) && CollectionUtils.isNotEmpty(entity.getDetailList())) {
                returnDeliveryOrOrder(entity, entity.getSourceType(), true);
            }
            //基于发货单的全部验收
            if (entity.getSourceType() == 0) {
                checkFinalAcceptFlag(entity);
            }
            if (entity.getSourceType() == 1) {
                entity.setFinalAcceptFlag(0);
                entity.setCloseDelivery(entity.getFinalAcceptFlag());
            }
        } else if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getDetailList())) {
            //验证零星材料验收数量是否超过可验收量
            String msg = expenseAccountDetailService.validateAcceptNum(saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toMap(item -> item.getSourceDetailId(), item -> item.getDetailNum())));
            if(StringUtils.isNotBlank(msg)) {
                throw new BusinessException(msg);
            }
        }
        entity.setCloseDelivery(entity.getFinalAcceptFlag());
        String materialNames = entity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) &&
                StringUtils.isNotEmpty(x.getMaterialTypeName())).map(AcceptDetailEntity::getMaterialName).distinct().collect(Collectors.joining(","));
        entity.setMaterialNames(materialNames);
        String materialTypeNames = entity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty(x.getMaterialTypeName())).map(AcceptDetailEntity::getMaterialTypeName).collect(Collectors.toSet()).stream().distinct().collect(Collectors.joining(","));
        entity.setAcceptContent(materialTypeNames);
        super.saveOrUpdate(entity, false);

        return BeanMapper.map(entity, AcceptVO.class);
    }

    /**
     * 回写发货单 回写订单
     *
     * @param entity
     * @param sourceType 0:来源发货单 --回写发货单 订单 ; 1:自制 回写订单;
     * @param status     true add;false sub
     */
    public void returnDeliveryOrOrder(AcceptEntity entity, Integer sourceType, Boolean status) {
        for (AcceptDetailEntity detail :entity.getDetailList()){
            detail.setCheckNum(detail.getDetailNum());
        }

        AcceptEntity dbAccept = null;
        if(null != entity.getId()&&status) {
            dbAccept = super.selectById(entity.getId());
            if (null != dbAccept) {
                List<AcceptDetailEntity> detailList = dbAccept.getDetailList();
                Map<Long, AcceptDetailEntity> collect = detailList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
                List<AcceptDetailEntity> detailList1 = entity.getDetailList();
                if (!collect.isEmpty()) {
                    for (AcceptDetailEntity detail : detailList1) {
                        if (collect.containsKey(detail.getId())) {
                            if (!"del".equals(detail.getRowState())) {
                                BigDecimal detailNum = detail.getDetailNum();
                                BigDecimal detailNum1 = collect.get(detail.getId()).getDetailNum();
                                detail.setCheckNum(ComputeUtil.safeSub(detailNum,detailNum1));
                            }
                        }
                    }
                }
            }
        }

        //查询基于当前发货单 一共有
        if (sourceType == 0) {
            deliveryService.returnDeliveryOrOrder(entity, status);
        } else if (sourceType == 1) {
            orderService.returnHandAcceptNum(entity, status);
        }
    }

    /**
     * 查询已验收量
     */
    @Override
    public Map<Long, BigDecimal> getAlreadyDetailNum(List<Long> detailIds, List<Long> ids) {
        /**
         * 查询历史验收量 是否保存即生效？ 合同 物资id
         * 查询条件 订单id？
         */
        QueryWrapper<AcceptDetailEntity> queryWrapper = new QueryWrapper();
        queryWrapper.in("source_detail_id", detailIds);
        queryWrapper.in("source_type", Arrays.asList("1", "0"));
        //过滤掉当前保存的数据
        if (CollectionUtils.isNotEmpty(ids)) {
            queryWrapper.notIn("id", ids);
        }
        List<AcceptDetailEntity> list = acceptDetailService.list(queryWrapper);
        Map<Long, BigDecimal> contractDetailBigDecimalList = list.stream().collect(Collectors.groupingBy(AcceptDetailEntity::getSourceDetailId, Collectors.reducing(BigDecimal.ZERO, AcceptDetailEntity::getDetailNum, BigDecimal::add)));
        //已经得到了每一条对应的物资的验收量
        return contractDetailBigDecimalList;
    }

    public Map<Long, BigDecimal> getDetailNum(List<Long> detailIds, List<Long> ids) {
        /**
         * 查询历史验收量 是否保存即生效？ 合同 物资id
         * 查询条件 订单id？
         */
        QueryWrapper<AcceptDetailEntity> queryWrapper = new QueryWrapper();
        queryWrapper.in("source_detail_id", detailIds);
        queryWrapper.eq("source_type", "0");
        //过滤掉当前保存的数据
        if (CollectionUtils.isNotEmpty(ids)) {
            queryWrapper.notIn("id", ids);
        }
        List<AcceptDetailEntity> list = acceptDetailService.list(queryWrapper);
        Map<Long, BigDecimal> contractDetailBigDecimalList = list.stream().collect(Collectors.groupingBy(AcceptDetailEntity::getSourceDetailId, Collectors.reducing(BigDecimal.ZERO, AcceptDetailEntity::getDetailNum, BigDecimal::add)));
        //已经得到了每一条对应的物资的验收量
        return contractDetailBigDecimalList;
    }

    @Override
    public void delete(List<AcceptVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AcceptVO entity : vos) {
                AcceptEntity entity1 = super.selectById(entity.getId());
                if(!PlanConstant.零星材料入库.equals(entity1.getAcceptMaterialType())) {
                    if (entity1.getSourceType() != 2 && CollectionUtils.isNotEmpty(entity1.getDetailList())) {
                        returnDeliveryOrOrder(entity1, entity1.getSourceType(), false);
                    }
                }
            }
        }
        super.removeByIds(vos.stream().map(AcceptVO::getId).collect(Collectors.toList()), true);
    }

    public ParamsCheckVO checkParams(AcceptVO acceptVO) {
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0 && null != e.getWarnType()).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<ParamsCheckVO> result = new ArrayList<>();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    private void initContext(Long userId) {
        String initContextUrl = environmentTools.getBaseHost() + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        initContextUrl = initContextUrl + "&userId="+userId.toString();
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);

        CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
        try {
            if(userContextResponse.isSuccess()) {
                JSONObject userContext =userContextResponse.getData().getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if(null != userContext) {
                    authtoken.append("userType=").append(userContext.get("userType"))
                            .append(";userCode=").append(userContext.get("userCode"))
                            .append(";orgId=").append(userContext.get("orgId"))
                            .append(";tenantid=").append(userContext.get("tenantid"))
                            .append(";token=").append(userContext.get("token"))
                            .append(";u_logints=").append(userContext.get("u_logints"))
                            .append(";u_usercode=").append(userContext.get("u_usercode"))
                            .append(";userId=").append(userContext.get("userId"));
                }
                if(authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());
                    InvocationInfoProxy.setParameter(ReferConstant.HEAD_authority, authtoken.toString());
                }
                if(null != userContext) {
                    InvocationInfoProxy.setTenantid(userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid(userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode(userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId(userContext.getLong("orgId"));
                }
            }
        } catch (Exception e) {
            logger.error("初始化异步任务上下文异常：",e);
        }

    }


    @Override
    @Async(value = "maNoContextTask")
    public void inToStore(AcceptEntity entity,Boolean outEffectiveON, Long curUserId) {
        initContext(curUserId);
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            //0:正常验收;1:直入直出;
            Integer acceptType = entity.getAcceptType();
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setOutEffectiveON(outEffectiveON);
            storeManageVO.setSourceId(entity.getId());
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            if (acceptType == 0) {
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.收料入库);
                for (int i = 0; i < entity.getDetailList().size(); i++) {
                    FlowVO flowVO = new FlowVO();
                    flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.收料入库, 0);
                    getFlow(entity, entity.getDetailList().get(i), flowVO);
                    flowVOS.add(flowVO);
                }
            } else {
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.直入直出入库);
                for (int i = 0; i < entity.getDetailList().size(); i++) {
                    FlowVO flowVO = new FlowVO();
                    flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.直入直出入库, 0);
                    getFlow(entity, entity.getDetailList().get(i), flowVO);
                    flowVOS.add(flowVO);
                }
                ArrayList<FlowVO> flowOutS = new ArrayList<>();
                for (int i = 0; i < entity.getDetailList().size(); i++) {
                    FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.直入直出出库, 0);
                    getFlow(entity, entity.getDetailList().get(i), flowVO);
                    flowOutS.add(flowVO);
                }
                storeManageVO.setStraightOutFlowVOList(flowOutS);
            }
            storeManageVO.setFlowVOList(flowVOS);
            logger.info("库存参数：" + JSONObject.toJSONString(storeManageVO));
            CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
            if (!response.isSuccess()) {
                logger.error("验收单id-{}调用库存管理失败,错误信息，{}" , entity.getId(), JSONObject.toJSONString(response));
                sendWarnMsg("验收单推送库存失败", "验收单【"+entity.getBillCode()+"】推送库存失败，请及时处理！", null);

                UpdateWrapper<AcceptEntity> update = new UpdateWrapper<>();
                update.eq("id", entity.getId());
                update.set("push_store_flag", 0);
                super.update(update);
            } else {
                UpdateWrapper<AcceptEntity> update = new UpdateWrapper<>();
                update.eq("id", entity.getId());
                update.set("push_store_flag", 1);
                super.update(update);
            }
        }
    }

    public boolean sendWarnMsg(String title, String content, String pcUrl) {
        try {
            PushMsgParameter parameter = new PushMsgParameter();
            parameter.setSubject(title);
            parameter.setContent(content);
            parameter.setPcUrl(pcUrl);
            parameter.setMobileUrl(pcUrl);
            String[] recIds = new String[]{"800312417274822673"}; //预警接收人Id
            parameter.setReceivers(recIds);
            parameter.setSaveFlag(true);
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setMsgType("notice");
            parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});

            CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
            if (!sendResp.isSuccess()) {
                logger.error("发送预警消息失败，消息-{}，发送消息结果-{}", JSONObject.toJSONString(parameter), JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                        SerializerFeature.WriteMapNullValue));
                return false;
            } else {
                logger.info("发送预警消息成功！");
                return true;
            }
        } catch (Exception e) {
            logger.error("发送预警消息异常！！！", e);
            return false;
        }
    }


    private void getFlow(AcceptEntity entity, AcceptDetailEntity t, FlowVO flowVO) {
        flowVO.setBrandId(t.getBrandId());
        flowVO.setBrandName(t.getBrandName());
        flowVO.setLicensePlate(entity.getCarCode());
        flowVO.setSupplierId(entity.getSupplierId());
        flowVO.setSupplierName(entity.getSupplierName());
        flowVO.setEmployeeId(entity.getSiteAcceptorId());
        flowVO.setEmployeeName(entity.getSiteAcceptorName());
        flowVO.setOrgId(entity.getOrgId());
        flowVO.setOrgName(entity.getOrgName());
        flowVO.setParentOrgId(entity.getParentOrgId());
        flowVO.setParentOrgName(entity.getParentOrgName());
        flowVO.setProjectId(entity.getProjectId());
        flowVO.setProjectName(entity.getProjectName());
        flowVO.setPurchaseContractId(entity.getContractId());
        flowVO.setPurchaseContractName(entity.getContractName());
        flowVO.setSupplierId(entity.getSupplierId());
        flowVO.setSupplierName(entity.getSupplierName());
        flowVO.setBillCode(entity.getBillCode());
        flowVO.setMaterialCategoryCode(t.getMaterialTypeCode());
        flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
        if (entity.getAcceptType() == 1) {
            flowVO.setInOutType(InOutTypeEnum.直入直出入库.getInOutType());
            flowVO.setInOutTypeName(InOutTypeEnum.直入直出入库.getInOutTypeName());
            flowVO.setSourceBillTypeName("直入直出入库");
            flowVO.setPickContractId(entity.getPickContractId());
            flowVO.setPickContractName(entity.getPickContractName());
            flowVO.setPickUnitId(entity.getSubcontractorId());
            flowVO.setPickUnitName(entity.getSubcontractorName());
        } else {
            flowVO.setInOutType(InOutTypeEnum.收料入库.getInOutType());
            flowVO.setInOutTypeName(InOutTypeEnum.收料入库.getInOutTypeName());
            flowVO.setSourceBillTypeName("收料入库");
        }
        if (null!=entity.getContractId()){
            flowVO.setPurchaseContractId(entity.getContractId());
            flowVO.setPurchaseContractName(entity.getContractName());
        }
        flowVO.setStoreId(entity.getStoreId());
        flowVO.setStoreName(entity.getStoreName());
        flowVO.setSourceBillDate(entity.getPickupDate());
        flowVO.setBillDate(entity.getPickupDate());
        flowVO.setMaterialCategoryName(t.getMaterialTypeName());
        flowVO.setMaterialCategoryId(t.getMaterialTypeId());
        flowVO.setMaterialTypeName(t.getMaterialTypeName());
        flowVO.setMaterialName(t.getMaterialName());
        flowVO.setMaterialId(t.getMaterialId());
        flowVO.setMaterialCode(t.getMaterialCode());
        flowVO.setMaterialSpec(t.getPropertyValue());//规格型号
        flowVO.setMaterialUnitId(t.getDetailUnitId());
        flowVO.setMaterialUnitName(t.getDetailUnitName());
        flowVO.setNum(t.getDetailNum());
        flowVO.setPrice(t.getDetailPrice());
        flowVO.setTaxPrice(t.getDetailTaxPrice());
        flowVO.setTax(t.getDetailTax());
        flowVO.setTaxRate(t.getDetailTaxRate());
        flowVO.setMny(t.getDetailMny());
        flowVO.setTaxMny(t.getDetailTaxMny());
        flowVO.setSourceId(entity.getId());
        flowVO.setSourceDetailId(t.getId());
        flowVO.setSourceBillCode(entity.getBillCode());
        flowVO.setSourceBillDate(entity.getPickupDate());
        flowVO.setSourceBillRemark(entity.getMemo());
        flowVO.setSourceBillDetailRemark(t.getMemo());
        if (entity.getSourceType() == 2) {
            flowVO.setSourceBillTypeCode(OTHER_BILL_TYPE_CODE);

        } else {
            flowVO.setSourceBillTypeCode(BILL_TYPE_CODE);
        }

        flowVO.setLicensePlate(entity.getCarCode());
        flowVO.setProductCode(t.getProductCode());
        if (null != entity.getContractId()) {
            flowVO.setContractTaxPrice(t.getDetailTaxPrice());
            flowVO.setContractPrice(t.getDetailPrice());
        }
        flowVO.setRowState(t.getRowState());
    }
    @Autowired
    private IContractService contractService;
    /**
     * 保存校验子表 自制 来源发货单
     *
     * @param entity
     */
    public void saveCheckDetailList(AcceptEntity entity) {
        List<AcceptDetailEntity> detailList = entity.getDetailList();
        List<AcceptDetailEntity> collect = detailList.stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.toList());
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());

        Integer priceType = contractEntity.getPriceType();

        for (AcceptDetailEntity detail : collect) {
            BigDecimal detailNum = detail.getDetailNum();
            BigDecimal alreadyNum = detail.getAlreadyNum();
            BigDecimal decimal = ComputeUtil.safeAdd(detailNum, alreadyNum);

            if (entity.getSourceType() == 0 && ComputeUtil.isGreaterThan(detailNum, detail.getResDeliveryNum())) {
                throw new BusinessException("物料明细[" + detail.getMaterialName() + ":" + detail.getMaterialCode() + "]本次验收量大于剩余可验收量");
            }
            //查询合同是否是单价合同


            if (priceType!=1&&ComputeUtil.isGreaterThan(decimal, detail.getContractNum())) {
                throw new BusinessException("物料明细[" + detail.getMaterialName() + ":" + detail.getMaterialCode() + "]明细累计验收数量不能大于合同签订数量");
            }
        }
        if (entity.getSourceType() == 1) {
            for (AcceptDetailEntity detail : collect) {
                BigDecimal detailNum = detail.getDetailNum();
                BigDecimal alreadyNum = detail.getResOrderNum();
                BigDecimal decimal = ComputeUtil.safeAdd(detailNum, alreadyNum);
                decimal = ComputeUtil.safeAdd(decimal, detail.getDeliveryNum());
                if (ComputeUtil.isGreaterThan(decimal, detail.getOrderNum())) {
                    throw new BusinessException("物料明细[" + detail.getMaterialName() + ":" + detail.getMaterialCode() + "]自制验收量+发货量 不能大于订单量！");
                }

            }
        }


    }

    /**
     * 提交前校验
     *
     * @param entity
     */
    @Override
    public void checkFinalAcceptFlag(AcceptEntity entity) {
        Integer sourceType = entity.getSourceType();
        if (sourceType == 0 || sourceType == 1) {
            List<AcceptDetailEntity> detailList = entity.getDetailList();
            entity.setFinalAcceptFlag(1);
            for (AcceptDetailEntity detail : detailList) {
                BigDecimal detailNum = detail.getDetailNum();
                BigDecimal alreadyNum = detail.getAlreadyNum();
                BigDecimal totalNum = ComputeUtil.safeAdd(detailNum, alreadyNum);
                if (sourceType == 0) {
                    BigDecimal deliveryNum = detail.getDeliveryNum();
                    if (ComputeUtil.equals(totalNum, deliveryNum)) {
                    } else {
                        entity.setFinalAcceptFlag(0);
                        break;
                    }
                }
            }
            if (sourceType == 0) {
                Long deliveryBillId = entity.getDeliveryBillId();
                DeliveryEntity deliveryEntity = deliveryService.selectById(deliveryBillId);
                for (DeliveryDetailEntity detail : deliveryEntity.getDetailList()) {
                    detail.getAlreadyNum();
                    if (ComputeUtil.equals(detail.getAlreadyNum(), detail.getDeliveryNum())) {
                    } else {
                        entity.setFinalAcceptFlag(0);
                        break;
                    }
                }

            }

        }
    }
    @Override
    @Async(value = "maNoContextTask")
    public String pushSubReturn(AcceptEntity entity, Long curUserId, Boolean pushToStoreEffect) {
        initContext(curUserId);
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = BILL_TYPE_CODE + "::" + entity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送验收单-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return "推送验收单失败，获取当前系统编码失败";
        }
        //设置当前系统ID
        entity.setSourceSystemId(ejcCloudSystemCode.getData());
        // 清空租户ID
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            entity.getDetailList().forEach(item -> item.setTenantId(null));
        }

        //查询对应分包领料人信息
        AcceptEntity copyEntity = BeanMapper.map(entity, AcceptEntity.class);
        if(null != copyEntity.getSubcontractorUserId()) {
           ProSubPickerEntity picker =  subPickerService.selectById(copyEntity.getSubcontractorUserId());
           if(null != picker) {
               copyEntity.setSubcontractorUserId(picker.getSupUserId());
           }
        }

        try {
            jedis = jedisPool.getResource();
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", JSONObject.toJSONString(copyEntity));
            logger.info("向供应商领料出库-{}推送验收单据参数-{}", copyEntity.getSubcontractorId(), JSONObject.toJSONString(paramMap));
            //推送单据到指定的供方 TODO 供应商取分包商
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_RETURN_SERVER_URL,
                    paramMap,
                    copyEntity.getSubcontractorId().toString(),
                    null);
            if (syncReqResp.isSuccess()) {
                CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (billPushResp.isSuccess()) {

                } else {
                    logger.error("领料出库id-{}处理推送验收id-{}失败, {}", entity.getSubcontractorId(), entity.getId(), billPushResp.getMsg());
                    msg = "推送验收单失败，供方领料出库处理推送验单失败";
                }
            } else {
                logger.error("发送请求推送结算单据id-{}给供方领料出库id-{}失败, {}", entity.getId(), entity.getSubcontractorId(), syncReqResp.getMsg());
                msg = "发送请求推送验收单失败";
            }
        } catch (Exception e) {
            logger.error("验收单id-{}推送供方领料出库失败，", entity.getId(), e);
            msg = "操作失败，验收单推送供方领料出库失败！";
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, BILL_TYPE_CODE);
        }

        //更新推送状态
        UpdateWrapper<AcceptEntity> update = new UpdateWrapper<>();
        update.eq("id", entity.getId());
        update.eq("dr", BaseVO.DR_UNDELETE);
        update.set("push_sup_return_flag", StringUtils.isBlank(msg) ? "1" : "0");
        super.update(update);

        if(null != pushToStoreEffect) {
            inToStore(entity, pushToStoreEffect, curUserId);
        }

        return msg;
    }
    @Override
    @Async(value = "maNoContextTask")
    public String pushSubAccept(AcceptEntity entity, Long curUserId) {
        return pushSubAccept(entity, curUserId, null);
    }

    @Override
    @Async(value = "maNoContextTask")
    public String pushSubAccept(AcceptEntity entity, Long curUserId, Boolean pushToStoreEffect) {
        initContext(curUserId);
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = BILL_TYPE_CODE + "::" + entity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送验收单-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return "推送验收单失败，获取当前系统编码失败";
        }
        //设置当前系统ID
        entity.setSourceSystemId(ejcCloudSystemCode.getData());
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            entity.getDetailList().forEach(item -> item.setTenantId(null));
        }

        //查询对应分包领料人信息
        AcceptEntity copyEntity = BeanMapper.map(entity, AcceptEntity.class);
        if(null != copyEntity.getSubcontractorUserId()) {
            ProSubPickerEntity picker =  subPickerService.selectById(copyEntity.getSubcontractorUserId());
            if(null != picker) {
                copyEntity.setSubcontractorUserId(picker.getSupUserId());
            }
        }

        try {
            jedis = jedisPool.getResource();
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", JSONObject.toJSONString(copyEntity));
            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(copyEntity.getId(), null, null, null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                //当前单据携带有附件信息
//                if (CollectionUtils.isNotEmpty(fileList)) {
//                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
//                    fileMap.keySet().stream().forEach(fileKey -> {
//                        Map<String, InputStream> file = new HashMap<>(1);
//                        file.put(fileKey, fileMap.get(fileKey));
//                        files.put(fileKey, file);
//                    });
//                }
                logger.info("向供应商-{}推送验收单据参数-{}", entity.getSupplierId(), JSONObject.toJSONString(paramMap));
                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        entity.getSupplierId().toString(),
                        files);

                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        logger.info("向供应商-{}推送验收单据成功-{}", entity.getSupplierId(), entity.getId());
                    } else {
                        logger.error("供方id-{}处理推送验收id-{}失败, {}", copyEntity.getSupplierId(), copyEntity.getId(), billPushResp.getMsg());
                        msg = "推送验收单失败，供方处理推送验单失败";
                    }
                } else {
                    logger.error("发送请求推送结算单据id-{}给供方id-{}失败, {}", copyEntity.getId(), copyEntity.getSupplierId(), syncReqResp.getMsg());
                    msg = "发送请求推送验收单失败";
                }
            } else {
                logger.error("获取验收id-{}对应附件信息失败, {}", copyEntity.getId(), fileResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("验收单id-{}推送供方失败，", copyEntity.getId(), e);
            msg = "操作失败，验收单推送供方失败！";
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, BILL_TYPE_CODE);
        }

        //更新推送状态
        UpdateWrapper<AcceptEntity> update = new UpdateWrapper<>();
        update.eq("id", entity.getId());
        update.eq("dr", BaseVO.DR_UNDELETE);
        update.set("push_sup_accept_flag", StringUtils.isBlank(msg) ? "1" : "0");
        super.update(update);

        if(null != pushToStoreEffect) {
            inToStore(entity,pushToStoreEffect, curUserId);
        }

        return msg;
    }

    @Override
    public void updateSignatureStatus(Long acceptId) {
        UpdateWrapper<AcceptEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", acceptId);
        updateWrapper.set("signature_status", 1);
        super.update(updateWrapper);
    }

    @Override
    public String deletePickReturnBill(AcceptEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + entity.getId().toString() + "::sup";

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            //加锁失败
            if (!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return "材料验收作废失败，加锁失败！";
            }
            Map<String, String> params = new HashMap<>();
            params.put("sourceId", entity.getId().toString());

            //设置单据当前系统信息
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                logger.error("推送验收-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
                return "推送验收失败，获取当前系统编码失败";
            }
            logger.info("材料验收作废通知供方平台: url-{}, 材料退库：{}", BILL_DEL_PM_SERVER_URL, JSONObject.toJSONString(entity));
            CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_DEL_PM_SERVER_URL,
                    params, entity.getSupplierId().toString(), null);
            logger.error("材料验收作废通知供方平台请求结果，{}", JSONObject.toJSONString(writeBackResp));
            if (!writeBackResp.isSuccess()) {
                releaseLock(jedis, true, key, OPERATE);
                logger.error("材料验收id-{}作废通知供方平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                return "验收作废通知供方平台失败";
            }
            String operateRespStr = writeBackResp.getData();
            CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                logger.error("材料验收id-{}推送供方，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                releaseLock(jedis, true, key, OPERATE);
                return "材料验收作废通知供方平台失败";
            }

        } catch (Exception e) {
            logger.error("材料验收id-{}作废通知供方平台失败，", entity.getId(), e);
            msg = "操作失败，材料验收作废通知供方平台失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }
    @Override
    public String deleteReturnBill(AcceptEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = OPERATE + "::" + entity.getId().toString() + "::sup";

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            //加锁失败
            if (!locked) {
                releaseLock(jedis, false, key, OPERATE);
                return "材料验收作废失败，加锁失败！";
            }
            Map<String, String> params = new HashMap<>();
            params.put("id", entity.getId().toString());

            //设置单据当前系统信息
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                logger.error("推送验收-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
                return "推送验收失败，获取当前系统编码失败";
            }
            params.put("systemId", ejcCloudSystemCode.getData().toString());

            logger.info("材料验收作废通知分包商平台: url-{}, 材料退库：{}", DELPUSH_BILL_SERVER_URL, JSONObject.toJSONString(entity));
            CommonResponse<String> writeBackResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_DEL_PM_SERVER_URL,
                    params, entity.getSubcontractorId().toString(), null);
            logger.error("材料验收作废通知分包商平台请求结果，{}", JSONObject.toJSONString(writeBackResp));
            if (!writeBackResp.isSuccess()) {
                releaseLock(jedis, true, key, OPERATE);
                logger.error("材料验收id-{}作废通知分包商平台发送请求失败，{}", entity.getId(), writeBackResp.getMsg());
                return "验收作废通知分包商平台失败";
            }
            String operateRespStr = writeBackResp.getData();
            CommonResponse<String> operateResp = JSONObject.parseObject(operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                logger.error("材料验收id-{}推送分包商，平台处理失败，{}", entity.getId(), operateResp.getMsg());
                releaseLock(jedis, true, key, OPERATE);
                return "材料验收作废通知分包商平台失败";
            }

        } catch (Exception e) {
            logger.error("材料验收id-{}作废通知分包商平台失败，", entity.getId(), e);
            msg = "操作失败，材料验收作废通知分包商平台失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String subsignatureUserId = request.getParameter("subsignatureUserId");
        String subsignatureUserName = request.getParameter("subsignatureUserName");
        String subsignatureUserPhone = request.getParameter("subsignatureUserPhone");
        String acceptType = request.getParameter("acceptType");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
        AcceptEntity entity = super.selectById(billId);
        String billType = BILL_TYPE_CODE;
        if (entity.getSourceType()==2){
            billType = OTHER_BILL_TYPE_CODE;
        }
        if (acceptType.equals("1")){
            entity.setSubSignatureUserId(Long.valueOf(subsignatureUserId));
            entity.setSubSignatureUserName(subsignatureUserName);
            entity.setSubSignatureUserPhone(subsignatureUserPhone);
            entity.setSubSignatureDate(new Date());
            entity.setSubSignatureStatus(1);
            if(entity.getAcceptType()==1){
                //分包商签字 入库单生效
                inToStore(entity,true, InvocationInfoProxy.getUserid());
            }
            if(!PlanConstant.零星材料入库.equals(entity.getAcceptMaterialType())) {
                String s = pushSubAccept(entity, InvocationInfoProxy.getUserid());
            }
        }else {
            entity.setMaterialSignatureUserId(Long.valueOf(subsignatureUserId));
            entity.setMaterialSignatureUserName(subsignatureUserName);
            entity.setMaterialSignatureUserPhone(subsignatureUserPhone);
            entity.setMaterialSignatureDate(new Date());
            entity.setMaterialSignatureStatus(1);
        }
        String key = billType + "::" + entity.getId().toString()+"::return";
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", entity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, billType, authority, entity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            entity.setAttachIds(attchIdsList);
            //更新单据
            super.saveOrUpdate(entity, false);

            if(!PlanConstant.零星材料入库.equals(entity.getAcceptMaterialType())) {
                logger.info("验收结果向乙方联系人id-{}发送消息", entity.getSiteAcceptorId().toString());
                PushMsgParameter parameter = new PushMsgParameter();
                parameter.setSubject("【验收结果】：【"+entity.getBillCode()+"】，【"+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()) +"】发货单已验收，请查看！");
                StringBuilder content = new StringBuilder();
                content.append("【").append(entity.getSupplierName()).append("】，您向【")
                        .append(entity.getProjectName()).append("】，【")
                        .append(entity.getContractName()).append("】，的发货单，【").append(entity.getSupplierName()).append("】，已被验收，请查看验收结果。");
                parameter.setContent(content.toString());
                parameter.setPcUrl(BASE_HOST + CommonConstants.物资验收PC详情 + entity.getId().toString());
                parameter.setMobileUrl(BASE_HOST + CommonConstants.物资验收移动端详情 + entity.getId().toString());

                String[] recIds = new String[]{entity.getSiteAcceptorId().toString()}; //验收人Id
                parameter.setReceivers(recIds);
                sendMsg(parameter, entity.getId(), "验收结果向乙方联系人发送消息");
            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", entity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return null;
    }
    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});

        CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            logger.error("{}-发送消息失败，单据Id-{}，发送消息结果-{}", oprMsg, billId, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
        } else {
            logger.info("{}-发送消息成功！", oprMsg);
        }
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /**
     * 更新单据推送状态
     *
     * @param id   单据id
     * @param flag 是否成功推送
     */
    private void executeUpdate(Long id, Boolean flag) {
        // 更新协同推送状态
        UpdateWrapper<AcceptEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", id);
        // 修改推送状态
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set("bill_push_flag", BillPushStatusEnum.推送成功.getStatus());
        } else {
            updateWrapper.set("bill_push_flag", BillPushStatusEnum.未成功推送.getStatus());
        }
        super.update(updateWrapper);
    }

    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    public void toNumErp(AcceptEntity entity,boolean flag){
        Integer sourceType = entity.getSourceType();
        //回写多少是否可以回写？ 0:来源发货单;1:自制; 2 其他

        if (sourceType==0){
            //来源发货单
            List<AcceptDetailEntity> detailList = entity.getDetailList();
            if (CollectionUtils.isNotEmpty(detailList)){
                Map<Long, AcceptDetailEntity> acceptDetailEntityMap = detailList.stream().collect(Collectors.toMap(e -> e.getSourceDetailId(), e -> e));
                QueryWrapper<DeliveryDetailEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.in("id", acceptDetailEntityMap.keySet());
                List<DeliveryDetailEntity> deliveryDetailList = deliveryDetailService.list(queryWrapper);
                for (DeliveryDetailEntity item : deliveryDetailList){

                    if (flag){
                        //判断当前是否可用
                        BigDecimal deliveryNum = item.getDeliveryNum();//发货数量
                        AcceptDetailEntity accItem = acceptDetailEntityMap.get(item.getId());


                    }
                }


            }

        }
        //来源发货单回写发货单 -回写订单

        //自制回写订单


        //统计订单
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBillEffect(AcceptEntity entity) {
        if(!PlanConstant.零星材料入库.equals(entity.getAcceptMaterialType())) {
            if (entity.getSourceType()==0){
                if (0==entity.getFinalAcceptFlag()&&0==entity.getCloseDelivery()){
                    //部分验收 不关闭只是修改发货单的验收状态
                    deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.分批验收.getCode());
                }else if (1==entity.getFinalAcceptFlag()&&1==entity.getCloseDelivery()){
                    //匹配全部验收 修改发货单全部验收
                    deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.验收完成.getCode());
                }else if (0==entity.getFinalAcceptFlag()&&1==entity.getCloseDelivery()){
                    //不匹配全部验收 关闭发货单 释放金额赋值
                    deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.部分退回.getCode());
                    deliveryDetailService.updateDeliveryResNum(entity,true);
                }
            }
            if (entity.getSourceType()==0||entity.getSourceType()==1){
                if (entity.getSourceType()==0){
                    DeliveryEntity deliveryEntity = deliveryService.selectById(entity.getDeliveryBillId());
                    String s = deliveryService.updateSupDelivery(deliveryEntity);
                    if (StringUtils.isNotBlank(s)){
                        throw new BusinessException(s);
                    }
                }
                OrderEntity orderEntity = orderService.selectById(entity.getOrderBillId());
                String supBusiness = orderService.pushToSupBusiness(BeanMapper.map(orderEntity, OrderVO.class));
                if (StringUtils.isNotBlank(supBusiness)){
                    throw new BusinessException(supBusiness);
                }
            }
        }

        // 生效
        entity.setEffectDate(new Date());
        entity.setApproveUserId(sessionManager.getUserContext().getUserId());
        entity.setApproveUserName(sessionManager.getUserContext().getUserName());
        super.saveOrUpdate(entity, false);
    }
}