package com.ejianc.business.zdsmaterial.material.service;

import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 材料分类属性可选值
 * 
 * @author generator
 * 
 */
public interface IMaterialCategoryPropertySubItemService extends IBaseService<MaterialCategoryPropertySubItemEntity> {

    List<MaterialCategoryPropertySubItemVO> getAllByCategoryId(Long categoryId);

    List<MaterialCategoryPropertySubItemEntity> queryByNames(ArrayList<String> names, Long propertyId);

    void updatePropertyItemsValidFlag(List<Long> validPropertyValIds, Integer code);

    List<MaterialCategoryPropertySubItemVO> getAllByCategoryId(Long categoryId, Boolean includeUnValid);

    List<Long> getInValidPropertyItemIds(List<Long> materialIds);

    void validPropertyItems(List<Long> getInValidPropertyItemIds);

    List<MaterialCategoryPropertySubItemVO> searchList(MaterialCategoryPropertySubItemVO searchVO);

    Map<Long, List<MaterialCategoryPropertySubItemVO>> getAllByCategoryIds(List<Long> categoryIds);
    Map<Long, List<MaterialCategoryPropertySubItemVO>> getAllByCategoryIds(List<Long> categoryIds, Integer enabled);

    Map<Long, List<MaterialCategoryPropertySubItemVO>> getCategoryItemMap(List<Long> categoryIds, Integer enabled);
}
