package com.ejianc.business.zdsmaterial.cloudstore.order.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cloudstore.order.bean.AllotOrderDetailEntity;
import com.ejianc.business.zdsmaterial.cloudstore.order.bean.AllotOrderEntity;
import com.ejianc.business.zdsmaterial.cloudstore.constants.AllotOrderBusinessStatusEnums;
import com.ejianc.business.zdsmaterial.cloudstore.constants.CommonConstants;
import com.ejianc.business.zdsmaterial.cloudstore.order.mapper.AllotOrderMapper;
import com.ejianc.business.zdsmaterial.cloudstore.order.service.IAllotOrderDetailService;
import com.ejianc.business.zdsmaterial.cloudstore.order.service.IAllotOrderService;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyDetailVO;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyVO;
import com.ejianc.business.zdsmaterial.cloudstore.order.vo.AllotOrderVO;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsstore.api.IIdleManageApi;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.IdleFlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import io.seata.spring.annotation.GlobalTransactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 调拨订单
 *
 * @author generator
 */
@Service("allotOrderService")
public class AllotOrderServiceImpl extends BaseServiceImpl<AllotOrderMapper, AllotOrderEntity> implements IAllotOrderService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ALLOT_ORDER";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private AllotOrderMapper mapper;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IAllotOrderDetailService detailService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IStoreManageApi storeManageApi;

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private IStoreFlowApi storeFlowApi;

    @Autowired
    private IIdleManageApi iIdleManageApi;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Override
    public void saveNewOrderByApply(AllotApplyVO allotApplyVO) {

        //本次新增的订单列表
        List<AllotOrderEntity> newOrderList = new ArrayList<>();
        List<AllotOrderDetailEntity> newOrderDetailList = new ArrayList<>();

        //1、将调拨申请子表按照调出方进行分组
        Map<Long, List<AllotApplyDetailVO>> applyDetailMap = allotApplyVO.getDetailList().stream()
                .collect(Collectors.groupingBy(AllotApplyDetailVO::getExceedOrgId, Collectors.toList()));

        List<Long> shelfDetailIds =  allotApplyVO.getDetailList().stream().map(AllotApplyDetailVO::getSourceId).collect(Collectors.toList());

        List<GoodsEntity> goods = goodsService.getAllByIds(shelfDetailIds);
        Map<Long,GoodsEntity> shelfDetailMap = goods.stream().collect(Collectors.toMap(GoodsEntity::getId, item -> item));

        //2、根据拆分的调拨申请子表，创建对应的调拨订单
        AllotOrderEntity tmp = null;
        for (Long outOrgId : applyDetailMap.keySet()) {
            tmp = generateOrderByApply(allotApplyVO, applyDetailMap.get(outOrgId), shelfDetailMap);
            newOrderDetailList.addAll(tmp.getAllotOrderDetailList());
            newOrderList.add(tmp);
        }

        //3、保存入库
        //保存订单子表
        detailService.saveOrUpdateBatch(newOrderDetailList, newOrderDetailList.size(), false);
        //保存订单主表
        super.saveOrUpdateBatch(newOrderList, newOrderList.size(), false);

        //发送消息
        //标题：【物资调拨】，【单据编号】，【时间】闲置物资被下单，请尽快处理！
        //内容：【单据编号】，【被下单物资分类】已被【调入项目】下单调拨，请尽快处理！
        List<Long> projectIdS = newOrderList.stream().map(AllotOrderEntity::getOutProjectId).collect(Collectors.toList());
        Map<Long, Long> projectManagerIdS = getProjectManagerIdS(projectIdS);

        List<Long> categoryIds = newOrderDetailList.stream().map(AllotOrderDetailEntity::getMaterialTypeId).collect(Collectors.toList());
        List<MaterialCategoryVO> categtoryVOs = categoryService.queryCategoryListByChildren(categoryIds);

//        Map<Long, MaterialCategoryVO> categoryMap = new HashMap<>();
//        if(CollectionUtils.isNotEmpty(categtoryVOs)) {
//            categoryMap = categtoryVOs.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
//        }

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        for (AllotOrderEntity order : newOrderList) {
            Long projectManagerId = null;
            List<String> userIds = new ArrayList<>();
//            Set<String> categoryNames = new HashSet<>();
            if (null!=order.getOutProjectId()&&projectManagerIdS.containsKey(order.getOutProjectId())) {
                projectManagerId = projectManagerIdS.get(order.getOutProjectId());
            }
            //去重记录对应的发布人
            for (AllotOrderDetailEntity detail : order.getAllotOrderDetailList()) {
                if (!userIds.contains(detail.getSellUserId().toString())) {
                    userIds.add(detail.getSellUserId().toString());
                }
//                if(categoryMap.containsKey(detail.getMaterialTypeId()) && categoryMap.containsKey(categoryMap.get(detail.getMaterialTypeId()).getParentId())) {
//                    categoryNames.add(categoryMap.get(categoryMap.get(detail.getMaterialTypeId()).getParentId()).getName());
//                }
            }

            //调拨申请生效 向项目经理、物资发布人
            PushMsgParameter parameter = new PushMsgParameter();
            StringBuilder content = new StringBuilder();
            content.append("【").append(order.getBillCode()).append("】");
            if(StringUtils.isNotEmpty(order.getCategoryNames())) {
                content.append("，【").append(order.getCategoryNames()).append("】");
            }
            content.append("已被【").append(order.getInProjectName()).append("】下单调货，请尽快处理！");

            parameter.setContent(content.toString());
            parameter.setPcUrl(BASE_HOST + (null == order.getOutProjectId() ? CommonConstants.大区调出订单PC详情 : CommonConstants.云仓调出订单PC详情) + order.getId().toString());
            parameter.setSubject("【物资调拨】，【"+order.getBillCode()+"】，【"+DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())+"】闲置物资被下单，请尽快处理！");
            if (null != projectManagerId) {
                userIds.add(projectManagerId.toString());
            }
            String[] longs = userIds.toArray(new String[userIds.size()]);
            parameter.setReceivers(longs);
            sendMsg(parameter, order.getId(), "调拨申请生效 向项目经理、物资发布人发送消息");
        }
    }

    @Override
    public void deleteOrderByApply(Long allotApplyId) {
        logger.info("根据调拨单Id-{}删除对应订单信息", allotApplyId);

        QueryWrapper<AllotOrderEntity> countQuery = new QueryWrapper<>();
        countQuery.eq("allot_apply_id", allotApplyId);
        countQuery.and(iq -> iq.gt("business_status", AllotOrderBusinessStatusEnums.调入方洽商已确认.getCode()).or().gt("edit_num", 0));
        int count = super.count(countQuery);
        if (count > 0) {
            throw new BusinessException("调拨订单已被下游引用");
        }

        QueryWrapper<AllotOrderEntity> query = new QueryWrapper<>();
        query.select("id");
        query.eq("allot_apply_id", allotApplyId);
        List<Long> orderIds = super.listObjs(query, (item) -> Long.valueOf(item.toString()));
        super.removeByIds(orderIds);
    }

    @Override
    public void checkAllotableNum(List<AllotOrderDetailEntity> allotOrderDetailList) {
        Map<Long, BigDecimal> goodsAllotableNumMap = goodsService.getAllotableNum(allotOrderDetailList.stream()
                .map(item -> item.getSourceId()).collect(Collectors.toList()));

        StringBuilder sp = new StringBuilder();
        for (AllotOrderDetailEntity detail : allotOrderDetailList) {
            if (detail.getAllotNum().compareTo(ComputeUtil.safeAdd(goodsAllotableNumMap.get(detail.getSourceId()), detail.getInitialAllotNum())) > 0) { //本次调拨量 <= 可下单量+初始调拨量
                sp.append("编码：").append(detail.getMaterialCode()).append("-").append("品牌：").append(detail.getBrandName()).append("、");
            }
        }
        if (sp.length() > 0) {
            throw new BusinessException("物资" + sp.substring(0, sp.length() - 1) + "调拨量超出可下单量");
        }
    }

    @Override
    public AllotOrderVO saveEditAllotOrderInfo(AllotOrderEntity entity) {
        //TODO 集市物资加锁

        //校验调拨量是否超过可下单量
        checkAllotableNum(entity.getAllotOrderDetailList());

        //改写占用调拨中数量
        goodsService.updateAllotNum(getUpdateGoodList(entity.getAllotOrderDetailList(), "update", "allot"), true);

        //编辑 次数+1
        entity.setEditNum(entity.getEditNum() + 1);
        entity.setEditUserId(InvocationInfoProxy.getUserid());
        entity.setEditUserName(sessionManager.getUserContext().getUserName());

        //修改状态为待调入方确认
        entity.setBusinessStatus(AllotOrderBusinessStatusEnums.调入方洽商待确认.getCode());

        //保存
        super.saveOrUpdate(entity, false);

        Long inProjetMgid =  getProjectManagerId(entity.getInProjectId());
        List<String> recIds = new ArrayList<>();
        if(null != inProjetMgid) {
            recIds.add(inProjetMgid.toString());
        }
        recIds.add(entity.getPurUserId().toString());

        //向调入方预订人、项目经理 发送消息：【您订购的物资{调出项目+物资分类名称}调出方已修改订单信息，请尽快确认。】
        StringBuilder content = new StringBuilder();
        content.append("您订购的物资【")
                .append(entity.getStoreType() == 1 ? "调出项目：" + entity.getOutProjectName() : "调出单位" + entity.getOutParentOrgName())
                .append("，物资分类：").append(entity.getCategoryNames())
                .append("】调出方已修改订单信息，请尽快确认。");

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(recIds.toArray(new String[recIds.size()]));
        parameter.setPcUrl(BASE_HOST + CommonConstants.调入订单PC详情 + entity.getId().toString());
        parameter.setSubject("【调入订单】【" + entity.getBillCode() + "】【" + sdf.format(entity.getCreateTime()) +"】");
        parameter.setContent(content.toString());
        parameter.setSubject(parameter.getContent());

        sendMsg(parameter, entity.getId(), "调出方修改，向调入方预订人");
        return BeanMapper.map(entity, AllotOrderVO.class);
    }

    @Override
    public List<GoodsVO> getUpdateGoodList(List<AllotOrderDetailEntity> allotOrderDetailList, String oprType, String allotType) {
        List<GoodsVO> resp = new ArrayList<>();
        allotOrderDetailList.stream().forEach(detail -> {
            GoodsVO g = new GoodsVO();
            g.setId(detail.getSourceId());
            if("alloted".equals(allotType)) {
                g.setAllotedNum(detail.getAllotNum());
            } else {
                if ("update".equals(oprType)) {
                    g.setAllotNum(ComputeUtil.safeSub(detail.getAllotNum(), detail.getInitialAllotNum()));
                } else {
                    g.setAllotNum(detail.getAllotNum());
                }
            }
            resp.add(g);
        });

        return resp;
    }

    @Override
    public void sendMsg(PushMsgParameter parameter, Long allotOrderId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});

        CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            logger.error("调拨订单id-{},{}发送消息失败，{}", allotOrderId, oprMsg, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
        } else {
            logger.info("调拨订单id-{},{}发送消息成功！", allotOrderId, oprMsg);
        }
    }

    public void sendEmail(PushMsgParameter parameter, Long allotOrderId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_EMAIL});

        CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            logger.error("调拨订单id-{},{}发送消息失败，{}", allotOrderId, oprMsg, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
        } else {
            logger.info("调拨订单id-{},{}发送消息成功！", allotOrderId, oprMsg);
        }
    }

    @Override
    @GlobalTransactional(name = "AllotOrderServiceImpl_saveOrderInStore", rollbackFor = Exception.class)
    public AllotOrderVO saveOrderInStore(AllotOrderEntity entity) {
        //校验子表是否都已设置入库仓库
        List<AllotOrderDetailEntity> detailList = entity.getAllotOrderDetailList().stream()
                .filter(item -> null == item.getInStoreId()).collect(Collectors.toList());
        if (detailList.size() > 0) {
            throw new BusinessException("操作失败，存在物资未设置入库仓库！");
        }

        //TODO 集市物资加锁

        //修改物资集市调拨中数量
        goodsService.updateAllotNum(getUpdateGoodList(entity.getAllotOrderDetailList(), "release", "allot"), false);
        goodsService.updateAllotedNum(getUpdateGoodList(entity.getAllotOrderDetailList(), "release", "alloted"), true);

        //设置订单状态
        entity.setBusinessStatus(AllotOrderBusinessStatusEnums.交易完成.getCode());
        super.saveOrUpdate(entity, false);

        //生成调入方入库流水
        sendInStoreData(entity);
        logger.info("调拨订单-{}生成调入方调入流水成功！", entity.getId());

        //向调出方上架人发送消息：
        // 标题：【物资调拨】，【单据编号】，【时间】订单完成交易！
        //内容：【单据编号】，【调入项目】已完成交易，并收货入库！
        StringBuilder content = new StringBuilder();
        StringBuilder subject = new StringBuilder();
        subject.append("【物资调拨】，【").append(entity.getBillCode()).append("】").append("，【").append(entity.getBillCode())
                .append("】，【").append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】订单完成交易！");
        content.append("【").append(entity.getBillCode()).append("】，调入项目【")
                .append(entity.getInProjectName())
                .append("】，已完成交易，并收货入库！");

        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(new String[]{entity.getPurUserId().toString()});
        parameter.setPcUrl(BASE_HOST
                + (entity.getStoreType() == 1 ? CommonConstants.云仓调出订单PC详情 : CommonConstants.大区调出订单PC详情)
                + entity.getId().toString());
        parameter.setContent(content.toString());
        parameter.setSubject(parameter.getContent());
        sendMsg(parameter, entity.getId(), "调入方收货入库完成，向调入方联系人");

        return BeanMapper.map(entity, AllotOrderVO.class);
    }

    @Override
    public AllotOrderVO saveOrderInStoreEdit(AllotOrderEntity entity) {
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, AllotOrderVO.class);
    }

    @Override
    @GlobalTransactional(name = "AllotOrderServiceImpl_saveOrderOutStore", rollbackFor = Exception.class)
    public void saveOrderOutStore(AllotOrderEntity entity) {

        //生成调出方出库流水
        sendOutStoreData(entity, false);
        logger.info("调拨订单-{}生成调出方出库流水成功！", entity.getId());

        //生成调出方闲置流水
        sendIdleStoreData(entity, false);
        logger.info("调拨订单-{}生成调出方闲置流水成功！", entity.getId());

        super.saveOrUpdate(entity, false);
    }

    /**
     * 组装闲置流水数据
     *
     * @param entity
     * @return
     */
    @Override
    public void sendIdleStoreData(AllotOrderEntity entity, boolean isRollBack) {
        if(isRollBack) {
            CommonResponse<String> idleStoreResp = iIdleManageApi.inOutStoreRollback(entity.getId());
            logger.info("云仓闲置撤回参数：{}, 结果: {}", entity.getId(),
                    JSONObject.toJSONString(idleStoreResp, SerializerFeature.PrettyFormat));
            if (!idleStoreResp.isSuccess()) {
                logger.error("调拨订单-{}生成调出方闲置撤回失败，数据：{}, 结果：{}", entity.getId(),
                        entity.getId(),
                        JSONObject.toJSONString(idleStoreResp, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                throw new BusinessException("操作失败，生成调出方闲置撤回失败！");
            }

        } else {
            Map<Long, List<AllotOrderDetailEntity>> storeMap = entity.getAllotOrderDetailList().stream()
                    .collect(Collectors.groupingBy(item -> item.getOutStoreId(), Collectors.toList()));

            List<IdleFlowVO> vos = new ArrayList<>();
            IdleFlowVO flowVO = null;
            for (Long inStoreId : storeMap.keySet()) {
                for (AllotOrderDetailEntity orderDetail : storeMap.get(inStoreId)) {
                    flowVO = BeanMapper.map(StoreManageUtil.getFlowVO(InOutTypeEnum.云仓出库, 0), IdleFlowVO.class);
                    setIdleFlowData(flowVO, orderDetail, InOutTypeEnum.云仓出库, entity);
                    vos.add(flowVO);
                }
            }

            CommonResponse<String> idleStoreResp = iIdleManageApi.inOutStore(vos);
            logger.info("云仓闲置参数：{}, 结果: {}", JSONObject.toJSONString(vos, SerializerFeature.PrettyFormat),
                    JSONObject.toJSONString(idleStoreResp, SerializerFeature.PrettyFormat));
            if (!idleStoreResp.isSuccess()) {
                logger.error("调拨订单-{}生成调出方出库流水失败，数据：{}, 结果：{}", entity.getId(),
                        JSONObject.toJSONString(vos, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue),
                        JSONObject.toJSONString(idleStoreResp, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                throw new BusinessException("操作失败，生成调出方出库流水失败！");
            }
        }

    }

    /**
     * 组装出库流水数据
     *
     * @param entity
     * @return
     */
    @Override
    public void sendOutStoreData(AllotOrderEntity entity, boolean isRollBack) {
        Map<Long, List<AllotOrderDetailEntity>> storeMap = entity.getAllotOrderDetailList().stream()
                .collect(Collectors.groupingBy(item -> item.getOutStoreId(),
                Collectors.toList()));

        List<FlowVO> flowVOS = new ArrayList<>();
        List<StoreManageVO> vos = new ArrayList<>();
        StoreManageVO outStoreVo = null;
        FlowVO flowVO = null;
        List<Long> sourceIdsForRollBack = null;
        for (Long inStoreId : storeMap.keySet()) {
            outStoreVo = new StoreManageVO();
            outStoreVo.setFlowVOList(new ArrayList<>());
            outStoreVo.setSourceId(entity.getId());
            outStoreVo.setStoreId(inStoreId);
            outStoreVo.setInOutTypeEnum(InOutTypeEnum.云仓出库);
            outStoreVo.setOutEffectiveON(true); //生效
            sourceIdsForRollBack = new ArrayList<>();
            sourceIdsForRollBack.add(entity.getId());
            outStoreVo.setSourceIdsForRollBack(sourceIdsForRollBack);
            outStoreVo.setInOutTypeEnum(InOutTypeEnum.云仓出库);

            for (AllotOrderDetailEntity orderDetail : storeMap.get(inStoreId)) {
                flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.云仓出库, 0);
                setFlowData(flowVO, orderDetail, InOutTypeEnum.云仓出库, entity);
                flowVOS.add(flowVO);
                outStoreVo.getFlowVOList().add(flowVO);
            }
            vos.add(outStoreVo);
        }

        //获取物资库存均价   TODO 此处有个问题  查询库存均价 flowVo inOutType是否使用出库的还是用入库的类型
        CommonResponse<List<FlowVO>> priceResp = storeFlowApi.getNewPrice(flowVOS);
        if (!priceResp.isSuccess()) {
            logger.error("获取物资库存均价失败,{}", JSONObject.toJSONString(priceResp, SerializerFeature.PrettyFormat));
            throw new BusinessException("获取物资库存均价失败");
        }

        Map<String, FlowVO> flowMap = new HashMap<>();
        priceResp.getData().stream().forEach(item -> {
            flowMap.put(item.getStoreId().toString() + item.getMaterialId().toString() + item.getBrandId().toString(), item);
        });

        for (FlowVO f : flowVOS) {
            flowVO = flowMap.get(f.getStoreId().toString() + f.getMaterialId().toString() + f.getBrandId().toString());
            if (null != flowVO && null != flowVO.getTaxRate()) {
                f.setTaxRate(flowVO.getTaxRate());
                f.setPrice(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(f.getTaxPrice(), f.getTaxRate()), new BigDecimal("100")));
                f.setMny(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(f.getPrice(), f.getNum())));
                f.setTax(ComputeUtil.safeSub(f.getTaxMny(), f.getMny()));
            } else {
                f.setTaxRate(BigDecimal.ZERO);
                f.setPrice(f.getTaxPrice());
                f.setMny(f.getTaxMny());
                f.setTax(BigDecimal.ZERO);
            }
        }

        if(isRollBack) {
            CommonResponse<List<StoreManageVO>> outStoreResp = storeManageApi.inOutStoreRollbackBatch(vos);
            logger.info("云仓出库流水撤回参数：{}, 结果: {}", JSONObject.toJSONString(vos, SerializerFeature.PrettyFormat),
                    JSONObject.toJSONString(outStoreResp, SerializerFeature.PrettyFormat));
            if (!outStoreResp.isSuccess()) {
                logger.error("调拨订单-{}生成调出方出库流水撤回失败，数据：{}, 结果：{}", entity.getId(),
                        JSONObject.toJSONString(outStoreVo, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue),
                        JSONObject.toJSONString(outStoreResp, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                throw new BusinessException("操作失败，生成调出方出库流水撤回失败！");
            }
        } else {
            CommonResponse<List<StoreManageVO>> outStoreResp = storeManageApi.inOutStoreBatch(vos);
            logger.info("云仓出库参数：{}, 结果: {}", JSONObject.toJSONString(vos, SerializerFeature.PrettyFormat),
                    JSONObject.toJSONString(outStoreResp, SerializerFeature.PrettyFormat));
            if (!outStoreResp.isSuccess()) {
                logger.error("调拨订单-{}生成调出方出库流水失败，数据：{}, 结果：{}", entity.getId(),
                        JSONObject.toJSONString(outStoreVo, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue),
                        JSONObject.toJSONString(outStoreResp, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                throw new BusinessException("操作失败，生成调出方出库流水失败！");
            }
        }

    }

    /**
     * 组装入库流水数据
     *
     * @param entity
     * @return
     */
    private void sendInStoreData(AllotOrderEntity entity) {
        Map<Long, List<AllotOrderDetailEntity>> storeMap = entity.getAllotOrderDetailList().stream().collect(Collectors.groupingBy(item -> item.getInStoreId(),
                Collectors.toList()));
        List<FlowVO> flowVOS = new ArrayList<>();
        List<StoreManageVO> vos = new ArrayList<>();
        StoreManageVO inStoreVo = null;
        FlowVO flowVO = null;
        for (Long inStoreId : storeMap.keySet()) {
            inStoreVo = new StoreManageVO();
            inStoreVo.setFlowVOList(new ArrayList<>());
            inStoreVo.setStoreId(inStoreId);
            inStoreVo.setSourceId(entity.getId());
            inStoreVo.setInOutTypeEnum(InOutTypeEnum.云仓入库);
            for (AllotOrderDetailEntity orderDetail : storeMap.get(inStoreId)) {
                flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.云仓入库, 0);
                setFlowData(flowVO, orderDetail, InOutTypeEnum.云仓入库, entity);
                flowVOS.add(flowVO);
                inStoreVo.getFlowVOList().add(flowVO);
            }
            vos.add(inStoreVo);
        }

        //获取物资库存均价
        CommonResponse<List<FlowVO>> priceResp = storeFlowApi.getNewPrice(flowVOS);
        if (!priceResp.isSuccess()) {
            logger.error("获取物资库存均价失败,{}", JSONObject.toJSONString(priceResp, SerializerFeature.PrettyFormat));
            throw new BusinessException("获取物资库存均价失败");
        }

        Map<String, FlowVO> flowMap = new HashMap<>();
        priceResp.getData().stream().forEach(item -> {
            flowMap.put(item.getStoreId().toString() + item.getMaterialId().toString() + item.getBrandId().toString(), item);
        });

        for (FlowVO f : flowVOS) {
            flowVO = flowMap.get(f.getStoreId().toString() + f.getMaterialId().toString() + f.getBrandId().toString());
            if (null != flowVO && null != flowVO.getTaxRate()) {
                f.setTaxRate(flowVO.getTaxRate());
                f.setPrice(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(f.getTaxPrice(), f.getTaxRate()), new BigDecimal("100")));
                f.setMny(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(f.getPrice(), f.getNum())));
                f.setTax(ComputeUtil.safeSub(f.getTaxMny(), f.getMny()));
            } else {
                f.setTaxRate(BigDecimal.ZERO);
                f.setPrice(f.getTaxPrice());
                f.setMny(f.getTaxMny());
                f.setTax(BigDecimal.ZERO);
            }
        }

        CommonResponse<List<StoreManageVO>> inStoreResp = storeManageApi.inOutStoreBatch(vos);
        logger.info("云仓入库参数：{}, 结果: {}", JSONObject.toJSONString(vos, SerializerFeature.PrettyFormat),
                JSONObject.toJSONString(inStoreResp, SerializerFeature.PrettyFormat));
        if (!inStoreResp.isSuccess()) {
            logger.error("调拨订单-{}生成调入方入库流水失败，数据：{}, 结果：{}", entity.getId(),
                    JSONObject.toJSONString(inStoreVo, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue),
                    JSONObject.toJSONString(inStoreResp, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            throw new BusinessException("操作失败，生成调入方入库流水失败！");
        }
    }

    /**
     * 组装流水信息
     *
     * @param flowVO
     * @param orderDetail
     * @param inOutTypeEnum
     */
    private void setIdleFlowData(IdleFlowVO flowVO, AllotOrderDetailEntity orderDetail, InOutTypeEnum inOutTypeEnum, AllotOrderEntity order) {
        flowVO.setSourceBillTypeName(inOutTypeEnum.getInOutTypeName());
        flowVO.setStoreId(orderDetail.getOutStoreId());
        flowVO.setStoreName(orderDetail.getOutStoreName());
        flowVO.setSourceId(orderDetail.getOrderId());
        flowVO.setSourceDetailId(orderDetail.getId());
        flowVO.setProjectId(order.getOutProjectId());
        flowVO.setProjectName(order.getOutProjectName());
        flowVO.setOrgId(order.getOutOrgId());
        flowVO.setOrgName(order.getOutOrgName());
        flowVO.setParentOrgId(order.getOutParentOrgId());
        flowVO.setParentOrgCode(order.getOutParentOrgCode());
        flowVO.setParentOrgName(order.getOutParentOrgName());
        flowVO.setMaterialCategoryId(orderDetail.getMaterialTypeId());
        flowVO.setMaterialCategoryName(orderDetail.getMaterialTypeName());
        flowVO.setMaterialCategoryCode(orderDetail.getMaterialTypeCode());
        flowVO.setMaterialId(orderDetail.getMaterialId());
        flowVO.setMaterialName(orderDetail.getMaterialName());
        flowVO.setMaterialCode(orderDetail.getMaterialCode());
        flowVO.setMaterialSpec(orderDetail.getPropertyValue());
        flowVO.setBrandId(orderDetail.getBrandId());
        flowVO.setBrandName(orderDetail.getBrandName());
        flowVO.setMaterialUnitName(orderDetail.getUnitName());
        flowVO.setNum(orderDetail.getAllotNum().negate()); //闲置推负值
        flowVO.setProductCode(orderDetail.getProductCode());
        flowVO.setMaterialUnitId(orderDetail.getUnitId());
        flowVO.setMaterialUnitName(orderDetail.getUnitName());
        flowVO.setSourceId(order.getId());
        flowVO.setSourceDetailId(orderDetail.getId());
        flowVO.setSourceBillCode(order.getBillCode());
        flowVO.setSourceBillDate(order.getPurTime());
    }

    /**
     * 组装流水信息
     *
     * @param flowVO
     * @param orderDetail
     * @param inOutTypeEnum
     */
    private void setFlowData(FlowVO flowVO, AllotOrderDetailEntity orderDetail, InOutTypeEnum inOutTypeEnum, AllotOrderEntity order) {
        flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
        flowVO.setSourceBillTypeName(inOutTypeEnum.getInOutTypeName());
        flowVO.setStoreId(inOutTypeEnum.getInOutType() == 15 ? orderDetail.getInStoreId() : orderDetail.getOutStoreId());
        flowVO.setStoreName(inOutTypeEnum.getInOutType() == 15 ? orderDetail.getInStoreName() : orderDetail.getOutStoreName());
        flowVO.setProjectId(inOutTypeEnum.getInOutType() == 15 ? order.getInProjectId() : order.getOutProjectId());
        flowVO.setProjectName(inOutTypeEnum.getInOutType() == 15 ? order.getInProjectName() : order.getOutProjectName());
        flowVO.setOrgId(inOutTypeEnum.getInOutType() == 15 ? order.getInOrgId() : order.getOutOrgId());
        flowVO.setOrgName(inOutTypeEnum.getInOutType() == 15 ? order.getInOrgName() : order.getOutOrgName());
        flowVO.setParentOrgId(inOutTypeEnum.getInOutType() == 15 ? order.getInParentOrgId() : order.getOutParentOrgId());
        flowVO.setParentOrgCode(inOutTypeEnum.getInOutType() == 15 ? order.getInParentOrgCode() : order.getOutParentOrgCode());
        flowVO.setParentOrgName(inOutTypeEnum.getInOutType() == 15 ? order.getInParentOrgName() : order.getOutParentOrgName());
        flowVO.setEmployeeId(inOutTypeEnum.getInOutType() == 15 ? order.getPurUserId() : orderDetail.getSellUserId());
        flowVO.setEmployeeName(inOutTypeEnum.getInOutType() == 15 ? order.getPurUserName() : orderDetail.getSellUserName());
        flowVO.setMaterialCategoryId(orderDetail.getMaterialTypeId());
        flowVO.setMaterialCategoryName(orderDetail.getMaterialTypeName());
        flowVO.setMaterialCategoryCode(orderDetail.getMaterialTypeCode());
        flowVO.setMaterialId(orderDetail.getMaterialId());
        flowVO.setMaterialName(orderDetail.getMaterialName());
        flowVO.setMaterialCode(orderDetail.getMaterialCode());
        flowVO.setMaterialSpec(orderDetail.getPropertyValue());
        flowVO.setBrandId(orderDetail.getBrandId());
        flowVO.setBrandName(orderDetail.getBrandName());
        flowVO.setMaterialUnitName(orderDetail.getUnitName());
        flowVO.setNum(orderDetail.getAllotNum());
        flowVO.setProductCode(orderDetail.getProductCode());
        flowVO.setMaterialUnitId(orderDetail.getUnitId());
        flowVO.setMaterialUnitName(orderDetail.getUnitName());
        flowVO.setSourceId(orderDetail.getOrderId());
        flowVO.setSourceDetailId(orderDetail.getId());

        flowVO.setTaxMny(orderDetail.getDetailAssetTaxMny());
        flowVO.setTaxPrice(ComputeUtil.safeDiv(orderDetail.getDetailAssetTaxMny(), orderDetail.getAllotNum()));

        //TODO 根据最新均价反算税率  计算单价无税 计算金额无税 计算税额
//        flowVO.setPrice(flowEntity.getPrice());
//        flowVO.setTaxRate(flowEntity.getTaxRate());
//        flowVO.setMny(ComputeUtil.safeMultiply(flowVO.getPrice(), item.getInventory()));
//        flowVO.setTax(ComputeUtil.safeSub(flowVO.getTaxMny(), flowVO.getMny()));

        flowVO.setSourceId(order.getId());
        flowVO.setSourceDetailId(orderDetail.getId());
        flowVO.setSourceBillCode(order.getBillCode());
        flowVO.setSourceBillDate(order.getPurTime());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancelOrder(AllotOrderEntity order) {
        //查询的当前操作人信息
        CommonResponse<EmployeeVO> empResp = employeeApi.getById(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        if (!empResp.isSuccess()) {
            logger.error("查询用户id-{}失败，{}", InvocationInfoProxy.getEmployeeId(), JSONObject.toJSONString(empResp));
            throw new BusinessException("操作失败，获取当前用户信息失败！");
        }

        EmployeeVO emp = empResp.getData();

        //记录当前操作人
        order.setCancelTime(new Date());
        order.setCancelUserCode(emp.getCode());
        order.setCancelUserId(emp.getId());
        order.setCancelUserName(emp.getUserName());

        //消息发送准备
        StringBuilder content = new StringBuilder();
        StringBuilder subject = new StringBuilder();
        String pcUrl = null, oprMsg = null;
        String[] receivers = null;
        Set<String> receiverList = null;
        Long projectManagerId = null;

        //更改订单状态
        switch (order.getBusinessStatus()) {
            case 1: //调出方待确认, 调出方取消
            case 3: //调入方洽商已确认, 调出方取消
                //向调入方联系人发消息：
                // 标题：【物资调拨】，【单据编号】，【时间】订单被调出方取消，请尽快处理！
                // 内容：【单据编号】，【调入项目】申请调拨的物资已被调出方取消，请尽快处理！
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.调出方取消.getCode());
                projectManagerId = getProjectManagerId(order.getInProjectId());
                receivers = null != projectManagerId ? new String[]{order.getPurUserId().toString(),projectManagerId.toString()} : new String[]{order.getPurUserId().toString()};

                subject.append("【物资调拨】,【").append(order.getBillCode())
                        .append("】，【").append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】订单被调出方取消，请尽快处理！");
                content.append("【").append(order.getBillCode()).append("】，【")
                        .append(order.getInProjectName()).append("】申请调拨的物资已被调出方取消，请尽快处理！");
                oprMsg = "订单调出方取消，向调入方联系人";
                pcUrl = BASE_HOST + CommonConstants.调入订单PC详情 + order.getId().toString();
                break;

            case 2: //调入方洽商待确认, 调入方取消
                //向调洽商修改人、调出方上架人、项目经理发送消息：【{订单编号+调入项目+材料分类}洽商被取消，请查看订单信息。】
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.调入方取消.getCode());

                receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
                receiverList.add(order.getEditUserId().toString());
                //查询项目经理
                projectManagerId = getProjectManagerId(order.getOutProjectId());
                if (null != projectManagerId) {
                    receiverList.add(projectManagerId.toString());
                }

                subject.append("【物资调拨】,【").append(order.getBillCode())
                        .append("】，【").append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】订单被调入方取消，请尽快处理！");
                receivers = receiverList.toArray(new String[receiverList.size()]);
                content.append("订单编号【").append(order.getBillCode()).append("】，调入项目【")
                        .append(order.getInProjectName())
                        .append("】，物资分类【").append(order.getCategoryNames())
                        .append("】调入方已取消订单，请查看。");
                oprMsg = "订单调入方方取消，向调洽商修改人、调出方上架人、项目经理";
                pcUrl = BASE_HOST + (order.getStoreType() == 1 ? CommonConstants.云仓调出订单PC详情 : CommonConstants.大区调出订单PC详情) + order.getId().toString();

                break;
            case 5: //调入方待收货, 调入方取消
                //向调出方上架人、项目经理发送消息：
                //标题：【物资调拨】，【单据编号】，【时间】调入方拒绝入库，交易结束！
                //内容：【单据编号】，【调入项目】拒绝入库，交易结束！
                order.setBusinessStatus(AllotOrderBusinessStatusEnums.调入方取消.getCode());

                subject.append("【物资调拨】,【").append(order.getBillCode())
                        .append("】，【").append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】调入方拒绝入库，交易结束！");
                receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
                //查询项目经理
                projectManagerId = getProjectManagerId(order.getOutProjectId());
                if (null != projectManagerId) {
                    receiverList.add(projectManagerId.toString());
                }
                receivers = receiverList.toArray(new String[receiverList.size()]);
                content.append("【").append(order.getBillCode()).append("】，【")
                        .append(order.getInProjectName()).append("】调入方拒绝入库，交易结束！");
                oprMsg = "订单调入方调拨拒绝入库，向调出方上架人、项目经理";
                pcUrl = BASE_HOST + (order.getStoreType() == 1 ? CommonConstants.云仓调出订单PC详情 : CommonConstants.大区调出订单PC详情) + order.getId().toString();

                //生出生成的调出方出库流水和闲置
                //生成调出方出库流水
                sendOutStoreData(order, true);
                logger.info("调拨订单-{}撤回调出方出库流水成功！", order.getId());

                //生成调出方闲置流水
                sendIdleStoreData(order, true);
                logger.info("调拨订单-{}撤回调出方闲置流水成功！", order.getId());

                break;
            default:
                throw new BusinessException("操作失败，订单状态为【" + AllotOrderBusinessStatusEnums.getNameByCode(order.getBusinessStatus()) + "】不支持此操作");
        }

        //释放调拨中占用量
        goodsService.updateAllotNum(getUpdateGoodList(order.getAllotOrderDetailList(), "release", "allot"), false);

        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setPcUrl(pcUrl);
        parameter.setContent(content.toString());
        parameter.setSubject(subject.toString());
        sendMsg(parameter, order.getId(), oprMsg);

        super.saveOrUpdate(order, false);
    }

    private Long getProjectManagerId(Long projectId) {
        CommonResponse<JSONArray> projectResp = projectPoolApi.queryProjectPoolById(projectId);
        logger.error("根据项目Id-{}获取项目信息结果，{}", projectId, JSONObject.toJSONString(projectResp, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        if (!projectResp.isSuccess() || projectResp.getData().size() == 0) {
            return null;
        }
        ProjectPoolSetVO p = JSONObject.parseObject(JSONObject.toJSONString(projectResp.getData().get(0)), ProjectPoolSetVO.class);
        return p.getProjectManagementId();
    }

    private Map<Long, Long> getProjectManagerIdS(List<Long> projectId) {
        CommonResponse<List<ProjectPoolSetVO>> projectResp = projectPoolApi.queryProjectsByIds(projectId);
        if (!projectResp.isSuccess() || projectResp.getData().size() == 0) {
            return null;
        }
        List<ProjectPoolSetVO> list = projectResp.getData();
        Map<Long, Long> collect = list.stream().filter(e->null!=e.getProjectManagementId()).collect(Collectors.toMap(ProjectPoolSetVO::getProjectId, ProjectPoolSetVO::getProjectManagementId));
        return collect;
    }

    @Override
    public void confirmOrder(Long id) {
        AllotOrderEntity order = super.selectById(id);
        //更改订单状态
        order.setBusinessStatus(AllotOrderBusinessStatusEnums.调入方洽商已确认.getCode());

        //发送消息 向调出方洽商修改人、上架联系人、项目经理发送消息：
        Set<String> receiverList = order.getAllotOrderDetailList().stream().map(item -> item.getSellUserId().toString()).collect(Collectors.toSet());
        receiverList.add(order.getEditUserId().toString());
        //查询项目经理
        Long projectManagerId = getProjectManagerId(order.getOutProjectId());
        if (null != projectManagerId) {
            receiverList.add(projectManagerId.toString());
        }
        String[] receivers = receiverList.toArray(new String[receiverList.size()]);
        StringBuilder subject = new StringBuilder();
        StringBuilder content = new StringBuilder();
        subject.append("【物资调拨】，【").append(order.getBillCode()).append("】，【")
                .append(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date())).append("】调入方已确认订单，请查看。");

        content.append("订单编号【").append(order.getBillCode()).append("】，调入项目【")
                .append(order.getInProjectName())
                .append("】，物资分类【").append(order.getCategoryNames())
                .append("】调入方已确认订单，请查看。");

        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setPcUrl(BASE_HOST + (order.getStoreType() == 1 ? CommonConstants.云仓调出订单PC详情 : CommonConstants.大区调出订单PC详情) + order.getId().toString());
        parameter.setContent(content.toString());
        parameter.setSubject(subject.toString());

        sendMsg(parameter, order.getId(), "订单调入方确认订单，向调洽商修改人、调出方上架人、项目经理");

        super.saveOrUpdate(order, false);
    }

    /**
     * 根据调拨申请组装调拨订单子表信息
     *
     * @param allotApplyDetailVOS
     * @param order
     * @return
     */
    private List<AllotOrderDetailEntity> generateOrderDetailByApply(List<AllotApplyDetailVO> allotApplyDetailVOS, AllotOrderEntity order, Map<Long,GoodsEntity> shelfDetailMap) {
        List<AllotOrderDetailEntity> resp = BeanMapper.mapList(allotApplyDetailVOS, AllotOrderDetailEntity.class);

        BigDecimal totalAllotMny = BigDecimal.ZERO;
        BigDecimal totalAllotTaxMny = BigDecimal.ZERO;
        Map<Long, String> categoryMap = new HashMap<>();
        for (AllotOrderDetailEntity orderDetail : resp) {
            orderDetail.setAllotApplyDetailId(orderDetail.getId());
            clearBaseField(orderDetail);
            orderDetail.setOrderId(order.getId());
            orderDetail.setSellNum(shelfDetailMap.get(orderDetail.getSourceId()).getNum()); //设置出售数量
            orderDetail.setDetailAllotTaxMny(orderDetail.getAllotTaxMny());
            orderDetail.setDetailAllotMny(orderDetail.getAllotMny());
            orderDetail.setInitialAllotMny(orderDetail.getAllotMny());
            orderDetail.setInitialAllotTaxMny(orderDetail.getDetailAllotTaxMny());
            orderDetail.setAllotApplyDetailId(orderDetail.getId());
            orderDetail.setDetailAssetTaxMny(orderDetail.getDetailAllotTaxMny());
            orderDetail.setDetailAssetMny(orderDetail.getDetailAllotMny());
            orderDetail.setInitialAssetTaxMny(orderDetail.getDetailAssetTaxMny());
            orderDetail.setInitialAssetMny(orderDetail.getDetailAssetMny());
            orderDetail.setInitialSellPrice(orderDetail.getSellPrice());
            orderDetail.setInitialSellTaxPrice(orderDetail.getSellTaxPrice());
            orderDetail.setInitialAllotNum(orderDetail.getAllotNum());
            orderDetail.setMemo(null);
            categoryMap.put(orderDetail.getMaterialTypeId(), orderDetail.getMaterialTypeName());
            totalAllotMny = ComputeUtil.safeAdd(totalAllotMny, orderDetail.getDetailAllotMny());
            totalAllotTaxMny = ComputeUtil.safeAdd(totalAllotTaxMny, orderDetail.getDetailAllotTaxMny());
        }

        order.setTotalAssetTaxMny(totalAllotTaxMny);
        order.setTotalAllotTaxMny(totalAllotTaxMny);
        order.setTotalAllotMny(totalAllotMny);
        order.setTotalAssetMny(totalAllotMny);
        order.setCategoryNames(StringUtils.join(categoryMap.values(), ","));

        return resp;
    }

    private void clearBaseField(BaseEntity base) {
        base.setId(null);
        base.setCreateTime(null);
        base.setCreateUserCode(null);
        base.setUpdateUserCode(null);
        base.setUpdateTime(null);
        base.setVersion(0);
    }

    /**
     * 根据调拨申请组装调拨订单主表信息
     *
     * @param allotApplyVO
     * @param allotApplyDetailVOs
     * @return
     */
    private AllotOrderEntity generateOrderByApply(AllotApplyVO allotApplyVO, List<AllotApplyDetailVO> allotApplyDetailVOs, Map<Long,GoodsEntity> shelfDetailMap) {
        AllotOrderEntity order = new AllotOrderEntity();
        AllotApplyDetailVO tmpApplyDetail = allotApplyDetailVOs.get(0);

        order.setId(IdWorker.getId());
        order.setAllotApplyId(allotApplyVO.getId());
        order.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode()); //默认自由态
        order.setEditNum(0); //修改次数0
        order.setBusinessStatus(AllotOrderBusinessStatusEnums.调出方待确认.getCode()); //待调出方确认
        //调入方信息
        order.setInProjectCode(allotApplyVO.getInProjectCode());
        order.setInProjectId(allotApplyVO.getInProjectId());
        order.setInProjectName(allotApplyVO.getInProjectName());
        order.setInProjectAddress(allotApplyVO.getInProjectAddress());
        order.setInOrgId(allotApplyVO.getInOrgId());
        order.setInOrgCode(allotApplyVO.getInOrgCode());
        order.setInOrgName(allotApplyVO.getInOrgName());
        order.setInParentOrgCode(allotApplyVO.getInParentOrgCode());
        order.setInParentOrgId(allotApplyVO.getInParentOrgId());
        order.setInParentOrgName(allotApplyVO.getInParentOrgName());
        //调入方执行单位
        order.setInCorpCode(allotApplyVO.getCorpCode());
        order.setInCorpId(allotApplyVO.getCorpId());
        order.setInCorpName(allotApplyVO.getCorpName());
        //调入联系人、时间 取调拨申请生效日期
        order.setPurTime(allotApplyVO.getEffectDate());
        order.setPurUserCode(allotApplyVO.getPurUserCode());
        order.setPurUserId(allotApplyVO.getPurUserId());
        order.setPurUserName(allotApplyVO.getPurUserName());
        order.setPurUserPhone(allotApplyVO.getPurUserPhone());

        //调出方
        order.setOutProjectId(tmpApplyDetail.getOutProjectId());
        order.setOutProjectCode(tmpApplyDetail.getOutProjectCode());
        order.setOutProjectName(tmpApplyDetail.getOutProjectName());
        order.setOutOrgId(tmpApplyDetail.getOutOrgId());
        order.setOutOrgCode(tmpApplyDetail.getOutOrgCode());
        order.setOutOrgName(tmpApplyDetail.getOutOrgName());
        order.setOutParentOrgId(tmpApplyDetail.getOutParentOrgId());
        order.setOutParentOrgCode(tmpApplyDetail.getOutParentOrgCode());
        order.setOutParentOrgName(tmpApplyDetail.getOutParentOrgName());
        order.setStoreType(tmpApplyDetail.getStoreType());

        //生成编码
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(order, AllotOrderVO.class));
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
            order.setBillCode(billCode.getData());
        } else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }

        order.setAllotOrderDetailList(generateOrderDetailByApply(allotApplyDetailVOs, order, shelfDetailMap));

        return order;
    }
}
