package com.ejianc.business.zdsmaterial.pick.bean;

import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 分包领料设置主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_pro_pick_setting")
public class ProPickSettingEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码


    @TableField(exist=false)
    @SubEntity(serviceName="proSubContractorService",pidName = "settingId")//此处有pid="xxx"，默认值pid="pid"
    private List<ProSubContractorEntity> proSubContractorList = new ArrayList<>(); // 分包领料设置子表-领料分包商
    @TableField(exist=false)
    @SubEntity(serviceName="proPickRangeService",pidName = "settingId")//此处有pid="xxx"，默认值pid="pid"
    private List<ProSubRangeEntity> proSubRangeList = new ArrayList<>(); // 分包领料设置子表-领料范围
    @TableField(exist=false)
    @SubEntity(serviceName="proSubPickerService",pidName = "settingId")//此处有pid="xxx"，默认值pid="pid"
    private List<ProSubPickerEntity> proSubPickerList = new ArrayList<>(); // 分包领料设置子表-领料人
    @TableField(exist=false)
    @SubEntity(serviceName="proSubSignerService",pidName = "settingId")//此处有pid="xxx"，默认值pid="pid"
    private List<ProSubSignerEntity> proSubSignerList = new ArrayList<>(); // 分包领料设置子表-领料确认工程师
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    
    public List<ProSubContractorEntity> getProSubContractorList() {
        return proSubContractorList;
    }

    public void setProSubContractorList(List<ProSubContractorEntity> proSubContractorList) {
        this.proSubContractorList = proSubContractorList;
    }
    public List<ProSubRangeEntity> getProSubRangeList() {
        return proSubRangeList;
    }

    public void setProSubRangeList(List<ProSubRangeEntity> proSubRangeList) {
        this.proSubRangeList = proSubRangeList;
    }
    public List<ProSubPickerEntity> getProSubPickerList() {
        return proSubPickerList;
    }

    public void setProSubPickerList(List<ProSubPickerEntity> proSubPickerList) {
        this.proSubPickerList = proSubPickerList;
    }
    public List<ProSubSignerEntity> getProSubSignerList() {
        return proSubSignerList;
    }

    public void setProSubSignerList(List<ProSubSignerEntity> proSubSignerList) {
        this.proSubSignerList = proSubSignerList;
    }
}
