package com.ejianc.business.zdsmaterial.sub.invoice.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 分包发票登记-明细
 *
 * @author generator
 *
 */
 @TableName("ejc_material_sub_invoice_detail")
public class SubInvoiceDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="main_id")
    private Long mainId; // 主表id
    @TableField(value="source_main_id")
    private Long sourceMainId; // 来源主键id
    @TableField(value="source_id")
    private Long sourceId; // 来源id
    @TableField(value="invoice_code")
    private String invoiceCode; // 发票代码
    @TableField(value="invoice_number")
    private String invoiceNumber; // 发票号码
    @TableField(value="invoice_date")
    private Date invoiceDate; // 开票日期
    @TableField(value="invoice_header")
    private String invoiceHeader; // 发票抬头
    @TableField(value="goods_name")
    private String goodsName; // 货物名称
    @TableField(value="invoice_cty")
    private String invoiceCty; // 发票种类
    @TableField(value="rate")
    private BigDecimal rate; // 税率
    @TableField(value="mny")
    private BigDecimal mny; // 发票金额(无税)
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 发票金额
    @TableField(value="erp_id")
    private String erpId; // 领航erpId
    @TableField(value="invoice_state")
    private String invoiceState; // 发票状态
    @TableField(value = "invoice_id")
    private Long invoiceId; //发票Id

    @TableField(value = "invoice_detail_id")
    private Long invoiceDetailId; //发票子表Id

    @TableField(value = "erp_quote_bill_code")
    private String erpQuoteBillCode; //引用标识：用于记录数据推送ERP前 发票的引用情况，ERP引用单据编码
    @TableField(value = "ocr_state")
    private String ocrState; // 发票附件识别：0-未通过，1-已通过

    @TableField(value = "ocr_check_msg")
    private String ocrCheckMsg; //OCR识别结果描述

    @TableField(value = "ocr_file_id")
    private String ocrFileId; //匹配的OCR附件Id

    @TableField(value = "invoice_detail_spec")
    private String invoiceDetailSpec; // 规格型号
    @TableField(value = "invoice_detail_unit_name")
    private String invoiceDetailUnitName; // 单位
    @TableField(value = "invoice_detail_num")
    private BigDecimal invoiceDetailNum; // 数量
    @TableField(value = "invoice_detail_mny")
    private BigDecimal invoiceDetailMny; // 金额
    @TableField(value = "invoice_detail_price")
    private BigDecimal invoiceDetailPrice; // 单价

    public String getInvoiceDetailSpec() {
        return invoiceDetailSpec;
    }

    public void setInvoiceDetailSpec(String invoiceDetailSpec) {
        this.invoiceDetailSpec = invoiceDetailSpec;
    }

    public String getInvoiceDetailUnitName() {
        return invoiceDetailUnitName;
    }

    public void setInvoiceDetailUnitName(String invoiceDetailUnitName) {
        this.invoiceDetailUnitName = invoiceDetailUnitName;
    }

    public BigDecimal getInvoiceDetailNum() {
        return invoiceDetailNum;
    }

    public void setInvoiceDetailNum(BigDecimal invoiceDetailNum) {
        this.invoiceDetailNum = invoiceDetailNum;
    }

    public BigDecimal getInvoiceDetailMny() {
        return invoiceDetailMny;
    }

    public void setInvoiceDetailMny(BigDecimal invoiceDetailMny) {
        this.invoiceDetailMny = invoiceDetailMny;
    }

    public BigDecimal getInvoiceDetailPrice() {
        return invoiceDetailPrice;
    }

    public void setInvoiceDetailPrice(BigDecimal invoiceDetailPrice) {
        this.invoiceDetailPrice = invoiceDetailPrice;
    }

    public String getOcrCheckMsg() {
        return ocrCheckMsg;
    }

    public void setOcrCheckMsg(String ocrCheckMsg) {
        this.ocrCheckMsg = ocrCheckMsg;
    }

    public String getOcrFileId() {
        return ocrFileId;
    }

    public void setOcrFileId(String ocrFileId) {
        this.ocrFileId = ocrFileId;
    }

    public String getErpQuoteBillCode() {
        return erpQuoteBillCode;
    }

    public void setErpQuoteBillCode(String erpQuoteBillCode) {
        this.erpQuoteBillCode = erpQuoteBillCode;
    }

    public Long getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }

    public Long getInvoiceDetailId() {
        return invoiceDetailId;
    }

    public void setInvoiceDetailId(Long invoiceDetailId) {
        this.invoiceDetailId = invoiceDetailId;
    }

    public Long getMainId() {
        return mainId;
    }

    public void setMainId(Long mainId) {
        this.mainId = mainId;
    }
    public Long getSourceMainId() {
        return sourceMainId;
    }

    public void setSourceMainId(Long sourceMainId) {
        this.sourceMainId = sourceMainId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    public String getInvoiceHeader() {
        return invoiceHeader;
    }

    public void setInvoiceHeader(String invoiceHeader) {
        this.invoiceHeader = invoiceHeader;
    }
    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }
    public String getInvoiceCty() {
        return invoiceCty;
    }

    public void setInvoiceCty(String invoiceCty) {
        this.invoiceCty = invoiceCty;
    }
    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public String getErpId() {
        return erpId;
    }

    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    public String getInvoiceState() {
        return invoiceState;
    }

    public void setInvoiceState(String invoiceState) {
        this.invoiceState = invoiceState;
    }

    public String getOcrState() {
        return ocrState;
    }

    public void setOcrState(String ocrState) {
        this.ocrState = ocrState;
    }
}
