package com.ejianc.business.zdsmaterial.erp.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分包合同
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_sub_contract")
public class SubContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="source_contract_id")
    private String sourceContractId; // 合同来源主键
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="source_project_id")
    private String sourceProjectId; // 项目来源主键
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码

    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id 乙方
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="supplier_code")
    private String supplierCode; // 供应商编码
    @TableField(value="source_supplier_id")
    private String sourceSupplierId; // 供应商来源主键

    @TableField(value="compile_id")
    private Long compileId; // 编制人 采购工程师
    @TableField(value="compile_name")
    private String compileName; // 编制人名称
    @TableField(value="compile_code")
    private String compileCode; // 编制人编码
    @TableField(value="source_compile_id")
    private String sourceCompileId; // 编制人来源主键
    @TableField(value="system_last_update_time")
    private Date systemLastUpdateTime; // 最后更新时间

    @TableField(value="fu_jia_money")
    private BigDecimal fuJiaMoney;//附加合同额
    @TableField(value="contract_content")
    private String contractContent;//合同内容
    @TableField(value="specialty_type")
    private String specialtyType;//专业类别
    @TableField(value="contract_type")
    private String contractType;//合同类型  定价方式
    @TableField(value="party_contacts")
    private String partyContacts;//乙方联系人 分包联系人
    @TableField(value="party_contact_id")
    private Long partyContactId;//乙方联系人 系统id 分包联系人
    @TableField(value="party_contact_s_id")
    private String partyContactSId;//乙方联系人 来源id 分包联系人
    @TableField(value="party_sup_contact_id")
    private Long partySupContactId;//乙方联系人 供方系统id 分包联系人

    @TableField(value="settle_sum_money")
    private BigDecimal settleSumMoney;//分包结算金额
    @TableField(value="appear_money")
    private BigDecimal appearMoney;//累积已批金额
    @TableField(value="sub_contract_flag")
    private Integer subContractFlag;//合同标识 1 主合同,2 附加合同
    @TableField(value="sub_contract_parent_sid")
    private String subContractParentSid;//附加合同对应的主合同主键
    @TableField(value="contract_id")
    private Long contractId;//主合同id
    @TableField(value="is_apply")
    private Integer isApply;//是否有申请中分包费用 0没有 1有
    @TableField(value="bill_type")
    private String billType; //发票类型
    @TableField(value="is_official_seal")
    private Integer isOfficialSeal;//签章状态 0否1已签
    @TableField(value="audit_worker_id")
    private Long auditWorkerId;//审核工程师id
    @TableField(value="audit_worker_name")
    private String auditWorkerName;//审核工程师

    @TableField(value="project_management_id")
    private Long projectManagementId; // 项目经理 系统项目池
    @TableField(value="project_sup_management_id")
    private Long projectSupManagementId; // 项目经理 系统项目池 供方id
    @TableField(value="project_management_name")
    private String projectManagementName; // 项目经理
    @TableField(value="project_management_phone")
    private String projectManagementPhone; // 项目经理电话

    @TableField(value="contract_money")
    private BigDecimal contractMoney;//合同金额

    @TableField(value = "tax_rate")
    private BigDecimal taxRate; //合同税率

    @TableField(value = "contract_party_a")
    private String contractPartyA; // 合同甲方
    @TableField(value = "pro_manager_party_b")
    private String proManagerPartyB; // 乙方项目经理
    @TableField(value = "pro_manager_sid_party_b")
    private String proManagerSidPartyB; // 乙方项目经理SID
    @TableField(value = "pro_manager_sid_party_b_id")
    private Long proManagerSidPartyBId; // 乙方项目经理id
    @TableField(value = "pro_sup_manager_sid_party_b_id")
    private Long proSupManagerSidPartyBId; // 乙方项目经理 供方id

    @TableField(value = "pro_manager_tel_party_b")
    private String proManagerTelPartyB; // 乙方项目经理联系方式
    @TableField(value = "id_card_party_b")
    private String idCardPartyB; // 乙方项目经理身份证

    @TableField(value = "is_finish")
    private String IsFinish; //完工状态 0未 1已完成
    @TableField(value = "is_sett")
    private String isSett;//结算状态 0未 1已完成

    @TableField(value = "pay_money")
    private BigDecimal payMoney;//累计已付金额


    @TableField(value = "payment_style_sid")
    private String paymentStyleSid;//最新一笔分包费用申请单付款类型
    @TableField(value = "payment_style")
    private String paymentStyle;//最新一笔分包费用申请单付款类型


    @TableField(value = "sign_status_code")
    private String signStatusCode;//  0申请1待乙方签章2待甲方签章3签章完成4拒签5作废6乙方拒签7甲方拒签
    @TableField(value = "sign_status_name")
    private String signStatusName;//  0申请1待乙方签章2待甲方签章3签章完成4拒签5作废6乙方拒签7甲方拒签

    @TableField(value = "execut_code")
    private String executCode; //执行编码
    @TableField(value = "execut_unit_sid")
    private String executUnitSid; //执行总部SID
    @TableField(value = "execut_unit_name")
    private String executUnitName; //执行总部名称
    @TableField(value = "execut_unit_id")
    private String executUnitId;//执行总部id(EL组织Id)

    @TableField(value = "sys_last_upd")
    private String sysLastUpd; //ERP最后更新时间

    @TableField(value = "purchase_type")
    private String purchaseType; //采购方式 0-业务单元，1-公司集采，2-公式直属
    @TableField(value = "tax_point_name")
    private String taxPointName; //税点名称

    @TableField(exist=false)
    @SubEntity(serviceName="subContractDetailService",pidName = "contractId")
    private List<SubContractDetailEntity> detailList = new ArrayList<>(); // 分包合同子表


    @TableField(exist = false)
    private String erpStatus; //单据状态：2-生效，5-作废

    public String getErpStatus() {
        return erpStatus;
    }

    public void setErpStatus(String erpStatus) {
        this.erpStatus = erpStatus;
    }

    public String getTaxPointName() {
        return taxPointName;
    }

    public void setTaxPointName(String taxPointName) {
        this.taxPointName = taxPointName;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getSysLastUpd() {
        return sysLastUpd;
    }

    public void setSysLastUpd(String sysLastUpd) {
        this.sysLastUpd = sysLastUpd;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getSignStatusCode() {
        return signStatusCode;
    }

    public void setSignStatusCode(String signStatusCode) {
        this.signStatusCode = signStatusCode;
    }

    public String getSignStatusName() {
        return signStatusName;
    }

    public void setSignStatusName(String signStatusName) {
        this.signStatusName = signStatusName;
    }

    public String getExecutCode() {
        return executCode;
    }

    public void setExecutCode(String executCode) {
        this.executCode = executCode;
    }

    public String getExecutUnitSid() {
        return executUnitSid;
    }

    public void setExecutUnitSid(String executUnitSid) {
        this.executUnitSid = executUnitSid;
    }

    public String getExecutUnitName() {
        return executUnitName;
    }

    public void setExecutUnitName(String executUnitName) {
        this.executUnitName = executUnitName;
    }

    public String getExecutUnitId() {
        return executUnitId;
    }

    public void setExecutUnitId(String executUnitId) {
        this.executUnitId = executUnitId;
    }

    public String getPaymentStyleSid() {
        return paymentStyleSid;
    }

    public void setPaymentStyleSid(String paymentStyleSid) {
        this.paymentStyleSid = paymentStyleSid;
    }

    public String getPaymentStyle() {
        return paymentStyle;
    }

    public void setPaymentStyle(String paymentStyle) {
        this.paymentStyle = paymentStyle;
    }

    public BigDecimal getPayMoney() {
        return payMoney;
    }

    public void setPayMoney(BigDecimal payMoney) {
        this.payMoney = payMoney;
    }

    public String getIsSett() {
        return isSett;
    }

    public void setIsSett(String isSett) {
        this.isSett = isSett;
    }

    public String getIsFinish() {
        return IsFinish;
    }

    public void setIsFinish(String isFinish) {
        IsFinish = isFinish;
    }

    public Long getProSupManagerSidPartyBId() {
        return proSupManagerSidPartyBId;
    }

    public void setProSupManagerSidPartyBId(Long proSupManagerSidPartyBId) {
        this.proSupManagerSidPartyBId = proSupManagerSidPartyBId;
    }

    public Long getPartySupContactId() {
        return partySupContactId;
    }

    public void setPartySupContactId(Long partySupContactId) {
        this.partySupContactId = partySupContactId;
    }

    public Long getProjectSupManagementId() {
        return projectSupManagementId;
    }

    public void setProjectSupManagementId(Long projectSupManagementId) {
        this.projectSupManagementId = projectSupManagementId;
    }

    public Long getPartyContactId() {
        return partyContactId;
    }

    public void setPartyContactId(Long partyContactId) {
        this.partyContactId = partyContactId;
    }

    public String getPartyContactSId() {
        return partyContactSId;
    }

    public void setPartyContactSId(String partyContactSId) {
        this.partyContactSId = partyContactSId;
    }

    public Long getProManagerSidPartyBId() {
        return proManagerSidPartyBId;
    }

    public void setProManagerSidPartyBId(Long proManagerSidPartyBId) {
        this.proManagerSidPartyBId = proManagerSidPartyBId;
    }

    public String getContractPartyA() {
        return contractPartyA;
    }

    public void setContractPartyA(String contractPartyA) {
        this.contractPartyA = contractPartyA;
    }

    public String getProManagerPartyB() {
        return proManagerPartyB;
    }

    public void setProManagerPartyB(String proManagerPartyB) {
        this.proManagerPartyB = proManagerPartyB;
    }

    public String getProManagerSidPartyB() {
        return proManagerSidPartyB;
    }

    public void setProManagerSidPartyB(String proManagerSidPartyB) {
        this.proManagerSidPartyB = proManagerSidPartyB;
    }

    public String getProManagerTelPartyB() {
        return proManagerTelPartyB;
    }

    public void setProManagerTelPartyB(String proManagerTelPartyB) {
        this.proManagerTelPartyB = proManagerTelPartyB;
    }

    public String getIdCardPartyB() {
        return idCardPartyB;
    }

    public void setIdCardPartyB(String idCardPartyB) {
        this.idCardPartyB = idCardPartyB;
    }

    public BigDecimal getContractMoney() {
        return contractMoney;
    }

    public void setContractMoney(BigDecimal contractMoney) {
        this.contractMoney = contractMoney;
    }

    public Long getProjectManagementId() {
        return projectManagementId;
    }

    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }

    public String getProjectManagementName() {
        return projectManagementName;
    }

    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }

    public String getProjectManagementPhone() {
        return projectManagementPhone;
    }

    public void setProjectManagementPhone(String projectManagementPhone) {
        this.projectManagementPhone = projectManagementPhone;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getAuditWorkerName() {
        return auditWorkerName;
    }

    public void setAuditWorkerName(String auditWorkerName) {
        this.auditWorkerName = auditWorkerName;
    }

    public Long getAuditWorkerId() {
        return auditWorkerId;
    }

    public void setAuditWorkerId(Long auditWorkerId) {
        this.auditWorkerId = auditWorkerId;
    }

    public BigDecimal getFuJiaMoney() {
        return fuJiaMoney;
    }

    public void setFuJiaMoney(BigDecimal fuJiaMoney) {
        this.fuJiaMoney = fuJiaMoney;
    }

    public String getContractContent() {
        return contractContent;
    }

    public void setContractContent(String contractContent) {
        this.contractContent = contractContent;
    }

    public String getSpecialtyType() {
        return specialtyType;
    }

    public void setSpecialtyType(String specialtyType) {
        this.specialtyType = specialtyType;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public String getPartyContacts() {
        return partyContacts;
    }

    public void setPartyContacts(String partyContacts) {
        this.partyContacts = partyContacts;
    }

    public BigDecimal getSettleSumMoney() {
        return settleSumMoney;
    }

    public void setSettleSumMoney(BigDecimal settleSumMoney) {
        this.settleSumMoney = settleSumMoney;
    }

    public BigDecimal getAppearMoney() {
        return appearMoney;
    }

    public void setAppearMoney(BigDecimal appearMoney) {
        this.appearMoney = appearMoney;
    }

    public Integer getSubContractFlag() {
        return subContractFlag;
    }

    public void setSubContractFlag(Integer subContractFlag) {
        this.subContractFlag = subContractFlag;
    }

    public String getSubContractParentSid() {
        return subContractParentSid;
    }

    public void setSubContractParentSid(String subContractParentSid) {
        this.subContractParentSid = subContractParentSid;
    }

    public Integer getIsApply() {
        return isApply;
    }

    public void setIsApply(Integer isApply) {
        this.isApply = isApply;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public Integer getIsOfficialSeal() {
        return isOfficialSeal;
    }

    public void setIsOfficialSeal(Integer isOfficialSeal) {
        this.isOfficialSeal = isOfficialSeal;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getSourceProjectId() {
        return sourceProjectId;
    }

    public void setSourceProjectId(String sourceProjectId) {
        this.sourceProjectId = sourceProjectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSourceSupplierId() {
        return sourceSupplierId;
    }

    public void setSourceSupplierId(String sourceSupplierId) {
        this.sourceSupplierId = sourceSupplierId;
    }
    public Long getCompileId() {
        return compileId;
    }

    public void setCompileId(Long compileId) {
        this.compileId = compileId;
    }
    public String getCompileName() {
        return compileName;
    }

    public void setCompileName(String compileName) {
        this.compileName = compileName;
    }
    public String getCompileCode() {
        return compileCode;
    }

    public void setCompileCode(String compileCode) {
        this.compileCode = compileCode;
    }
    public String getSourceCompileId() {
        return sourceCompileId;
    }

    public void setSourceCompileId(String sourceCompileId) {
        this.sourceCompileId = sourceCompileId;
    }
    public Date getSystemLastUpdateTime() {
        return systemLastUpdateTime;
    }

    public void setSystemLastUpdateTime(Date systemLastUpdateTime) {
        this.systemLastUpdateTime = systemLastUpdateTime;
    }
    

    public List<SubContractDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SubContractDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
