/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MaterialBasePriceContentEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialBasePriceEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceContentService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceContentVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.ConjectureEditVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.ResultAsTree;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IUnitApi;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialBasePrice"})
public class MaterialBasePriceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialConjectureService materialConjectureService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IUnitApi unitApi;
    private static final String BILL_CODE = "BASE-PRICE-IMPORT";
    @Autowired
    private IMaterialBasePriceService service;
    @Autowired
    private IMaterialBasePriceContentService materialBasePriceContentService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialBasePriceVO> saveOrUpdate(@RequestBody MaterialBasePriceVO saveOrUpdateVO) {
        List repeatMaterialCodeList;
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getMaterialBasePriceContentList()) && CollectionUtils.isNotEmpty(repeatMaterialCodeList = saveOrUpdateVO.getMaterialBasePriceContentList().stream().collect(Collectors.groupingBy(MaterialBasePriceContentVO::getMaterialCode, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList()))) {
            return CommonResponse.error((String)("\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u590d\u7684\u7269\u6599,\u7f16\u7801\u4e3a[" + repeatMaterialCodeList.stream().collect(Collectors.joining()) + "]\uff0c\u8bf7\u4fee\u6539\u6216\u5220\u9664\uff01"));
        }
        return this.service.saves(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialBasePriceVO> queryDetail(Long id) {
        MaterialBasePriceEntity entity = (MaterialBasePriceEntity)((Object)this.service.selectById(id));
        MaterialBasePriceVO vo = (MaterialBasePriceVO)BeanMapper.map((Object)((Object)entity), MaterialBasePriceVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialBasePriceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialBasePriceVO materialBasePriceVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialBasePriceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "topicName", "brandName", "supplierName", "materialClass", "employeeName", "areaName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialBasePriceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "topicName", "brandName", "supplierName", "materialClass", "employeeName", "areaName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List materialBasePriceVOS = BeanMapper.mapList((Iterable)list, MaterialBasePriceVO.class);
        materialBasePriceVOS.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            Integer status = vo.getStatus();
            vo.setStatusName(status == 1 ? "\u542f\u7528" : "\u7981\u7528");
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", materialBasePriceVOS);
        ExcelExport.getInstance().export("MaterialBasePrice-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialBasePriceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialBasePriceVO>> refMaterialBasePriceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialBasePriceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/changeStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> changeStatus(@RequestBody MaterialBasePriceVO saveOrUpdateVO) {
        return this.service.changeStatus(saveOrUpdateVO);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"BasePriceImport-material-import.xlsx", (String)"\u57fa\u51c6\u4ef7\u683c\u5e93\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/excelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId");
        String mode = request.getParameter("mode");
        if (StringUtils.isBlank((CharSequence)mode)) {
            mode = "CJYT";
        }
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        ArrayList<MaterialConjectureVO> successList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> processList = new ArrayList<MaterialConjectureVO>();
        ArrayList<MaterialConjectureVO> errorList = new ArrayList<MaterialConjectureVO>();
        HashSet<String> unitNames = new HashSet<String>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            MaterialConjectureVO vo = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4");
                vo.setConjectureMateType("4");
                vo.setDelFlag("0");
                vo.setIgnoreFlag("0");
                vo.setLoadState("0");
                vo.setIdentificationDate(new Date());
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setImportSeq((String)datas.get(0));
                vo.setSourceMaterialName((String)datas.get(1));
                vo.setSourceUnitName((String)datas.get(3));
                vo.setSourceMaterialSpec((String)datas.get(2));
                try {
                    vo.setSourceBasePrice(ComputeUtil.toBigDecimal((String)datas.get(4)));
                }
                catch (Exception e) {
                    vo.setErrorMsg("\u3010\u57fa\u51c6\u4ef7\u683c\u3011\u9700\u4e3a\u6570\u503c\u7c7b\u578b\uff01");
                    errorList.add(vo);
                    continue;
                }
                vo.setActualBasePrice(ComputeUtil.toBigDecimal((String)datas.get(4)));
                try {
                    vo.setSourceBaseOriginPrice(ComputeUtil.toBigDecimal((String)datas.get(5)));
                }
                catch (Exception e) {
                    vo.setErrorMsg("\u3010\u57fa\u51c6\u539f\u6750\u6599\u540c\u4ef7\u3011\u9700\u4e3a\u6570\u503c\u7c7b\u578b\uff01");
                    errorList.add(vo);
                    continue;
                }
                vo.setActualBaseOriginPrice(ComputeUtil.toBigDecimal((String)datas.get(5)));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setErrorMsg("\u3010\u7269\u6599\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setErrorMsg("\u3010\u63cf\u8ff0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    vo.setErrorMsg("\u3010\u5355\u4f4d\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setErrorMsg("\u3010\u57fa\u51c6\u4ef7\u683c(\u5355\u4ef7)\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setErrorMsg("\u3010\u57fa\u51c6\u539f\u6750\u6599\u540c\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(vo);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        vo.setSourceBaseTwoPrice(ComputeUtil.toBigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u7b2c\u4e8c\u57fa\u51c6\u4ef7\u683c\u3011\u9700\u4e3a\u6570\u503c\u7c7b\u578b\uff01");
                        errorList.add(vo);
                        continue;
                    }
                    vo.setActualBaseTwoPrice(ComputeUtil.toBigDecimal((String)datas.get(6)));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    vo.setContractName((String)datas.get(7));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    vo.setContractCode((String)datas.get(8));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    vo.setProjectName((String)datas.get(9));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        String time = (String)datas.get(10);
                        Date date = sdf.parse(time);
                        vo.setSignDate(date);
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u7b7e\u8ba2\u65e5\u671f\u3011\u9700\u4e3a\u65e5\u671f\u7c7b\u578b\uff01");
                        errorList.add(vo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                    vo.setSupplierName((String)datas.get(11));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12)))) {
                    try {
                        vo.setPurchaseNum(ComputeUtil.toBigDecimal((String)datas.get(12)));
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u91c7\u8d2d\u6570\u91cf\u3011\u9700\u4e3a\u6570\u503c\u7c7b\u578b\uff01");
                        errorList.add(vo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13)))) {
                    try {
                        vo.setExtParam1(ComputeUtil.toBigDecimal((String)datas.get(13)).toPlainString());
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u69fd\u91cd\u3011\u9700\u4e3a\u6570\u503c\u7c7b\u578b\uff01");
                        errorList.add(vo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14)))) {
                    try {
                        vo.setExtParam2(ComputeUtil.toBigDecimal((String)datas.get(14)).toPlainString());
                    }
                    catch (Exception e) {
                        vo.setErrorMsg("\u3010\u76d6\u91cd\u3011\u9700\u4e3a\u6570\u503c\u7c7b\u578b\uff01");
                        errorList.add(vo);
                        continue;
                    }
                }
                unitNames.add(vo.getSourceUnitName());
                vo.setRowState("add");
                processList.add(vo);
            }
        }
        if (CollectionUtils.isNotEmpty(processList)) {
            CommonResponse unitListResp = this.unitApi.findAllEnabledList(new ArrayList(unitNames));
            if (!unitListResp.isSuccess()) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25,names:{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(unitNames), (Object)JSONObject.toJSONString((Object)unitListResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)unitListResp.getData()))) {
                this.logger.error("\u7269\u6599ai\u5bfc\u5165\u8bc6\u522b\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a, names:{}", (Object)JSONObject.toJSONString(unitNames));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5339\u914d\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
            }
            HashMap<String, Long> unitNameIdMap = new HashMap<String, Long>();
            HashMap<String, Long> unitAliasNameIdMap = new HashMap<String, Long>();
            unitNameIdMap.putAll(((List)unitListResp.getData()).stream().collect(Collectors.toMap(UnitShareVO::getUnitName, BaseVO::getId, (k1, k2) -> k1)));
            unitAliasNameIdMap.putAll(((List)unitListResp.getData()).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), BaseVO::getId, (k1, k2) -> k1)));
            for (MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());
                if (unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId((Long)unitNameIdMap.get(m.getSourceUnitName()));
                }
                for (String key : unitAliasNameIdMap.keySet()) {
                    if (!key.contains("," + m.getSourceUnitName() + ",")) continue;
                    m.setActualUnitId((Long)unitAliasNameIdMap.get(key));
                }
                if (null == m.getActualUnitId()) {
                    m.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u4e0e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
                    errorList.add(m);
                    continue;
                }
                successList.add(m);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", (Object)successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"/saveImport"})
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<MaterialConjectureVO> saveList, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        this.materialConjectureService.saveOrUpdateBatch(BeanMapper.mapList(saveList, MaterialConjectureEntity.class), saveList.size(), false);
        this.materialConjectureService.startConjecture(saveList.get(0).getIdentificationId(), authority, saveList.get(0).getMode());
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f,\u7269\u6599\u8bc6\u522b\u4e2d\uff01");
    }

    @GetMapping(value={"/getConjectureProgress"})
    @ResponseBody
    public CommonResponse<JSONObject> saveImport(@RequestParam String identificationId, @RequestParam(required=false) String mateType, @RequestParam(required=false) String actualCategoryName, @RequestParam(required=false) String actualMaterialCode, @RequestParam(required=false) String actualMaterialName, @RequestParam(required=false) String actualMaterialSpec, @RequestParam(required=false) String actualUnitName, @RequestParam(required=false) BigDecimal actualNum) {
        JSONObject resp = new JSONObject();
        List<MaterialConjectureEntity> identifyList = this.materialConjectureService.getAllByIdentifyId(identificationId, null, actualCategoryName, actualMaterialCode, actualMaterialName, actualMaterialSpec, actualUnitName, actualNum);
        resp.put("total", (Object)identifyList.size());
        Integer completeMatch = 0;
        Integer partialMatch = 0;
        Integer misMatch = 0;
        resp.put("conjecturedNum", (Object)identifyList.stream().filter(item -> !"3".equals(item.getMateType()) && !"4".equals(item.getMateType())).count());
        ArrayList<MaterialConjectureEntity> respList = new ArrayList<MaterialConjectureEntity>();
        for (MaterialConjectureEntity m : identifyList) {
            switch (m.getMateType()) {
                case "0": {
                    Integer n = misMatch;
                    Integer n2 = misMatch = Integer.valueOf(misMatch + 1);
                    break;
                }
                case "1": {
                    Integer n = partialMatch;
                    Integer n2 = partialMatch = Integer.valueOf(partialMatch + 1);
                    break;
                }
                case "2": {
                    Integer n = completeMatch;
                    Integer n2 = completeMatch = Integer.valueOf(completeMatch + 1);
                    break;
                }
            }
            if (!StringUtils.isBlank((CharSequence)mateType) && !"-1".equals(mateType) && !m.getMateType().equals(mateType)) continue;
            respList.add(m);
        }
        resp.put("completeMatch", (Object)completeMatch);
        resp.put("partialMatch", (Object)partialMatch);
        resp.put("misMatch", (Object)misMatch);
        resp.put("identifyList", CollectionUtils.isNotEmpty(respList) ? BeanMapper.mapList(respList, MaterialConjectureVO.class) : new ArrayList());
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"/saveConjecture"})
    @ResponseBody
    public CommonResponse<MaterialConjectureVO> saveConjecture(@RequestBody ConjectureEditVO materialVO) {
        MaterialConjectureEntity entity = (MaterialConjectureEntity)((Object)this.materialConjectureService.selectById(materialVO.getConjectureId()));
        entity.setActualMaterialId(materialVO.getMaterialId());
        entity.setActualCategoryId(materialVO.getCategoryId());
        entity.setActualCategoryName(materialVO.getCategoryName());
        entity.setActualMaterialSpec(materialVO.getPropertyShowName());
        entity.setActualMaterialCode(materialVO.getCode());
        if (CollectionUtils.isNotEmpty((Collection)materialVO.getRelationList())) {
            JSONArray specArr = new JSONArray();
            JSONObject json = null;
            for (MaterialPropertyRelationVO s : materialVO.getRelationList()) {
                json = (JSONObject)BeanMapper.map((Object)s, JSONObject.class);
                json.put("propertyItemId", (Object)s.getPropertyItemId().toString());
                json.put("id", (Object)s.getPropertyItemId().toString());
                json.put("categoryId", (Object)s.getCategoryId().toString());
                json.put("propertyId", (Object)s.getPropertyId().toString());
                specArr.add((Object)json);
            }
            entity.setActualMaterialSpecs(specArr.toJSONString());
        }
        entity.setActualNum(materialVO.getNum());
        entity.setActualBasePrice(materialVO.getBasePrice());
        entity.setActualBaseOriginPrice(materialVO.getBaseOriginPrice());
        entity.setActualBaseTwoPrice(materialVO.getBaseTwoPrice());
        entity.setActualUnitId(materialVO.getUnitId());
        entity.setActualUnitName(materialVO.getUnitName());
        entity.setActualMaterialName(materialVO.getName());
        entity.setAdjustFlag(PlanConstant.INTEGER_YES);
        entity.setMateType("2");
        this.materialConjectureService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f!", (Object)BeanMapper.map((Object)((Object)entity), MaterialConjectureVO.class));
    }

    @RequestMapping(value={"/loadMaterialCategoryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> loadMaterialCategoryTree() {
        List<MaterialBasePriceContentEntity> list = this.materialBasePriceContentService.select(null);
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> classIds = list.stream().map(MaterialBasePriceContentEntity::getMaterialClassId).collect(Collectors.toList());
            List<MaterialCategoryVO> materialCategoryVOS = this.materialCategoryService.queryCategoryListByChildren(classIds);
            return CommonResponse.success(ResultAsTree.createTreeData(BeanMapper.mapList(materialCategoryVOS, Map.class)));
        }
        return CommonResponse.success(new ArrayList());
    }

    @RequestMapping(value={"/queryByCategoryId"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialBasePriceContentVO>> queryByCategoryId(@RequestBody QueryParam param) {
        Parameter category = (Parameter)param.getParams().get("categoryId");
        Long categoryId = null;
        if (ObjectUtil.isNotEmpty((Object)category)) {
            Object value = ((Parameter)param.getParams().get("categoryId")).getValue();
            String id = null;
            if (value != null) {
                id = value.toString();
            }
            categoryId = StringUtils.isBlank(id) ? null : Long.valueOf(Long.parseLong(id));
        }
        param.getParams().remove("categoryId");
        if (categoryId == null) {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)new Page());
        }
        List<MaterialCategoryEntity> allCategoryByLeafNodeId = this.materialCategoryService.getChildrenByPid(categoryId);
        List<Long> ids = allCategoryByLeafNodeId.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("materialCode", "areaName", "brandName", "supplierName", "contractCode"));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<MaterialBasePriceContentEntity> select = this.materialBasePriceContentService.selectData(param, (IPage<MaterialBasePriceContentVO>)page, ids);
        List materialBasePriceContentVOS1 = BeanMapper.mapList(select, MaterialBasePriceContentVO.class);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(materialBasePriceContentVOS1);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Parameter category = (Parameter)param.getParams().get("categoryId");
        Long categoryId = null;
        if (ObjectUtil.isNotEmpty((Object)category)) {
            categoryId = Long.parseLong(((Parameter)param.getParams().get("categoryId")).getValue().toString());
        }
        param.getParams().remove("categoryId");
        List<MaterialCategoryEntity> allCategoryByLeafNodeId = this.materialCategoryService.getChildrenByPid(categoryId);
        List<Long> ids = allCategoryByLeafNodeId.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("materialCode", "areaName", "brandName", "supplierName", "contractCode"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<MaterialBasePriceContentEntity> select = this.materialBasePriceContentService.selectData(param, (IPage<MaterialBasePriceContentVO>)page, ids);
        List materialBasePriceContentVOS = BeanMapper.mapList(select, MaterialBasePriceContentVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", materialBasePriceContentVOS);
        ExcelExport.getInstance().export("MaterialBasePriceReport-export.xlsx", beans, response);
    }
}

