package com.ejianc.business.zdsmaterial.asynchandler.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.asynchandler.bean.MaPushErpRecordsEntity;
import com.ejianc.business.zdsmaterial.asynchandler.service.IMaPushErpRecordsService;
import com.ejianc.business.zdsmaterial.erp.bean.MessageInfoEntity;
import com.ejianc.business.zdsmaterial.erp.service.IMessageInfoService;
import com.ejianc.business.zdsmaterial.erp.vo.MessageInfoVO;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;


@Component
public class PushMessageInfoListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private IMessageInfoService service;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        logger.info("接收到代办推送信息数据记录：{}", mqMessage.getBody());
        try {
            MessageInfoEntity entity = JSONObject.parseObject(mqMessage.getBody().toString(), MessageInfoEntity.class);
            service.saveOrUpdate(entity, false);
        } catch (Exception e) {
            logger.error("保存待办推送信息记录异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{MessageInfoVO.QUEUE_NAME+"_1"+profile};
    }
}
