package com.ejianc.business.zdsmaterial.erp.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 发货单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_delivery")
public class DeliveryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商
    @TableField(value="supplier_code")
    private String supplierCode; // 供应商编码
    @TableField(value="supplier_link_name")
    private String supplierLinkName; // 供应商联系人
    @TableField(value="supplier_link_phone")
    private String supplierLinkPhone; // 供应商联系人手机号
    @TableField(value="supplier_delivery_id")
    private Long supplierDeliveryId; // 发货人id
    @TableField(value="supplier_delivery_name")
    private String supplierDeliveryName; // 发货人名称
    @TableField(value="supplier_delivery_code")
    private String supplierDeliveryCode; // 发货人编码
    @TableField(value="supplier_delivery_phone")
    private String supplierDeliveryPhone; // 发货人手机号
    @TableField(value="supplier_delivery_date")
    private Date supplierDeliveryDate; // 发货时间
    @TableField(value="site_acceptor_id")
    private Long siteAcceptorId; // 现场验收人id
    @TableField(value="site_acceptor_name")
    private String siteAcceptorName; // 现场验收人name
    @TableField(value="site_acceptor_code")
    private String siteAcceptorCode; // 现场验收人编码
    @TableField(value = "site_acceptor_link_phone")
    private String siteAcceptorLinkPhone; //现场验收人电话
    @TableField(value="predict_arrival_date")
    private Date predictArrivalDate; // 预计到货日期
    @TableField(value="car_code")
    private String carCode; // 车牌号
    @TableField(value="delivery_driver_name")
    private String deliveryDriverName; // 发货司机名称
    @TableField(value = "delivery_driver_phone")
    private String deliveryDriverPhone; // 送货司机电话
    @TableField(value="accept_status")
    private Integer acceptStatus; // 验收状态 1:待验收;2:验收中;3部分验收，4全部验收; 
    @TableField(value="delivery_tax_mny")
    private BigDecimal deliveryTaxMny; // 本次发货金额（含税）
    @TableField(value="delivery_mny")
    private BigDecimal deliveryMny; // 本次发货金额
    @TableField(value="order_code")
    private String orderCode; // 订单编码
    @TableField(value="order_id")
    private Long orderId; // 订单id
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据提交状态：0-暂存,1-提交
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="supplier_tenant_id")
    private Long supplierTenantId; // 供方租户主键

    @TableField(value = "close_status")
    private Integer closeStatus; //关闭状态:0-未关闭，1-已关闭
    
    @TableField(exist=false)
    @SubEntity(serviceName="deliveryDetailService", pidName = "deliveryId")//此处有pid="xxx"，默认值pid="pid"
    private List<DeliveryDetailEntity> detailList = new ArrayList<>(); // 发货单-物资清单
    @TableField(exist=false)
    @SubEntity(serviceName="transmitService" ,pidName = "deliveryId")//此处有pid="xxx"，默认值pid="pid"
    private List<TransmitEntity> transmitList = new ArrayList<>(); // 发货单-验收转签记录


    /**
     * 来源业务单据Id
     */
    @TableField(value = "source_id")
    private String sourceId;

    /**
     * 来源业务系统id
     */
    @TableField(value = "source_system_id")
    private String sourceSystemId;

    @TableField(value = "accept_content")
    private String acceptContent; // 发货单内容

    @TableField(value = "delivery_address")
    private String deliveryAddress; // 送货地址

    public String getDeliveryDriverPhone() {
        return deliveryDriverPhone;
    }

    public void setDeliveryDriverPhone(String deliveryDriverPhone) {
        this.deliveryDriverPhone = deliveryDriverPhone;
    }

    public String getSiteAcceptorLinkPhone() {
        return siteAcceptorLinkPhone;
    }

    public void setSiteAcceptorLinkPhone(String siteAcceptorLinkPhone) {
        this.siteAcceptorLinkPhone = siteAcceptorLinkPhone;
    }

    public String getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public String getAcceptContent() {
        return acceptContent;
    }

    public void setAcceptContent(String acceptContent) {
        this.acceptContent = acceptContent;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public Integer getCloseStatus() {
        return closeStatus;
    }

    public void setCloseStatus(Integer closeStatus) {
        this.closeStatus = closeStatus;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSupplierLinkName() {
        return supplierLinkName;
    }

    public void setSupplierLinkName(String supplierLinkName) {
        this.supplierLinkName = supplierLinkName;
    }
    public String getSupplierLinkPhone() {
        return supplierLinkPhone;
    }

    public void setSupplierLinkPhone(String supplierLinkPhone) {
        this.supplierLinkPhone = supplierLinkPhone;
    }
    public Long getSupplierDeliveryId() {
        return supplierDeliveryId;
    }

    public void setSupplierDeliveryId(Long supplierDeliveryId) {
        this.supplierDeliveryId = supplierDeliveryId;
    }
    public String getSupplierDeliveryName() {
        return supplierDeliveryName;
    }

    public void setSupplierDeliveryName(String supplierDeliveryName) {
        this.supplierDeliveryName = supplierDeliveryName;
    }
    public String getSupplierDeliveryCode() {
        return supplierDeliveryCode;
    }

    public void setSupplierDeliveryCode(String supplierDeliveryCode) {
        this.supplierDeliveryCode = supplierDeliveryCode;
    }
    public String getSupplierDeliveryPhone() {
        return supplierDeliveryPhone;
    }

    public void setSupplierDeliveryPhone(String supplierDeliveryPhone) {
        this.supplierDeliveryPhone = supplierDeliveryPhone;
    }
    public Date getSupplierDeliveryDate() {
        return supplierDeliveryDate;
    }

    public void setSupplierDeliveryDate(Date supplierDeliveryDate) {
        this.supplierDeliveryDate = supplierDeliveryDate;
    }
    public Long getSiteAcceptorId() {
        return siteAcceptorId;
    }

    public void setSiteAcceptorId(Long siteAcceptorId) {
        this.siteAcceptorId = siteAcceptorId;
    }
    public String getSiteAcceptorName() {
        return siteAcceptorName;
    }

    public void setSiteAcceptorName(String siteAcceptorName) {
        this.siteAcceptorName = siteAcceptorName;
    }
    public String getSiteAcceptorCode() {
        return siteAcceptorCode;
    }

    public void setSiteAcceptorCode(String siteAcceptorCode) {
        this.siteAcceptorCode = siteAcceptorCode;
    }
    public Date getPredictArrivalDate() {
        return predictArrivalDate;
    }

    public void setPredictArrivalDate(Date predictArrivalDate) {
        this.predictArrivalDate = predictArrivalDate;
    }
    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }
    public String getDeliveryDriverName() {
        return deliveryDriverName;
    }

    public void setDeliveryDriverName(String deliveryDriverName) {
        this.deliveryDriverName = deliveryDriverName;
    }
    public Integer getAcceptStatus() {
        return acceptStatus;
    }

    public void setAcceptStatus(Integer acceptStatus) {
        this.acceptStatus = acceptStatus;
    }
    public BigDecimal getDeliveryTaxMny() {
        return deliveryTaxMny;
    }

    public void setDeliveryTaxMny(BigDecimal deliveryTaxMny) {
        this.deliveryTaxMny = deliveryTaxMny;
    }
    public BigDecimal getDeliveryMny() {
        return deliveryMny;
    }

    public void setDeliveryMny(BigDecimal deliveryMny) {
        this.deliveryMny = deliveryMny;
    }
    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }
    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getSupplierTenantId() {
        return supplierTenantId;
    }

    public void setSupplierTenantId(Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    
    public List<DeliveryDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DeliveryDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<TransmitEntity> getTransmitList() {
        return transmitList;
    }

    public void setTransmitList(List<TransmitEntity> transmitList) {
        this.transmitList = transmitList;
    }
}
