package com.ejianc.business.zdsmaterial.erp.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.vo.ContractVO;
import com.ejianc.business.zdssupplier.material.api.IMatLinkerApi;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/26 13:45
 */
@RestController
@RequestMapping(value = "/api/zdscongtract/")
public class ContractApi {

    @Autowired
    private IContractService service;

    @Autowired
    private IMatLinkerApi matLinkerApi;

    @GetMapping(value = "getContractDetail")
    CommonResponse<ContractVO> getContractDetail(@RequestParam Long contractId) {
        ContractEntity contract= service.selectById(contractId);
        return CommonResponse.success(BeanMapper.map(contract, ContractVO.class));
    }

    /**
     * 查询乙方联系人对应合同、订单信息
     *
     * @param params
     * @return
     */
    @PostMapping(value = "pageContractAndOrder")
    public CommonResponse<JSONObject> pageContractAndOrder(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Map<String, Object> queryParam = new HashMap<>();
        Long linkerSupUserId =  params.getLong("supUserId"); //乙方联系人供方用户ID
        Long supTenant = params.getLong("supTenant"); //乙方联系人租户ID
        String billType = params.getString("billType"); //1-主合同，2-附加合同，3-订单
        Integer pageSize = null != params.getInteger("pageSize") ? params.getInteger("pageSize") : 10;
        Integer pageNum = null != params.getInteger("pageNum") ? params.getInteger("pageNum") : 1;

        Long contractId = params.getLong("contractId"); //合同Id

        Integer startLine = (pageNum < 1 ? 0 : pageNum -1) * pageSize;
        queryParam.put("startLine", startLine);
        queryParam.put("pageSize", pageSize);
        resp.put("size", pageSize);
        resp.put("current", pageNum);

        if(null == linkerSupUserId) {
            return CommonResponse.error("查询失败，乙方联系人供方用户ID为空");
        }
        if(null == supTenant) {
            return CommonResponse.error("查询失败，乙方联系人租户ID为空");
        }
//        if(StringUtils.isBlank(billType)) {
//            return CommonResponse.error("查询失败，查询单据类型为空");
//        }
        //查询乙方联系人信息
//        CommonResponse<MatLinkerVO> linkerResp = matLinkerApi.getSupUserIdAndTenant(linkerSupUserId, supTenant);
//        if(!linkerResp.isSuccess() || null == linkerResp.getData()) {
//            return CommonResponse.error("查询失败，查询乙方联系人信息失败！");
//        }
//        MatLinkerVO linker = linkerResp.getData();

//        queryParam.put("linkerId", linker.getId());
//        queryParam.put("linkerSid", linker.getThirdSourceId());

        CommonResponse<List<MatLinkerVO>> linkerResp = matLinkerApi.getEntrustUserIdAndTenant(linkerSupUserId, supTenant);
        if(!linkerResp.isSuccess() || null == linkerResp.getData() || linkerResp.getData().size() <=0) {
            return CommonResponse.error("查询失败，查询乙方联系人信息失败！");
        }
        List<MatLinkerVO> linkerList = linkerResp.getData();
        //当前联系人是否为管理员
        List<MatLinkerVO> curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && linkerSupUserId.equals(item.getSupUserId())).collect(Collectors.toList());
        Long supplierId = null;
        if(CollectionUtils.isNotEmpty(curLinker)) {
            MatLinkerVO linker = curLinker.get(0);
            if(null != linker.getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                supplierId = linker.getSupplierId();
            }
        }

        if(null != supplierId) {
            queryParam.put("supplierId", supplierId);
        } else {
            List<Long> linkerIds = linkerList.stream().map(x->x.getId()).collect(Collectors.toList());
            List<String> linkerSids = linkerList.stream().map(x->x.getThirdSourceId()).filter(Objects::nonNull).collect(Collectors.toList());
            queryParam.put("linkerId", linkerIds);
            queryParam.put("linkerSid", linkerSids);
        }

        if(StringUtils.isNotBlank(billType)) {
            queryParam.put("billTypes", billType.split(","));
        }

        //查询合同信息
        if(null != contractId) {
            ContractEntity contract = service.selectById(contractId);
            queryParam.put("contractId", contract.getId());
            queryParam.put("contractSid", contract.getSourceContractId());


            if(PlanConstant.INTEGER_YES.equals(contract.getPriceType())) {
                //单价合同查询主合同+子合同+子合同订单
                if(null != contract.getMainContractId()) {
                    queryParam.put("parentContractId", contract.getMainContractId());
                }
                if(StringUtils.isNotBlank(contract.getMainContractSid()) && !PlanConstant.EMPTY_STR.equals(contract.getMainContractSid())) {
                    queryParam.put("parentContractSid", contract.getMainContractSid());
                }
            } else {
                //总价合同只查询 主合同+子合同
                queryParam.put("billTypes", new Integer[]{1,2});
            }
        }

        if(StringUtils.isBlank(params.getString("searchText"))) {
            queryParam.put("searchText", params.getString("searchText"));
        }
        if(StringUtils.isBlank(params.getString("projectName"))) {
            queryParam.put("projectName", params.getString("projectName"));
        }
        if(StringUtils.isBlank(params.getString("billCode"))) { //订单编号
            queryParam.put("billCode", params.getString("billCode"));
        }
        if(StringUtils.isBlank(params.getString("contractName"))) {
            queryParam.put("contractName", params.getString("contractName"));
        }
        if(StringUtils.isBlank(params.getString("contractCode"))) {
            queryParam.put("contractCode", params.getString("contractCode"));
        }
        if(StringUtils.isBlank(params.getString("sealFlag"))) {
            queryParam.put("sealFlag", params.getString("sealFlag"));
        } else {
            queryParam.put("sealFlag", PlanConstant.STRING_YES);
        }

        int count = service.countContractAndOrder(queryParam);
        resp.put("total", count);
        if(count == 0) {
            resp.put("records", new ArrayList<>());
            return CommonResponse.success(resp);
        }

        List<Map> records =  service.pageContractAndOrder(queryParam);
        resp.put("records", records);

        return CommonResponse.success(resp);
    }

}
