package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.FeePackageEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.FeePackageMapper;
import com.ejianc.business.zdsmaterial.erp.service.IFeePackageService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 费用包实体
 * 
 * @author generator
 * 
 */
@Service("feePackageService")
public class FeePackageServiceImpl extends BaseServiceImpl<FeePackageMapper, FeePackageEntity> implements IFeePackageService{

    @Override
    public List<FeePackageEntity> getAllBySourceIds(ArrayList<String> sourceIds) {
        QueryWrapper<FeePackageEntity> query = new QueryWrapper<>();
        query.in("source_id", sourceIds);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        return super.list(query);
    }
}
