package com.ejianc.business.zdsmaterial.erp.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 领航发票实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zdsmaterial_erp_invoice")
public class ErpInvoiceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "tax")
    private BigDecimal tax; //发票税额
    @TableField(value="type_code")
    private String typeCode; // 发票种类代码
    @TableField(value="type_name")
    private String typeName; // 发票种类名称
    @TableField(value="status_code")
    private String statusCode; // 发票状态代码
    @TableField(value="status_name")
    private String statusName; // 发票状态名称
    @TableField(value="code")
    private String code; // 发票代码
    @TableField(value="number")
    private String number; // 发票号码
    @TableField(value="mny")
    private BigDecimal mny; // 发票金额
    @TableField(value="invoice_date")
    private Date invoiceDate; // 开票日期
    @TableField(value="sale_tax_number")
    private String saleTaxNumber; // 销方税号
    @TableField(value="sale_name")
    private String saleName; // 销方名称
    @TableField(value="invoice_title")
    private String invoiceTitle; // 发票抬头
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(value = "quote_flag")
    private String quoteFlag; //引用标识：0-未引用，1-已引用

    @TableField(value = "source_id")
    private String sourceId; //ERPId

    @TableField(value = "erp_quote_flag")
    private String erpQuoteFlag;// ERP引用标记：0-未引用，1-已引用
    @TableField(value = "goods_name")
    private String goodsName; //ERP引用发票物料名称
    @TableField(value = "erp_register_name")
    private String erpRegisterName;//ERP引用发票注册人名称
    @TableField(value = "erp_create_time")
    private String erpCreateTime;//ERP引用发票创建时间
    @TableField(value = "erp_quote_bill_code")
    private String erpQuoteBillCode; //ERP引用发票单据编码


    @TableField(exist=false)
    @SubEntity(serviceName="erpInvoiceDetailService")
    private List<ErpInvoiceDetailEntity> detailList = new ArrayList<>(); // 领航发票子实体

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getErpQuoteBillCode() {
        return erpQuoteBillCode;
    }

    public void setErpQuoteBillCode(String erpQuoteBillCode) {
        this.erpQuoteBillCode = erpQuoteBillCode;
    }

    public String getErpQuoteFlag() {
        return erpQuoteFlag;
    }

    public void setErpQuoteFlag(String erpQuoteFlag) {
        this.erpQuoteFlag = erpQuoteFlag;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getErpRegisterName() {
        return erpRegisterName;
    }

    public void setErpRegisterName(String erpRegisterName) {
        this.erpRegisterName = erpRegisterName;
    }

    public String getErpCreateTime() {
        return erpCreateTime;
    }

    public void setErpCreateTime(String erpCreateTime) {
        this.erpCreateTime = erpCreateTime;
    }

    public String getQuoteFlag() {
        return quoteFlag;
    }

    public void setQuoteFlag(String quoteFlag) {
        this.quoteFlag = quoteFlag;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }
    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
    public String getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }
    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    public String getSaleTaxNumber() {
        return saleTaxNumber;
    }

    public void setSaleTaxNumber(String saleTaxNumber) {
        this.saleTaxNumber = saleTaxNumber;
    }
    public String getSaleName() {
        return saleName;
    }

    public void setSaleName(String saleName) {
        this.saleName = saleName;
    }
    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<ErpInvoiceDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ErpInvoiceDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
}
